
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NegotiatedFareCodeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Supplier" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:CodeListAirGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NegotiatedFareCodeType implements Serializable
{
    private List<String> supplierList = new ArrayList<String>();
    private CodeListAirGroup codeListAirGroup;

    /** 
     * Get the list of 'Supplier' element items. This element indicates the supplier associated with
                          a negotiated fare code.
                      
     * 
     * @return list
     */
    public List<String> getSupplierList() {
        return supplierList;
    }

    /** 
     * Set the list of 'Supplier' element items. This element indicates the supplier associated with
                          a negotiated fare code.
                      
     * 
     * @param list
     */
    public void setSupplierList(List<String> list) {
        supplierList = list;
    }

    /** 
     * Get the 'CodeListAirGroup' attributeGroup value.
     * 
     * @return value
     */
    public CodeListAirGroup getCodeListAirGroup() {
        return codeListAirGroup;
    }

    /** 
     * Set the 'CodeListAirGroup' attributeGroup value.
     * 
     * @param codeListAirGroup
     */
    public void setCodeListAirGroup(CodeListAirGroup codeListAirGroup) {
        this.codeListAirGroup = codeListAirGroup;
    }
}
