
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OpenReservationElementType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element ref="ns:SocialMediaContact"/>
 *       &lt;xs:element ref="ns:AgencyFees"/>
 *       &lt;xs:element ref="ns:LangDetails"/>
 *       &lt;xs:element ref="ns:FormOfPayment"/>
 *       &lt;xs:element ref="ns:Loyalty"/>
 *       &lt;xs:element ref="ns:AncillaryProduct"/>
 *       &lt;xs:element ref="ns:InvoiceData"/>
 *       &lt;xs:element ref="ns:AccountingField"/>
 *       &lt;xs:element ref="ns:ServiceRequest"/>
 *       &lt;xs:element ref="ns:Email"/>
 *       &lt;xs:element ref="ns:PriceCache"/>
 *       &lt;xs:element ref="ns:TripProposalReference"/>
 *       &lt;xs:element ref="ns:InsuranceOptOut"/>
 *       &lt;xs:element ref="ns:Profile"/>
 *     &lt;/xs:choice>
 *     &lt;xs:group ref="ns:Associations"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="displayIndex"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OpenReservationElementType implements Serializable
{
    private int choiceSelect = -1;
    private static final int SOCIAL_MEDIA_CONTACT_CHOICE = 0;
    private static final int AGENCY_FEES_CHOICE = 1;
    private static final int LANG_DETAILS_CHOICE = 2;
    private static final int FORM_OF_PAYMENT_CHOICE = 3;
    private static final int LOYALTY_CHOICE = 4;
    private static final int ANCILLARY_PRODUCT_CHOICE = 5;
    private static final int INVOICE_DATA_CHOICE = 6;
    private static final int ACCOUNTING_FIELD_CHOICE = 7;
    private static final int SERVICE_REQUEST_CHOICE = 8;
    private static final int EMAIL_CHOICE = 9;
    private static final int PRICE_CACHE_CHOICE = 10;
    private static final int TRIP_PROPOSAL_REFERENCE_CHOICE = 11;
    private static final int INSURANCE_OPT_OUT_CHOICE = 12;
    private static final int PROFILE_CHOICE = 13;
    private SocialMediaContactType socialMediaContact;
    private AgencyFeesType agencyFees;
    private LangDetailsType langDetails;
    private FormOfPayment formOfPayment;
    private Loyalty loyalty;
    private AncillaryProductObject ancillaryProduct;
    private InvoiceData invoiceData;
    private AccountingField accountingField;
    private ServiceRequestType serviceRequest;
    private Email email;
    private PriceCache priceCache;
    private TripProposalReference tripProposalReference;
    private InsuranceOptOut insuranceOptOut;
    private ProfileType profile;
    private Associations associations;
    private String id;
    private String type;
    private Integer displayIndex;
    private String elementId;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if SocialMediaContact is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSocialMediaContact() {
        return choiceSelect == SOCIAL_MEDIA_CONTACT_CHOICE;
    }

    /** 
     * Get the 'SocialMediaContact' element value.
     * 
     * @return value
     */
    public SocialMediaContactType getSocialMediaContact() {
        return socialMediaContact;
    }

    /** 
     * Set the 'SocialMediaContact' element value.
     * 
     * @param socialMediaContact
     */
    public void setSocialMediaContact(SocialMediaContactType socialMediaContact) {
        setChoiceSelect(SOCIAL_MEDIA_CONTACT_CHOICE);
        this.socialMediaContact = socialMediaContact;
    }

    /** 
     * Check if AgencyFees is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAgencyFees() {
        return choiceSelect == AGENCY_FEES_CHOICE;
    }

    /** 
     * Get the 'AgencyFees' element value.
     * 
     * @return value
     */
    public AgencyFeesType getAgencyFees() {
        return agencyFees;
    }

    /** 
     * Set the 'AgencyFees' element value.
     * 
     * @param agencyFees
     */
    public void setAgencyFees(AgencyFeesType agencyFees) {
        setChoiceSelect(AGENCY_FEES_CHOICE);
        this.agencyFees = agencyFees;
    }

    /** 
     * Check if LangDetails is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLangDetails() {
        return choiceSelect == LANG_DETAILS_CHOICE;
    }

    /** 
     * Get the 'LangDetails' element value.
     * 
     * @return value
     */
    public LangDetailsType getLangDetails() {
        return langDetails;
    }

    /** 
     * Set the 'LangDetails' element value.
     * 
     * @param langDetails
     */
    public void setLangDetails(LangDetailsType langDetails) {
        setChoiceSelect(LANG_DETAILS_CHOICE);
        this.langDetails = langDetails;
    }

    /** 
     * Check if FormOfPayment is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFormOfPayment() {
        return choiceSelect == FORM_OF_PAYMENT_CHOICE;
    }

    /** 
     * Get the 'FormOfPayment' element value.
     * 
     * @return value
     */
    public FormOfPayment getFormOfPayment() {
        return formOfPayment;
    }

    /** 
     * Set the 'FormOfPayment' element value.
     * 
     * @param formOfPayment
     */
    public void setFormOfPayment(FormOfPayment formOfPayment) {
        setChoiceSelect(FORM_OF_PAYMENT_CHOICE);
        this.formOfPayment = formOfPayment;
    }

    /** 
     * Check if Loyalty is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLoyalty() {
        return choiceSelect == LOYALTY_CHOICE;
    }

    /** 
     * Get the 'Loyalty' element value.
     * 
     * @return value
     */
    public Loyalty getLoyalty() {
        return loyalty;
    }

    /** 
     * Set the 'Loyalty' element value.
     * 
     * @param loyalty
     */
    public void setLoyalty(Loyalty loyalty) {
        setChoiceSelect(LOYALTY_CHOICE);
        this.loyalty = loyalty;
    }

    /** 
     * Check if AncillaryProduct is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAncillaryProduct() {
        return choiceSelect == ANCILLARY_PRODUCT_CHOICE;
    }

    /** 
     * Get the 'AncillaryProduct' element value.
     * 
     * @return value
     */
    public AncillaryProductObject getAncillaryProduct() {
        return ancillaryProduct;
    }

    /** 
     * Set the 'AncillaryProduct' element value.
     * 
     * @param ancillaryProduct
     */
    public void setAncillaryProduct(AncillaryProductObject ancillaryProduct) {
        setChoiceSelect(ANCILLARY_PRODUCT_CHOICE);
        this.ancillaryProduct = ancillaryProduct;
    }

    /** 
     * Check if InvoiceData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifInvoiceData() {
        return choiceSelect == INVOICE_DATA_CHOICE;
    }

    /** 
     * Get the 'InvoiceData' element value.
     * 
     * @return value
     */
    public InvoiceData getInvoiceData() {
        return invoiceData;
    }

    /** 
     * Set the 'InvoiceData' element value.
     * 
     * @param invoiceData
     */
    public void setInvoiceData(InvoiceData invoiceData) {
        setChoiceSelect(INVOICE_DATA_CHOICE);
        this.invoiceData = invoiceData;
    }

    /** 
     * Check if AccountingField is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAccountingField() {
        return choiceSelect == ACCOUNTING_FIELD_CHOICE;
    }

    /** 
     * Get the 'AccountingField' element value.
     * 
     * @return value
     */
    public AccountingField getAccountingField() {
        return accountingField;
    }

    /** 
     * Set the 'AccountingField' element value.
     * 
     * @param accountingField
     */
    public void setAccountingField(AccountingField accountingField) {
        setChoiceSelect(ACCOUNTING_FIELD_CHOICE);
        this.accountingField = accountingField;
    }

    /** 
     * Check if ServiceRequest is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifServiceRequest() {
        return choiceSelect == SERVICE_REQUEST_CHOICE;
    }

    /** 
     * Get the 'ServiceRequest' element value.
     * 
     * @return value
     */
    public ServiceRequestType getServiceRequest() {
        return serviceRequest;
    }

    /** 
     * Set the 'ServiceRequest' element value.
     * 
     * @param serviceRequest
     */
    public void setServiceRequest(ServiceRequestType serviceRequest) {
        setChoiceSelect(SERVICE_REQUEST_CHOICE);
        this.serviceRequest = serviceRequest;
    }

    /** 
     * Check if Email is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmail() {
        return choiceSelect == EMAIL_CHOICE;
    }

    /** 
     * Get the 'Email' element value.
     * 
     * @return value
     */
    public Email getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value.
     * 
     * @param email
     */
    public void setEmail(Email email) {
        setChoiceSelect(EMAIL_CHOICE);
        this.email = email;
    }

    /** 
     * Check if PriceCache is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceCache() {
        return choiceSelect == PRICE_CACHE_CHOICE;
    }

    /** 
     * Get the 'PriceCache' element value.
     * 
     * @return value
     */
    public PriceCache getPriceCache() {
        return priceCache;
    }

    /** 
     * Set the 'PriceCache' element value.
     * 
     * @param priceCache
     */
    public void setPriceCache(PriceCache priceCache) {
        setChoiceSelect(PRICE_CACHE_CHOICE);
        this.priceCache = priceCache;
    }

    /** 
     * Check if TripProposalReference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTripProposalReference() {
        return choiceSelect == TRIP_PROPOSAL_REFERENCE_CHOICE;
    }

    /** 
     * Get the 'TripProposalReference' element value.
     * 
     * @return value
     */
    public TripProposalReference getTripProposalReference() {
        return tripProposalReference;
    }

    /** 
     * Set the 'TripProposalReference' element value.
     * 
     * @param tripProposalReference
     */
    public void setTripProposalReference(
            TripProposalReference tripProposalReference) {
        setChoiceSelect(TRIP_PROPOSAL_REFERENCE_CHOICE);
        this.tripProposalReference = tripProposalReference;
    }

    /** 
     * Check if InsuranceOptOut is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifInsuranceOptOut() {
        return choiceSelect == INSURANCE_OPT_OUT_CHOICE;
    }

    /** 
     * Get the 'InsuranceOptOut' element value.
     * 
     * @return value
     */
    public InsuranceOptOut getInsuranceOptOut() {
        return insuranceOptOut;
    }

    /** 
     * Set the 'InsuranceOptOut' element value.
     * 
     * @param insuranceOptOut
     */
    public void setInsuranceOptOut(InsuranceOptOut insuranceOptOut) {
        setChoiceSelect(INSURANCE_OPT_OUT_CHOICE);
        this.insuranceOptOut = insuranceOptOut;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public ProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(ProfileType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Get the 'Associations' group value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' group value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'id' attribute value. hold reference ID
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. hold reference ID
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. open reservation element type, like SF for Agency Fees
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. open reservation element type, like SF for Agency Fees
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'displayIndex' attribute value. used to order items sequentially for presentation purposes
     * 
     * @return value
     */
    public Integer getDisplayIndex() {
        return displayIndex;
    }

    /** 
     * Set the 'displayIndex' attribute value. used to order items sequentially for presentation purposes
     * 
     * @param displayIndex
     */
    public void setDisplayIndex(Integer displayIndex) {
        this.displayIndex = displayIndex;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }
}
