
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalIndicator">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Y"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value=" "/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OptionalIndicator implements Serializable {
    Y("Y"), N("N"), _(" ");
    private final String value;

    private OptionalIndicator(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OptionalIndicator convert(String value) {
        for (OptionalIndicator inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
