
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Identify pricing source, if negotiated fares are requested and if it is a
 reprice request.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceRequestOptionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NegotiatedFareCodeType" name="NegotiatedFareCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AccountCodeType" name="AccountCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:IndDefaultFalseType" name="PublicFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndDefaultFalseType" name="PrivateFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndDefaultFalseType" name="IATAFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndType" name="WebFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriorityComplexType" name="Priority" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndicatorsType" name="Indicators" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PromoID" minOccurs="0"/>
 *     &lt;xs:element type="ns:CustomerComplexType" name="CustomerType" minOccurs="0"/>
 *     &lt;xs:element type="ns:ItinerariesPerGroupType" name="MultipleTravelerGroups" minOccurs="0"/>
 *     &lt;xs:element type="ns:BrandedFareIndicatorsType" name="BrandedFareIndicators" minOccurs="0"/>
 *     &lt;xs:element type="ns:PassengerStatusType" name="PassengerStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PointOfSaleOverride" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PointOfTicketingOverride" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ApplyResidentDiscount" minOccurs="0"/>
 *     &lt;xs:element type="ns:ETicketableOverrideType" name="ETicketableOverride" minOccurs="0"/>
 *     &lt;xs:element type="ns:CurrencyType" name="Currency" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndType" name="UseReducedConstructions" minOccurs="0"/>
 *     &lt;xs:element type="ns:OBFeesType" name="OBFees" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndType" name="FareBreaksAtLegs" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareAdjustmentType" name="FareAdjustment" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:ValueType" name="ForceCompanion" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndRequiredType" name="UsePassengerFares" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndRequiredType" name="UseNegotiatedFares" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PriceRequestAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceRequestOptionsType implements Serializable
{
    private List<NegotiatedFareCodeType> negotiatedFareCodeList = new ArrayList<NegotiatedFareCodeType>();
    private List<AccountCodeType> accountCodeList = new ArrayList<AccountCodeType>();
    private IndDefaultFalseType publicFare;
    private IndDefaultFalseType privateFare;
    private IndDefaultFalseType IATAFare;
    private IndType webFare;
    private PriorityComplexType priority;
    private IndicatorsType indicators;
    private String promoID;
    private CustomerComplexType customerType;
    private ItinerariesPerGroupType multipleTravelerGroups;
    private BrandedFareIndicatorsType brandedFareIndicators;
    private PassengerStatusType passengerStatus;
    private String pointOfSaleOverride;
    private String pointOfTicketingOverride;
    private Boolean applyResidentDiscount;
    private ETicketableOverrideType ETicketableOverride;
    private CurrencyType currency;
    private IndType useReducedConstructions;
    private OBFeesType OBFees;
    private IndType fareBreaksAtLegs;
    private List<FareAdjustmentType> fareAdjustmentList = new ArrayList<FareAdjustmentType>();
    private ValueType forceCompanion;
    private IndRequiredType usePassengerFares;
    private IndRequiredType useNegotiatedFares;
    private PriceRequestAttributes priceRequestAttributes;

    /** 
     * Get the list of 'NegotiatedFareCode' element items.
     * 
     * @return list
     */
    public List<NegotiatedFareCodeType> getNegotiatedFareCodeList() {
        return negotiatedFareCodeList;
    }

    /** 
     * Set the list of 'NegotiatedFareCode' element items.
     * 
     * @param list
     */
    public void setNegotiatedFareCodeList(List<NegotiatedFareCodeType> list) {
        negotiatedFareCodeList = list;
    }

    /** 
     * Get the list of 'AccountCode' element items.
     * 
     * @return list
     */
    public List<AccountCodeType> getAccountCodeList() {
        return accountCodeList;
    }

    /** 
     * Set the list of 'AccountCode' element items.
     * 
     * @param list
     */
    public void setAccountCodeList(List<AccountCodeType> list) {
        accountCodeList = list;
    }

    /** 
     * Get the 'PublicFare' element value. This element finds only public fares.
     * 
     * @return value
     */
    public IndDefaultFalseType getPublicFare() {
        return publicFare;
    }

    /** 
     * Set the 'PublicFare' element value. This element finds only public fares.
     * 
     * @param publicFare
     */
    public void setPublicFare(IndDefaultFalseType publicFare) {
        this.publicFare = publicFare;
    }

    /** 
     * Get the 'PrivateFare' element value. This element finds only private fares.
     * 
     * @return value
     */
    public IndDefaultFalseType getPrivateFare() {
        return privateFare;
    }

    /** 
     * Set the 'PrivateFare' element value. This element finds only private fares.
     * 
     * @param privateFare
     */
    public void setPrivateFare(IndDefaultFalseType privateFare) {
        this.privateFare = privateFare;
    }

    /** 
     * Get the 'IATAFare' element value. This element finds only IATA fares.
     * 
     * @return value
     */
    public IndDefaultFalseType getIATAFare() {
        return IATAFare;
    }

    /** 
     * Set the 'IATAFare' element value. This element finds only IATA fares.
     * 
     * @param IATAFare
     */
    public void setIATAFare(IndDefaultFalseType IATAFare) {
        this.IATAFare = IATAFare;
    }

    /** 
     * Get the 'WebFare' element value. Web fare
     * 
     * @return value
     */
    public IndType getWebFare() {
        return webFare;
    }

    /** 
     * Set the 'WebFare' element value. Web fare
     * 
     * @param webFare
     */
    public void setWebFare(IndType webFare) {
        this.webFare = webFare;
    }

    /** 
     * Get the 'Priority' element value. This element governs how flights are returned. A user can uses a
                          priority of 1-9 to make this determination.
                      
     * 
     * @return value
     */
    public PriorityComplexType getPriority() {
        return priority;
    }

    /** 
     * Set the 'Priority' element value. This element governs how flights are returned. A user can uses a
                          priority of 1-9 to make this determination.
                      
     * 
     * @param priority
     */
    public void setPriority(PriorityComplexType priority) {
        this.priority = priority;
    }

    /** 
     * Get the 'Indicators' element value. This element restricts fares which can be returned in response. If a
                          customer passes this element, all its children should be specified.
                      
     * 
     * @return value
     */
    public IndicatorsType getIndicators() {
        return indicators;
    }

    /** 
     * Set the 'Indicators' element value. This element restricts fares which can be returned in response. If a
                          customer passes this element, all its children should be specified.
                      
     * 
     * @param indicators
     */
    public void setIndicators(IndicatorsType indicators) {
        this.indicators = indicators;
    }

    /** 
     * Get the 'PromoID' element value. Promotional Identifier - a string which identifies a promotion, possibly giving a
                          discount prices etc.
                      
     * 
     * @return value
     */
    public String getPromoID() {
        return promoID;
    }

    /** 
     * Set the 'PromoID' element value. Promotional Identifier - a string which identifies a promotion, possibly giving a
                          discount prices etc.
                      
     * 
     * @param promoID
     */
    public void setPromoID(String promoID) {
        this.promoID = promoID;
    }

    /** 
     * Get the 'CustomerType' element value.
     * 
     * @return value
     */
    public CustomerComplexType getCustomerType() {
        return customerType;
    }

    /** 
     * Set the 'CustomerType' element value.
     * 
     * @param customerType
     */
    public void setCustomerType(CustomerComplexType customerType) {
        this.customerType = customerType;
    }

    /** 
     * Get the 'MultipleTravelerGroups' element value. This element governs how flights are returned when multiple passenger groups are
                          requested.
                      
     * 
     * @return value
     */
    public ItinerariesPerGroupType getMultipleTravelerGroups() {
        return multipleTravelerGroups;
    }

    /** 
     * Set the 'MultipleTravelerGroups' element value. This element governs how flights are returned when multiple passenger groups are
                          requested.
                      
     * 
     * @param multipleTravelerGroups
     */
    public void setMultipleTravelerGroups(
            ItinerariesPerGroupType multipleTravelerGroups) {
        this.multipleTravelerGroups = multipleTravelerGroups;
    }

    /** 
     * Get the 'BrandedFareIndicators' element value.
     * 
     * @return value
     */
    public BrandedFareIndicatorsType getBrandedFareIndicators() {
        return brandedFareIndicators;
    }

    /** 
     * Set the 'BrandedFareIndicators' element value.
     * 
     * @param brandedFareIndicators
     */
    public void setBrandedFareIndicators(
            BrandedFareIndicatorsType brandedFareIndicators) {
        this.brandedFareIndicators = brandedFareIndicators;
    }

    /** 
     * Get the 'PassengerStatus' element value.
     * 
     * @return value
     */
    public PassengerStatusType getPassengerStatus() {
        return passengerStatus;
    }

    /** 
     * Set the 'PassengerStatus' element value.
     * 
     * @param passengerStatus
     */
    public void setPassengerStatus(PassengerStatusType passengerStatus) {
        this.passengerStatus = passengerStatus;
    }

    /** 
     * Get the 'PointOfSaleOverride' element value. Will return the fares available for specified point of sale and
                          priced in this point of sale currency. Currency is overriden by
                          PriceRequestInformation@CurrencyCode.
                      
     * 
     * @return value
     */
    public String getPointOfSaleOverride() {
        return pointOfSaleOverride;
    }

    /** 
     * Set the 'PointOfSaleOverride' element value. Will return the fares available for specified point of sale and
                          priced in this point of sale currency. Currency is overriden by
                          PriceRequestInformation@CurrencyCode.
                      
     * 
     * @param pointOfSaleOverride
     */
    public void setPointOfSaleOverride(String pointOfSaleOverride) {
        this.pointOfSaleOverride = pointOfSaleOverride;
    }

    /** 
     * Get the 'PointOfTicketingOverride' element value.
     * 
     * @return value
     */
    public String getPointOfTicketingOverride() {
        return pointOfTicketingOverride;
    }

    /** 
     * Set the 'PointOfTicketingOverride' element value.
     * 
     * @param pointOfTicketingOverride
     */
    public void setPointOfTicketingOverride(String pointOfTicketingOverride) {
        this.pointOfTicketingOverride = pointOfTicketingOverride;
    }

    /** 
     * Get the 'ApplyResidentDiscount' element value. Apply resident discount in CLFE
     * 
     * @return value
     */
    public Boolean getApplyResidentDiscount() {
        return applyResidentDiscount;
    }

    /** 
     * Set the 'ApplyResidentDiscount' element value. Apply resident discount in CLFE
     * 
     * @param applyResidentDiscount
     */
    public void setApplyResidentDiscount(Boolean applyResidentDiscount) {
        this.applyResidentDiscount = applyResidentDiscount;
    }

    /** 
     * Get the 'ETicketableOverride' element value.
     * 
     * @return value
     */
    public ETicketableOverrideType getETicketableOverride() {
        return ETicketableOverride;
    }

    /** 
     * Set the 'ETicketableOverride' element value.
     * 
     * @param ETicketableOverride
     */
    public void setETicketableOverride(
            ETicketableOverrideType ETicketableOverride) {
        this.ETicketableOverride = ETicketableOverride;
    }

    /** 
     * Get the 'Currency' element value.
     * 
     * @return value
     */
    public CurrencyType getCurrency() {
        return currency;
    }

    /** 
     * Set the 'Currency' element value.
     * 
     * @param currency
     */
    public void setCurrency(CurrencyType currency) {
        this.currency = currency;
    }

    /** 
     * Get the 'UseReducedConstructions' element value. Use reduced constructions (simple fare paths with restrictions on the number of
                          fare components).
                      
     * 
     * @return value
     */
    public IndType getUseReducedConstructions() {
        return useReducedConstructions;
    }

    /** 
     * Set the 'UseReducedConstructions' element value. Use reduced constructions (simple fare paths with restrictions on the number of
                          fare components).
                      
     * 
     * @param useReducedConstructions
     */
    public void setUseReducedConstructions(IndType useReducedConstructions) {
        this.useReducedConstructions = useReducedConstructions;
    }

    /** 
     * Get the 'OBFees' element value.
     * 
     * @return value
     */
    public OBFeesType getOBFees() {
        return OBFees;
    }

    /** 
     * Set the 'OBFees' element value.
     * 
     * @param OBFees
     */
    public void setOBFees(OBFeesType OBFees) {
        this.OBFees = OBFees;
    }

    /** 
     * Get the 'FareBreaksAtLegs' element value. Force fare breaks at leg points if split taxes by leg requested. By default set to
                          true.
                      
     * 
     * @return value
     */
    public IndType getFareBreaksAtLegs() {
        return fareBreaksAtLegs;
    }

    /** 
     * Set the 'FareBreaksAtLegs' element value. Force fare breaks at leg points if split taxes by leg requested. By default set to
                          true.
                      
     * 
     * @param fareBreaksAtLegs
     */
    public void setFareBreaksAtLegs(IndType fareBreaksAtLegs) {
        this.fareBreaksAtLegs = fareBreaksAtLegs;
    }

    /** 
     * Get the list of 'FareAdjustment' element items. Capability to specify Plus-Up and Discount Amount and Percentage.
                      
     * 
     * @return list
     */
    public List<FareAdjustmentType> getFareAdjustmentList() {
        return fareAdjustmentList;
    }

    /** 
     * Set the list of 'FareAdjustment' element items. Capability to specify Plus-Up and Discount Amount and Percentage.
                      
     * 
     * @param list
     */
    public void setFareAdjustmentList(List<FareAdjustmentType> list) {
        fareAdjustmentList = list;
    }

    /** 
     * Get the 'ForceCompanion' element value. Force companion fare value.
     * 
     * @return value
     */
    public ValueType getForceCompanion() {
        return forceCompanion;
    }

    /** 
     * Set the 'ForceCompanion' element value. Force companion fare value.
     * 
     * @param forceCompanion
     */
    public void setForceCompanion(ValueType forceCompanion) {
        this.forceCompanion = forceCompanion;
    }

    /** 
     * Get the 'UsePassengerFares' element value. At least one fare component for each passenger type must be applicable for that
                          passenger type.
                      
     * 
     * @return value
     */
    public IndRequiredType getUsePassengerFares() {
        return usePassengerFares;
    }

    /** 
     * Set the 'UsePassengerFares' element value. At least one fare component for each passenger type must be applicable for that
                          passenger type.
                      
     * 
     * @param usePassengerFares
     */
    public void setUsePassengerFares(IndRequiredType usePassengerFares) {
        this.usePassengerFares = usePassengerFares;
    }

    /** 
     * Get the 'UseNegotiatedFares' element value. Returned fares need to match AcccountCode/CorporateID on at least one fare
                          component.
                      
     * 
     * @return value
     */
    public IndRequiredType getUseNegotiatedFares() {
        return useNegotiatedFares;
    }

    /** 
     * Set the 'UseNegotiatedFares' element value. Returned fares need to match AcccountCode/CorporateID on at least one fare
                          component.
                      
     * 
     * @param useNegotiatedFares
     */
    public void setUseNegotiatedFares(IndRequiredType useNegotiatedFares) {
        this.useNegotiatedFares = useNegotiatedFares;
    }

    /** 
     * Get the 'PriceRequestAttributes' attributeGroup value.
     * 
     * @return value
     */
    public PriceRequestAttributes getPriceRequestAttributes() {
        return priceRequestAttributes;
    }

    /** 
     * Set the 'PriceRequestAttributes' attributeGroup value.
     * 
     * @param priceRequestAttributes
     */
    public void setPriceRequestAttributes(
            PriceRequestAttributes priceRequestAttributes) {
        this.priceRequestAttributes = priceRequestAttributes;
    }
}
