
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProductNameType" name="ProductName"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:HotelProductType" name="Hotel"/>
 *       &lt;xs:element type="ns:GroundTransportationType" name="GroundTransportation"/>
 *       &lt;xs:element type="ns:RailType" name="Rail"/>
 *       &lt;xs:element type="ns:TourType" name="Tour"/>
 *       &lt;xs:element type="ns:AirType" name="Air"/>
 *       &lt;xs:element type="ns:VisaType" name="Visa"/>
 *       &lt;xs:element type="ns:VehicleType" name="Vehicle"/>
 *       &lt;xs:element type="ns:SkiType" name="Ski"/>
 *       &lt;xs:element type="ns:OtherType" name="Other"/>
 *       &lt;xs:element type="ns:InsuranceType" name="Insurance"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:ExternalSystemReferenceType" name="ExternalSystemReference" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element name="TransactionInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class TransactionInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BillingInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class BillingInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CO2ValueType" name="CO2Value" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:SegmentCommonAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProductDetailsType implements Serializable
{
    private ProductNameType productName;
    private int choiceSelect = -1;
    private static final int HOTEL_CHOICE = 0;
    private static final int GROUND_TRANSPORTATION_CHOICE = 1;
    private static final int RAIL_CHOICE = 2;
    private static final int TOUR_CHOICE = 3;
    private static final int AIR_CHOICE = 4;
    private static final int VISA_CHOICE = 5;
    private static final int VEHICLE_CHOICE = 6;
    private static final int SKI_CHOICE = 7;
    private static final int OTHER_CHOICE = 8;
    private static final int INSURANCE_CHOICE = 9;
    private HotelProductType hotel;
    private GroundTransportationType groundTransportation;
    private RailType rail;
    private TourType tour;
    private AirType air;
    private VisaType visa;
    private VehicleType vehicle;
    private SkiType ski;
    private OtherType other;
    private InsuranceType insurance;
    private List<ExternalSystemReferenceType> externalSystemReferenceList = new ArrayList<ExternalSystemReferenceType>();
    private TransactionInfo transactionInfo;
    private BillingInfo billingInfo;
    private CO2ValueType CO2Value;
    private String comment;
    private SegmentCommonAttributes segmentCommonAttributes;

    /** 
     * Get the 'ProductName' element value.
     * 
     * @return value
     */
    public ProductNameType getProductName() {
        return productName;
    }

    /** 
     * Set the 'ProductName' element value.
     * 
     * @param productName
     */
    public void setProductName(ProductNameType productName) {
        this.productName = productName;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Hotel is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHotel() {
        return choiceSelect == HOTEL_CHOICE;
    }

    /** 
     * Get the 'Hotel' element value.
     * 
     * @return value
     */
    public HotelProductType getHotel() {
        return hotel;
    }

    /** 
     * Set the 'Hotel' element value.
     * 
     * @param hotel
     */
    public void setHotel(HotelProductType hotel) {
        setChoiceSelect(HOTEL_CHOICE);
        this.hotel = hotel;
    }

    /** 
     * Check if GroundTransportation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroundTransportation() {
        return choiceSelect == GROUND_TRANSPORTATION_CHOICE;
    }

    /** 
     * Get the 'GroundTransportation' element value.
     * 
     * @return value
     */
    public GroundTransportationType getGroundTransportation() {
        return groundTransportation;
    }

    /** 
     * Set the 'GroundTransportation' element value.
     * 
     * @param groundTransportation
     */
    public void setGroundTransportation(
            GroundTransportationType groundTransportation) {
        setChoiceSelect(GROUND_TRANSPORTATION_CHOICE);
        this.groundTransportation = groundTransportation;
    }

    /** 
     * Check if Rail is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRail() {
        return choiceSelect == RAIL_CHOICE;
    }

    /** 
     * Get the 'Rail' element value.
     * 
     * @return value
     */
    public RailType getRail() {
        return rail;
    }

    /** 
     * Set the 'Rail' element value.
     * 
     * @param rail
     */
    public void setRail(RailType rail) {
        setChoiceSelect(RAIL_CHOICE);
        this.rail = rail;
    }

    /** 
     * Check if Tour is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTour() {
        return choiceSelect == TOUR_CHOICE;
    }

    /** 
     * Get the 'Tour' element value.
     * 
     * @return value
     */
    public TourType getTour() {
        return tour;
    }

    /** 
     * Set the 'Tour' element value.
     * 
     * @param tour
     */
    public void setTour(TourType tour) {
        setChoiceSelect(TOUR_CHOICE);
        this.tour = tour;
    }

    /** 
     * Check if Air is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAir() {
        return choiceSelect == AIR_CHOICE;
    }

    /** 
     * Get the 'Air' element value.
     * 
     * @return value
     */
    public AirType getAir() {
        return air;
    }

    /** 
     * Set the 'Air' element value.
     * 
     * @param air
     */
    public void setAir(AirType air) {
        setChoiceSelect(AIR_CHOICE);
        this.air = air;
    }

    /** 
     * Check if Visa is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVisa() {
        return choiceSelect == VISA_CHOICE;
    }

    /** 
     * Get the 'Visa' element value.
     * 
     * @return value
     */
    public VisaType getVisa() {
        return visa;
    }

    /** 
     * Set the 'Visa' element value.
     * 
     * @param visa
     */
    public void setVisa(VisaType visa) {
        setChoiceSelect(VISA_CHOICE);
        this.visa = visa;
    }

    /** 
     * Check if Vehicle is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVehicle() {
        return choiceSelect == VEHICLE_CHOICE;
    }

    /** 
     * Get the 'Vehicle' element value.
     * 
     * @return value
     */
    public VehicleType getVehicle() {
        return vehicle;
    }

    /** 
     * Set the 'Vehicle' element value.
     * 
     * @param vehicle
     */
    public void setVehicle(VehicleType vehicle) {
        setChoiceSelect(VEHICLE_CHOICE);
        this.vehicle = vehicle;
    }

    /** 
     * Check if Ski is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSki() {
        return choiceSelect == SKI_CHOICE;
    }

    /** 
     * Get the 'Ski' element value.
     * 
     * @return value
     */
    public SkiType getSki() {
        return ski;
    }

    /** 
     * Set the 'Ski' element value.
     * 
     * @param ski
     */
    public void setSki(SkiType ski) {
        setChoiceSelect(SKI_CHOICE);
        this.ski = ski;
    }

    /** 
     * Check if Other is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOther() {
        return choiceSelect == OTHER_CHOICE;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public OtherType getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param other
     */
    public void setOther(OtherType other) {
        setChoiceSelect(OTHER_CHOICE);
        this.other = other;
    }

    /** 
     * Check if Insurance is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifInsurance() {
        return choiceSelect == INSURANCE_CHOICE;
    }

    /** 
     * Get the 'Insurance' element value.
     * 
     * @return value
     */
    public InsuranceType getInsurance() {
        return insurance;
    }

    /** 
     * Set the 'Insurance' element value.
     * 
     * @param insurance
     */
    public void setInsurance(InsuranceType insurance) {
        setChoiceSelect(INSURANCE_CHOICE);
        this.insurance = insurance;
    }

    /** 
     * Get the list of 'ExternalSystemReference' element items. Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
    				
     * 
     * @return list
     */
    public List<ExternalSystemReferenceType> getExternalSystemReferenceList() {
        return externalSystemReferenceList;
    }

    /** 
     * Set the list of 'ExternalSystemReference' element items. Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
    				
     * 
     * @param list
     */
    public void setExternalSystemReferenceList(
            List<ExternalSystemReferenceType> list) {
        externalSystemReferenceList = list;
    }

    /** 
     * Get the 'TransactionInfo' element value.
     * 
     * @return value
     */
    public TransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value.
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'BillingInfo' element value.
     * 
     * @return value
     */
    public BillingInfo getBillingInfo() {
        return billingInfo;
    }

    /** 
     * Set the 'BillingInfo' element value.
     * 
     * @param billingInfo
     */
    public void setBillingInfo(BillingInfo billingInfo) {
        this.billingInfo = billingInfo;
    }

    /** 
     * Get the 'CO2Value' element value.
     * 
     * @return value
     */
    public CO2ValueType getCO2Value() {
        return CO2Value;
    }

    /** 
     * Set the 'CO2Value' element value.
     * 
     * @param CO2Value
     */
    public void setCO2Value(CO2ValueType CO2Value) {
        this.CO2Value = CO2Value;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @return value
     */
    public SegmentCommonAttributes getSegmentCommonAttributes() {
        return segmentCommonAttributes;
    }

    /** 
     * Set the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @param segmentCommonAttributes
     */
    public void setSegmentCommonAttributes(
            SegmentCommonAttributes segmentCommonAttributes) {
        this.segmentCommonAttributes = segmentCommonAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:RequestorSourceType" name="RequestorInfo"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:dateTime" name="LastUpdateTimeStamp"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TransactionInfo implements Serializable
    {
        private RequestorSourceType requestorInfo;
        private Date lastUpdateTimeStamp;

        /** 
         * Get the 'RequestorInfo' element value.
         * 
         * @return value
         */
        public RequestorSourceType getRequestorInfo() {
            return requestorInfo;
        }

        /** 
         * Set the 'RequestorInfo' element value.
         * 
         * @param requestorInfo
         */
        public void setRequestorInfo(RequestorSourceType requestorInfo) {
            this.requestorInfo = requestorInfo;
        }

        /** 
         * Get the 'LastUpdateTimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with
        							time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
        						
         * 
         * @return value
         */
        public Date getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        /** 
         * Set the 'LastUpdateTimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with
        							time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
        						
         * 
         * @param lastUpdateTimeStamp
         */
        public void setLastUpdateTimeStamp(Date lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BillingInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="BillingCode" minOccurs="1"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BillingInfo implements Serializable
    {
        private String billingCode;

        /** 
         * Get the 'BillingCode' element value. Holds information about billing code for product
         * 
         * @return value
         */
        public String getBillingCode() {
            return billingCode;
        }

        /** 
         * Set the 'BillingCode' element value. Holds information about billing code for product
         * 
         * @param billingCode
         */
        public void setBillingCode(String billingCode) {
            this.billingCode = billingCode;
        }
    }
}
