
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:ProductBase" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ProductDetails" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element ref="ns:AdditionalContent" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:ProductSourceType" name="ProductSource" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:short" name="sequence"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProductType implements Serializable
{
    private ProductBaseType productBase;
    private ProductDetailsType productDetails;
    private List<AdditionalContentType> additionalContentList = new ArrayList<AdditionalContentType>();
    private ProductSourceType productSource;
    private Short sequence;
    private String id;
    private Boolean isPast;

    /** 
     * Get the 'ProductBase' element value.
     * 
     * @return value
     */
    public ProductBaseType getProductBase() {
        return productBase;
    }

    /** 
     * Set the 'ProductBase' element value.
     * 
     * @param productBase
     */
    public void setProductBase(ProductBaseType productBase) {
        this.productBase = productBase;
    }

    /** 
     * Get the 'ProductDetails' element value.
     * 
     * @return value
     */
    public ProductDetailsType getProductDetails() {
        return productDetails;
    }

    /** 
     * Set the 'ProductDetails' element value.
     * 
     * @param productDetails
     */
    public void setProductDetails(ProductDetailsType productDetails) {
        this.productDetails = productDetails;
    }

    /** 
     * Get the list of 'AdditionalContent' element items.
     * 
     * @return list
     */
    public List<AdditionalContentType> getAdditionalContentList() {
        return additionalContentList;
    }

    /** 
     * Set the list of 'AdditionalContent' element items.
     * 
     * @param list
     */
    public void setAdditionalContentList(List<AdditionalContentType> list) {
        additionalContentList = list;
    }

    /** 
     * Get the 'ProductSource' element value.
     * 
     * @return value
     */
    public ProductSourceType getProductSource() {
        return productSource;
    }

    /** 
     * Set the 'ProductSource' element value.
     * 
     * @param productSource
     */
    public void setProductSource(ProductSourceType productSource) {
        this.productSource = productSource;
    }

    /** 
     * Get the 'sequence' attribute value.
     * 
     * @return value
     */
    public Short getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value.
     * 
     * @param sequence
     */
    public void setSequence(Short sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'id' attribute value. to be used as Segment Reference
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. to be used as Segment Reference
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Product - ProductBase - EndDateTime, Product - ProductBase - Endpoint.
     * 
     * @return value
     */
    public Boolean getIsPast() {
        return isPast;
    }

    /** 
     * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Product - ProductBase - EndDateTime, Product - ProductBase - Endpoint.
     * 
     * @param isPast
     */
    public void setIsPast(Boolean isPast) {
        this.isPast = isPast;
    }
}
