
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Provides information on the source of a request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestorSourceType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentSine"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentDutyCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AirportCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TerminalID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ApplicationID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Agency"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SubAgency"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RequestorSourceType implements Serializable
{
    private String agentSine;
    private String pseudoCityCode;
    private String agentDutyCode;
    private String airportCode;
    private String terminalID;
    private String applicationID;
    private String agency;
    private String subAgency;

    /** 
     * Get the 'AgentSine' attribute value. Identifies the party within the requesting entity.
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' attribute value. Identifies the party within the requesting entity.
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
    			
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
    			
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'AgentDutyCode' attribute value. An authority code assigned to a requestor.
     * 
     * @return value
     */
    public String getAgentDutyCode() {
        return agentDutyCode;
    }

    /** 
     * Set the 'AgentDutyCode' attribute value. An authority code assigned to a requestor.
     * 
     * @param agentDutyCode
     */
    public void setAgentDutyCode(String agentDutyCode) {
        this.agentDutyCode = agentDutyCode;
    }

    /** 
     * Get the 'AirportCode' attribute value. The IATA assigned airport code.
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'AirportCode' attribute value. The IATA assigned airport code.
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'TerminalID' attribute value. This is the electronic address of the device from which payload is submitted.
    			
     * 
     * @return value
     */
    public String getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'TerminalID' attribute value. This is the electronic address of the device from which payload is submitted.
    			
     * 
     * @param terminalID
     */
    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }

    /** 
     * Get the 'ApplicationID' attribute value. The identifier of the calling application that used by this requestor to submit this
    				payload.
    			
     * 
     * @return value
     */
    public String getApplicationID() {
        return applicationID;
    }

    /** 
     * Set the 'ApplicationID' attribute value. The identifier of the calling application that used by this requestor to submit this
    				payload.
    			
     * 
     * @param applicationID
     */
    public void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    /** 
     * Get the 'Agency' attribute value. The identifier of the calling agency
     * 
     * @return value
     */
    public String getAgency() {
        return agency;
    }

    /** 
     * Set the 'Agency' attribute value. The identifier of the calling agency
     * 
     * @param agency
     */
    public void setAgency(String agency) {
        this.agency = agency;
    }

    /** 
     * Get the 'SubAgency' attribute value. The identifier of the sub agency
     * 
     * @return value
     */
    public String getSubAgency() {
        return subAgency;
    }

    /** 
     * Set the 'SubAgency' attribute value. The identifier of the sub agency
     * 
     * @param subAgency
     */
    public void setSubAgency(String subAgency) {
        this.subAgency = subAgency;
    }
}
