
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VisaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CustomerResponsibilityID" minOccurs="0"/>
 *     &lt;xs:element name="Rates" minOccurs="0">
 *       &lt;!-- Reference to inner class Rates -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ServiceFee" minOccurs="0">
 *       &lt;!-- Reference to inner class ServiceFee -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="DestinationCountry" minOccurs="0">
 *       &lt;!-- Reference to inner class DestinationCountry -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ProcessingTime" minOccurs="0">
 *       &lt;!-- Reference to inner class ProcessingTime -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Purpose" minOccurs="0">
 *       &lt;!-- Reference to inner class Purpose -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Transit" minOccurs="0">
 *       &lt;!-- Reference to inner class Transit -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Vendor" minOccurs="0">
 *       &lt;!-- Reference to inner class Vendor -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0"/>
 *     &lt;xs:element name="Payment" minOccurs="0">
 *       &lt;!-- Reference to inner class Payment -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PricingElementsType" name="PricingElements" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VisaType implements Serializable
{
    private String customerResponsibilityID;
    private Rates rates;
    private ServiceFee serviceFee;
    private DestinationCountry destinationCountry;
    private ProcessingTime processingTime;
    private Purpose purpose;
    private Transit transit;
    private Vendor vendor;
    private String duration;
    private Payment payment;
    private PricingElementsType pricingElements;

    /** 
     * Get the 'CustomerResponsibilityID' element value. Customer responsibility ID
     * 
     * @return value
     */
    public String getCustomerResponsibilityID() {
        return customerResponsibilityID;
    }

    /** 
     * Set the 'CustomerResponsibilityID' element value. Customer responsibility ID
     * 
     * @param customerResponsibilityID
     */
    public void setCustomerResponsibilityID(String customerResponsibilityID) {
        this.customerResponsibilityID = customerResponsibilityID;
    }

    /** 
     * Get the 'Rates' element value.
     * 
     * @return value
     */
    public Rates getRates() {
        return rates;
    }

    /** 
     * Set the 'Rates' element value.
     * 
     * @param rates
     */
    public void setRates(Rates rates) {
        this.rates = rates;
    }

    /** 
     * Get the 'ServiceFee' element value.
     * 
     * @return value
     */
    public ServiceFee getServiceFee() {
        return serviceFee;
    }

    /** 
     * Set the 'ServiceFee' element value.
     * 
     * @param serviceFee
     */
    public void setServiceFee(ServiceFee serviceFee) {
        this.serviceFee = serviceFee;
    }

    /** 
     * Get the 'DestinationCountry' element value.
     * 
     * @return value
     */
    public DestinationCountry getDestinationCountry() {
        return destinationCountry;
    }

    /** 
     * Set the 'DestinationCountry' element value.
     * 
     * @param destinationCountry
     */
    public void setDestinationCountry(DestinationCountry destinationCountry) {
        this.destinationCountry = destinationCountry;
    }

    /** 
     * Get the 'ProcessingTime' element value.
     * 
     * @return value
     */
    public ProcessingTime getProcessingTime() {
        return processingTime;
    }

    /** 
     * Set the 'ProcessingTime' element value.
     * 
     * @param processingTime
     */
    public void setProcessingTime(ProcessingTime processingTime) {
        this.processingTime = processingTime;
    }

    /** 
     * Get the 'Purpose' element value.
     * 
     * @return value
     */
    public Purpose getPurpose() {
        return purpose;
    }

    /** 
     * Set the 'Purpose' element value.
     * 
     * @param purpose
     */
    public void setPurpose(Purpose purpose) {
        this.purpose = purpose;
    }

    /** 
     * Get the 'Transit' element value.
     * 
     * @return value
     */
    public Transit getTransit() {
        return transit;
    }

    /** 
     * Set the 'Transit' element value.
     * 
     * @param transit
     */
    public void setTransit(Transit transit) {
        this.transit = transit;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public Vendor getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'Duration' element value. Visa duration
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Visa duration
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'Payment' element value.
     * 
     * @return value
     */
    public Payment getPayment() {
        return payment;
    }

    /** 
     * Set the 'Payment' element value.
     * 
     * @param payment
     */
    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    /** 
     * Get the 'PricingElements' element value.
     * 
     * @return value
     */
    public PricingElementsType getPricingElements() {
        return pricingElements;
    }

    /** 
     * Set the 'PricingElements' element value.
     * 
     * @param pricingElements
     */
    public void setPricingElements(PricingElementsType pricingElements) {
        this.pricingElements = pricingElements;
    }
    /** 
     * Cost of visa
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rates" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="FOP" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:decimal" name="amount"/>
     *     &lt;xs:attribute type="xs:string" name="currency"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Rates implements Serializable
    {
        private String FOP;
        private BigDecimal amount;
        private String currency;

        /** 
         * Get the 'FOP' element value. Form of payments
         * 
         * @return value
         */
        public String getFOP() {
            return FOP;
        }

        /** 
         * Set the 'FOP' element value. Form of payments
         * 
         * @param FOP
         */
        public void setFOP(String FOP) {
            this.FOP = FOP;
        }

        /** 
         * Get the 'amount' attribute value. Amount to pay
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'amount' attribute value. Amount to pay
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'currency' attribute value. Currency
         * 
         * @return value
         */
        public String getCurrency() {
            return currency;
        }

        /** 
         * Set the 'currency' attribute value. Currency
         * 
         * @param currency
         */
        public void setCurrency(String currency) {
            this.currency = currency;
        }
    }
    /** 
     * Service fee
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFee" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" name="amount"/>
     *     &lt;xs:attribute type="xs:string" name="currency"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceFee implements Serializable
    {
        private BigDecimal amount;
        private String currency;

        /** 
         * Get the 'amount' attribute value. Amount to pay
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'amount' attribute value. Amount to pay
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'currency' attribute value. Currency
         * 
         * @return value
         */
        public String getCurrency() {
            return currency;
        }

        /** 
         * Set the 'currency' attribute value. Currency
         * 
         * @param currency
         */
        public void setCurrency(String currency) {
            this.currency = currency;
        }
    }
    /** 
     * Destination country for visa
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationCountry" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="code"/>
     *     &lt;xs:attribute type="xs:string" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DestinationCountry implements Serializable
    {
        private String code;
        private String name;

        /** 
         * Get the 'code' attribute value. Country code
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Country code
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'name' attribute value. Country name
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value. Country name
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Approximate time to process visa
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingTime" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Duration" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Notes" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Unit" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProcessingTime implements Serializable
    {
        private String duration;
        private String notes;
        private String unit;

        /** 
         * Get the 'Duration' element value. Duration of processing time
         * 
         * @return value
         */
        public String getDuration() {
            return duration;
        }

        /** 
         * Set the 'Duration' element value. Duration of processing time
         * 
         * @param duration
         */
        public void setDuration(String duration) {
            this.duration = duration;
        }

        /** 
         * Get the 'Notes' element value. Notes for processing time
         * 
         * @return value
         */
        public String getNotes() {
            return notes;
        }

        /** 
         * Set the 'Notes' element value. Notes for processing time
         * 
         * @param notes
         */
        public void setNotes(String notes) {
            this.notes = notes;
        }

        /** 
         * Get the 'Unit' element value. Processing time unit
         * 
         * @return value
         */
        public String getUnit() {
            return unit;
        }

        /** 
         * Set the 'Unit' element value. Processing time unit
         * 
         * @param unit
         */
        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Purpose" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Comments" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Purpose implements Serializable
    {
        private String comments;

        /** 
         * Get the 'Comments' element value. Purpose of issue visa
         * 
         * @return value
         */
        public String getComments() {
            return comments;
        }

        /** 
         * Set the 'Comments' element value. Purpose of issue visa
         * 
         * @param comments
         */
        public void setComments(String comments) {
            this.comments = comments;
        }
    }
    /** 
     * Visa transit city
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transit" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="City" minOccurs="0">
     *         &lt;!-- Reference to inner class City -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Transit implements Serializable
    {
        private City city;

        /** 
         * Get the 'City' element value.
         * 
         * @return value
         */
        public City getCity() {
            return city;
        }

        /** 
         * Set the 'City' element value.
         * 
         * @param city
         */
        public void setCity(City city) {
            this.city = city;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="City" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="name"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class City implements Serializable
        {
            private String name;

            /** 
             * Get the 'name' attribute value. City name
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'name' attribute value. City name
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
    }
    /** 
     * Visa vendor
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Vendor implements Serializable
    {
        private String name;

        /** 
         * Get the 'Name' element value. Vendor name
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Vendor name
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Receiver" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payment implements Serializable
    {
        private String receiver;

        /** 
         * Get the 'Receiver' element value. Visa payment receiver
         * 
         * @return value
         */
        public String getReceiver() {
            return receiver;
        }

        /** 
         * Set the 'Receiver' element value. Visa payment receiver
         * 
         * @param receiver
         */
        public void setReceiver(String receiver) {
            this.receiver = receiver;
        }
    }
}
