
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingFieldAncillaryServicesDataGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CommercialName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RficCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RficSubcode"/>
 *     &lt;xs:element type="xs:string" name="SSRCode" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element name="ProductTextDetails" minOccurs="0" maxOccurs="1">
 *         &lt;!-- Reference to inner class ProductTextDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="ProductText" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="OwningCarrierCode"/>
 *     &lt;xs:element type="xs:string" name="SsimCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OfferSnapId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BookingIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Vendor" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDCoupon" minOccurs="0"/>
 *     &lt;xs:element type="ns:AccountingFieldAncillaryETicketNumber" name="ETicketNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceFeeLineNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="DisplayOnlyIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ConsumptionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PresentTo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AtCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Endorsements" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StationIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceCityDestination" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceType" minOccurs="0"/>
 *     &lt;xs:element name="RuleSet" minOccurs="0">
 *       &lt;!-- Reference to inner class RuleSet -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginalPrice" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginalPrice -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:byte" name="NewMiscIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GroupCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class AccountingFieldAncillaryServicesDataGroup implements Serializable
{
    private String commercialName;
    private String rficCode;
    private String rficSubcode;
    private String SSRCode;
    private int choiceSelect = -1;
    private static final int PRODUCT_TEXT_DETAILS_CHOICE = 0;
    private static final int PRODUCT_TEXT_CHOICE = 1;
    private ProductTextDetails productTextDetails;
    private String productText;
    private String owningCarrierCode;
    private String ssimCode;
    private String offerSnapId;
    private String bookingIndicator;
    private String vendor;
    private String EMDType;
    private String EMDNumber;
    private String EMDCoupon;
    private AccountingFieldAncillaryETicketNumber ETicketNumber;
    private String serviceFeeLineNumber;
    private Boolean displayOnlyIndicator;
    private String consumptionIndicator;
    private String presentTo;
    private String atCity;
    private String endorsements;
    private String stationIndicator;
    private String serviceCity;
    private String serviceCityDestination;
    private String serviceType;
    private RuleSet ruleSet;
    private OriginalPrice originalPrice;
    private Byte newMiscIndicator;
    private String groupCode;

    /** 
     * Get the 'CommercialName' element value.
     * 
     * @return value
     */
    public String getCommercialName() {
        return commercialName;
    }

    /** 
     * Set the 'CommercialName' element value.
     * 
     * @param commercialName
     */
    public void setCommercialName(String commercialName) {
        this.commercialName = commercialName;
    }

    /** 
     * Get the 'RficCode' element value.
     * 
     * @return value
     */
    public String getRficCode() {
        return rficCode;
    }

    /** 
     * Set the 'RficCode' element value.
     * 
     * @param rficCode
     */
    public void setRficCode(String rficCode) {
        this.rficCode = rficCode;
    }

    /** 
     * Get the 'RficSubcode' element value.
     * 
     * @return value
     */
    public String getRficSubcode() {
        return rficSubcode;
    }

    /** 
     * Set the 'RficSubcode' element value.
     * 
     * @param rficSubcode
     */
    public void setRficSubcode(String rficSubcode) {
        this.rficSubcode = rficSubcode;
    }

    /** 
     * Get the 'SSRCode' element value.
     * 
     * @return value
     */
    public String getSSRCode() {
        return SSRCode;
    }

    /** 
     * Set the 'SSRCode' element value.
     * 
     * @param SSRCode
     */
    public void setSSRCode(String SSRCode) {
        this.SSRCode = SSRCode;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ProductTextDetails is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProductTextDetails() {
        return choiceSelect == PRODUCT_TEXT_DETAILS_CHOICE;
    }

    /** 
     * Get the 'ProductTextDetails' element value.
     * 
     * @return value
     */
    public ProductTextDetails getProductTextDetails() {
        return productTextDetails;
    }

    /** 
     * Set the 'ProductTextDetails' element value.
     * 
     * @param productTextDetails
     */
    public void setProductTextDetails(ProductTextDetails productTextDetails) {
        setChoiceSelect(PRODUCT_TEXT_DETAILS_CHOICE);
        this.productTextDetails = productTextDetails;
    }

    /** 
     * Check if ProductText is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProductText() {
        return choiceSelect == PRODUCT_TEXT_CHOICE;
    }

    /** 
     * Get the 'ProductText' element value.
     * 
     * @return value
     */
    public String getProductText() {
        return productText;
    }

    /** 
     * Set the 'ProductText' element value.
     * 
     * @param productText
     */
    public void setProductText(String productText) {
        setChoiceSelect(PRODUCT_TEXT_CHOICE);
        this.productText = productText;
    }

    /** 
     * Get the 'OwningCarrierCode' element value.
     * 
     * @return value
     */
    public String getOwningCarrierCode() {
        return owningCarrierCode;
    }

    /** 
     * Set the 'OwningCarrierCode' element value.
     * 
     * @param owningCarrierCode
     */
    public void setOwningCarrierCode(String owningCarrierCode) {
        this.owningCarrierCode = owningCarrierCode;
    }

    /** 
     * Get the 'SsimCode' element value.
     * 
     * @return value
     */
    public String getSsimCode() {
        return ssimCode;
    }

    /** 
     * Set the 'SsimCode' element value.
     * 
     * @param ssimCode
     */
    public void setSsimCode(String ssimCode) {
        this.ssimCode = ssimCode;
    }

    /** 
     * Get the 'OfferSnapId' element value.
     * 
     * @return value
     */
    public String getOfferSnapId() {
        return offerSnapId;
    }

    /** 
     * Set the 'OfferSnapId' element value.
     * 
     * @param offerSnapId
     */
    public void setOfferSnapId(String offerSnapId) {
        this.offerSnapId = offerSnapId;
    }

    /** 
     * Get the 'BookingIndicator' element value.
     * 
     * @return value
     */
    public String getBookingIndicator() {
        return bookingIndicator;
    }

    /** 
     * Set the 'BookingIndicator' element value.
     * 
     * @param bookingIndicator
     */
    public void setBookingIndicator(String bookingIndicator) {
        this.bookingIndicator = bookingIndicator;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'EMDType' element value.
     * 
     * @return value
     */
    public String getEMDType() {
        return EMDType;
    }

    /** 
     * Set the 'EMDType' element value.
     * 
     * @param EMDType
     */
    public void setEMDType(String EMDType) {
        this.EMDType = EMDType;
    }

    /** 
     * Get the 'EMDNumber' element value.
     * 
     * @return value
     */
    public String getEMDNumber() {
        return EMDNumber;
    }

    /** 
     * Set the 'EMDNumber' element value.
     * 
     * @param EMDNumber
     */
    public void setEMDNumber(String EMDNumber) {
        this.EMDNumber = EMDNumber;
    }

    /** 
     * Get the 'EMDCoupon' element value.
     * 
     * @return value
     */
    public String getEMDCoupon() {
        return EMDCoupon;
    }

    /** 
     * Set the 'EMDCoupon' element value.
     * 
     * @param EMDCoupon
     */
    public void setEMDCoupon(String EMDCoupon) {
        this.EMDCoupon = EMDCoupon;
    }

    /** 
     * Get the 'ETicketNumber' element value.
     * 
     * @return value
     */
    public AccountingFieldAncillaryETicketNumber getETicketNumber() {
        return ETicketNumber;
    }

    /** 
     * Set the 'ETicketNumber' element value.
     * 
     * @param ETicketNumber
     */
    public void setETicketNumber(
            AccountingFieldAncillaryETicketNumber ETicketNumber) {
        this.ETicketNumber = ETicketNumber;
    }

    /** 
     * Get the 'ServiceFeeLineNumber' element value.
     * 
     * @return value
     */
    public String getServiceFeeLineNumber() {
        return serviceFeeLineNumber;
    }

    /** 
     * Set the 'ServiceFeeLineNumber' element value.
     * 
     * @param serviceFeeLineNumber
     */
    public void setServiceFeeLineNumber(String serviceFeeLineNumber) {
        this.serviceFeeLineNumber = serviceFeeLineNumber;
    }

    /** 
     * Get the 'DisplayOnlyIndicator' element value.
     * 
     * @return value
     */
    public Boolean getDisplayOnlyIndicator() {
        return displayOnlyIndicator;
    }

    /** 
     * Set the 'DisplayOnlyIndicator' element value.
     * 
     * @param displayOnlyIndicator
     */
    public void setDisplayOnlyIndicator(Boolean displayOnlyIndicator) {
        this.displayOnlyIndicator = displayOnlyIndicator;
    }

    /** 
     * Get the 'ConsumptionIndicator' element value.
     * 
     * @return value
     */
    public String getConsumptionIndicator() {
        return consumptionIndicator;
    }

    /** 
     * Set the 'ConsumptionIndicator' element value.
     * 
     * @param consumptionIndicator
     */
    public void setConsumptionIndicator(String consumptionIndicator) {
        this.consumptionIndicator = consumptionIndicator;
    }

    /** 
     * Get the 'PresentTo' element value.
     * 
     * @return value
     */
    public String getPresentTo() {
        return presentTo;
    }

    /** 
     * Set the 'PresentTo' element value.
     * 
     * @param presentTo
     */
    public void setPresentTo(String presentTo) {
        this.presentTo = presentTo;
    }

    /** 
     * Get the 'AtCity' element value.
     * 
     * @return value
     */
    public String getAtCity() {
        return atCity;
    }

    /** 
     * Set the 'AtCity' element value.
     * 
     * @param atCity
     */
    public void setAtCity(String atCity) {
        this.atCity = atCity;
    }

    /** 
     * Get the 'Endorsements' element value.
     * 
     * @return value
     */
    public String getEndorsements() {
        return endorsements;
    }

    /** 
     * Set the 'Endorsements' element value.
     * 
     * @param endorsements
     */
    public void setEndorsements(String endorsements) {
        this.endorsements = endorsements;
    }

    /** 
     * Get the 'StationIndicator' element value.
     * 
     * @return value
     */
    public String getStationIndicator() {
        return stationIndicator;
    }

    /** 
     * Set the 'StationIndicator' element value.
     * 
     * @param stationIndicator
     */
    public void setStationIndicator(String stationIndicator) {
        this.stationIndicator = stationIndicator;
    }

    /** 
     * Get the 'ServiceCity' element value.
     * 
     * @return value
     */
    public String getServiceCity() {
        return serviceCity;
    }

    /** 
     * Set the 'ServiceCity' element value.
     * 
     * @param serviceCity
     */
    public void setServiceCity(String serviceCity) {
        this.serviceCity = serviceCity;
    }

    /** 
     * Get the 'ServiceCityDestination' element value. Destination city or off point, Ex “BLR”
     * 
     * @return value
     */
    public String getServiceCityDestination() {
        return serviceCityDestination;
    }

    /** 
     * Set the 'ServiceCityDestination' element value. Destination city or off point, Ex “BLR”
     * 
     * @param serviceCityDestination
     */
    public void setServiceCityDestination(String serviceCityDestination) {
        this.serviceCityDestination = serviceCityDestination;
    }

    /** 
     * Get the 'ServiceType' element value. Need to know the Service Type to e.g. 'A'llowance - indicate registered bag that
    					is part of allowance; 'C'harges; 'F'light Related; 'P'repaid
    				
     * 
     * @return value
     */
    public String getServiceType() {
        return serviceType;
    }

    /** 
     * Set the 'ServiceType' element value. Need to know the Service Type to e.g. 'A'llowance - indicate registered bag that
    					is part of allowance; 'C'harges; 'F'light Related; 'P'repaid
    				
     * 
     * @param serviceType
     */
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    /** 
     * Get the 'RuleSet' element value.
     * 
     * @return value
     */
    public RuleSet getRuleSet() {
        return ruleSet;
    }

    /** 
     * Set the 'RuleSet' element value.
     * 
     * @param ruleSet
     */
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    /** 
     * Get the 'OriginalPrice' element value.
     * 
     * @return value
     */
    public OriginalPrice getOriginalPrice() {
        return originalPrice;
    }

    /** 
     * Set the 'OriginalPrice' element value.
     * 
     * @param originalPrice
     */
    public void setOriginalPrice(OriginalPrice originalPrice) {
        this.originalPrice = originalPrice;
    }

    /** 
     * Get the 'NewMiscIndicator' element value.
     * 
     * @return value
     */
    public Byte getNewMiscIndicator() {
        return newMiscIndicator;
    }

    /** 
     * Set the 'NewMiscIndicator' element value.
     * 
     * @param newMiscIndicator
     */
    public void setNewMiscIndicator(Byte newMiscIndicator) {
        this.newMiscIndicator = newMiscIndicator;
    }

    /** 
     * Get the 'GroupCode' element value. Type of ancillary service as per IATA standard
    					(2 letter code defined in ARIMP manual.
    				
     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'GroupCode' element value. Type of ancillary service as per IATA standard
    					(2 letter code defined in ARIMP manual.
    				
     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductTextDetails" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ProductTextDetailsItem" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ProductTextDetailsItem -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProductTextDetails implements Serializable
    {
        private List<ProductTextDetailsItem> productTextDetailsItemList = new ArrayList<ProductTextDetailsItem>();

        /** 
         * Get the list of 'ProductTextDetailsItem' element items.
         * 
         * @return list
         */
        public List<ProductTextDetailsItem> getProductTextDetailsItemList() {
            return productTextDetailsItemList;
        }

        /** 
         * Set the list of 'ProductTextDetailsItem' element items.
         * 
         * @param list
         */
        public void setProductTextDetailsItemList(
                List<ProductTextDetailsItem> list) {
            productTextDetailsItemList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductTextDetailsItem" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="ItemName"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="ItemValue"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ProductTextDetailsItem implements Serializable
        {
            private String itemName;
            private String itemValue;

            /** 
             * Get the 'ItemName' attribute value.
             * 
             * @return value
             */
            public String getItemName() {
                return itemName;
            }

            /** 
             * Set the 'ItemName' attribute value.
             * 
             * @param itemName
             */
            public void setItemName(String itemName) {
                this.itemName = itemName;
            }

            /** 
             * Get the 'ItemValue' attribute value.
             * 
             * @return value
             */
            public String getItemValue() {
                return itemValue;
            }

            /** 
             * Set the 'ItemValue' attribute value.
             * 
             * @param itemValue
             */
            public void setItemValue(String itemValue) {
                this.itemValue = itemValue;
            }
        }
    }
    /** 
     * Needed to keep track of companion benefits for example. Will come from the Rules
    					Processor
    				
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleSet" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:unsignedLong" name="RuleId"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleSet implements Serializable
    {
        private String string;
        private String ruleId;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'RuleId' attribute value.
         * 
         * @return value
         */
        public String getRuleId() {
            return ruleId;
        }

        /** 
         * Set the 'RuleId' attribute value.
         * 
         * @param ruleId
         */
        public void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }
    }
    /** 
     * Original Price from Pricing - will need to be persisted with the waiver code
    				
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalPrice" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:decimal">
     *         &lt;xs:attribute type="xs:string" use="required" name="WaiverCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginalPrice implements Serializable
    {
        private BigDecimal decimal;
        private String waiverCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getDecimal() {
            return decimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param decimal
         */
        public void setDecimal(BigDecimal decimal) {
            this.decimal = decimal;
        }

        /** 
         * Get the 'WaiverCode' attribute value. To override the price, waiver code is required
        								
         * 
         * @return value
         */
        public String getWaiverCode() {
            return waiverCode;
        }

        /** 
         * Set the 'WaiverCode' attribute value. To override the price, waiver code is required
        								
         * 
         * @param waiverCode
         */
        public void setWaiverCode(String waiverCode) {
            this.waiverCode = waiverCode;
        }
    }
}
