
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Use for free text relating to check-in/check-out, surcharge and other details. Uses OTA ADT Table in Code Attribute
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalDetailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="optional" name="Code"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="GuestCount"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="StartDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="EndDate"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="NumberOfNights"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AdditionalDetailType implements Serializable
{
    private List<String> textList = new ArrayList<String>();
    private Integer code;
    private BigDecimal amount;
    private String currencyCode;
    private Integer guestCount;
    private Date startDate;
    private Date endDate;
    private Integer numberOfNights;

    /** 
     * Get the list of 'Text' element items.
     * 
     * @return list
     */
    public List<String> getTextList() {
        return textList;
    }

    /** 
     * Set the list of 'Text' element items.
     * 
     * @param list
     */
    public void setTextList(List<String> list) {
        textList = list;
    }

    /** 
     * Get the 'Code' attribute value.
     * 
     * @return value
     */
    public Integer getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value.
     * 
     * @param code
     */
    public void setCode(Integer code) {
        this.code = code;
    }

    /** 
     * Get the 'Amount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'GuestCount' attribute value.
     * 
     * @return value
     */
    public Integer getGuestCount() {
        return guestCount;
    }

    /** 
     * Set the 'GuestCount' attribute value.
     * 
     * @param guestCount
     */
    public void setGuestCount(Integer guestCount) {
        this.guestCount = guestCount;
    }

    /** 
     * Get the 'StartDate' attribute value.
     * 
     * @return value
     */
    public Date getStartDate() {
        return startDate;
    }

    /** 
     * Set the 'StartDate' attribute value.
     * 
     * @param startDate
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    /** 
     * Get the 'EndDate' attribute value.
     * 
     * @return value
     */
    public Date getEndDate() {
        return endDate;
    }

    /** 
     * Set the 'EndDate' attribute value.
     * 
     * @param endDate
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /** 
     * Get the 'NumberOfNights' attribute value.
     * 
     * @return value
     */
    public Integer getNumberOfNights() {
        return numberOfNights;
    }

    /** 
     * Set the 'NumberOfNights' attribute value.
     * 
     * @param numberOfNights
     */
    public void setNumberOfNights(Integer numberOfNights) {
        this.numberOfNights = numberOfNights;
    }
}
