
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="LocationType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="9"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element name="CityCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class CityCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="LocalCityName" minOccurs="0"/>
 *     &lt;xs:element type="ns:CodeDescriptionType" name="StateProvince" minOccurs="0"/>
 *     &lt;xs:element name="StateProvinceCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class StateProvinceCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="PostCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:CodeDescriptionType" name="Country" minOccurs="0"/>
 *     &lt;xs:element name="CountryCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class CountryCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Latitude" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Longitude" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Altitude" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressType implements Serializable
{
    private String locationType;
    private List<String> addressLineList = new ArrayList<String>();
    private String cityName;
    private CityCodes cityCodes;
    private String localCityName;
    private CodeDescriptionType stateProvince;
    private StateProvinceCodes stateProvinceCodes;
    private String postCode;
    private CodeDescriptionType country;
    private CountryCodes countryCodes;
    private String latitude;
    private String longitude;
    private String altitude;

    /** 
     * Get the 'LocationType' element value.
     * 
     * @return value
     */
    public String getLocationType() {
        return locationType;
    }

    /** 
     * Set the 'LocationType' element value.
     * 
     * @param locationType
     */
    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    /** 
     * Get the list of 'AddressLine' element items.
     * 
     * @return list
     */
    public List<String> getAddressLineList() {
        return addressLineList;
    }

    /** 
     * Set the list of 'AddressLine' element items.
     * 
     * @param list
     */
    public void setAddressLineList(List<String> list) {
        addressLineList = list;
    }

    /** 
     * Get the 'CityName' element value.
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value.
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'CityCodes' element value.
     * 
     * @return value
     */
    public CityCodes getCityCodes() {
        return cityCodes;
    }

    /** 
     * Set the 'CityCodes' element value.
     * 
     * @param cityCodes
     */
    public void setCityCodes(CityCodes cityCodes) {
        this.cityCodes = cityCodes;
    }

    /** 
     * Get the 'LocalCityName' element value.
     * 
     * @return value
     */
    public String getLocalCityName() {
        return localCityName;
    }

    /** 
     * Set the 'LocalCityName' element value.
     * 
     * @param localCityName
     */
    public void setLocalCityName(String localCityName) {
        this.localCityName = localCityName;
    }

    /** 
     * Get the 'StateProvince' element value.
     * 
     * @return value
     */
    public CodeDescriptionType getStateProvince() {
        return stateProvince;
    }

    /** 
     * Set the 'StateProvince' element value.
     * 
     * @param stateProvince
     */
    public void setStateProvince(CodeDescriptionType stateProvince) {
        this.stateProvince = stateProvince;
    }

    /** 
     * Get the 'StateProvinceCodes' element value.
     * 
     * @return value
     */
    public StateProvinceCodes getStateProvinceCodes() {
        return stateProvinceCodes;
    }

    /** 
     * Set the 'StateProvinceCodes' element value.
     * 
     * @param stateProvinceCodes
     */
    public void setStateProvinceCodes(StateProvinceCodes stateProvinceCodes) {
        this.stateProvinceCodes = stateProvinceCodes;
    }

    /** 
     * Get the 'PostCode' element value.
     * 
     * @return value
     */
    public String getPostCode() {
        return postCode;
    }

    /** 
     * Set the 'PostCode' element value.
     * 
     * @param postCode
     */
    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    /** 
     * Get the 'Country' element value.
     * 
     * @return value
     */
    public CodeDescriptionType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value.
     * 
     * @param country
     */
    public void setCountry(CodeDescriptionType country) {
        this.country = country;
    }

    /** 
     * Get the 'CountryCodes' element value.
     * 
     * @return value
     */
    public CountryCodes getCountryCodes() {
        return countryCodes;
    }

    /** 
     * Set the 'CountryCodes' element value.
     * 
     * @param countryCodes
     */
    public void setCountryCodes(CountryCodes countryCodes) {
        this.countryCodes = countryCodes;
    }

    /** 
     * Get the 'Latitude' element value.
     * 
     * @return value
     */
    public String getLatitude() {
        return latitude;
    }

    /** 
     * Set the 'Latitude' element value.
     * 
     * @param latitude
     */
    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    /** 
     * Get the 'Longitude' element value.
     * 
     * @return value
     */
    public String getLongitude() {
        return longitude;
    }

    /** 
     * Set the 'Longitude' element value.
     * 
     * @param longitude
     */
    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    /** 
     * Get the 'Altitude' element value.
     * 
     * @return value
     */
    public String getAltitude() {
        return altitude;
    }

    /** 
     * Set the 'Altitude' element value.
     * 
     * @param altitude
     */
    public void setAltitude(String altitude) {
        this.altitude = altitude;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CityCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Code" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Code -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CityCodes implements Serializable
    {
        private List<Code> codeList = new ArrayList<Code>();

        /** 
         * Get the list of 'Code' element items.
         * 
         * @return list
         */
        public List<Code> getCodeList() {
            return codeList;
        }

        /** 
         * Set the list of 'Code' element items.
         * 
         * @param list
         */
        public void setCodeList(List<Code> list) {
            codeList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Code implements Serializable
        {
            private String string;
            private String codeContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'codeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'codeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvinceCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Code" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Code -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class StateProvinceCodes implements Serializable
    {
        private List<Code> codeList = new ArrayList<Code>();

        /** 
         * Get the list of 'Code' element items.
         * 
         * @return list
         */
        public List<Code> getCodeList() {
            return codeList;
        }

        /** 
         * Set the list of 'Code' element items.
         * 
         * @param list
         */
        public void setCodeList(List<Code> list) {
            codeList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Code implements Serializable
        {
            private String string;
            private String codeContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'codeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'codeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Code" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Code -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CountryCodes implements Serializable
    {
        private List<Code> codeList = new ArrayList<Code>();

        /** 
         * Get the list of 'Code' element items.
         * 
         * @return list
         */
        public List<Code> getCodeList() {
            return codeList;
        }

        /** 
         * Set the list of 'Code' element items.
         * 
         * @param list
         */
        public void setCodeList(List<Code> list) {
            codeList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Code implements Serializable
        {
            private String string;
            private String codeContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'codeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'codeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }
        }
    }
}
