
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Direct Bill to Agency. Address and Name are optional if IATANumber is provided

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Agency">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="ns:PhoneType" name="Phone" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:Email" name="Email" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="IATANumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Agency implements Serializable
{
    private String name;
    private AddressType address;
    private List<PhoneType> phoneList = new ArrayList<PhoneType>();
    private List<Email> emailList = new ArrayList<Email>();
    private String IATANumber;

    /** 
     * Get the 'Name' element value.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        this.address = address;
    }

    /** 
     * Get the list of 'Phone' element items.
     * 
     * @return list
     */
    public List<PhoneType> getPhoneList() {
        return phoneList;
    }

    /** 
     * Set the list of 'Phone' element items.
     * 
     * @param list
     */
    public void setPhoneList(List<PhoneType> list) {
        phoneList = list;
    }

    /** 
     * Get the list of 'Email' element items.
     * 
     * @return list
     */
    public List<Email> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items.
     * 
     * @param list
     */
    public void setEmailList(List<Email> list) {
        emailList = list;
    }

    /** 
     * Get the 'IATANumber' element value.
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value.
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }
}
