
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amenity">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:int" name="Code"/>
 *       &lt;xs:attribute type="xs:string" name="Description"/>
 *       &lt;xs:attribute type="xs:boolean" name="ComplimentaryInd"/>
 *       &lt;xs:anyAttribute processContents="lax" namespace="##any"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Amenity implements Serializable
{
    private String string;
    private Integer code;
    private String description;
    private Boolean complimentaryInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Code' attribute value. 
    						Uses HAC table for OTA mapped codes and description.
    						ComplimentaryInd - true : Attribute is not displayed in response as Amenity has no additional charge and it is complimentary
    						false : Amenity has additional charge and appropriately indicated
    					
     * 
     * @return value
     */
    public Integer getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. 
    						Uses HAC table for OTA mapped codes and description.
    						ComplimentaryInd - true : Attribute is not displayed in response as Amenity has no additional charge and it is complimentary
    						false : Amenity has additional charge and appropriately indicated
    					
     * 
     * @param code
     */
    public void setCode(Integer code) {
        this.code = code;
    }

    /** 
     * Get the 'Description' attribute value.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' attribute value.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'ComplimentaryInd' attribute value.
     * 
     * @return value
     */
    public Boolean getComplimentaryInd() {
        return complimentaryInd;
    }

    /** 
     * Set the 'ComplimentaryInd' attribute value.
     * 
     * @param complimentaryInd
     */
    public void setComplimentaryInd(Boolean complimentaryInd) {
        this.complimentaryInd = complimentaryInd;
    }
}
