
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Basic Information about Guest /Person.  Includes Lead Guest, Loyalty Id, Frequent traveler ID
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicGuestInformation">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:GuestName">
 *       &lt;xs:attribute type="xs:string" use="optional" name="Email"/>
 *       &lt;xs:attribute type="xs:int" use="optional" name="Age"/>
 *       &lt;xs:attribute type="xs:int" use="optional" name="Index"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="LeadGuest"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="FrequentFlyerNumber"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="LoyaltyId"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BasicGuestInformation extends GuestName implements Serializable
{
    private String email;
    private Integer age;
    private Integer index;
    private Boolean leadGuest;
    private String frequentFlyerNumber;
    private String loyaltyId;

    /** 
     * Get the 'Email' attribute value.
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' attribute value.
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'Age' attribute value. Age is mandatory for a child
     * 
     * @return value
     */
    public Integer getAge() {
        return age;
    }

    /** 
     * Set the 'Age' attribute value. Age is mandatory for a child
     * 
     * @param age
     */
    public void setAge(Integer age) {
        this.age = age;
    }

    /** 
     * Get the 'Index' attribute value.
     * 
     * @return value
     */
    public Integer getIndex() {
        return index;
    }

    /** 
     * Set the 'Index' attribute value.
     * 
     * @param index
     */
    public void setIndex(Integer index) {
        this.index = index;
    }

    /** 
     * Get the 'LeadGuest' attribute value. Only one lead passenger per booking 
     * 
     * @return value
     */
    public Boolean getLeadGuest() {
        return leadGuest;
    }

    /** 
     * Set the 'LeadGuest' attribute value. Only one lead passenger per booking 
     * 
     * @param leadGuest
     */
    public void setLeadGuest(Boolean leadGuest) {
        this.leadGuest = leadGuest;
    }

    /** 
     * Get the 'FrequentFlyerNumber' attribute value.
     * 
     * @return value
     */
    public String getFrequentFlyerNumber() {
        return frequentFlyerNumber;
    }

    /** 
     * Set the 'FrequentFlyerNumber' attribute value.
     * 
     * @param frequentFlyerNumber
     */
    public void setFrequentFlyerNumber(String frequentFlyerNumber) {
        this.frequentFlyerNumber = frequentFlyerNumber;
    }

    /** 
     * Get the 'LoyaltyId' attribute value.
     * 
     * @return value
     */
    public String getLoyaltyId() {
        return loyaltyId;
    }

    /** 
     * Set the 'LoyaltyId' attribute value.
     * 
     * @param loyaltyId
     */
    public void setLoyaltyId(String loyaltyId) {
        this.loyaltyId = loyaltyId;
    }
}
