
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Represent a Basic Room Which Can be used in Request/Response
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicRoom">
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NonSmoking"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="BedTypeCode"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="AccessibilityInformation"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="RoomIndex"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BedTypeDescription"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BasicRoom implements Serializable
{
    private Boolean nonSmoking;
    private Integer bedTypeCode;
    private Integer accessibilityInformation;
    private Integer roomIndex;
    private String bedTypeDescription;

    /** 
     * Get the 'NonSmoking' attribute value.
     * 
     * @return value
     */
    public Boolean getNonSmoking() {
        return nonSmoking;
    }

    /** 
     * Set the 'NonSmoking' attribute value.
     * 
     * @param nonSmoking
     */
    public void setNonSmoking(Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
    }

    /** 
     * Get the 'BedTypeCode' attribute value. OTA Type Codes , Uses BED Table 
     * 
     * @return value
     */
    public Integer getBedTypeCode() {
        return bedTypeCode;
    }

    /** 
     * Set the 'BedTypeCode' attribute value. OTA Type Codes , Uses BED Table 
     * 
     * @param bedTypeCode
     */
    public void setBedTypeCode(Integer bedTypeCode) {
        this.bedTypeCode = bedTypeCode;
    }

    /** 
     * Get the 'AccessibilityInformation' attribute value. OTA Types Code, Uses PHY table 
     * 
     * @return value
     */
    public Integer getAccessibilityInformation() {
        return accessibilityInformation;
    }

    /** 
     * Set the 'AccessibilityInformation' attribute value. OTA Types Code, Uses PHY table 
     * 
     * @param accessibilityInformation
     */
    public void setAccessibilityInformation(Integer accessibilityInformation) {
        this.accessibilityInformation = accessibilityInformation;
    }

    /** 
     * Get the 'RoomIndex' attribute value.
     * 
     * @return value
     */
    public Integer getRoomIndex() {
        return roomIndex;
    }

    /** 
     * Set the 'RoomIndex' attribute value.
     * 
     * @param roomIndex
     */
    public void setRoomIndex(Integer roomIndex) {
        this.roomIndex = roomIndex;
    }

    /** 
     * Get the 'BedTypeDescription' attribute value. Used for NON OTA Bed Type.
     * 
     * @return value
     */
    public String getBedTypeDescription() {
        return bedTypeDescription;
    }

    /** 
     * Set the 'BedTypeDescription' attribute value. Used for NON OTA Bed Type.
     * 
     * @param bedTypeDescription
     */
    public void setBedTypeDescription(String bedTypeDescription) {
        this.bedTypeDescription = bedTypeDescription;
    }
}
