
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingInfoRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BookingKey" minOccurs="0"/>
 *     &lt;xs:element type="ns:LodgingBookingSearchRef" name="BookingRef" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CancellationReason" minOccurs="0"/>
 *     &lt;xs:element type="ns:HotelReservationIds" name="HotelReservationIds" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RequestorID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CorpDiscount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PromotionalCode"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="CreationDate"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ExistingItinerary"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InfoSource"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RateKey"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TransactionId"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RetransmissionIndicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Email"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FrequentFlyerNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LoyaltyId"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="PartialCancelAllowed"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BookingInfoRefType implements Serializable
{
    private String bookingKey;
    private LodgingBookingSearchRef bookingRef;
    private String cancellationReason;
    private HotelReservationIds hotelReservationIds;
    private String status;
    private String requestorID;
    private String corpDiscount;
    private String promotionalCode;
    private Date creationDate;
    private Boolean existingItinerary;
    private String infoSource;
    private String rateKey;
    private String transactionId;
    private Boolean retransmissionIndicator;
    private String email;
    private String frequentFlyerNumber;
    private String loyaltyId;
    private Boolean partialCancelAllowed;

    /** 
     * Get the 'BookingKey' element value.
     * 
     * @return value
     */
    public String getBookingKey() {
        return bookingKey;
    }

    /** 
     * Set the 'BookingKey' element value.
     * 
     * @param bookingKey
     */
    public void setBookingKey(String bookingKey) {
        this.bookingKey = bookingKey;
    }

    /** 
     * Get the 'BookingRef' element value.
     * 
     * @return value
     */
    public LodgingBookingSearchRef getBookingRef() {
        return bookingRef;
    }

    /** 
     * Set the 'BookingRef' element value.
     * 
     * @param bookingRef
     */
    public void setBookingRef(LodgingBookingSearchRef bookingRef) {
        this.bookingRef = bookingRef;
    }

    /** 
     * Get the 'CancellationReason' element value.
     * 
     * @return value
     */
    public String getCancellationReason() {
        return cancellationReason;
    }

    /** 
     * Set the 'CancellationReason' element value.
     * 
     * @param cancellationReason
     */
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    /** 
     * Get the 'HotelReservationIds' element value.
     * 
     * @return value
     */
    public HotelReservationIds getHotelReservationIds() {
        return hotelReservationIds;
    }

    /** 
     * Set the 'HotelReservationIds' element value.
     * 
     * @param hotelReservationIds
     */
    public void setHotelReservationIds(HotelReservationIds hotelReservationIds) {
        this.hotelReservationIds = hotelReservationIds;
    }

    /** 
     * Get the 'Status' attribute value. Uses STS OTA Code Table
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' attribute value. Uses STS OTA Code Table
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'RequestorID' attribute value.
     * 
     * @return value
     */
    public String getRequestorID() {
        return requestorID;
    }

    /** 
     * Set the 'RequestorID' attribute value.
     * 
     * @param requestorID
     */
    public void setRequestorID(String requestorID) {
        this.requestorID = requestorID;
    }

    /** 
     * Get the 'CorpDiscount' attribute value.
     * 
     * @return value
     */
    public String getCorpDiscount() {
        return corpDiscount;
    }

    /** 
     * Set the 'CorpDiscount' attribute value.
     * 
     * @param corpDiscount
     */
    public void setCorpDiscount(String corpDiscount) {
        this.corpDiscount = corpDiscount;
    }

    /** 
     * Get the 'PromotionalCode' attribute value.
     * 
     * @return value
     */
    public String getPromotionalCode() {
        return promotionalCode;
    }

    /** 
     * Set the 'PromotionalCode' attribute value.
     * 
     * @param promotionalCode
     */
    public void setPromotionalCode(String promotionalCode) {
        this.promotionalCode = promotionalCode;
    }

    /** 
     * Get the 'CreationDate' attribute value.
     * 
     * @return value
     */
    public Date getCreationDate() {
        return creationDate;
    }

    /** 
     * Set the 'CreationDate' attribute value.
     * 
     * @param creationDate
     */
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    /** 
     * Get the 'ExistingItinerary' attribute value.
     * 
     * @return value
     */
    public Boolean getExistingItinerary() {
        return existingItinerary;
    }

    /** 
     * Set the 'ExistingItinerary' attribute value.
     * 
     * @param existingItinerary
     */
    public void setExistingItinerary(Boolean existingItinerary) {
        this.existingItinerary = existingItinerary;
    }

    /** 
     * Get the 'InfoSource' attribute value. 
                      Booking source will be 3 character numeric code
                  
     * 
     * @return value
     */
    public String getInfoSource() {
        return infoSource;
    }

    /** 
     * Set the 'InfoSource' attribute value. 
                      Booking source will be 3 character numeric code
                  
     * 
     * @param infoSource
     */
    public void setInfoSource(String infoSource) {
        this.infoSource = infoSource;
    }

    /** 
     * Get the 'RateKey' attribute value.
     * 
     * @return value
     */
    public String getRateKey() {
        return rateKey;
    }

    /** 
     * Set the 'RateKey' attribute value.
     * 
     * @param rateKey
     */
    public void setRateKey(String rateKey) {
        this.rateKey = rateKey;
    }

    /** 
     * Get the 'TransactionId' attribute value. This is unique transaction id generated by hotels and should be provided on retries.
     * 
     * @return value
     */
    public String getTransactionId() {
        return transactionId;
    }

    /** 
     * Set the 'TransactionId' attribute value. This is unique transaction id generated by hotels and should be provided on retries.
     * 
     * @param transactionId
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /** 
     * Get the 'RetransmissionIndicator' attribute value.
     * 
     * @return value
     */
    public Boolean getRetransmissionIndicator() {
        return retransmissionIndicator;
    }

    /** 
     * Set the 'RetransmissionIndicator' attribute value.
     * 
     * @param retransmissionIndicator
     */
    public void setRetransmissionIndicator(Boolean retransmissionIndicator) {
        this.retransmissionIndicator = retransmissionIndicator;
    }

    /** 
     * Get the 'Email' attribute value.
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' attribute value.
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'FrequentFlyerNumber' attribute value.
     * 
     * @return value
     */
    public String getFrequentFlyerNumber() {
        return frequentFlyerNumber;
    }

    /** 
     * Set the 'FrequentFlyerNumber' attribute value.
     * 
     * @param frequentFlyerNumber
     */
    public void setFrequentFlyerNumber(String frequentFlyerNumber) {
        this.frequentFlyerNumber = frequentFlyerNumber;
    }

    /** 
     * Get the 'LoyaltyId' attribute value.
     * 
     * @return value
     */
    public String getLoyaltyId() {
        return loyaltyId;
    }

    /** 
     * Set the 'LoyaltyId' attribute value.
     * 
     * @param loyaltyId
     */
    public void setLoyaltyId(String loyaltyId) {
        this.loyaltyId = loyaltyId;
    }

    /** 
     * Get the 'PartialCancelAllowed' attribute value.
     * 
     * @return value
     */
    public Boolean getPartialCancelAllowed() {
        return partialCancelAllowed;
    }

    /** 
     * Set the 'PartialCancelAllowed' attribute value.
     * 
     * @param partialCancelAllowed
     */
    public void setPartialCancelAllowed(Boolean partialCancelAllowed) {
        this.partialCancelAllowed = partialCancelAllowed;
    }
}
