
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * A cabin is either Premium First (P), First (F), Premium Business (J), Business (C), Premium Economy (S) or Economy (Y)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinNameType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="PremiumFirst"/>
 *     &lt;xs:enumeration value="First"/>
 *     &lt;xs:enumeration value="PremiumBusiness"/>
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="PremiumEconomy"/>
 *     &lt;xs:enumeration value="Economy"/>
 *     &lt;xs:enumeration value="Y"/>
 *     &lt;xs:enumeration value="S"/>
 *     &lt;xs:enumeration value="C"/>
 *     &lt;xs:enumeration value="J"/>
 *     &lt;xs:enumeration value="F"/>
 *     &lt;xs:enumeration value="P"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CabinNameType implements Serializable {
    PREMIUM_FIRST("PremiumFirst"), FIRST("First"), PREMIUM_BUSINESS(
            "PremiumBusiness"), BUSINESS("Business"), PREMIUM_ECONOMY(
            "PremiumEconomy"), ECONOMY("Economy"), Y("Y"), S("S"), C("C"), J(
            "J"), F("F"), P("P");
    private final String value;

    private CabinNameType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CabinNameType convert(String value) {
        for (CabinNameType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
