
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Docket">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="xs:string" name="Custom" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Docket implements Serializable
{
    private int choiceSelect = -1;
    private static final int PREFIX_CHOICE = 0;
    private static final int CUSTOM_CHOICE = 1;
    private Sequence prefix;
    private String custom;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Prefix is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPrefix() {
        return choiceSelect == PREFIX_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getPrefix() {
        return prefix;
    }

    /** 
     * Set the sequence value.
     * 
     * @param prefix
     */
    public void setPrefix(Sequence prefix) {
        setChoiceSelect(PREFIX_CHOICE);
        this.prefix = prefix;
    }

    /** 
     * Check if Custom is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustom() {
        return choiceSelect == CUSTOM_CHOICE;
    }

    /** 
     * Get the 'Custom' element value.
     * 
     * @return value
     */
    public String getCustom() {
        return custom;
    }

    /** 
     * Set the 'Custom' element value.
     * 
     * @param custom
     */
    public void setCustom(String custom) {
        setChoiceSelect(CUSTOM_CHOICE);
        this.custom = custom;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="xs:string" name="Prefix" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="xs:string" name="DocketNumber" minOccurs="1" maxOccurs="1"/>
     *   &lt;xs:element type="xs:string" name="AgentInitials" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="xs:string" name="BNumber" minOccurs="0" maxOccurs="1"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private String prefix;
        private String docketNumber;
        private String agentInitials;
        private String BNumber;

        /** 
         * Get the 'Prefix' element value.
         * 
         * @return value
         */
        public String getPrefix() {
            return prefix;
        }

        /** 
         * Set the 'Prefix' element value.
         * 
         * @param prefix
         */
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        /** 
         * Get the 'DocketNumber' element value.
         * 
         * @return value
         */
        public String getDocketNumber() {
            return docketNumber;
        }

        /** 
         * Set the 'DocketNumber' element value.
         * 
         * @param docketNumber
         */
        public void setDocketNumber(String docketNumber) {
            this.docketNumber = docketNumber;
        }

        /** 
         * Get the 'AgentInitials' element value.
         * 
         * @return value
         */
        public String getAgentInitials() {
            return agentInitials;
        }

        /** 
         * Set the 'AgentInitials' element value.
         * 
         * @param agentInitials
         */
        public void setAgentInitials(String agentInitials) {
            this.agentInitials = agentInitials;
        }

        /** 
         * Get the 'BNumber' element value.
         * 
         * @return value
         */
        public String getBNumber() {
            return BNumber;
        }

        /** 
         * Set the 'BNumber' element value.
         * 
         * @param BNumber
         */
        public void setBNumber(String BNumber) {
            this.BNumber = BNumber;
        }
    }
}
