
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentID"/>
 *     &lt;xs:element type="xs:string" name="AgencyAccountNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CreationChannel" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SeatNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TypeOfPass" minOccurs="0"/>
 *     &lt;xs:element name="PassengerReferences" minOccurs="0">
 *       &lt;!-- Reference to inner class PassengerReferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SegmentReferences" minOccurs="0">
 *       &lt;!-- Reference to inner class SegmentReferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:dateTime" name="IssueTimeLimit" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="IssueDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocumentStatus" minOccurs="0"/>
 *     &lt;xs:element type="ns:ChargesType" name="Charges" minOccurs="0"/>
 *     &lt;xs:element name="FormOfPayment" minOccurs="0">
 *       &lt;!-- Reference to inner class FormOfPayment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="File" minOccurs="0">
 *       &lt;!-- Reference to inner class File -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="IssueType" minOccurs="0"/>
 *     &lt;xs:element name="DocumentRules" minOccurs="0">
 *       &lt;!-- Reference to inner class DocumentRules -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:anySimpleType" name="type"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="code"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DocumentType implements Serializable
{
    private String documentID;
    private String agencyAccountNumber;
    private String creationChannel;
    private String seatNumber;
    private String typeOfPass;
    private PassengerReferences passengerReferences;
    private SegmentReferences segmentReferences;
    private Date issueTimeLimit;
    private Date issueDateTime;
    private String documentStatus;
    private ChargesType charges;
    private FormOfPayment formOfPayment;
    private File file;
    private String issueType;
    private DocumentRules documentRules;
    private String type;
    private String code;
    private String codeContext;

    /** 
     * Get the 'DocumentID' element value.
     * 
     * @return value
     */
    public String getDocumentID() {
        return documentID;
    }

    /** 
     * Set the 'DocumentID' element value.
     * 
     * @param documentID
     */
    public void setDocumentID(String documentID) {
        this.documentID = documentID;
    }

    /** 
     * Get the 'AgencyAccountNumber' element value.
     * 
     * @return value
     */
    public String getAgencyAccountNumber() {
        return agencyAccountNumber;
    }

    /** 
     * Set the 'AgencyAccountNumber' element value.
     * 
     * @param agencyAccountNumber
     */
    public void setAgencyAccountNumber(String agencyAccountNumber) {
        this.agencyAccountNumber = agencyAccountNumber;
    }

    /** 
     * Get the 'CreationChannel' element value.
     * 
     * @return value
     */
    public String getCreationChannel() {
        return creationChannel;
    }

    /** 
     * Set the 'CreationChannel' element value.
     * 
     * @param creationChannel
     */
    public void setCreationChannel(String creationChannel) {
        this.creationChannel = creationChannel;
    }

    /** 
     * Get the 'SeatNumber' element value.
     * 
     * @return value
     */
    public String getSeatNumber() {
        return seatNumber;
    }

    /** 
     * Set the 'SeatNumber' element value.
     * 
     * @param seatNumber
     */
    public void setSeatNumber(String seatNumber) {
        this.seatNumber = seatNumber;
    }

    /** 
     * Get the 'TypeOfPass' element value.
     * 
     * @return value
     */
    public String getTypeOfPass() {
        return typeOfPass;
    }

    /** 
     * Set the 'TypeOfPass' element value.
     * 
     * @param typeOfPass
     */
    public void setTypeOfPass(String typeOfPass) {
        this.typeOfPass = typeOfPass;
    }

    /** 
     * Get the 'PassengerReferences' element value.
     * 
     * @return value
     */
    public PassengerReferences getPassengerReferences() {
        return passengerReferences;
    }

    /** 
     * Set the 'PassengerReferences' element value.
     * 
     * @param passengerReferences
     */
    public void setPassengerReferences(PassengerReferences passengerReferences) {
        this.passengerReferences = passengerReferences;
    }

    /** 
     * Get the 'SegmentReferences' element value.
     * 
     * @return value
     */
    public SegmentReferences getSegmentReferences() {
        return segmentReferences;
    }

    /** 
     * Set the 'SegmentReferences' element value.
     * 
     * @param segmentReferences
     */
    public void setSegmentReferences(SegmentReferences segmentReferences) {
        this.segmentReferences = segmentReferences;
    }

    /** 
     * Get the 'IssueTimeLimit' element value.
     * 
     * @return value
     */
    public Date getIssueTimeLimit() {
        return issueTimeLimit;
    }

    /** 
     * Set the 'IssueTimeLimit' element value.
     * 
     * @param issueTimeLimit
     */
    public void setIssueTimeLimit(Date issueTimeLimit) {
        this.issueTimeLimit = issueTimeLimit;
    }

    /** 
     * Get the 'IssueDateTime' element value.
     * 
     * @return value
     */
    public Date getIssueDateTime() {
        return issueDateTime;
    }

    /** 
     * Set the 'IssueDateTime' element value.
     * 
     * @param issueDateTime
     */
    public void setIssueDateTime(Date issueDateTime) {
        this.issueDateTime = issueDateTime;
    }

    /** 
     * Get the 'DocumentStatus' element value.
     * 
     * @return value
     */
    public String getDocumentStatus() {
        return documentStatus;
    }

    /** 
     * Set the 'DocumentStatus' element value.
     * 
     * @param documentStatus
     */
    public void setDocumentStatus(String documentStatus) {
        this.documentStatus = documentStatus;
    }

    /** 
     * Get the 'Charges' element value.
     * 
     * @return value
     */
    public ChargesType getCharges() {
        return charges;
    }

    /** 
     * Set the 'Charges' element value.
     * 
     * @param charges
     */
    public void setCharges(ChargesType charges) {
        this.charges = charges;
    }

    /** 
     * Get the 'FormOfPayment' element value.
     * 
     * @return value
     */
    public FormOfPayment getFormOfPayment() {
        return formOfPayment;
    }

    /** 
     * Set the 'FormOfPayment' element value.
     * 
     * @param formOfPayment
     */
    public void setFormOfPayment(FormOfPayment formOfPayment) {
        this.formOfPayment = formOfPayment;
    }

    /** 
     * Get the 'File' element value.
     * 
     * @return value
     */
    public File getFile() {
        return file;
    }

    /** 
     * Set the 'File' element value.
     * 
     * @param file
     */
    public void setFile(File file) {
        this.file = file;
    }

    /** 
     * Get the 'IssueType' element value.
     * 
     * @return value
     */
    public String getIssueType() {
        return issueType;
    }

    /** 
     * Set the 'IssueType' element value.
     * 
     * @param issueType
     */
    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    /** 
     * Get the 'DocumentRules' element value.
     * 
     * @return value
     */
    public DocumentRules getDocumentRules() {
        return documentRules;
    }

    /** 
     * Set the 'DocumentRules' element value.
     * 
     * @param documentRules
     */
    public void setDocumentRules(DocumentRules documentRules) {
        this.documentRules = documentRules;
    }

    /** 
     * Get the 'type' attribute value.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'code' attribute value.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'codeContext' attribute value.
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'codeContext' attribute value.
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerReferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerRef" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PassengerRef -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerReferences implements Serializable
    {
        private List<PassengerRef> passengerRefList = new ArrayList<PassengerRef>();

        /** 
         * Get the list of 'PassengerRef' element items.
         * 
         * @return list
         */
        public List<PassengerRef> getPassengerRefList() {
            return passengerRefList;
        }

        /** 
         * Set the list of 'PassengerRef' element items.
         * 
         * @param list
         */
        public void setPassengerRefList(List<PassengerRef> list) {
            passengerRefList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerRef" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:anySimpleType" name="id"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerRef implements Serializable
        {
            private String id;

            /** 
             * Get the 'id' attribute value.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentReferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SegmentRef" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SegmentRef -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SegmentReferences implements Serializable
    {
        private List<SegmentRef> segmentRefList = new ArrayList<SegmentRef>();

        /** 
         * Get the list of 'SegmentRef' element items.
         * 
         * @return list
         */
        public List<SegmentRef> getSegmentRefList() {
            return segmentRefList;
        }

        /** 
         * Set the list of 'SegmentRef' element items.
         * 
         * @param list
         */
        public void setSegmentRefList(List<SegmentRef> list) {
            segmentRefList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentRef" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:anySimpleType" name="id"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentRef implements Serializable
        {
            private String id;

            /** 
             * Get the 'id' attribute value.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormOfPayment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="CreditCard" minOccurs="0">
     *         &lt;!-- Reference to inner class CreditCard -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Cash" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Check" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Voucher" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Other" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:anySimpleType" name="transactionID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FormOfPayment implements Serializable
    {
        private CreditCard creditCard;
        private String cash;
        private String check;
        private String voucher;
        private String other;
        private String transactionID;

        /** 
         * Get the 'CreditCard' element value.
         * 
         * @return value
         */
        public CreditCard getCreditCard() {
            return creditCard;
        }

        /** 
         * Set the 'CreditCard' element value.
         * 
         * @param creditCard
         */
        public void setCreditCard(CreditCard creditCard) {
            this.creditCard = creditCard;
        }

        /** 
         * Get the 'Cash' element value.
         * 
         * @return value
         */
        public String getCash() {
            return cash;
        }

        /** 
         * Set the 'Cash' element value.
         * 
         * @param cash
         */
        public void setCash(String cash) {
            this.cash = cash;
        }

        /** 
         * Get the 'Check' element value.
         * 
         * @return value
         */
        public String getCheck() {
            return check;
        }

        /** 
         * Set the 'Check' element value.
         * 
         * @param check
         */
        public void setCheck(String check) {
            this.check = check;
        }

        /** 
         * Get the 'Voucher' element value.
         * 
         * @return value
         */
        public String getVoucher() {
            return voucher;
        }

        /** 
         * Set the 'Voucher' element value.
         * 
         * @param voucher
         */
        public void setVoucher(String voucher) {
            this.voucher = voucher;
        }

        /** 
         * Get the 'Other' element value.
         * 
         * @return value
         */
        public String getOther() {
            return other;
        }

        /** 
         * Set the 'Other' element value.
         * 
         * @param other
         */
        public void setOther(String other) {
            this.other = other;
        }

        /** 
         * Get the 'transactionID' attribute value.
         * 
         * @return value
         */
        public String getTransactionID() {
            return transactionID;
        }

        /** 
         * Set the 'transactionID' attribute value.
         * 
         * @param transactionID
         */
        public void setTransactionID(String transactionID) {
            this.transactionID = transactionID;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditCard" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Issuer" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ExpirationMonth" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ExpirationYear" minOccurs="0"/>
         *       &lt;xs:element name="CardHolder" minOccurs="0">
         *         &lt;!-- Reference to inner class CardHolder -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CreditCard implements Serializable
        {
            private String number;
            private String issuer;
            private String expirationMonth;
            private String expirationYear;
            private CardHolder cardHolder;

            /** 
             * Get the 'Number' element value.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' element value.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'Issuer' element value.
             * 
             * @return value
             */
            public String getIssuer() {
                return issuer;
            }

            /** 
             * Set the 'Issuer' element value.
             * 
             * @param issuer
             */
            public void setIssuer(String issuer) {
                this.issuer = issuer;
            }

            /** 
             * Get the 'ExpirationMonth' element value.
             * 
             * @return value
             */
            public String getExpirationMonth() {
                return expirationMonth;
            }

            /** 
             * Set the 'ExpirationMonth' element value.
             * 
             * @param expirationMonth
             */
            public void setExpirationMonth(String expirationMonth) {
                this.expirationMonth = expirationMonth;
            }

            /** 
             * Get the 'ExpirationYear' element value.
             * 
             * @return value
             */
            public String getExpirationYear() {
                return expirationYear;
            }

            /** 
             * Set the 'ExpirationYear' element value.
             * 
             * @param expirationYear
             */
            public void setExpirationYear(String expirationYear) {
                this.expirationYear = expirationYear;
            }

            /** 
             * Get the 'CardHolder' element value.
             * 
             * @return value
             */
            public CardHolder getCardHolder() {
                return cardHolder;
            }

            /** 
             * Set the 'CardHolder' element value.
             * 
             * @param cardHolder
             */
            public void setCardHolder(CardHolder cardHolder) {
                this.cardHolder = cardHolder;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolder" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:PersonNameType" name="PersonName" minOccurs="0"/>
             *       &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0"/>
             *       &lt;xs:element type="ns:PhoneType" name="Telephone" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="Email" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CardHolder implements Serializable
            {
                private PersonNameType personName;
                private AddressType address;
                private List<PhoneType> telephoneList = new ArrayList<PhoneType>();
                private List<String> emailList = new ArrayList<String>();

                /** 
                 * Get the 'PersonName' element value.
                 * 
                 * @return value
                 */
                public PersonNameType getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value.
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonNameType personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the 'Address' element value.
                 * 
                 * @return value
                 */
                public AddressType getAddress() {
                    return address;
                }

                /** 
                 * Set the 'Address' element value.
                 * 
                 * @param address
                 */
                public void setAddress(AddressType address) {
                    this.address = address;
                }

                /** 
                 * Get the list of 'Telephone' element items.
                 * 
                 * @return list
                 */
                public List<PhoneType> getTelephoneList() {
                    return telephoneList;
                }

                /** 
                 * Set the list of 'Telephone' element items.
                 * 
                 * @param list
                 */
                public void setTelephoneList(List<PhoneType> list) {
                    telephoneList = list;
                }

                /** 
                 * Get the list of 'Email' element items.
                 * 
                 * @return list
                 */
                public List<String> getEmailList() {
                    return emailList;
                }

                /** 
                 * Set the list of 'Email' element items.
                 * 
                 * @param list
                 */
                public void setEmailList(List<String> list) {
                    emailList = list;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="File" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Representation" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="URL" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:anySimpleType" use="optional" name="type"/>
     *     &lt;xs:attribute type="xs:anySimpleType" use="optional" name="coding"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class File implements Serializable
    {
        private String representation;
        private String URL;
        private String type;
        private String coding;

        /** 
         * Get the 'Representation' element value.
         * 
         * @return value
         */
        public String getRepresentation() {
            return representation;
        }

        /** 
         * Set the 'Representation' element value.
         * 
         * @param representation
         */
        public void setRepresentation(String representation) {
            this.representation = representation;
        }

        /** 
         * Get the 'URL' element value.
         * 
         * @return value
         */
        public String getURL() {
            return URL;
        }

        /** 
         * Set the 'URL' element value.
         * 
         * @param URL
         */
        public void setURL(String URL) {
            this.URL = URL;
        }

        /** 
         * Get the 'type' attribute value.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'coding' attribute value.
         * 
         * @return value
         */
        public String getCoding() {
            return coding;
        }

        /** 
         * Set the 'coding' attribute value.
         * 
         * @param coding
         */
        public void setCoding(String coding) {
            this.coding = coding;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentRules" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Exchangable" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Refundable" minOccurs="0"/>
     *       &lt;xs:element name="Rule" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Rule -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DocumentRules implements Serializable
    {
        private String exchangable;
        private String refundable;
        private List<Rule> ruleList = new ArrayList<Rule>();

        /** 
         * Get the 'Exchangable' element value.
         * 
         * @return value
         */
        public String getExchangable() {
            return exchangable;
        }

        /** 
         * Set the 'Exchangable' element value.
         * 
         * @param exchangable
         */
        public void setExchangable(String exchangable) {
            this.exchangable = exchangable;
        }

        /** 
         * Get the 'Refundable' element value.
         * 
         * @return value
         */
        public String getRefundable() {
            return refundable;
        }

        /** 
         * Set the 'Refundable' element value.
         * 
         * @param refundable
         */
        public void setRefundable(String refundable) {
            this.refundable = refundable;
        }

        /** 
         * Get the list of 'Rule' element items.
         * 
         * @return list
         */
        public List<Rule> getRuleList() {
            return ruleList;
        }

        /** 
         * Set the list of 'Rule' element items.
         * 
         * @param list
         */
        public void setRuleList(List<Rule> list) {
            ruleList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rule" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="type"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rule implements Serializable
        {
            private String string;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
    }
}
