
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * List of Hotel Fees
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:LodgingFeeType" name="Fee" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LodgingFeeGroupsType" name="FeeGroups" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeesType implements Serializable
{
    private List<LodgingFeeType> feeList = new ArrayList<LodgingFeeType>();
    private LodgingFeeGroupsType feeGroups;
    private BigDecimal amount;
    private String currencyCode;

    /** 
     * Get the list of 'Fee' element items.
     * 
     * @return list
     */
    public List<LodgingFeeType> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items.
     * 
     * @param list
     */
    public void setFeeList(List<LodgingFeeType> list) {
        feeList = list;
    }

    /** 
     * Get the 'FeeGroups' element value.
     * 
     * @return value
     */
    public LodgingFeeGroupsType getFeeGroups() {
        return feeGroups;
    }

    /** 
     * Set the 'FeeGroups' element value.
     * 
     * @param feeGroups
     */
    public void setFeeGroups(LodgingFeeGroupsType feeGroups) {
        this.feeGroups = feeGroups;
    }

    /** 
     * Get the 'Amount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
}
