
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GTR">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:GR" name="GR" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:SGR" name="SGR" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:GGR" name="GGR" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:FGR" name="FGR" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="BNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GTR implements Serializable
{
    private int choiceSelect = -1;
    private static final int GR_CHOICE = 0;
    private static final int SGR_CHOICE = 1;
    private static final int GGR_CHOICE = 2;
    private static final int FGR_CHOICE = 3;
    private GR GR;
    private SGR SGR;
    private GGR GGR;
    private FGR FGR;
    private String BNumber;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if GR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGR() {
        return choiceSelect == GR_CHOICE;
    }

    /** 
     * Get the 'GR' element value.
     * 
     * @return value
     */
    public GR getGR() {
        return GR;
    }

    /** 
     * Set the 'GR' element value.
     * 
     * @param GR
     */
    public void setGR(GR GR) {
        setChoiceSelect(GR_CHOICE);
        this.GR = GR;
    }

    /** 
     * Check if SGR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSGR() {
        return choiceSelect == SGR_CHOICE;
    }

    /** 
     * Get the 'SGR' element value.
     * 
     * @return value
     */
    public SGR getSGR() {
        return SGR;
    }

    /** 
     * Set the 'SGR' element value.
     * 
     * @param SGR
     */
    public void setSGR(SGR SGR) {
        setChoiceSelect(SGR_CHOICE);
        this.SGR = SGR;
    }

    /** 
     * Check if GGR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGGR() {
        return choiceSelect == GGR_CHOICE;
    }

    /** 
     * Get the 'GGR' element value.
     * 
     * @return value
     */
    public GGR getGGR() {
        return GGR;
    }

    /** 
     * Set the 'GGR' element value.
     * 
     * @param GGR
     */
    public void setGGR(GGR GGR) {
        setChoiceSelect(GGR_CHOICE);
        this.GGR = GGR;
    }

    /** 
     * Check if FGR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFGR() {
        return choiceSelect == FGR_CHOICE;
    }

    /** 
     * Get the 'FGR' element value.
     * 
     * @return value
     */
    public FGR getFGR() {
        return FGR;
    }

    /** 
     * Set the 'FGR' element value.
     * 
     * @param FGR
     */
    public void setFGR(FGR FGR) {
        setChoiceSelect(FGR_CHOICE);
        this.FGR = FGR;
    }

    /** 
     * Get the 'BNumber' element value.
     * 
     * @return value
     */
    public String getBNumber() {
        return BNumber;
    }

    /** 
     * Set the 'BNumber' element value.
     * 
     * @param BNumber
     */
    public void setBNumber(String BNumber) {
        this.BNumber = BNumber;
    }
}
