
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeType">
 *   &lt;xs:sequence minOccurs="0">
 *     &lt;!-- Reference to inner class Sequence -->
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GuaranteeType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GuaranteeType implements Serializable
{
    private Sequence sequence;
    private String guaranteeType;

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'GuaranteeType' attribute value.
     * 
     * @return value
     */
    public String getGuaranteeType() {
        return guaranteeType;
    }

    /** 
     * Set the 'GuaranteeType' attribute value.
     * 
     * @param guaranteeType
     */
    public void setGuaranteeType(String guaranteeType) {
        this.guaranteeType = guaranteeType;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element name="GuaranteesAccepted" minOccurs="0">
     *     &lt;!-- Reference to inner class GuaranteesAccepted -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Deadline" minOccurs="0">
     *     &lt;!-- Reference to inner class Deadline -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="AmountPercent" minOccurs="0">
     *     &lt;!-- Reference to inner class AmountPercent -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="GuaranteeDescription" minOccurs="0">
     *     &lt;!-- Reference to inner class GuaranteeDescription -->
     *   &lt;/xs:element>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private GuaranteesAccepted guaranteesAccepted;
        private Deadline deadline;
        private AmountPercent amountPercent;
        private GuaranteeDescription guaranteeDescription;

        /** 
         * Get the 'GuaranteesAccepted' element value.
         * 
         * @return value
         */
        public GuaranteesAccepted getGuaranteesAccepted() {
            return guaranteesAccepted;
        }

        /** 
         * Set the 'GuaranteesAccepted' element value.
         * 
         * @param guaranteesAccepted
         */
        public void setGuaranteesAccepted(GuaranteesAccepted guaranteesAccepted) {
            this.guaranteesAccepted = guaranteesAccepted;
        }

        /** 
         * Get the 'Deadline' element value.
         * 
         * @return value
         */
        public Deadline getDeadline() {
            return deadline;
        }

        /** 
         * Set the 'Deadline' element value.
         * 
         * @param deadline
         */
        public void setDeadline(Deadline deadline) {
            this.deadline = deadline;
        }

        /** 
         * Get the 'AmountPercent' element value.
         * 
         * @return value
         */
        public AmountPercent getAmountPercent() {
            return amountPercent;
        }

        /** 
         * Set the 'AmountPercent' element value.
         * 
         * @param amountPercent
         */
        public void setAmountPercent(AmountPercent amountPercent) {
            this.amountPercent = amountPercent;
        }

        /** 
         * Get the 'GuaranteeDescription' element value.
         * 
         * @return value
         */
        public GuaranteeDescription getGuaranteeDescription() {
            return guaranteeDescription;
        }

        /** 
         * Set the 'GuaranteeDescription' element value.
         * 
         * @param guaranteeDescription
         */
        public void setGuaranteeDescription(
                GuaranteeDescription guaranteeDescription) {
            this.guaranteeDescription = guaranteeDescription;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteesAccepted" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="GuaranteeAccepted" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class GuaranteeAccepted -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GuaranteesAccepted implements Serializable
        {
            private List<GuaranteeAccepted> guaranteeAcceptedList = new ArrayList<GuaranteeAccepted>();

            /** 
             * Get the list of 'GuaranteeAccepted' element items.
             * 
             * @return list
             */
            public List<GuaranteeAccepted> getGuaranteeAcceptedList() {
                return guaranteeAcceptedList;
            }

            /** 
             * Set the list of 'GuaranteeAccepted' element items.
             * 
             * @param list
             */
            public void setGuaranteeAcceptedList(List<GuaranteeAccepted> list) {
                guaranteeAcceptedList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeAccepted" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PaymentCards" minOccurs="0">
             *         &lt;!-- Reference to inner class PaymentCards -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PaymentCard" minOccurs="0">
             *         &lt;!-- Reference to inner class PaymentCard -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" name="GuaranteeTypeCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class GuaranteeAccepted implements Serializable
            {
                private PaymentCards paymentCards;
                private PaymentCard paymentCard;
                private Integer guaranteeTypeCode;

                /** 
                 * Get the 'PaymentCards' element value.
                 * 
                 * @return value
                 */
                public PaymentCards getPaymentCards() {
                    return paymentCards;
                }

                /** 
                 * Set the 'PaymentCards' element value.
                 * 
                 * @param paymentCards
                 */
                public void setPaymentCards(PaymentCards paymentCards) {
                    this.paymentCards = paymentCards;
                }

                /** 
                 * Get the 'PaymentCard' element value.
                 * 
                 * @return value
                 */
                public PaymentCard getPaymentCard() {
                    return paymentCard;
                }

                /** 
                 * Set the 'PaymentCard' element value.
                 * 
                 * @param paymentCard
                 */
                public void setPaymentCard(PaymentCard paymentCard) {
                    this.paymentCard = paymentCard;
                }

                /** 
                 * Get the 'GuaranteeTypeCode' attribute value. 
                                                    Uses OTA for PMT Table.
                                                
                 * 
                 * @return value
                 */
                public Integer getGuaranteeTypeCode() {
                    return guaranteeTypeCode;
                }

                /** 
                 * Set the 'GuaranteeTypeCode' attribute value. 
                                                    Uses OTA for PMT Table.
                                                
                 * 
                 * @param guaranteeTypeCode
                 */
                public void setGuaranteeTypeCode(Integer guaranteeTypeCode) {
                    this.guaranteeTypeCode = guaranteeTypeCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCards" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class PaymentCard -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PaymentCards implements Serializable
                {
                    private List<PaymentCard> paymentCardList = new ArrayList<PaymentCard>();

                    /** 
                     * Get the list of 'PaymentCard' element items.
                     * 
                     * @return list
                     */
                    public List<PaymentCard> getPaymentCardList() {
                        return paymentCardList;
                    }

                    /** 
                     * Set the list of 'PaymentCard' element items.
                     * 
                     * @param list
                     */
                    public void setPaymentCardList(List<PaymentCard> list) {
                        paymentCardList = list;
                    }
                    /** 
                     * The Card like Credit card or debit card
                                                                      which is used to pay
                                                                  
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="required" name="CardCode"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PaymentCard implements Serializable
                    {
                        private String string;
                        private String cardCode;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'CardCode' attribute value. Code identifying the card type
                                                                                    
                         * 
                         * @return value
                         */
                        public String getCardCode() {
                            return cardCode;
                        }

                        /** 
                         * Set the 'CardCode' attribute value. Code identifying the card type
                                                                                    
                         * 
                         * @param cardCode
                         */
                        public void setCardCode(String cardCode) {
                            this.cardCode = cardCode;
                        }
                    }
                }
                /** 
                 * Not used since 19.4
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" use="required" name="CardCode"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PaymentCard implements Serializable
                {
                    private String string;
                    private String cardCode;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'CardCode' attribute value. Code identifying the card type
                                                                      
                     * 
                     * @return value
                     */
                    public String getCardCode() {
                        return cardCode;
                    }

                    /** 
                     * Set the 'CardCode' attribute value. Code identifying the card type
                                                                      
                     * 
                     * @param cardCode
                     */
                    public void setCardCode(String cardCode) {
                        this.cardCode = cardCode;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deadline" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AbsoluteDeadline"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="OffsetTimeUnit"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="OffsetUnitMultiplier"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="OffsetDropTime"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Deadline implements Serializable
        {
            private String absoluteDeadline;
            private String offsetTimeUnit;
            private String offsetUnitMultiplier;
            private String offsetDropTime;

            /** 
             * Get the 'AbsoluteDeadline' attribute value.
             * 
             * @return value
             */
            public String getAbsoluteDeadline() {
                return absoluteDeadline;
            }

            /** 
             * Set the 'AbsoluteDeadline' attribute value.
             * 
             * @param absoluteDeadline
             */
            public void setAbsoluteDeadline(String absoluteDeadline) {
                this.absoluteDeadline = absoluteDeadline;
            }

            /** 
             * Get the 'OffsetTimeUnit' attribute value.
             * 
             * @return value
             */
            public String getOffsetTimeUnit() {
                return offsetTimeUnit;
            }

            /** 
             * Set the 'OffsetTimeUnit' attribute value.
             * 
             * @param offsetTimeUnit
             */
            public void setOffsetTimeUnit(String offsetTimeUnit) {
                this.offsetTimeUnit = offsetTimeUnit;
            }

            /** 
             * Get the 'OffsetUnitMultiplier' attribute value.
             * 
             * @return value
             */
            public String getOffsetUnitMultiplier() {
                return offsetUnitMultiplier;
            }

            /** 
             * Set the 'OffsetUnitMultiplier' attribute value.
             * 
             * @param offsetUnitMultiplier
             */
            public void setOffsetUnitMultiplier(String offsetUnitMultiplier) {
                this.offsetUnitMultiplier = offsetUnitMultiplier;
            }

            /** 
             * Get the 'OffsetDropTime' attribute value.
             * 
             * @return value
             */
            public String getOffsetDropTime() {
                return offsetDropTime;
            }

            /** 
             * Set the 'OffsetDropTime' attribute value.
             * 
             * @param offsetDropTime
             */
            public void setOffsetDropTime(String offsetDropTime) {
                this.offsetDropTime = offsetDropTime;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmountPercent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="TaxInclusive"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="FeesInclusive"/>
         *     &lt;xs:attribute type="xs:int" use="optional" name="NmbrOfNights"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="BasisType"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Percent"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ApplyAs"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AmountPercent implements Serializable
        {
            private Boolean taxInclusive;
            private Boolean feesInclusive;
            private Integer nmbrOfNights;
            private String basisType;
            private BigDecimal percent;
            private BigDecimal amount;
            private String currencyCode;
            private String applyAs;

            /** 
             * Get the 'TaxInclusive' attribute value.
             * 
             * @return value
             */
            public Boolean getTaxInclusive() {
                return taxInclusive;
            }

            /** 
             * Set the 'TaxInclusive' attribute value.
             * 
             * @param taxInclusive
             */
            public void setTaxInclusive(Boolean taxInclusive) {
                this.taxInclusive = taxInclusive;
            }

            /** 
             * Get the 'FeesInclusive' attribute value.
             * 
             * @return value
             */
            public Boolean getFeesInclusive() {
                return feesInclusive;
            }

            /** 
             * Set the 'FeesInclusive' attribute value.
             * 
             * @param feesInclusive
             */
            public void setFeesInclusive(Boolean feesInclusive) {
                this.feesInclusive = feesInclusive;
            }

            /** 
             * Get the 'NmbrOfNights' attribute value.
             * 
             * @return value
             */
            public Integer getNmbrOfNights() {
                return nmbrOfNights;
            }

            /** 
             * Set the 'NmbrOfNights' attribute value.
             * 
             * @param nmbrOfNights
             */
            public void setNmbrOfNights(Integer nmbrOfNights) {
                this.nmbrOfNights = nmbrOfNights;
            }

            /** 
             * Get the 'BasisType' attribute value.
             * 
             * @return value
             */
            public String getBasisType() {
                return basisType;
            }

            /** 
             * Set the 'BasisType' attribute value.
             * 
             * @param basisType
             */
            public void setBasisType(String basisType) {
                this.basisType = basisType;
            }

            /** 
             * Get the 'Percent' attribute value.
             * 
             * @return value
             */
            public BigDecimal getPercent() {
                return percent;
            }

            /** 
             * Set the 'Percent' attribute value.
             * 
             * @param percent
             */
            public void setPercent(BigDecimal percent) {
                this.percent = percent;
            }

            /** 
             * Get the 'Amount' attribute value.
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value.
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'CurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'ApplyAs' attribute value.
             * 
             * @return value
             */
            public String getApplyAs() {
                return applyAs;
            }

            /** 
             * Set the 'ApplyAs' attribute value.
             * 
             * @param applyAs
             */
            public void setApplyAs(String applyAs) {
                this.applyAs = applyAs;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteeDescription" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GuaranteeDescription implements Serializable
        {
            private String text;

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }
        }
    }
}
