
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * List of Guests for a room
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guests">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Guest" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Guest -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="optional" name="Count"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Guests implements Serializable
{
    private List<Guest> guestList = new ArrayList<Guest>();
    private Integer count;

    /** 
     * Get the list of 'Guest' element items.
     * 
     * @return list
     */
    public List<Guest> getGuestList() {
        return guestList;
    }

    /** 
     * Set the list of 'Guest' element items.
     * 
     * @param list
     */
    public void setGuestList(List<Guest> list) {
        guestList = list;
    }

    /** 
     * Get the 'Count' attribute value.
     * 
     * @return value
     */
    public Integer getCount() {
        return count;
    }

    /** 
     * Set the 'Count' attribute value.
     * 
     * @param count
     */
    public void setCount(Integer count) {
        this.count = count;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guest" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:ResponseGuestInformation">
     *         &lt;xs:attribute type="xs:int" use="optional" name="Type"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Guest extends ResponseGuestInformation implements
        Serializable
    {
        private Integer type;

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public Integer getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param type
         */
        public void setType(Integer type) {
            this.type = type;
        }
    }
}
