
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="xs:string" name="Custom" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Invoice implements Serializable
{
    private int choiceSelect = -1;
    private static final int TEXT_CHOICE = 0;
    private static final int CUSTOM_CHOICE = 1;
    private Sequence text;
    private String custom;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Text is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifText() {
        return choiceSelect == TEXT_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getText() {
        return text;
    }

    /** 
     * Set the sequence value.
     * 
     * @param text
     */
    public void setText(Sequence text) {
        setChoiceSelect(TEXT_CHOICE);
        this.text = text;
    }

    /** 
     * Check if Custom is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustom() {
        return choiceSelect == CUSTOM_CHOICE;
    }

    /** 
     * Get the 'Custom' element value.
     * 
     * @return value
     */
    public String getCustom() {
        return custom;
    }

    /** 
     * Set the 'Custom' element value.
     * 
     * @param custom
     */
    public void setCustom(String custom) {
        setChoiceSelect(CUSTOM_CHOICE);
        this.custom = custom;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="xs:string" name="BNumber" minOccurs="0" maxOccurs="1"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private String text;
        private String BNumber;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'BNumber' element value.
         * 
         * @return value
         */
        public String getBNumber() {
            return BNumber;
        }

        /** 
         * Set the 'BNumber' element value.
         * 
         * @param BNumber
         */
        public void setBNumber(String BNumber) {
            this.BNumber = BNumber;
        }
    }
}
