
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LangMatchDataType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="Id"/>
 *       &lt;xs:element type="xs:string" name="Content"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="ElementType"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LangMatchDataType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ID_CHOICE = 0;
    private static final int CONTENT_CHOICE = 1;
    private String id;
    private String content;
    private String elementType;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Id is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifId() {
        return choiceSelect == ID_CHOICE;
    }

    /** 
     * Get the 'Id' element value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'Id' element value.
     * 
     * @param id
     */
    public void setId(String id) {
        setChoiceSelect(ID_CHOICE);
        this.id = id;
    }

    /** 
     * Check if Content is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifContent() {
        return choiceSelect == CONTENT_CHOICE;
    }

    /** 
     * Get the 'Content' element value.
     * 
     * @return value
     */
    public String getContent() {
        return content;
    }

    /** 
     * Set the 'Content' element value.
     * 
     * @param content
     */
    public void setContent(String content) {
        setChoiceSelect(CONTENT_CHOICE);
        this.content = content;
    }

    /** 
     * Get the 'ElementType' element value.
     * 
     * @return value
     */
    public String getElementType() {
        return elementType;
    }

    /** 
     * Set the 'ElementType' element value.
     * 
     * @param elementType
     */
    public void setElementType(String elementType) {
        this.elementType = elementType;
    }
}
