
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DateTime" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="Comments" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LocationDetailsType implements Serializable
{
    private AddressType address;
    private Date dateTime;
    private Choice choice;
    private String comments;

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'DateTime' element value.
     * 
     * @return value
     */
    public Date getDateTime() {
        return dateTime;
    }

    /** 
     * Set the 'DateTime' element value.
     * 
     * @param dateTime
     */
    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Comments' element value.
     * 
     * @return value
     */
    public String getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value.
     * 
     * @param comments
     */
    public void setComments(String comments) {
        this.comments = comments;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:AirportInfoType" name="AirportInfo" minOccurs="0"/>
     *   &lt;xs:element name="RailwayStationInfo" minOccurs="0">
     *     &lt;!-- Reference to inner class RailwayStationInfo -->
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AIRPORT_INFO_CHOICE = 0;
        private static final int RAILWAY_STATION_INFO_CHOICE = 1;
        private AirportInfoType airportInfo;
        private RailwayStationInfo railwayStationInfo;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AirportInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAirportInfo() {
            return choiceSelect == AIRPORT_INFO_CHOICE;
        }

        /** 
         * Get the 'AirportInfo' element value.
         * 
         * @return value
         */
        public AirportInfoType getAirportInfo() {
            return airportInfo;
        }

        /** 
         * Set the 'AirportInfo' element value.
         * 
         * @param airportInfo
         */
        public void setAirportInfo(AirportInfoType airportInfo) {
            setChoiceSelect(AIRPORT_INFO_CHOICE);
            this.airportInfo = airportInfo;
        }

        /** 
         * Check if RailwayStationInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRailwayStationInfo() {
            return choiceSelect == RAILWAY_STATION_INFO_CHOICE;
        }

        /** 
         * Get the 'RailwayStationInfo' element value.
         * 
         * @return value
         */
        public RailwayStationInfo getRailwayStationInfo() {
            return railwayStationInfo;
        }

        /** 
         * Set the 'RailwayStationInfo' element value.
         * 
         * @param railwayStationInfo
         */
        public void setRailwayStationInfo(RailwayStationInfo railwayStationInfo) {
            setChoiceSelect(RAILWAY_STATION_INFO_CHOICE);
            this.railwayStationInfo = railwayStationInfo;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailwayStationInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:RailwayStationInfoType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="StationName" minOccurs="0">
         *             &lt;!-- Reference to inner class StationName -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="LocalStationName" minOccurs="0">
         *             &lt;!-- Reference to inner class LocalStationName -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="LocationCodes" minOccurs="0">
         *             &lt;!-- Reference to inner class LocationCodes -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="Amenities" minOccurs="0">
         *             &lt;!-- Reference to inner class Amenities -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *         &lt;xs:attribute type="xs:anySimpleType" name="borderPoint"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RailwayStationInfo extends RailwayStationInfoType
            implements Serializable
        {
            private StationName stationName;
            private LocalStationName localStationName;
            private LocationCodes locationCodes;
            private Amenities amenities;
            private String borderPoint;

            /** 
             * Get the 'StationName' element value.
             * 
             * @return value
             */
            public StationName getStationName() {
                return stationName;
            }

            /** 
             * Set the 'StationName' element value.
             * 
             * @param stationName
             */
            public void setStationName(StationName stationName) {
                this.stationName = stationName;
            }

            /** 
             * Get the 'LocalStationName' element value.
             * 
             * @return value
             */
            public LocalStationName getLocalStationName() {
                return localStationName;
            }

            /** 
             * Set the 'LocalStationName' element value.
             * 
             * @param localStationName
             */
            public void setLocalStationName(LocalStationName localStationName) {
                this.localStationName = localStationName;
            }

            /** 
             * Get the 'LocationCodes' element value.
             * 
             * @return value
             */
            public LocationCodes getLocationCodes() {
                return locationCodes;
            }

            /** 
             * Set the 'LocationCodes' element value.
             * 
             * @param locationCodes
             */
            public void setLocationCodes(LocationCodes locationCodes) {
                this.locationCodes = locationCodes;
            }

            /** 
             * Get the 'Amenities' element value.
             * 
             * @return value
             */
            public Amenities getAmenities() {
                return amenities;
            }

            /** 
             * Set the 'Amenities' element value.
             * 
             * @param amenities
             */
            public void setAmenities(Amenities amenities) {
                this.amenities = amenities;
            }

            /** 
             * Get the 'borderPoint' attribute value.
             * 
             * @return value
             */
            public String getBorderPoint() {
                return borderPoint;
            }

            /** 
             * Set the 'borderPoint' attribute value.
             * 
             * @param borderPoint
             */
            public void setBorderPoint(String borderPoint) {
                this.borderPoint = borderPoint;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StationName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="lang"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class StationName implements Serializable
            {
                private String string;
                private String lang;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'lang' attribute value.
                 * 
                 * @return value
                 */
                public String getLang() {
                    return lang;
                }

                /** 
                 * Set the 'lang' attribute value.
                 * 
                 * @param lang
                 */
                public void setLang(String lang) {
                    this.lang = lang;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocalStationName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="lang"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class LocalStationName implements Serializable
            {
                private String string;
                private String lang;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'lang' attribute value.
                 * 
                 * @return value
                 */
                public String getLang() {
                    return lang;
                }

                /** 
                 * Set the 'lang' attribute value.
                 * 
                 * @param lang
                 */
                public void setLang(String lang) {
                    this.lang = lang;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationCodes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Code" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Code -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class LocationCodes implements Serializable
            {
                private List<Code> codeList = new ArrayList<Code>();

                /** 
                 * Get the list of 'Code' element items.
                 * 
                 * @return list
                 */
                public List<Code> getCodeList() {
                    return codeList;
                }

                /** 
                 * Set the list of 'Code' element items.
                 * 
                 * @param list
                 */
                public void setCodeList(List<Code> list) {
                    codeList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Code implements Serializable
                {
                    private String string;
                    private String codeContext;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'codeContext' attribute value.
                     * 
                     * @return value
                     */
                    public String getCodeContext() {
                        return codeContext;
                    }

                    /** 
                     * Set the 'codeContext' attribute value.
                     * 
                     * @param codeContext
                     */
                    public void setCodeContext(String codeContext) {
                        this.codeContext = codeContext;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amenities" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Amenity" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amenities implements Serializable
            {
                private List<String> amenityList = new ArrayList<String>();

                /** 
                 * Get the list of 'Amenity' element items.
                 * 
                 * @return list
                 */
                public List<String> getAmenityList() {
                    return amenityList;
                }

                /** 
                 * Set the list of 'Amenity' element items.
                 * 
                 * @param list
                 */
                public void setAmenityList(List<String> list) {
                    amenityList = list;
                }
            }
        }
    }
}
