
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceBreakDownType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PassengerTypeCode" name="PassengerType"/>
 *     &lt;xs:element type="xs:int" default="1" name="NumberOfPassengers"/>
 *     &lt;xs:element type="ns:DecimalPrice" name="BasePrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:DecimalPrice" name="EquivPrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:TaxesType" name="Taxes" minOccurs="0"/>
 *     &lt;xs:element type="ns:DecimalPrice" name="Price"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceBreakDownType implements Serializable
{
    private PassengerTypeCode passengerType;
    private int numberOfPassengers;
    private DecimalPrice basePrice;
    private DecimalPrice equivPrice;
    private TaxesType taxes;
    private DecimalPrice price;

    /** 
     * Get the 'PassengerType' element value. PassengerType used for breakdown.
     * 
     * @return value
     */
    public PassengerTypeCode getPassengerType() {
        return passengerType;
    }

    /** 
     * Set the 'PassengerType' element value. PassengerType used for breakdown.
     * 
     * @param passengerType
     */
    public void setPassengerType(PassengerTypeCode passengerType) {
        this.passengerType = passengerType;
    }

    /** 
     * Get the 'NumberOfPassengers' element value. Number of Passengers each Type used for itinerary pricing.
     * 
     * @return value
     */
    public int getNumberOfPassengers() {
        return numberOfPassengers;
    }

    /** 
     * Set the 'NumberOfPassengers' element value. Number of Passengers each Type used for itinerary pricing.
     * 
     * @param numberOfPassengers
     */
    public void setNumberOfPassengers(int numberOfPassengers) {
        this.numberOfPassengers = numberOfPassengers;
    }

    /** 
     * Get the 'BasePrice' element value.
     * 
     * @return value
     */
    public DecimalPrice getBasePrice() {
        return basePrice;
    }

    /** 
     * Set the 'BasePrice' element value.
     * 
     * @param basePrice
     */
    public void setBasePrice(DecimalPrice basePrice) {
        this.basePrice = basePrice;
    }

    /** 
     * Get the 'EquivPrice' element value.
     * 
     * @return value
     */
    public DecimalPrice getEquivPrice() {
        return equivPrice;
    }

    /** 
     * Set the 'EquivPrice' element value.
     * 
     * @param equivPrice
     */
    public void setEquivPrice(DecimalPrice equivPrice) {
        this.equivPrice = equivPrice;
    }

    /** 
     * Get the 'Taxes' element value. Taxes by code summary.
     * 
     * @return value
     */
    public TaxesType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Taxes by code summary.
     * 
     * @param taxes
     */
    public void setTaxes(TaxesType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'Price' element value.
     * 
     * @return value
     */
    public DecimalPrice getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value.
     * 
     * @param price
     */
    public void setPrice(DecimalPrice price) {
        this.price = price;
    }
}
