
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriorityComplexType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriorityType" name="Price" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriorityLegType" name="DirectFlights" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriorityType" name="Time" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriorityType" name="Vendor" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="MarketingCarrier" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="OperatingCarrier" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriorityType" name="ElapsedTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriorityLegType" name="DepartureTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriorityLegType" name="ConnectionTime" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriorityComplexType implements Serializable
{
    private PriorityType price;
    private PriorityLegType directFlights;
    private PriorityType time;
    private PriorityType vendor;
    private CarrierType marketingCarrier;
    private CarrierType operatingCarrier;
    private PriorityType elapsedTime;
    private PriorityLegType departureTime;
    private PriorityLegType connectionTime;

    /** 
     * Get the 'Price' element value. Prefer cheaper itineraries
     * 
     * @return value
     */
    public PriorityType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Prefer cheaper itineraries
     * 
     * @param price
     */
    public void setPrice(PriorityType price) {
        this.price = price;
    }

    /** 
     * Get the 'DirectFlights' element value. Prefer itineraries will less connections
     * 
     * @return value
     */
    public PriorityLegType getDirectFlights() {
        return directFlights;
    }

    /** 
     * Set the 'DirectFlights' element value. Prefer itineraries will less connections
     * 
     * @param directFlights
     */
    public void setDirectFlights(PriorityLegType directFlights) {
        this.directFlights = directFlights;
    }

    /** 
     * Get the 'Time' element value. Prefer itineraries departing closer to requested departure time
                      
     * 
     * @return value
     */
    public PriorityType getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. Prefer itineraries departing closer to requested departure time
                      
     * 
     * @param time
     */
    public void setTime(PriorityType time) {
        this.time = time;
    }

    /** 
     * Get the 'Vendor' element value. Promote certain marketing carriers over all the others in returning
                          results. (configured in rules).
                      
     * 
     * @return value
     */
    public PriorityType getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value. Promote certain marketing carriers over all the others in returning
                          results. (configured in rules).
                      
     * 
     * @param vendor
     */
    public void setVendor(PriorityType vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'MarketingCarrier' element value. Prefer itineraries with marketing carriers in order speciied in
                          Carrier subtags, comparing segment-wise
                      
     * 
     * @return value
     */
    public CarrierType getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value. Prefer itineraries with marketing carriers in order speciied in
                          Carrier subtags, comparing segment-wise
                      
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(CarrierType marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Get the 'OperatingCarrier' element value. Prefer itineraries with operating carriers in order speciied in
                          Carrier subtags, comparing segment-wise
                      
     * 
     * @return value
     */
    public CarrierType getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value. Prefer itineraries with operating carriers in order speciied in
                          Carrier subtags, comparing segment-wise
                      
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(CarrierType operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'ElapsedTime' element value. Prefer itineraries with shorter travel times
     * 
     * @return value
     */
    public PriorityType getElapsedTime() {
        return elapsedTime;
    }

    /** 
     * Set the 'ElapsedTime' element value. Prefer itineraries with shorter travel times
     * 
     * @param elapsedTime
     */
    public void setElapsedTime(PriorityType elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    /** 
     * Get the 'DepartureTime' element value. Prefer itineraries departing earlier during the day
     * 
     * @return value
     */
    public PriorityLegType getDepartureTime() {
        return departureTime;
    }

    /** 
     * Set the 'DepartureTime' element value. Prefer itineraries departing earlier during the day
     * 
     * @param departureTime
     */
    public void setDepartureTime(PriorityLegType departureTime) {
        this.departureTime = departureTime;
    }

    /** 
     * Get the 'ConnectionTime' element value. Prefer itineraries with smaller amount of time waiting in the airports
                          during connections
                      
     * 
     * @return value
     */
    public PriorityLegType getConnectionTime() {
        return connectionTime;
    }

    /** 
     * Set the 'ConnectionTime' element value. Prefer itineraries with smaller amount of time waiting in the airports
                          during connections
                      
     * 
     * @param connectionTime
     */
    public void setConnectionTime(PriorityLegType connectionTime) {
        this.connectionTime = connectionTime;
    }
}
