
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ID"/>
 *     &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Source" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ShortType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PolicyId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreferenceId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PolicyRemovalReason" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OwningAgency" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileType implements Serializable
{
    private String ID;
    private String type;
    private String source;
    private String shortType;
    private String policyId;
    private String preferenceId;
    private String policyRemovalReason;
    private String owningAgency;

    /** 
     * Get the 'ID' element value.
     * 
     * @return value
     */
    public String getID() {
        return ID;
    }

    /** 
     * Set the 'ID' element value.
     * 
     * @param ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /** 
     * Get the 'Type' element value. Type of Profile, it will be having full name like TAGENCY, TAGENCT etc
    				
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Type of Profile, it will be having full name like TAGENCY, TAGENCT etc
    				
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Source' element value.
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value.
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the 'ShortType' element value. Type of Profile, same as above but in short, it will be having name like AGY, AGT
    					etc
    				
     * 
     * @return value
     */
    public String getShortType() {
        return shortType;
    }

    /** 
     * Set the 'ShortType' element value. Type of Profile, same as above but in short, it will be having name like AGY, AGT
    					etc
    				
     * 
     * @param shortType
     */
    public void setShortType(String shortType) {
        this.shortType = shortType;
    }

    /** 
     * Get the 'PolicyId' element value. PolicyId of the profile
     * 
     * @return value
     */
    public String getPolicyId() {
        return policyId;
    }

    /** 
     * Set the 'PolicyId' element value. PolicyId of the profile
     * 
     * @param policyId
     */
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    /** 
     * Get the 'PreferenceId' element value. PreferenceId of the profile
     * 
     * @return value
     */
    public String getPreferenceId() {
        return preferenceId;
    }

    /** 
     * Set the 'PreferenceId' element value. PreferenceId of the profile
     * 
     * @param preferenceId
     */
    public void setPreferenceId(String preferenceId) {
        this.preferenceId = preferenceId;
    }

    /** 
     * Get the 'PolicyRemovalReason' element value. Reason for removing the reason
     * 
     * @return value
     */
    public String getPolicyRemovalReason() {
        return policyRemovalReason;
    }

    /** 
     * Set the 'PolicyRemovalReason' element value. Reason for removing the reason
     * 
     * @param policyRemovalReason
     */
    public void setPolicyRemovalReason(String policyRemovalReason) {
        this.policyRemovalReason = policyRemovalReason;
    }

    /** 
     * Get the 'OwningAgency' element value. Name of the PCC where this profile is stored
     * 
     * @return value
     */
    public String getOwningAgency() {
        return owningAgency;
    }

    /** 
     * Set the 'OwningAgency' element value. Name of the PCC where this profile is stored
     * 
     * @param owningAgency
     */
    public void setOwningAgency(String owningAgency) {
        this.owningAgency = owningAgency;
    }
}
