
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Open" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="CrossBorder" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0"/>
 *     &lt;xs:element type="ns:CompanyType" name="MarketingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="ns:ServiceProviderType" name="OperatingCarrier" minOccurs="0"/>
 *     &lt;xs:element name="Passengers" minOccurs="0">
 *       &lt;!-- Reference to inner class Passengers -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SupplementaryServices" minOccurs="0">
 *       &lt;!-- Reference to inner class SupplementaryServices -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:TrainDetailsType" name="TrainInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:RailAccommodationType" name="Accommodation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="StartDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="StopDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="EndDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:RailFareType" name="RailFares" minOccurs="0"/>
 *     &lt;xs:element name="Documents" minOccurs="0">
 *       &lt;!-- Reference to inner class Documents -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Details" minOccurs="0">
 *       &lt;!-- Reference to inner class Details -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailType implements Serializable
{
    private String statusCode;
    private Boolean open;
    private Boolean crossBorder;
    private String duration;
    private CompanyType marketingCarrier;
    private ServiceProviderType operatingCarrier;
    private Passengers passengers;
    private SupplementaryServices supplementaryServices;
    private TrainDetailsType trainInfo;
    private List<RailAccommodationType> accommodationList = new ArrayList<RailAccommodationType>();
    private LocationDetailsType startDetails;
    private List<LocationDetailsType> stopDetailList = new ArrayList<LocationDetailsType>();
    private LocationDetailsType endDetails;
    private RailFareType railFares;
    private Documents documents;
    private Details details;

    /** 
     * Get the 'StatusCode' element value.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'Open' element value.
     * 
     * @return value
     */
    public Boolean getOpen() {
        return open;
    }

    /** 
     * Set the 'Open' element value.
     * 
     * @param open
     */
    public void setOpen(Boolean open) {
        this.open = open;
    }

    /** 
     * Get the 'CrossBorder' element value.
     * 
     * @return value
     */
    public Boolean getCrossBorder() {
        return crossBorder;
    }

    /** 
     * Set the 'CrossBorder' element value.
     * 
     * @param crossBorder
     */
    public void setCrossBorder(Boolean crossBorder) {
        this.crossBorder = crossBorder;
    }

    /** 
     * Get the 'Duration' element value.
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value.
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'MarketingCarrier' element value.
     * 
     * @return value
     */
    public CompanyType getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value.
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(CompanyType marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Get the 'OperatingCarrier' element value.
     * 
     * @return value
     */
    public ServiceProviderType getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value.
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(ServiceProviderType operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'SupplementaryServices' element value.
     * 
     * @return value
     */
    public SupplementaryServices getSupplementaryServices() {
        return supplementaryServices;
    }

    /** 
     * Set the 'SupplementaryServices' element value.
     * 
     * @param supplementaryServices
     */
    public void setSupplementaryServices(
            SupplementaryServices supplementaryServices) {
        this.supplementaryServices = supplementaryServices;
    }

    /** 
     * Get the 'TrainInfo' element value.
     * 
     * @return value
     */
    public TrainDetailsType getTrainInfo() {
        return trainInfo;
    }

    /** 
     * Set the 'TrainInfo' element value.
     * 
     * @param trainInfo
     */
    public void setTrainInfo(TrainDetailsType trainInfo) {
        this.trainInfo = trainInfo;
    }

    /** 
     * Get the list of 'Accommodation' element items.
     * 
     * @return list
     */
    public List<RailAccommodationType> getAccommodationList() {
        return accommodationList;
    }

    /** 
     * Set the list of 'Accommodation' element items.
     * 
     * @param list
     */
    public void setAccommodationList(List<RailAccommodationType> list) {
        accommodationList = list;
    }

    /** 
     * Get the 'StartDetails' element value.
     * 
     * @return value
     */
    public LocationDetailsType getStartDetails() {
        return startDetails;
    }

    /** 
     * Set the 'StartDetails' element value.
     * 
     * @param startDetails
     */
    public void setStartDetails(LocationDetailsType startDetails) {
        this.startDetails = startDetails;
    }

    /** 
     * Get the list of 'StopDetails' element items.
     * 
     * @return list
     */
    public List<LocationDetailsType> getStopDetailList() {
        return stopDetailList;
    }

    /** 
     * Set the list of 'StopDetails' element items.
     * 
     * @param list
     */
    public void setStopDetailList(List<LocationDetailsType> list) {
        stopDetailList = list;
    }

    /** 
     * Get the 'EndDetails' element value.
     * 
     * @return value
     */
    public LocationDetailsType getEndDetails() {
        return endDetails;
    }

    /** 
     * Set the 'EndDetails' element value.
     * 
     * @param endDetails
     */
    public void setEndDetails(LocationDetailsType endDetails) {
        this.endDetails = endDetails;
    }

    /** 
     * Get the 'RailFares' element value.
     * 
     * @return value
     */
    public RailFareType getRailFares() {
        return railFares;
    }

    /** 
     * Set the 'RailFares' element value.
     * 
     * @param railFares
     */
    public void setRailFares(RailFareType railFares) {
        this.railFares = railFares;
    }

    /** 
     * Get the 'Documents' element value.
     * 
     * @return value
     */
    public Documents getDocuments() {
        return documents;
    }

    /** 
     * Set the 'Documents' element value.
     * 
     * @param documents
     */
    public void setDocuments(Documents documents) {
        this.documents = documents;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PassengerType" name="Passenger" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="quantity"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private List<PassengerType> passengerList = new ArrayList<PassengerType>();
        private String quantity;

        /** 
         * Get the list of 'Passenger' element items.
         * 
         * @return list
         */
        public List<PassengerType> getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the list of 'Passenger' element items.
         * 
         * @param list
         */
        public void setPassengerList(List<PassengerType> list) {
            passengerList = list;
        }

        /** 
         * Get the 'quantity' attribute value.
         * 
         * @return value
         */
        public String getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'quantity' attribute value.
         * 
         * @param quantity
         */
        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SupplementaryServices" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:SupplementaryServiceType" name="SupplementaryService" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SupplementaryServices implements Serializable
    {
        private List<SupplementaryServiceType> supplementaryServiceList = new ArrayList<SupplementaryServiceType>();

        /** 
         * Get the list of 'SupplementaryService' element items.
         * 
         * @return list
         */
        public List<SupplementaryServiceType> getSupplementaryServiceList() {
            return supplementaryServiceList;
        }

        /** 
         * Set the list of 'SupplementaryService' element items.
         * 
         * @param list
         */
        public void setSupplementaryServiceList(
                List<SupplementaryServiceType> list) {
            supplementaryServiceList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Documents" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:DocumentType" name="Document" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Documents implements Serializable
    {
        private List<DocumentType> documentList = new ArrayList<DocumentType>();

        /** 
         * Get the list of 'Document' element items.
         * 
         * @return list
         */
        public List<DocumentType> getDocumentList() {
            return documentList;
        }

        /** 
         * Set the list of 'Document' element items.
         * 
         * @param list
         */
        public void setDocumentList(List<DocumentType> list) {
            documentList = list;
        }
    }
    /** 
     * added by Rail Team - to be checked what for
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Detail" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Detail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private List<Detail> detailList = new ArrayList<Detail>();

        /** 
         * Get the list of 'Detail' element items.
         * 
         * @return list
         */
        public List<Detail> getDetailList() {
            return detailList;
        }

        /** 
         * Set the list of 'Detail' element items.
         * 
         * @param list
         */
        public void setDetailList(List<Detail> list) {
            detailList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="required" name="type"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Detail implements Serializable
        {
            private String string;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
    }
}
