
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Added Optional Full Name to Guest Information because sometimes first name/last name is not returned
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseGuestInformation">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ExtendedGuestInformation">
 *       &lt;xs:attribute type="xs:string" use="optional" name="FullName"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResponseGuestInformation extends ExtendedGuestInformation
    implements Serializable
{
    private String fullName;

    /** 
     * Get the 'FullName' attribute value. In response sometimes aggregator does not return first name / last name and only full name is returned
     * 
     * @return value
     */
    public String getFullName() {
        return fullName;
    }

    /** 
     * Set the 'FullName' attribute value. In response sometimes aggregator does not return first name / last name and only full name is returned
     * 
     * @param fullName
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }
}
