
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * For adding extras to a Room 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomExtra">
 *   &lt;xs:attribute type="xs:int" use="required" name="Type"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="Quantity"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RoomExtra implements Serializable
{
    private int type;
    private Integer quantity;
    private BigDecimal amount;

    /** 
     * Get the 'Type' attribute value. Uses RMA OTA Table. Only 3 supported CRIB/Rollaway bed/Extra person
     * 
     * @return value
     */
    public int getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Uses RMA OTA Table. Only 3 supported CRIB/Rollaway bed/Extra person
     * 
     * @param type
     */
    public void setType(int type) {
        this.type = type;
    }

    /** 
     * Get the 'Quantity' attribute value. Quantity for room extras. Mandatory for request
     * 
     * @return value
     */
    public Integer getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' attribute value. Quantity for room extras. Mandatory for request
     * 
     * @param quantity
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the 'Amount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
}
