
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomInformation">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:BasicRoom">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:Guests" name="Guests" minOccurs="0"/>
 *         &lt;xs:element name="RoomDescription" minOccurs="0">
 *           &lt;!-- Reference to inner class RoomDescription -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:RoomExtras" name="RoomExtras" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="ConfirmationCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CancellationCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="BookingStatus" minOccurs="0"/>
 *         &lt;xs:element type="ns:RatePlanType" name="RatePlan" minOccurs="0"/>
 *         &lt;xs:element type="ns:ValueAdds" name="ValueAdds" minOccurs="0"/>
 *         &lt;xs:element type="ns:SpecialInstructions" name="SpecialInstructions" minOccurs="0"/>
 *         &lt;xs:element type="ns:LodgingSearchParameters" name="SearchParameters" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="RoomTypeCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="RoomType"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="InvBlockCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="RoomCategory"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="RoomId"/>
 *       &lt;xs:attribute type="xs:int" use="optional" name="SegmentNumber"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="Floor"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="RoomViewCode"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="SharedRoomInd"/>
 *       &lt;xs:attribute type="xs:int" use="optional" name="GuestRoomInfo"/>
 *       &lt;xs:attribute type="ns:UpdateActionCode" use="optional" name="Action"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RoomInformation extends BasicRoom implements Serializable
{
    private Guests guests;
    private RoomDescription roomDescription;
    private RoomExtras roomExtras;
    private String confirmationCode;
    private String cancellationCode;
    private String bookingStatus;
    private RatePlanType ratePlan;
    private ValueAdds valueAdds;
    private SpecialInstructions specialInstructions;
    private LodgingSearchParameters searchParameters;
    private String roomTypeCode;
    private String roomType;
    private String invBlockCode;
    private String roomCategory;
    private String roomId;
    private Integer segmentNumber;
    private String floor;
    private String roomViewCode;
    private Boolean sharedRoomInd;
    private Integer guestRoomInfo;
    private UpdateActionCode action;

    /** 
     * Get the 'Guests' element value.
     * 
     * @return value
     */
    public Guests getGuests() {
        return guests;
    }

    /** 
     * Set the 'Guests' element value.
     * 
     * @param guests
     */
    public void setGuests(Guests guests) {
        this.guests = guests;
    }

    /** 
     * Get the 'RoomDescription' element value.
     * 
     * @return value
     */
    public RoomDescription getRoomDescription() {
        return roomDescription;
    }

    /** 
     * Set the 'RoomDescription' element value.
     * 
     * @param roomDescription
     */
    public void setRoomDescription(RoomDescription roomDescription) {
        this.roomDescription = roomDescription;
    }

    /** 
     * Get the 'RoomExtras' element value.
     * 
     * @return value
     */
    public RoomExtras getRoomExtras() {
        return roomExtras;
    }

    /** 
     * Set the 'RoomExtras' element value.
     * 
     * @param roomExtras
     */
    public void setRoomExtras(RoomExtras roomExtras) {
        this.roomExtras = roomExtras;
    }

    /** 
     * Get the 'ConfirmationCode' element value. Room level Booking Confirmation Code if it exists
     * 
     * @return value
     */
    public String getConfirmationCode() {
        return confirmationCode;
    }

    /** 
     * Set the 'ConfirmationCode' element value. Room level Booking Confirmation Code if it exists
     * 
     * @param confirmationCode
     */
    public void setConfirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
    }

    /** 
     * Get the 'CancellationCode' element value. Room Level Cancellation Code if it exists
     * 
     * @return value
     */
    public String getCancellationCode() {
        return cancellationCode;
    }

    /** 
     * Set the 'CancellationCode' element value. Room Level Cancellation Code if it exists
     * 
     * @param cancellationCode
     */
    public void setCancellationCode(String cancellationCode) {
        this.cancellationCode = cancellationCode;
    }

    /** 
     * Get the 'BookingStatus' element value. Room Level Booking Status
     * 
     * @return value
     */
    public String getBookingStatus() {
        return bookingStatus;
    }

    /** 
     * Set the 'BookingStatus' element value. Room Level Booking Status
     * 
     * @param bookingStatus
     */
    public void setBookingStatus(String bookingStatus) {
        this.bookingStatus = bookingStatus;
    }

    /** 
     * Get the 'RatePlan' element value.
     * 
     * @return value
     */
    public RatePlanType getRatePlan() {
        return ratePlan;
    }

    /** 
     * Set the 'RatePlan' element value.
     * 
     * @param ratePlan
     */
    public void setRatePlan(RatePlanType ratePlan) {
        this.ratePlan = ratePlan;
    }

    /** 
     * Get the 'ValueAdds' element value.
     * 
     * @return value
     */
    public ValueAdds getValueAdds() {
        return valueAdds;
    }

    /** 
     * Set the 'ValueAdds' element value.
     * 
     * @param valueAdds
     */
    public void setValueAdds(ValueAdds valueAdds) {
        this.valueAdds = valueAdds;
    }

    /** 
     * Get the 'SpecialInstructions' element value.
     * 
     * @return value
     */
    public SpecialInstructions getSpecialInstructions() {
        return specialInstructions;
    }

    /** 
     * Set the 'SpecialInstructions' element value.
     * 
     * @param specialInstructions
     */
    public void setSpecialInstructions(SpecialInstructions specialInstructions) {
        this.specialInstructions = specialInstructions;
    }

    /** 
     * Get the 'SearchParameters' element value.
     * 
     * @return value
     */
    public LodgingSearchParameters getSearchParameters() {
        return searchParameters;
    }

    /** 
     * Set the 'SearchParameters' element value.
     * 
     * @param searchParameters
     */
    public void setSearchParameters(LodgingSearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    /** 
     * Get the 'RoomTypeCode' attribute value.
     * 
     * @return value
     */
    public String getRoomTypeCode() {
        return roomTypeCode;
    }

    /** 
     * Set the 'RoomTypeCode' attribute value.
     * 
     * @param roomTypeCode
     */
    public void setRoomTypeCode(String roomTypeCode) {
        this.roomTypeCode = roomTypeCode;
    }

    /** 
     * Get the 'RoomType' attribute value.
     * 
     * @return value
     */
    public String getRoomType() {
        return roomType;
    }

    /** 
     * Set the 'RoomType' attribute value.
     * 
     * @param roomType
     */
    public void setRoomType(String roomType) {
        this.roomType = roomType;
    }

    /** 
     * Get the 'InvBlockCode' attribute value.
     * 
     * @return value
     */
    public String getInvBlockCode() {
        return invBlockCode;
    }

    /** 
     * Set the 'InvBlockCode' attribute value.
     * 
     * @param invBlockCode
     */
    public void setInvBlockCode(String invBlockCode) {
        this.invBlockCode = invBlockCode;
    }

    /** 
     * Get the 'RoomCategory' attribute value.
     * 
     * @return value
     */
    public String getRoomCategory() {
        return roomCategory;
    }

    /** 
     * Set the 'RoomCategory' attribute value.
     * 
     * @param roomCategory
     */
    public void setRoomCategory(String roomCategory) {
        this.roomCategory = roomCategory;
    }

    /** 
     * Get the 'RoomId' attribute value.
     * 
     * @return value
     */
    public String getRoomId() {
        return roomId;
    }

    /** 
     * Set the 'RoomId' attribute value.
     * 
     * @param roomId
     */
    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    /** 
     * Get the 'SegmentNumber' attribute value.
     * 
     * @return value
     */
    public Integer getSegmentNumber() {
        return segmentNumber;
    }

    /** 
     * Set the 'SegmentNumber' attribute value.
     * 
     * @param segmentNumber
     */
    public void setSegmentNumber(Integer segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    /** 
     * Get the 'Floor' attribute value.
     * 
     * @return value
     */
    public String getFloor() {
        return floor;
    }

    /** 
     * Set the 'Floor' attribute value.
     * 
     * @param floor
     */
    public void setFloor(String floor) {
        this.floor = floor;
    }

    /** 
     * Get the 'RoomViewCode' attribute value.
     * 
     * @return value
     */
    public String getRoomViewCode() {
        return roomViewCode;
    }

    /** 
     * Set the 'RoomViewCode' attribute value.
     * 
     * @param roomViewCode
     */
    public void setRoomViewCode(String roomViewCode) {
        this.roomViewCode = roomViewCode;
    }

    /** 
     * Get the 'SharedRoomInd' attribute value.
     * 
     * @return value
     */
    public Boolean getSharedRoomInd() {
        return sharedRoomInd;
    }

    /** 
     * Set the 'SharedRoomInd' attribute value.
     * 
     * @param sharedRoomInd
     */
    public void setSharedRoomInd(Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
    }

    /** 
     * Get the 'GuestRoomInfo' attribute value.
     * 
     * @return value
     */
    public Integer getGuestRoomInfo() {
        return guestRoomInfo;
    }

    /** 
     * Set the 'GuestRoomInfo' attribute value.
     * 
     * @param guestRoomInfo
     */
    public void setGuestRoomInfo(Integer guestRoomInfo) {
        this.guestRoomInfo = guestRoomInfo;
    }

    /** 
     * Get the 'Action' attribute value.
     * 
     * @return value
     */
    public UpdateActionCode getAction() {
        return action;
    }

    /** 
     * Set the 'Action' attribute value.
     * 
     * @param action
     */
    public void setAction(UpdateActionCode action) {
        this.action = action;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomDescription" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RoomDescription implements Serializable
    {
        private String text;
        private String name;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
}
