
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VirtualCard">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CustomerAccountCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="Transactions" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class Transactions -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AuthorizedChargesType" name="AuthorizedCharges" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VirtualCard implements Serializable
{
    private String customerAccountCode;
    private String BNumber;
    private Transactions transactions;
    private AuthorizedChargesType authorizedCharges;

    /** 
     * Get the 'CustomerAccountCode' element value.
     * 
     * @return value
     */
    public String getCustomerAccountCode() {
        return customerAccountCode;
    }

    /** 
     * Set the 'CustomerAccountCode' element value.
     * 
     * @param customerAccountCode
     */
    public void setCustomerAccountCode(String customerAccountCode) {
        this.customerAccountCode = customerAccountCode;
    }

    /** 
     * Get the 'BNumber' element value.
     * 
     * @return value
     */
    public String getBNumber() {
        return BNumber;
    }

    /** 
     * Set the 'BNumber' element value.
     * 
     * @param BNumber
     */
    public void setBNumber(String BNumber) {
        this.BNumber = BNumber;
    }

    /** 
     * Get the 'Transactions' element value.
     * 
     * @return value
     */
    public Transactions getTransactions() {
        return transactions;
    }

    /** 
     * Set the 'Transactions' element value.
     * 
     * @param transactions
     */
    public void setTransactions(Transactions transactions) {
        this.transactions = transactions;
    }

    /** 
     * Get the 'AuthorizedCharges' element value.
     * 
     * @return value
     */
    public AuthorizedChargesType getAuthorizedCharges() {
        return authorizedCharges;
    }

    /** 
     * Set the 'AuthorizedCharges' element value.
     * 
     * @param authorizedCharges
     */
    public void setAuthorizedCharges(AuthorizedChargesType authorizedCharges) {
        this.authorizedCharges = authorizedCharges;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transactions" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Transaction" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Transaction -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Transactions implements Serializable
    {
        private List<Transaction> transactionList = new ArrayList<Transaction>();

        /** 
         * Get the list of 'Transaction' element items.
         * 
         * @return list
         */
        public List<Transaction> getTransactionList() {
            return transactionList;
        }

        /** 
         * Set the list of 'Transaction' element items.
         * 
         * @param list
         */
        public void setTransactionList(List<Transaction> list) {
            transactionList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transaction" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:dateTime" name="LastUpdateTime" minOccurs="0" maxOccurs="1"/>
         *       &lt;xs:element type="xs:string" name="DeploymentId" minOccurs="0" maxOccurs="1"/>
         *       &lt;xs:choice>
         *         &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0" maxOccurs="1"/>
         *         &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0" maxOccurs="1"/>
         *       &lt;/xs:choice>
         *       &lt;xs:element type="ns:FaxHistory" name="FaxHistory" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:int" use="optional" name="index"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="paymentReferenceNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="faxStatus"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Transaction implements Serializable
        {
            private Date lastUpdateTime;
            private String deploymentId;
            private int choiceSelect = -1;
            private static final int DOCUMENT_NUMBER_CHOICE = 0;
            private static final int CONFIRMATION_NUMBER_CHOICE = 1;
            private String documentNumber;
            private String confirmationNumber;
            private List<FaxHistory> faxHistoryList = new ArrayList<FaxHistory>();
            private Integer index;
            private String paymentReferenceNumber;
            private String faxStatus;

            /** 
             * Get the 'LastUpdateTime' element value.
             * 
             * @return value
             */
            public Date getLastUpdateTime() {
                return lastUpdateTime;
            }

            /** 
             * Set the 'LastUpdateTime' element value.
             * 
             * @param lastUpdateTime
             */
            public void setLastUpdateTime(Date lastUpdateTime) {
                this.lastUpdateTime = lastUpdateTime;
            }

            /** 
             * Get the 'DeploymentId' element value.
             * 
             * @return value
             */
            public String getDeploymentId() {
                return deploymentId;
            }

            /** 
             * Set the 'DeploymentId' element value.
             * 
             * @param deploymentId
             */
            public void setDeploymentId(String deploymentId) {
                this.deploymentId = deploymentId;
            }

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if DocumentNumber is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDocumentNumber() {
                return choiceSelect == DOCUMENT_NUMBER_CHOICE;
            }

            /** 
             * Get the 'DocumentNumber' element value.
             * 
             * @return value
             */
            public String getDocumentNumber() {
                return documentNumber;
            }

            /** 
             * Set the 'DocumentNumber' element value.
             * 
             * @param documentNumber
             */
            public void setDocumentNumber(String documentNumber) {
                setChoiceSelect(DOCUMENT_NUMBER_CHOICE);
                this.documentNumber = documentNumber;
            }

            /** 
             * Check if ConfirmationNumber is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifConfirmationNumber() {
                return choiceSelect == CONFIRMATION_NUMBER_CHOICE;
            }

            /** 
             * Get the 'ConfirmationNumber' element value.
             * 
             * @return value
             */
            public String getConfirmationNumber() {
                return confirmationNumber;
            }

            /** 
             * Set the 'ConfirmationNumber' element value.
             * 
             * @param confirmationNumber
             */
            public void setConfirmationNumber(String confirmationNumber) {
                setChoiceSelect(CONFIRMATION_NUMBER_CHOICE);
                this.confirmationNumber = confirmationNumber;
            }

            /** 
             * Get the list of 'FaxHistory' element items.
             * 
             * @return list
             */
            public List<FaxHistory> getFaxHistoryList() {
                return faxHistoryList;
            }

            /** 
             * Set the list of 'FaxHistory' element items.
             * 
             * @param list
             */
            public void setFaxHistoryList(List<FaxHistory> list) {
                faxHistoryList = list;
            }

            /** 
             * Get the 'index' attribute value.
             * 
             * @return value
             */
            public Integer getIndex() {
                return index;
            }

            /** 
             * Set the 'index' attribute value.
             * 
             * @param index
             */
            public void setIndex(Integer index) {
                this.index = index;
            }

            /** 
             * Get the 'paymentReferenceNumber' attribute value.
             * 
             * @return value
             */
            public String getPaymentReferenceNumber() {
                return paymentReferenceNumber;
            }

            /** 
             * Set the 'paymentReferenceNumber' attribute value.
             * 
             * @param paymentReferenceNumber
             */
            public void setPaymentReferenceNumber(String paymentReferenceNumber) {
                this.paymentReferenceNumber = paymentReferenceNumber;
            }

            /** 
             * Get the 'faxStatus' attribute value.
             * 
             * @return value
             */
            public String getFaxStatus() {
                return faxStatus;
            }

            /** 
             * Set the 'faxStatus' attribute value.
             * 
             * @param faxStatus
             */
            public void setFaxStatus(String faxStatus) {
                this.faxStatus = faxStatus;
            }
        }
    }
}
