
package com.sabre.services.res.tir.v310;

import com.sabre.services.res.or.v111.PriceQuoteType;
import com.sabre.services.res.or.v111.ProductType;
import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:ns1="http://services.sabre.com/STL/v01" xmlns:ns2="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItineraryReadRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns1:ApplicationResults"/>
 *       &lt;xs:element name="TravelItinerary" minOccurs="0">
 *         &lt;!-- Reference to inner class TravelItinerary -->
 *       &lt;/xs:element>
 *       &lt;xs:element ref="ns2:PriceQuote" minOccurs="0"/>
 *       &lt;xs:element name="VCR" minOccurs="0" maxOccurs="1">
 *         &lt;!-- Reference to inner class VCR -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TravelItineraryReadRS implements Serializable
{
    private ApplicationResults applicationResults;
    private TravelItinerary travelItinerary;
    private PriceQuoteType priceQuote;
    private VCR VCR1;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'TravelItinerary' element value.
     * 
     * @return value
     */
    public TravelItinerary getTravelItinerary() {
        return travelItinerary;
    }

    /** 
     * Set the 'TravelItinerary' element value.
     * 
     * @param travelItinerary
     */
    public void setTravelItinerary(TravelItinerary travelItinerary) {
        this.travelItinerary = travelItinerary;
    }

    /** 
     * Get the 'PriceQuote' element value.
     * 
     * @return value
     */
    public PriceQuoteType getPriceQuote() {
        return priceQuote;
    }

    /** 
     * Set the 'PriceQuote' element value.
     * 
     * @param priceQuote
     */
    public void setPriceQuote(PriceQuoteType priceQuote) {
        this.priceQuote = priceQuote;
    }

    /** 
     * Get the 'VCR' element value.
     * 
     * @return value
     */
    public VCR getVCR1() {
        return VCR1;
    }

    /** 
     * Set the 'VCR' element value.
     * 
     * @param VCR1
     */
    public void setVCR1(VCR VCR1) {
        this.VCR1 = VCR1;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItinerary" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AccountingInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AccountingInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CustomerInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class CustomerInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FileInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class FileInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItineraryInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItineraryRef" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryRef -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PayInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PayInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="QueueInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class QueueInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RemarkInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class RemarkInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SpecialServiceInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SpecialServiceInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CorporateIDInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class CorporateIDInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:AssociationMatrices" name="AssociationMatrices" minOccurs="0" maxOccurs="1"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelItinerary implements Serializable
    {
        private List<AccountingInfo> accountingInfoList = new ArrayList<AccountingInfo>();
        private CustomerInfo customerInfo;
        private FileInfo fileInfo;
        private ItineraryInfo itineraryInfo;
        private ItineraryRef itineraryRef;
        private List<PayInfo> payInfoList = new ArrayList<PayInfo>();
        private QueueInfo queueInfo;
        private RemarkInfo remarkInfo;
        private List<SpecialServiceInfo> specialServiceInfoList = new ArrayList<SpecialServiceInfo>();
        private List<CorporateIDInfo> corporateIDInfoList = new ArrayList<CorporateIDInfo>();
        private AssociationMatrices associationMatrices;

        /** 
         * Get the list of 'AccountingInfo' element items.
         * 
         * @return list
         */
        public List<AccountingInfo> getAccountingInfoList() {
            return accountingInfoList;
        }

        /** 
         * Set the list of 'AccountingInfo' element items.
         * 
         * @param list
         */
        public void setAccountingInfoList(List<AccountingInfo> list) {
            accountingInfoList = list;
        }

        /** 
         * Get the 'CustomerInfo' element value.
         * 
         * @return value
         */
        public CustomerInfo getCustomerInfo() {
            return customerInfo;
        }

        /** 
         * Set the 'CustomerInfo' element value.
         * 
         * @param customerInfo
         */
        public void setCustomerInfo(CustomerInfo customerInfo) {
            this.customerInfo = customerInfo;
        }

        /** 
         * Get the 'FileInfo' element value.
         * 
         * @return value
         */
        public FileInfo getFileInfo() {
            return fileInfo;
        }

        /** 
         * Set the 'FileInfo' element value.
         * 
         * @param fileInfo
         */
        public void setFileInfo(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
        }

        /** 
         * Get the 'ItineraryInfo' element value.
         * 
         * @return value
         */
        public ItineraryInfo getItineraryInfo() {
            return itineraryInfo;
        }

        /** 
         * Set the 'ItineraryInfo' element value.
         * 
         * @param itineraryInfo
         */
        public void setItineraryInfo(ItineraryInfo itineraryInfo) {
            this.itineraryInfo = itineraryInfo;
        }

        /** 
         * Get the 'ItineraryRef' element value.
         * 
         * @return value
         */
        public ItineraryRef getItineraryRef() {
            return itineraryRef;
        }

        /** 
         * Set the 'ItineraryRef' element value.
         * 
         * @param itineraryRef
         */
        public void setItineraryRef(ItineraryRef itineraryRef) {
            this.itineraryRef = itineraryRef;
        }

        /** 
         * Get the list of 'PayInfo' element items.
         * 
         * @return list
         */
        public List<PayInfo> getPayInfoList() {
            return payInfoList;
        }

        /** 
         * Set the list of 'PayInfo' element items.
         * 
         * @param list
         */
        public void setPayInfoList(List<PayInfo> list) {
            payInfoList = list;
        }

        /** 
         * Get the 'QueueInfo' element value.
         * 
         * @return value
         */
        public QueueInfo getQueueInfo() {
            return queueInfo;
        }

        /** 
         * Set the 'QueueInfo' element value.
         * 
         * @param queueInfo
         */
        public void setQueueInfo(QueueInfo queueInfo) {
            this.queueInfo = queueInfo;
        }

        /** 
         * Get the 'RemarkInfo' element value.
         * 
         * @return value
         */
        public RemarkInfo getRemarkInfo() {
            return remarkInfo;
        }

        /** 
         * Set the 'RemarkInfo' element value.
         * 
         * @param remarkInfo
         */
        public void setRemarkInfo(RemarkInfo remarkInfo) {
            this.remarkInfo = remarkInfo;
        }

        /** 
         * Get the list of 'SpecialServiceInfo' element items.
         * 
         * @return list
         */
        public List<SpecialServiceInfo> getSpecialServiceInfoList() {
            return specialServiceInfoList;
        }

        /** 
         * Set the list of 'SpecialServiceInfo' element items.
         * 
         * @param list
         */
        public void setSpecialServiceInfoList(List<SpecialServiceInfo> list) {
            specialServiceInfoList = list;
        }

        /** 
         * Get the list of 'CorporateIDInfo' element items.
         * 
         * @return list
         */
        public List<CorporateIDInfo> getCorporateIDInfoList() {
            return corporateIDInfoList;
        }

        /** 
         * Set the list of 'CorporateIDInfo' element items.
         * 
         * @param list
         */
        public void setCorporateIDInfoList(List<CorporateIDInfo> list) {
            corporateIDInfoList = list;
        }

        /** 
         * Get the 'AssociationMatrices' element value.
         * 
         * @return value
         */
        public AssociationMatrices getAssociationMatrices() {
            return associationMatrices;
        }

        /** 
         * Set the 'AssociationMatrices' element value.
         * 
         * @param associationMatrices
         */
        public void setAssociationMatrices(
                AssociationMatrices associationMatrices) {
            this.associationMatrices = associationMatrices;
        }
        /** 
         * Place holder for the Accounting information details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AccountVendor" minOccurs="0">
         *         &lt;!-- Reference to inner class AccountVendor -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Airline" minOccurs="0">
         *         &lt;!-- Reference to inner class Airline -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ChargeCategory" minOccurs="0"/>
         *       &lt;xs:element name="DocumentInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class DocumentInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="FareApplication" minOccurs="0"/>
         *       &lt;xs:element name="PaymentInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class PaymentInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
         *       &lt;xs:element name="TicketingInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TicketingInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AccountingInfo implements Serializable
        {
            private AccountVendor accountVendor;
            private Airline airline;
            private BaseFare baseFare;
            private String chargeCategory;
            private DocumentInfo documentInfo;
            private String fareApplication;
            private PaymentInfo paymentInfo;
            private PersonName personName;
            private Taxes taxes;
            private String text;
            private TicketingInfo ticketingInfo;
            private String linkCode;
            private String type;
            private String id;

            /** 
             * Get the 'AccountVendor' element value.
             * 
             * @return value
             */
            public AccountVendor getAccountVendor() {
                return accountVendor;
            }

            /** 
             * Set the 'AccountVendor' element value.
             * 
             * @param accountVendor
             */
            public void setAccountVendor(AccountVendor accountVendor) {
                this.accountVendor = accountVendor;
            }

            /** 
             * Get the 'Airline' element value.
             * 
             * @return value
             */
            public Airline getAirline() {
                return airline;
            }

            /** 
             * Set the 'Airline' element value.
             * 
             * @param airline
             */
            public void setAirline(Airline airline) {
                this.airline = airline;
            }

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'ChargeCategory' element value. Holds the charge category information
             * 
             * @return value
             */
            public String getChargeCategory() {
                return chargeCategory;
            }

            /** 
             * Set the 'ChargeCategory' element value. Holds the charge category information
             * 
             * @param chargeCategory
             */
            public void setChargeCategory(String chargeCategory) {
                this.chargeCategory = chargeCategory;
            }

            /** 
             * Get the 'DocumentInfo' element value.
             * 
             * @return value
             */
            public DocumentInfo getDocumentInfo() {
                return documentInfo;
            }

            /** 
             * Set the 'DocumentInfo' element value.
             * 
             * @param documentInfo
             */
            public void setDocumentInfo(DocumentInfo documentInfo) {
                this.documentInfo = documentInfo;
            }

            /** 
             * Get the 'FareApplication' element value. Holds the Fare application information	Example: ONE
             * 
             * @return value
             */
            public String getFareApplication() {
                return fareApplication;
            }

            /** 
             * Set the 'FareApplication' element value. Holds the Fare application information	Example: ONE
             * 
             * @param fareApplication
             */
            public void setFareApplication(String fareApplication) {
                this.fareApplication = fareApplication;
            }

            /** 
             * Get the 'PaymentInfo' element value.
             * 
             * @return value
             */
            public PaymentInfo getPaymentInfo() {
                return paymentInfo;
            }

            /** 
             * Set the 'PaymentInfo' element value.
             * 
             * @param paymentInfo
             */
            public void setPaymentInfo(PaymentInfo paymentInfo) {
                this.paymentInfo = paymentInfo;
            }

            /** 
             * Get the 'PersonName' element value.
             * 
             * @return value
             */
            public PersonName getPersonName() {
                return personName;
            }

            /** 
             * Set the 'PersonName' element value.
             * 
             * @param personName
             */
            public void setPersonName(PersonName personName) {
                this.personName = personName;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the 'Text' element value. "Text" is used to return miscellaneous free text-related information associated with the	particular ticketing information if applicable	Example: INCLUDES SERVICE CHARGE
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value. "Text" is used to return miscellaneous free text-related information associated with the	particular ticketing information if applicable	Example: INCLUDES SERVICE CHARGE
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'TicketingInfo' element value.
             * 
             * @return value
             */
            public TicketingInfo getTicketingInfo() {
                return ticketingInfo;
            }

            /** 
             * Set the 'TicketingInfo' element value.
             * 
             * @param ticketingInfo
             */
            public void setTicketingInfo(TicketingInfo ticketingInfo) {
                this.ticketingInfo = ticketingInfo;
            }

            /** 
             * Get the 'LinkCode' attribute value.
             * 
             * @return value
             */
            public String getLinkCode() {
                return linkCode;
            }

            /** 
             * Set the 'LinkCode' attribute value.
             * 
             * @param linkCode
             */
            public void setLinkCode(String linkCode) {
                this.linkCode = linkCode;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'Id' attribute value.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'Id' attribute value.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountVendor" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AccountVendor implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. Place holder for Accounting vendor code associated with the accounting line.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Place holder for Accounting vendor code associated with the accounting line.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Airline implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. Place holder for the Airline vendor code associated with the accounting line	Example: Code="EY"
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Place holder for the Airline vendor code associated with the accounting line	Example: Code="EY"
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private String amount;
                private String currencyCode;
                private String percent;

                /** 
                 * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'Percent' attribute value. "Percent" is used to return the applicable percentage.
                 * 
                 * @return value
                 */
                public String getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' attribute value. "Percent" is used to return the applicable percentage.
                 * 
                 * @param percent
                 */
                public void setPercent(String percent) {
                    this.percent = percent;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Document" minOccurs="0">
             *         &lt;!-- Reference to inner class Document -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DocumentInfo implements Serializable
            {
                private Document document;

                /** 
                 * Get the 'Document' element value.
                 * 
                 * @return value
                 */
                public Document getDocument() {
                    return document;
                }

                /** 
                 * Set the 'Document' element value.
                 * 
                 * @param document
                 */
                public void setDocument(Document document) {
                    this.document = document;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Document" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Document implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Payment" minOccurs="0">
             *         &lt;!-- Reference to inner class Payment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PaymentInfo implements Serializable
            {
                private Commission commission;
                private Payment payment;

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'Payment' element value.
                 * 
                 * @return value
                 */
                public Payment getPayment() {
                    return payment;
                }

                /** 
                 * Set the 'Payment' element value.
                 * 
                 * @param payment
                 */
                public void setPayment(Payment payment) {
                    this.payment = payment;
                }
                /** 
                 * Commission is used as a place holder for commission associated with the particular accounting line	Example: Commission Amount="31.00" Percent="1"
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private String amount;
                    private String percent;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Form" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Payment implements Serializable
                {
                    private CCInfo CCInfo1;
                    private String form;

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Form' element value.
                     * 
                     * @return value
                     */
                    public String getForm() {
                        return form;
                    }

                    /** 
                     * Set the 'Form' element value.
                     * 
                     * @param form
                     */
                    public void setForm(String form) {
                        this.form = form;
                    }
                    /** 
                     * CC_Info is used as a container for payment Card details. Hold the payment card type, and the card number	Example: PaymentCard Code="AX" Number="3XXXXXXXXXX8431"
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class PaymentCard -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private List<PaymentCard> paymentCardList = new ArrayList<PaymentCard>();

                        /** 
                         * Get the list of 'PaymentCard' element items.
                         * 
                         * @return list
                         */
                        public List<PaymentCard> getPaymentCardList() {
                            return paymentCardList;
                        }

                        /** 
                         * Set the list of 'PaymentCard' element items.
                         * 
                         * @param list
                         */
                        public void setPaymentCardList(List<PaymentCard> list) {
                            paymentCardList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PaymentCard implements Serializable
                        {
                            private String code;
                            private String number;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return credit card code associated with the particular accounting line if applicable.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return credit card code associated with the particular accounting line if applicable.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Number' attribute value. "Number" is used to return credit card number associated with the particular accounting line if applicable.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value. "Number" is used to return credit card number associated with the particular accounting line if applicable.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }
                        }
                    }
                }
            }
            /** 
             * PersonName is used to return the passenger name associated with the particular accounting line	Example: NameNumber="1.1" TESTA TEST1"
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String string;
                private String nameNumber;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
            /** 
             * Taxes is used as a container for Tax details.
            											It holds the details for GST, QST and Tax. For GST information about amount, Currency code and Percentage is present for QST and Tax along with information about amount, Currency code,
            											Percentage Tax code details is also included.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="GST" minOccurs="0">
             *         &lt;!-- Reference to inner class GST -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="QST" minOccurs="0">
             *         &lt;!-- Reference to inner class QST -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Tax" minOccurs="0">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private GST GST1;
                private QST QST1;
                private Tax tax;

                /** 
                 * Get the 'GST' element value.
                 * 
                 * @return value
                 */
                public GST getGST1() {
                    return GST1;
                }

                /** 
                 * Set the 'GST' element value.
                 * 
                 * @param GST1
                 */
                public void setGST1(GST GST1) {
                    this.GST1 = GST1;
                }

                /** 
                 * Get the 'QST' element value.
                 * 
                 * @return value
                 */
                public QST getQST1() {
                    return QST1;
                }

                /** 
                 * Set the 'QST' element value.
                 * 
                 * @param QST1
                 */
                public void setQST1(QST QST1) {
                    this.QST1 = QST1;
                }

                /** 
                 * Get the 'Tax' element value.
                 * 
                 * @return value
                 */
                public Tax getTax() {
                    return tax;
                }

                /** 
                 * Set the 'Tax' element value.
                 * 
                 * @param tax
                 */
                public void setTax(Tax tax) {
                    this.tax = tax;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GST" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GST implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String percent;

                    /** 
                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value. "Percent" is used to return the applicable percentage.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value. "Percent" is used to return the applicable percentage.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QST" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QST implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String percent;
                    private String taxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value. "TaxCode" is used to return the tax code.
                     * 
                     * @return value
                     */
                    public String getTaxCode() {
                        return taxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value. "TaxCode" is used to return the tax code.
                     * 
                     * @param taxCode
                     */
                    public void setTaxCode(String taxCode) {
                        this.taxCode = taxCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String percent;
                    private String taxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxCode() {
                        return taxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value.
                     * 
                     * @param taxCode
                     */
                    public void setTaxCode(String taxCode) {
                        this.taxCode = taxCode;
                    }
                }
            }
            /** 
             * "TicketingInfo" is used as a container for  Ticketing Information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="eTicket" minOccurs="0">
             *         &lt;!-- Reference to inner class ETicket -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Exchange" minOccurs="0">
             *         &lt;!-- Reference to inner class Exchange -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="IssueDate" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="IssueLocation" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="OriginalInvoiceNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="OriginalTicketNumber" minOccurs="0" maxOccurs="9"/>
             *       &lt;xs:element type="xs:string" name="TariffBasis" minOccurs="0"/>
             *       &lt;xs:element name="Ticketing" minOccurs="0">
             *         &lt;!-- Reference to inner class Ticketing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TicketingInfo implements Serializable
            {
                private ETicket ETicket;
                private Exchange exchange;
                private String issueDate;
                private String issueLocation;
                private String originalInvoiceNumber;
                private List<String> originalTicketNumberList = new ArrayList<String>();
                private String tariffBasis;
                private Ticketing ticketing;

                /** 
                 * Get the 'eTicket' element value.
                 * 
                 * @return value
                 */
                public ETicket getETicket() {
                    return ETicket;
                }

                /** 
                 * Set the 'eTicket' element value.
                 * 
                 * @param eTicket
                 */
                public void setETicket(ETicket eTicket) {
                    ETicket = eTicket;
                }

                /** 
                 * Get the 'Exchange' element value.
                 * 
                 * @return value
                 */
                public Exchange getExchange() {
                    return exchange;
                }

                /** 
                 * Set the 'Exchange' element value.
                 * 
                 * @param exchange
                 */
                public void setExchange(Exchange exchange) {
                    this.exchange = exchange;
                }

                /** 
                 * Get the 'IssueDate' element value. "IssueDate" is used to return the issue date associated with the particular accounting line if applicable.
                 * 
                 * @return value
                 */
                public String getIssueDate() {
                    return issueDate;
                }

                /** 
                 * Set the 'IssueDate' element value. "IssueDate" is used to return the issue date associated with the particular accounting line if applicable.
                 * 
                 * @param issueDate
                 */
                public void setIssueDate(String issueDate) {
                    this.issueDate = issueDate;
                }

                /** 
                 * Get the 'IssueLocation' element value. "IssueLocation" is used to return the issue location associated with the particular accounting line if applicable
                 * 
                 * @return value
                 */
                public String getIssueLocation() {
                    return issueLocation;
                }

                /** 
                 * Set the 'IssueLocation' element value. "IssueLocation" is used to return the issue location associated with the particular accounting line if applicable
                 * 
                 * @param issueLocation
                 */
                public void setIssueLocation(String issueLocation) {
                    this.issueLocation = issueLocation;
                }

                /** 
                 * Get the 'OriginalInvoiceNumber' element value. "Number" is used to return the original invoice number associated with the particular accounting line if applicable.
                 * 
                 * @return value
                 */
                public String getOriginalInvoiceNumber() {
                    return originalInvoiceNumber;
                }

                /** 
                 * Set the 'OriginalInvoiceNumber' element value. "Number" is used to return the original invoice number associated with the particular accounting line if applicable.
                 * 
                 * @param originalInvoiceNumber
                 */
                public void setOriginalInvoiceNumber(
                        String originalInvoiceNumber) {
                    this.originalInvoiceNumber = originalInvoiceNumber;
                }

                /** 
                 * Get the list of 'OriginalTicketNumber' element items. "OriginalTicketNumber" is used to return the original ticket number associated with the particular accounting line if applicable.
                 * 
                 * @return list
                 */
                public List<String> getOriginalTicketNumberList() {
                    return originalTicketNumberList;
                }

                /** 
                 * Set the list of 'OriginalTicketNumber' element items. "OriginalTicketNumber" is used to return the original ticket number associated with the particular accounting line if applicable.
                 * 
                 * @param list
                 */
                public void setOriginalTicketNumberList(List<String> list) {
                    originalTicketNumberList = list;
                }

                /** 
                 * Get the 'TariffBasis' element value. "TariffBasis" is used to return tarriff basis-related information associated with the particular accounting line if applicable.
                 * 
                 * @return value
                 */
                public String getTariffBasis() {
                    return tariffBasis;
                }

                /** 
                 * Set the 'TariffBasis' element value. "TariffBasis" is used to return tarriff basis-related information associated with the particular accounting line if applicable.
                 * 
                 * @param tariffBasis
                 */
                public void setTariffBasis(String tariffBasis) {
                    this.tariffBasis = tariffBasis;
                }

                /** 
                 * Get the 'Ticketing' element value.
                 * 
                 * @return value
                 */
                public Ticketing getTicketing() {
                    return ticketing;
                }

                /** 
                 * Set the 'Ticketing' element value.
                 * 
                 * @param ticketing
                 */
                public void setTicketing(Ticketing ticketing) {
                    this.ticketing = ticketing;
                }
                /** 
                 * "eTicket" holds indicator to denote whether or not the flight segment associated with the accounting line is eticket eligible	Example: eTicket Ind="false"
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicket" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ETicket implements Serializable
                {
                    private Boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * "Exchange" holds indicator to denote whether or not the the accounting line relates to an exchange transaction	Example: Exchange Ind="false"
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Exchange" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Exchange implements Serializable
                {
                    private Boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ConjunctedCount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CouponCount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Ticketing implements Serializable
                {
                    private String conjunctedCount;
                    private String couponCount;

                    /** 
                     * Get the 'ConjunctedCount' attribute value. "ConjunctedCount" is used to return the number of conjuncted eTicket coupons associated with the particular accounting line if applicable.
                     * 
                     * @return value
                     */
                    public String getConjunctedCount() {
                        return conjunctedCount;
                    }

                    /** 
                     * Set the 'ConjunctedCount' attribute value. "ConjunctedCount" is used to return the number of conjuncted eTicket coupons associated with the particular accounting line if applicable.
                     * 
                     * @param conjunctedCount
                     */
                    public void setConjunctedCount(String conjunctedCount) {
                        this.conjunctedCount = conjunctedCount;
                    }

                    /** 
                     * Get the 'CouponCount' attribute value. "CouponCount" is used to return the number of eTicket coupons associated with the particular accounting line if applicable.
                     * 
                     * @return value
                     */
                    public String getCouponCount() {
                        return couponCount;
                    }

                    /** 
                     * Set the 'CouponCount' attribute value. "CouponCount" is used to return the number of eTicket coupons associated with the particular accounting line if applicable.
                     * 
                     * @param couponCount
                     */
                    public void setCouponCount(String couponCount) {
                        this.couponCount = couponCount;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Address" minOccurs="0">
         *         &lt;!-- Reference to inner class Address -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
         *         &lt;!-- Reference to inner class ContactNumbers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class CustLoyalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Passport" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Passport -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PaymentInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class PaymentInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CustomerInfo implements Serializable
        {
            private Address address;
            private ContactNumbers contactNumbers;
            private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
            private List<Passport> passportList = new ArrayList<Passport>();
            private PaymentInfo paymentInfo;
            private List<PersonName> personNameList = new ArrayList<PersonName>();

            /** 
             * Get the 'Address' element value.
             * 
             * @return value
             */
            public Address getAddress() {
                return address;
            }

            /** 
             * Set the 'Address' element value.
             * 
             * @param address
             */
            public void setAddress(Address address) {
                this.address = address;
            }

            /** 
             * Get the 'ContactNumbers' element value.
             * 
             * @return value
             */
            public ContactNumbers getContactNumbers() {
                return contactNumbers;
            }

            /** 
             * Set the 'ContactNumbers' element value.
             * 
             * @param contactNumbers
             */
            public void setContactNumbers(ContactNumbers contactNumbers) {
                this.contactNumbers = contactNumbers;
            }

            /** 
             * Get the list of 'CustLoyalty' element items.
             * 
             * @return list
             */
            public List<CustLoyalty> getCustLoyaltyList() {
                return custLoyaltyList;
            }

            /** 
             * Set the list of 'CustLoyalty' element items.
             * 
             * @param list
             */
            public void setCustLoyaltyList(List<CustLoyalty> list) {
                custLoyaltyList = list;
            }

            /** 
             * Get the list of 'Passport' element items.
             * 
             * @return list
             */
            public List<Passport> getPassportList() {
                return passportList;
            }

            /** 
             * Set the list of 'Passport' element items.
             * 
             * @param list
             */
            public void setPassportList(List<Passport> list) {
                passportList = list;
            }

            /** 
             * Get the 'PaymentInfo' element value.
             * 
             * @return value
             */
            public PaymentInfo getPaymentInfo() {
                return paymentInfo;
            }

            /** 
             * Set the 'PaymentInfo' element value.
             * 
             * @param paymentInfo
             */
            public void setPaymentInfo(PaymentInfo paymentInfo) {
                this.paymentInfo = paymentInfo;
            }

            /** 
             * Get the list of 'PersonName' element items.
             * 
             * @return list
             */
            public List<PersonName> getPersonNameList() {
                return personNameList;
            }

            /** 
             * Set the list of 'PersonName' element items.
             * 
             * @param list
             */
            public void setPersonNameList(List<PersonName> list) {
                personNameList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AddressLine" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class AddressLine -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Address implements Serializable
            {
                private List<AddressLine> addressLineList = new ArrayList<AddressLine>();

                /** 
                 * Get the list of 'AddressLine' element items.
                 * 
                 * @return list
                 */
                public List<AddressLine> getAddressLineList() {
                    return addressLineList;
                }

                /** 
                 * Set the list of 'AddressLine' element items.
                 * 
                 * @param list
                 */
                public void setAddressLineList(List<AddressLine> list) {
                    addressLineList = list;
                }
                /** 
                 * "AddressLine" is used to return customer address information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressLine" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                 *         &lt;xs:attribute type="xs:string" name="type"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AddressLine implements Serializable
                {
                    private String string;
                    private String id;
                    private String type;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }

                    /** 
                     * Get the 'type' attribute value. 
                    																Indicates type of information ex. 
                    																	O Other
                    																	N Name
                    																	A Address
                    																	C City and State
                    																	Z Zip code
                    																	B Business
                    																
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'type' attribute value. 
                    																Indicates type of information ex. 
                    																	O Other
                    																	N Name
                    																	A Address
                    																	C City and State
                    																	Z Zip code
                    																	B Business
                    																
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ContactNumber" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ContactNumber -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ContactNumbers implements Serializable
            {
                private List<ContactNumber> contactNumberList = new ArrayList<ContactNumber>();

                /** 
                 * Get the list of 'ContactNumber' element items.
                 * 
                 * @return list
                 */
                public List<ContactNumber> getContactNumberList() {
                    return contactNumberList;
                }

                /** 
                 * Set the list of 'ContactNumber' element items.
                 * 
                 * @param list
                 */
                public void setContactNumberList(List<ContactNumber> list) {
                    contactNumberList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class PersonName -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ContactNumber implements Serializable
                {
                    private List<PersonName> personNameList = new ArrayList<PersonName>();
                    private String locationCode;
                    private String phone;
                    private String RPH;
                    private String id;

                    /** 
                     * Get the list of 'PersonName' element items.
                     * 
                     * @return list
                     */
                    public List<PersonName> getPersonNameList() {
                        return personNameList;
                    }

                    /** 
                     * Set the list of 'PersonName' element items.
                     * 
                     * @param list
                     */
                    public void setPersonNameList(List<PersonName> list) {
                        personNameList = list;
                    }

                    /** 
                     * Get the 'LocationCode' attribute value. "LocationCode" is used to return the city code associated to the phone number.
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value. "LocationCode" is used to return the city code associated to the phone number.
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }

                    /** 
                     * Get the 'Phone' attribute value. "Phone" is used to return the telephone number.
                     * 
                     * @return value
                     */
                    public String getPhone() {
                        return phone;
                    }

                    /** 
                     * Set the 'Phone' attribute value. "Phone" is used to return the telephone number.
                     * 
                     * @param phone
                     */
                    public void setPhone(String phone) {
                        this.phone = phone;
                    }

                    /** 
                     * Get the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PersonName implements Serializable
                    {
                        private String string;
                        private String nameNumber;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'NameNumber' attribute value. NameNumber is used to return the passenger name number associated with the particular passenger
                         * 
                         * @return value
                         */
                        public String getNameNumber() {
                            return nameNumber;
                        }

                        /** 
                         * Set the 'NameNumber' attribute value. NameNumber is used to return the passenger name number associated with the particular passenger
                         * 
                         * @param nameNumber
                         */
                        public void setNameNumber(String nameNumber) {
                            this.nameNumber = nameNumber;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="TravelingCarrierCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramID"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CustLoyalty implements Serializable
            {
                private String travelingCarrierCode;
                private String membershipID;
                private String nameNumber;
                private String programID;
                private String RPH;
                private String shortText;
                private String status;
                private String id;

                /** 
                 * Get the 'TravelingCarrierCode' attribute value. "TravelingCarrierCode" is used to return the traveling airline code.
                 * 
                 * @return value
                 */
                public String getTravelingCarrierCode() {
                    return travelingCarrierCode;
                }

                /** 
                 * Set the 'TravelingCarrierCode' attribute value. "TravelingCarrierCode" is used to return the traveling airline code.
                 * 
                 * @param travelingCarrierCode
                 */
                public void setTravelingCarrierCode(String travelingCarrierCode) {
                    this.travelingCarrierCode = travelingCarrierCode;
                }

                /** 
                 * Get the 'MembershipID' attribute value. "MembershipID" is used to return the passenger's frequent flyer number.
                 * 
                 * @return value
                 */
                public String getMembershipID() {
                    return membershipID;
                }

                /** 
                 * Set the 'MembershipID' attribute value. "MembershipID" is used to return the passenger's frequent flyer number.
                 * 
                 * @param membershipID
                 */
                public void setMembershipID(String membershipID) {
                    this.membershipID = membershipID;
                }

                /** 
                 * Get the 'NameNumber' attribute value. "NameNumber" is used to associate the particular frequent flyer number to a particular passenger within the record.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. "NameNumber" is used to associate the particular frequent flyer number to a particular passenger within the record.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'ProgramID' attribute value. "ProgramID" is used to return the passenger's frequent flyer airline code.
                 * 
                 * @return value
                 */
                public String getProgramID() {
                    return programID;
                }

                /** 
                 * Set the 'ProgramID' attribute value. "ProgramID" is used to return the passenger's frequent flyer airline code.
                 * 
                 * @param programID
                 */
                public void setProgramID(String programID) {
                    this.programID = programID;
                }

                /** 
                 * Get the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }

                /** 
                 * Get the 'ShortText' attribute value. "ShortText" is used to return miscellaneous frequent flyer-related information.
                 * 
                 * @return value
                 */
                public String getShortText() {
                    return shortText;
                }

                /** 
                 * Set the 'ShortText' attribute value. "ShortText" is used to return miscellaneous frequent flyer-related information.
                 * 
                 * @param shortText
                 */
                public void setShortText(String shortText) {
                    this.shortText = shortText;
                }

                /** 
                 * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular flight segment within the record.
                 * 
                 * @return value
                 */
                public String getStatus() {
                    return status;
                }

                /** 
                 * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular flight segment within the record.
                 * 
                 * @param status
                 */
                public void setStatus(String status) {
                    this.status = status;
                }

                /** 
                 * Get the 'Id' attribute value.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passport" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passport implements Serializable
            {
                private String number;
                private String RPH;
                private String id;

                /** 
                 * Get the 'Number' attribute value. "Number" is used to return the passenger's passport number.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value. "Number" is used to return the passenger's passport number.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }

                /** 
                 * Get the 'Id' attribute value.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Payment" minOccurs="0">
             *         &lt;!-- Reference to inner class Payment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PaymentInfo implements Serializable
            {
                private Payment payment;

                /** 
                 * Get the 'Payment' element value.
                 * 
                 * @return value
                 */
                public Payment getPayment() {
                    return payment;
                }

                /** 
                 * Set the 'Payment' element value.
                 * 
                 * @param payment
                 */
                public void setPayment(Payment payment) {
                    this.payment = payment;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Form" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Form -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Payment implements Serializable
                {
                    private List<CCInfo> CCInfoList = new ArrayList<CCInfo>();
                    private List<Form> formList = new ArrayList<Form>();

                    /** 
                     * Get the list of 'CC_Info' element items.
                     * 
                     * @return list
                     */
                    public List<CCInfo> getCCInfoList() {
                        return CCInfoList;
                    }

                    /** 
                     * Set the list of 'CC_Info' element items.
                     * 
                     * @param list
                     */
                    public void setCCInfoList(List<CCInfo> list) {
                        CCInfoList = list;
                    }

                    /** 
                     * Get the list of 'Form' element items.
                     * 
                     * @return list
                     */
                    public List<Form> getFormList() {
                        return formList;
                    }

                    /** 
                     * Set the list of 'Form' element items.
                     * 
                     * @param list
                     */
                    public void setFormList(List<Form> list) {
                        formList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="CardHolderInfo" minOccurs="0">
                     *         &lt;!-- Reference to inner class CardHolderInfo -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="PreferredCustomer"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private CardHolderInfo cardHolderInfo;
                        private String preferredCustomer;
                        private String shortText;

                        /** 
                         * Get the 'CardHolderInfo' element value.
                         * 
                         * @return value
                         */
                        public CardHolderInfo getCardHolderInfo() {
                            return cardHolderInfo;
                        }

                        /** 
                         * Set the 'CardHolderInfo' element value.
                         * 
                         * @param cardHolderInfo
                         */
                        public void setCardHolderInfo(
                                CardHolderInfo cardHolderInfo) {
                            this.cardHolderInfo = cardHolderInfo;
                        }

                        /** 
                         * Get the 'PreferredCustomer' attribute value. "PreferredCustomer" is used to indicate whether or not the cardholder is a preferred customer.
                         * 
                         * @return value
                         */
                        public String getPreferredCustomer() {
                            return preferredCustomer;
                        }

                        /** 
                         * Set the 'PreferredCustomer' attribute value. "PreferredCustomer" is used to indicate whether or not the cardholder is a preferred customer.
                         * 
                         * @param preferredCustomer
                         */
                        public void setPreferredCustomer(
                                String preferredCustomer) {
                            this.preferredCustomer = preferredCustomer;
                        }

                        /** 
                         * Get the 'ShortText' attribute value. "ShortText" is used to return miscellaneous credit card-related information.
                         * 
                         * @return value
                         */
                        public String getShortText() {
                            return shortText;
                        }

                        /** 
                         * Set the 'ShortText' attribute value. "ShortText" is used to return miscellaneous credit card-related information.
                         * 
                         * @param shortText
                         */
                        public void setShortText(String shortText) {
                            this.shortText = shortText;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderInfo" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Address" minOccurs="0">
                         *         &lt;!-- Reference to inner class Address -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
                         *         &lt;!-- Reference to inner class ContactNumbers -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CardHolderInfo implements
                            Serializable
                        {
                            private Address address;
                            private ContactNumbers contactNumbers;
                            private String name;

                            /** 
                             * Get the 'Address' element value.
                             * 
                             * @return value
                             */
                            public Address getAddress() {
                                return address;
                            }

                            /** 
                             * Set the 'Address' element value.
                             * 
                             * @param address
                             */
                            public void setAddress(Address address) {
                                this.address = address;
                            }

                            /** 
                             * Get the 'ContactNumbers' element value.
                             * 
                             * @return value
                             */
                            public ContactNumbers getContactNumbers() {
                                return contactNumbers;
                            }

                            /** 
                             * Set the 'ContactNumbers' element value.
                             * 
                             * @param contactNumbers
                             */
                            public void setContactNumbers(
                                    ContactNumbers contactNumbers) {
                                this.contactNumbers = contactNumbers;
                            }

                            /** 
                             * Get the 'Name' attribute value. "Name" is used to return the credit card holder's name.
                             * 
                             * @return value
                             */
                            public String getName() {
                                return name;
                            }

                            /** 
                             * Set the 'Name' attribute value. "Name" is used to return the credit card holder's name.
                             * 
                             * @param name
                             */
                            public void setName(String name) {
                                this.name = name;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="4"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Address implements Serializable
                            {
                                private List<String> addressLineList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'AddressLine' element items. "AddressLine" is used to return the address associated with the particular credit card holder.
                                 * 
                                 * @return list
                                 */
                                public List<String> getAddressLineList() {
                                    return addressLineList;
                                }

                                /** 
                                 * Set the list of 'AddressLine' element items. "AddressLine" is used to return the address associated with the particular credit card holder.
                                 * 
                                 * @param list
                                 */
                                public void setAddressLineList(List<String> list) {
                                    addressLineList = list;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="ContactNumber" minOccurs="0">
                             *         &lt;!-- Reference to inner class ContactNumber -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class ContactNumbers implements
                                Serializable
                            {
                                private ContactNumber contactNumber;

                                /** 
                                 * Get the 'ContactNumber' element value.
                                 * 
                                 * @return value
                                 */
                                public ContactNumber getContactNumber() {
                                    return contactNumber;
                                }

                                /** 
                                 * Set the 'ContactNumber' element value.
                                 * 
                                 * @param contactNumber
                                 */
                                public void setContactNumber(
                                        ContactNumber contactNumber) {
                                    this.contactNumber = contactNumber;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class ContactNumber implements
                                    Serializable
                                {
                                    private String phone;

                                    /** 
                                     * Get the 'Phone' attribute value. "Phone" is used to return the telephone number associated with the particular credit card holder.
                                     * 
                                     * @return value
                                     */
                                    public String getPhone() {
                                        return phone;
                                    }

                                    /** 
                                     * Set the 'Phone' attribute value. "Phone" is used to return the telephone number associated with the particular credit card holder.
                                     * 
                                     * @param phone
                                     */
                                    public void setPhone(String phone) {
                                        this.phone = phone;
                                    }
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Form" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Form implements Serializable
                    {
                        private List<String> textList = new ArrayList<String>();
                        private String RPH;
                        private String id;

                        /** 
                         * Get the list of 'Text' element items. "Text" is used to return the form of payment.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. "Text" is used to return the form of payment.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }

                        /** 
                         * Get the 'RPH' attribute value. "RPH" is used as a reference place holder.
                         * 
                         * @return value
                         */
                        public String getRPH() {
                            return RPH;
                        }

                        /** 
                         * Set the 'RPH' attribute value. "RPH" is used as a reference place holder.
                         * 
                         * @param RPH
                         */
                        public void setRPH(String RPH) {
                            this.RPH = RPH;
                        }

                        /** 
                         * Get the 'Id' attribute value.
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value.
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Email" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Email -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
             *       &lt;xs:element name="GroupInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class GroupInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ProfileIndex" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ProfileIndex -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="WithInfant"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="NameReference"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="PassengerType"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private List<Email> emailList = new ArrayList<Email>();
                private String givenName;
                private GroupInfo groupInfo;
                private List<ProfileIndex> profileIndexList = new ArrayList<ProfileIndex>();
                private String surname;
                private String withInfant;
                private String nameNumber;
                private String nameReference;
                private String passengerType;
                private String RPH;
                private String id;
                private String elementId;

                /** 
                 * Get the list of 'Email' element items.
                 * 
                 * @return list
                 */
                public List<Email> getEmailList() {
                    return emailList;
                }

                /** 
                 * Set the list of 'Email' element items.
                 * 
                 * @param list
                 */
                public void setEmailList(List<Email> list) {
                    emailList = list;
                }

                /** 
                 * Get the 'GivenName' element value. "GivenName" is used to return the passenger's given (first) name.
                 * 
                 * @return value
                 */
                public String getGivenName() {
                    return givenName;
                }

                /** 
                 * Set the 'GivenName' element value. "GivenName" is used to return the passenger's given (first) name.
                 * 
                 * @param givenName
                 */
                public void setGivenName(String givenName) {
                    this.givenName = givenName;
                }

                /** 
                 * Get the 'GroupInfo' element value.
                 * 
                 * @return value
                 */
                public GroupInfo getGroupInfo() {
                    return groupInfo;
                }

                /** 
                 * Set the 'GroupInfo' element value.
                 * 
                 * @param groupInfo
                 */
                public void setGroupInfo(GroupInfo groupInfo) {
                    this.groupInfo = groupInfo;
                }

                /** 
                 * Get the list of 'ProfileIndex' element items.
                 * 
                 * @return list
                 */
                public List<ProfileIndex> getProfileIndexList() {
                    return profileIndexList;
                }

                /** 
                 * Set the list of 'ProfileIndex' element items.
                 * 
                 * @param list
                 */
                public void setProfileIndexList(List<ProfileIndex> list) {
                    profileIndexList = list;
                }

                /** 
                 * Get the 'Surname' element value. "Surname" is used to return the passenger's last name.
                 * 
                 * @return value
                 */
                public String getSurname() {
                    return surname;
                }

                /** 
                 * Set the 'Surname' element value. "Surname" is used to return the passenger's last name.
                 * 
                 * @param surname
                 */
                public void setSurname(String surname) {
                    this.surname = surname;
                }

                /** 
                 * Get the 'WithInfant' attribute value. "WithInfant" is used to indicate whether or not the passenger is an infant.
                 * 
                 * @return value
                 */
                public String getWithInfant() {
                    return withInfant;
                }

                /** 
                 * Set the 'WithInfant' attribute value. "WithInfant" is used to indicate whether or not the passenger is an infant.
                 * 
                 * @param withInfant
                 */
                public void setWithInfant(String withInfant) {
                    this.withInfant = withInfant;
                }

                /** 
                 * Get the 'NameNumber' attribute value. "NameNumber" is used to return the passenger name number.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value. "NameNumber" is used to return the passenger name number.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'NameReference' attribute value. "NameReference" is used to return miscellaneous name reference-related information if applicable.
                 * 
                 * @return value
                 */
                public String getNameReference() {
                    return nameReference;
                }

                /** 
                 * Set the 'NameReference' attribute value. "NameReference" is used to return miscellaneous name reference-related information if applicable.
                 * 
                 * @param nameReference
                 */
                public void setNameReference(String nameReference) {
                    this.nameReference = nameReference;
                }

                /** 
                 * Get the 'PassengerType' attribute value. "PassengerType" is used to return the passenger type associated with the particular passenger.
                 * 
                 * @return value
                 */
                public String getPassengerType() {
                    return passengerType;
                }

                /** 
                 * Set the 'PassengerType' attribute value. "PassengerType" is used to return the passenger type associated with the particular passenger.
                 * 
                 * @param passengerType
                 */
                public void setPassengerType(String passengerType) {
                    this.passengerType = passengerType;
                }

                /** 
                 * Get the 'RPH' attribute value. "RPH" is used as a reference place holder.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. "RPH" is used as a reference place holder.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }

                /** 
                 * Get the 'Id' attribute value.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }

                /** 
                 * Get the 'elementId' attribute value.
                 * 
                 * @return value
                 */
                public String getElementId() {
                    return elementId;
                }

                /** 
                 * Set the 'elementId' attribute value.
                 * 
                 * @param elementId
                 */
                public void setElementId(String elementId) {
                    this.elementId = elementId;
                }
                /** 
                 * "Email" is used to return the passenger's email address.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Comment"/>
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Email implements Serializable
                {
                    private String string;
                    private String id;
                    private String comment;
                    private String type;
                    private String name;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }

                    /** 
                     * Get the 'Comment' attribute value.
                     * 
                     * @return value
                     */
                    public String getComment() {
                        return comment;
                    }

                    /** 
                     * Set the 'Comment' attribute value.
                     * 
                     * @param comment
                     */
                    public void setComment(String comment) {
                        this.comment = comment;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'Name' attribute value.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="AssociatedReferenceInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class AssociatedReferenceInformation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="OriginalNumberOfSeats"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="GroupNameNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="NumSeatsRemaining"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="SoldNumberOfSeats"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GroupInfo implements Serializable
                {
                    private AssociatedReferenceInformation associatedReferenceInformation;
                    private String name;
                    private String originalNumberOfSeats;
                    private String groupNameNumber;
                    private String numSeatsRemaining;
                    private String soldNumberOfSeats;

                    /** 
                     * Get the 'AssociatedReferenceInformation' element value.
                     * 
                     * @return value
                     */
                    public AssociatedReferenceInformation getAssociatedReferenceInformation() {
                        return associatedReferenceInformation;
                    }

                    /** 
                     * Set the 'AssociatedReferenceInformation' element value.
                     * 
                     * @param associatedReferenceInformation
                     */
                    public void setAssociatedReferenceInformation(
                            AssociatedReferenceInformation associatedReferenceInformation) {
                        this.associatedReferenceInformation = associatedReferenceInformation;
                    }

                    /** 
                     * Get the 'Name' attribute value. "Name" is used to return the corporate/group name.
                     * 
                     * @return value
                     */
                    public String getName() {
                        return name;
                    }

                    /** 
                     * Set the 'Name' attribute value. "Name" is used to return the corporate/group name.
                     * 
                     * @param name
                     */
                    public void setName(String name) {
                        this.name = name;
                    }

                    /** 
                     * Get the 'OriginalNumberOfSeats' attribute value. "OriginalNumberOfSeats" is used to return the original number of seats requested in the BSG
                     * 
                     * @return value
                     */
                    public String getOriginalNumberOfSeats() {
                        return originalNumberOfSeats;
                    }

                    /** 
                     * Set the 'OriginalNumberOfSeats' attribute value. "OriginalNumberOfSeats" is used to return the original number of seats requested in the BSG
                     * 
                     * @param originalNumberOfSeats
                     */
                    public void setOriginalNumberOfSeats(
                            String originalNumberOfSeats) {
                        this.originalNumberOfSeats = originalNumberOfSeats;
                    }

                    /** 
                     * Get the 'GroupNameNumber' attribute value. "GroupNameNumber" is used to return the passenger name number in relation to the rest of the group.
                     * 
                     * @return value
                     */
                    public String getGroupNameNumber() {
                        return groupNameNumber;
                    }

                    /** 
                     * Set the 'GroupNameNumber' attribute value. "GroupNameNumber" is used to return the passenger name number in relation to the rest of the group.
                     * 
                     * @param groupNameNumber
                     */
                    public void setGroupNameNumber(String groupNameNumber) {
                        this.groupNameNumber = groupNameNumber;
                    }

                    /** 
                     * Get the 'NumSeatsRemaining' attribute value. "NumSeatsRemaining" is used to return the number of remaining seats.
                     * 
                     * @return value
                     */
                    public String getNumSeatsRemaining() {
                        return numSeatsRemaining;
                    }

                    /** 
                     * Set the 'NumSeatsRemaining' attribute value. "NumSeatsRemaining" is used to return the number of remaining seats.
                     * 
                     * @param numSeatsRemaining
                     */
                    public void setNumSeatsRemaining(String numSeatsRemaining) {
                        this.numSeatsRemaining = numSeatsRemaining;
                    }

                    /** 
                     * Get the 'SoldNumberOfSeats' attribute value. "SoldNumberOfSeats is used to return the number of seats sold from the BSG"
                     * 
                     * @return value
                     */
                    public String getSoldNumberOfSeats() {
                        return soldNumberOfSeats;
                    }

                    /** 
                     * Set the 'SoldNumberOfSeats' attribute value. "SoldNumberOfSeats is used to return the number of seats sold from the BSG"
                     * 
                     * @param soldNumberOfSeats
                     */
                    public void setSoldNumberOfSeats(String soldNumberOfSeats) {
                        this.soldNumberOfSeats = soldNumberOfSeats;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedReferenceInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="AssociatedPNRSummaries" minOccurs="0">
                     *         &lt;!-- Reference to inner class AssociatedPNRSummaries -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AssociatedReferenceInformation
                        implements Serializable
                    {
                        private AssociatedPNRSummaries associatedPNRSummaries;

                        /** 
                         * Get the 'AssociatedPNRSummaries' element value.
                         * 
                         * @return value
                         */
                        public AssociatedPNRSummaries getAssociatedPNRSummaries() {
                            return associatedPNRSummaries;
                        }

                        /** 
                         * Set the 'AssociatedPNRSummaries' element value.
                         * 
                         * @param associatedPNRSummaries
                         */
                        public void setAssociatedPNRSummaries(
                                AssociatedPNRSummaries associatedPNRSummaries) {
                            this.associatedPNRSummaries = associatedPNRSummaries;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedPNRSummaries" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="AssociatedPNRSummary" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class AssociatedPNRSummary -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class AssociatedPNRSummaries implements
                            Serializable
                        {
                            private List<AssociatedPNRSummary> associatedPNRSummaryList = new ArrayList<AssociatedPNRSummary>();

                            /** 
                             * Get the list of 'AssociatedPNRSummary' element items.
                             * 
                             * @return list
                             */
                            public List<AssociatedPNRSummary> getAssociatedPNRSummaryList() {
                                return associatedPNRSummaryList;
                            }

                            /** 
                             * Set the list of 'AssociatedPNRSummary' element items.
                             * 
                             * @param list
                             */
                            public void setAssociatedPNRSummaryList(
                                    List<AssociatedPNRSummary> list) {
                                associatedPNRSummaryList = list;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedPNRSummary" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="RecordLocator" minOccurs="0"/>
                             *       &lt;xs:element type="xs:string" name="NumberOfSeats" minOccurs="0"/>
                             *       &lt;xs:element type="xs:string" name="TicketingTimeLimitInfo" minOccurs="0"/>
                             *       &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class AssociatedPNRSummary implements
                                Serializable
                            {
                                private String recordLocator;
                                private String numberOfSeats;
                                private String ticketingTimeLimitInfo;
                                private String freeText;

                                /** 
                                 * Get the 'RecordLocator' element value. "RecordLocator" is used to return the Associated PNRs Record locator.
                                 * 
                                 * @return value
                                 */
                                public String getRecordLocator() {
                                    return recordLocator;
                                }

                                /** 
                                 * Set the 'RecordLocator' element value. "RecordLocator" is used to return the Associated PNRs Record locator.
                                 * 
                                 * @param recordLocator
                                 */
                                public void setRecordLocator(
                                        String recordLocator) {
                                    this.recordLocator = recordLocator;
                                }

                                /** 
                                 * Get the 'NumberOfSeats' element value. "NumberOfSeats" is used to return the number of seats in the Associated PNR.
                                 * 
                                 * @return value
                                 */
                                public String getNumberOfSeats() {
                                    return numberOfSeats;
                                }

                                /** 
                                 * Set the 'NumberOfSeats' element value. "NumberOfSeats" is used to return the number of seats in the Associated PNR.
                                 * 
                                 * @param numberOfSeats
                                 */
                                public void setNumberOfSeats(
                                        String numberOfSeats) {
                                    this.numberOfSeats = numberOfSeats;
                                }

                                /** 
                                 * Get the 'TicketingTimeLimitInfo' element value. "TicketingTimeLimitInfo" is used to return the ticketing time limit for the Associated PNR.
                                 * 
                                 * @return value
                                 */
                                public String getTicketingTimeLimitInfo() {
                                    return ticketingTimeLimitInfo;
                                }

                                /** 
                                 * Set the 'TicketingTimeLimitInfo' element value. "TicketingTimeLimitInfo" is used to return the ticketing time limit for the Associated PNR.
                                 * 
                                 * @param ticketingTimeLimitInfo
                                 */
                                public void setTicketingTimeLimitInfo(
                                        String ticketingTimeLimitInfo) {
                                    this.ticketingTimeLimitInfo = ticketingTimeLimitInfo;
                                }

                                /** 
                                 * Get the 'FreeText' element value. "FreeText" is used to return miscellaneous free text associated with the particular Associated PNR.
                                 * 
                                 * @return value
                                 */
                                public String getFreeText() {
                                    return freeText;
                                }

                                /** 
                                 * Set the 'FreeText' element value. "FreeText" is used to return miscellaneous free text associated with the particular Associated PNR.
                                 * 
                                 * @param freeText
                                 */
                                public void setFreeText(String freeText) {
                                    this.freeText = freeText;
                                }
                            }
                        }
                    }
                }
                /** 
                 * "ProfileIndex" is used to return the profile index if applicable.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileIndex" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ProfileIndex implements Serializable
                {
                    private String string;
                    private String id;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FileInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="File" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class File -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FileInfo implements Serializable
        {
            private List<File> fileList = new ArrayList<File>();

            /** 
             * Get the list of 'File' element items.
             * 
             * @return list
             */
            public List<File> getFileList() {
                return fileList;
            }

            /** 
             * Set the list of 'File' element items.
             * 
             * @param list
             */
            public void setFileList(List<File> list) {
                fileList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="File" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="ProductCode"/>
             *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *         &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class File implements Serializable
            {
                private String string;
                private String productCode;
                private String RPH;
                private String id;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'ProductCode' attribute value. "ProductCode" is used to return the product code.
                 * 
                 * @return value
                 */
                public String getProductCode() {
                    return productCode;
                }

                /** 
                 * Set the 'ProductCode' attribute value. "ProductCode" is used to return the product code.
                 * 
                 * @param productCode
                 */
                public void setProductCode(String productCode) {
                    this.productCode = productCode;
                }

                /** 
                 * Get the 'RPH' attribute value. "RPH" is used as a reference place holder.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. "RPH" is used as a reference place holder.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }

                /** 
                 * Get the 'Id' attribute value.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ItineraryPricing" minOccurs="0">
         *         &lt;!-- Reference to inner class ItineraryPricing -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ReservationItems" minOccurs="0">
         *         &lt;!-- Reference to inner class ReservationItems -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Ticketing" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Ticketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItineraryInfo implements Serializable
        {
            private ItineraryPricing itineraryPricing;
            private ReservationItems reservationItems;
            private List<Ticketing> ticketingList = new ArrayList<Ticketing>();

            /** 
             * Get the 'ItineraryPricing' element value.
             * 
             * @return value
             */
            public ItineraryPricing getItineraryPricing() {
                return itineraryPricing;
            }

            /** 
             * Set the 'ItineraryPricing' element value.
             * 
             * @param itineraryPricing
             */
            public void setItineraryPricing(ItineraryPricing itineraryPricing) {
                this.itineraryPricing = itineraryPricing;
            }

            /** 
             * Get the 'ReservationItems' element value.
             * 
             * @return value
             */
            public ReservationItems getReservationItems() {
                return reservationItems;
            }

            /** 
             * Set the 'ReservationItems' element value.
             * 
             * @param reservationItems
             */
            public void setReservationItems(ReservationItems reservationItems) {
                this.reservationItems = reservationItems;
            }

            /** 
             * Get the list of 'Ticketing' element items.
             * 
             * @return list
             */
            public List<Ticketing> getTicketingList() {
                return ticketingList;
            }

            /** 
             * Set the list of 'Ticketing' element items.
             * 
             * @param list
             */
            public void setTicketingList(List<Ticketing> list) {
                ticketingList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryPricing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="FuturePriceInfo" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FuturePriceInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PriceQuote" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PriceQuote -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PriceQuoteTotals" minOccurs="0">
             *         &lt;!-- Reference to inner class PriceQuoteTotals -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ItineraryPricing implements Serializable
            {
                private List<FuturePriceInfo> futurePriceInfoList = new ArrayList<FuturePriceInfo>();
                private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();
                private PriceQuoteTotals priceQuoteTotals;

                /** 
                 * Get the list of 'FuturePriceInfo' element items.
                 * 
                 * @return list
                 */
                public List<FuturePriceInfo> getFuturePriceInfoList() {
                    return futurePriceInfoList;
                }

                /** 
                 * Set the list of 'FuturePriceInfo' element items.
                 * 
                 * @param list
                 */
                public void setFuturePriceInfoList(List<FuturePriceInfo> list) {
                    futurePriceInfoList = list;
                }

                /** 
                 * Get the list of 'PriceQuote' element items.
                 * 
                 * @return list
                 */
                public List<PriceQuote> getPriceQuoteList() {
                    return priceQuoteList;
                }

                /** 
                 * Set the list of 'PriceQuote' element items.
                 * 
                 * @param list
                 */
                public void setPriceQuoteList(List<PriceQuote> list) {
                    priceQuoteList = list;
                }

                /** 
                 * Get the 'PriceQuoteTotals' element value.
                 * 
                 * @return value
                 */
                public PriceQuoteTotals getPriceQuoteTotals() {
                    return priceQuoteTotals;
                }

                /** 
                 * Set the 'PriceQuoteTotals' element value.
                 * 
                 * @param priceQuoteTotals
                 */
                public void setPriceQuoteTotals(
                        PriceQuoteTotals priceQuoteTotals) {
                    this.priceQuoteTotals = priceQuoteTotals;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FuturePriceInfo" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FuturePriceInfo implements Serializable
                {
                    private String text;
                    private String RPH;

                    /** 
                     * Get the 'Text' element value. "Text" is used to return future pricing line-related information if applicable.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value. "Text" is used to return future pricing line-related information if applicable.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'RPH' attribute value. "RPH" is used as a reference place holder.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. "RPH" is used as a reference place holder.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="MiscInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class MiscInformation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PricedItinerary" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class PricedItinerary -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ResponseHeader" minOccurs="0">
                 *         &lt;!-- Reference to inner class ResponseHeader -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PriceQuotePlus" minOccurs="0">
                 *         &lt;!-- Reference to inner class PriceQuotePlus -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PriceQuote implements Serializable
                {
                    private MiscInformation miscInformation;
                    private List<PricedItinerary> pricedItineraryList = new ArrayList<PricedItinerary>();
                    private ResponseHeader responseHeader;
                    private PriceQuotePlus priceQuotePlus;
                    private String RPH;

                    /** 
                     * Get the 'MiscInformation' element value.
                     * 
                     * @return value
                     */
                    public MiscInformation getMiscInformation() {
                        return miscInformation;
                    }

                    /** 
                     * Set the 'MiscInformation' element value.
                     * 
                     * @param miscInformation
                     */
                    public void setMiscInformation(
                            MiscInformation miscInformation) {
                        this.miscInformation = miscInformation;
                    }

                    /** 
                     * Get the list of 'PricedItinerary' element items.
                     * 
                     * @return list
                     */
                    public List<PricedItinerary> getPricedItineraryList() {
                        return pricedItineraryList;
                    }

                    /** 
                     * Set the list of 'PricedItinerary' element items.
                     * 
                     * @param list
                     */
                    public void setPricedItineraryList(
                            List<PricedItinerary> list) {
                        pricedItineraryList = list;
                    }

                    /** 
                     * Get the 'ResponseHeader' element value.
                     * 
                     * @return value
                     */
                    public ResponseHeader getResponseHeader() {
                        return responseHeader;
                    }

                    /** 
                     * Set the 'ResponseHeader' element value.
                     * 
                     * @param responseHeader
                     */
                    public void setResponseHeader(ResponseHeader responseHeader) {
                        this.responseHeader = responseHeader;
                    }

                    /** 
                     * Get the 'PriceQuotePlus' element value.
                     * 
                     * @return value
                     */
                    public PriceQuotePlus getPriceQuotePlus() {
                        return priceQuotePlus;
                    }

                    /** 
                     * Set the 'PriceQuotePlus' element value.
                     * 
                     * @param priceQuotePlus
                     */
                    public void setPriceQuotePlus(PriceQuotePlus priceQuotePlus) {
                        this.priceQuotePlus = priceQuotePlus;
                    }

                    /** 
                     * Get the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BaggageFees" minOccurs="0">
                     *         &lt;!-- Reference to inner class BaggageFees -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="GlobalNetRemit" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class GlobalNetRemit -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SignatureLine" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class SignatureLine -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="TicketingFees" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class TicketingFees -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MiscInformation implements Serializable
                    {
                        private BaggageFees baggageFees;
                        private List<GlobalNetRemit> globalNetRemitList = new ArrayList<GlobalNetRemit>();
                        private List<SignatureLine> signatureLineList = new ArrayList<SignatureLine>();
                        private List<TicketingFees> ticketingFeeList = new ArrayList<TicketingFees>();

                        /** 
                         * Get the 'BaggageFees' element value.
                         * 
                         * @return value
                         */
                        public BaggageFees getBaggageFees() {
                            return baggageFees;
                        }

                        /** 
                         * Set the 'BaggageFees' element value.
                         * 
                         * @param baggageFees
                         */
                        public void setBaggageFees(BaggageFees baggageFees) {
                            this.baggageFees = baggageFees;
                        }

                        /** 
                         * Get the list of 'GlobalNetRemit' element items.
                         * 
                         * @return list
                         */
                        public List<GlobalNetRemit> getGlobalNetRemitList() {
                            return globalNetRemitList;
                        }

                        /** 
                         * Set the list of 'GlobalNetRemit' element items.
                         * 
                         * @param list
                         */
                        public void setGlobalNetRemitList(
                                List<GlobalNetRemit> list) {
                            globalNetRemitList = list;
                        }

                        /** 
                         * Get the list of 'SignatureLine' element items.
                         * 
                         * @return list
                         */
                        public List<SignatureLine> getSignatureLineList() {
                            return signatureLineList;
                        }

                        /** 
                         * Set the list of 'SignatureLine' element items.
                         * 
                         * @param list
                         */
                        public void setSignatureLineList(
                                List<SignatureLine> list) {
                            signatureLineList = list;
                        }

                        /** 
                         * Get the list of 'TicketingFees' element items.
                         * 
                         * @return list
                         */
                        public List<TicketingFees> getTicketingFeeList() {
                            return ticketingFeeList;
                        }

                        /** 
                         * Set the list of 'TicketingFees' element items.
                         * 
                         * @param list
                         */
                        public void setTicketingFeeList(List<TicketingFees> list) {
                            ticketingFeeList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageFees" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BaggageFees implements Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items. "Text" is used to return baggage fee-related information.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items. "Text" is used to return baggage fee-related information.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GlobalNetRemit" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="NetFare" minOccurs="0">
                         *         &lt;!-- Reference to inner class NetFare -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="SellingFare" minOccurs="0">
                         *         &lt;!-- Reference to inner class SellingFare -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="MethodType"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ValueCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class GlobalNetRemit implements
                            Serializable
                        {
                            private NetFare netFare;
                            private SellingFare sellingFare;
                            private String text;
                            private String methodType;
                            private String valueCode;

                            /** 
                             * Get the 'NetFare' element value.
                             * 
                             * @return value
                             */
                            public NetFare getNetFare() {
                                return netFare;
                            }

                            /** 
                             * Set the 'NetFare' element value.
                             * 
                             * @param netFare
                             */
                            public void setNetFare(NetFare netFare) {
                                this.netFare = netFare;
                            }

                            /** 
                             * Get the 'SellingFare' element value.
                             * 
                             * @return value
                             */
                            public SellingFare getSellingFare() {
                                return sellingFare;
                            }

                            /** 
                             * Set the 'SellingFare' element value.
                             * 
                             * @param sellingFare
                             */
                            public void setSellingFare(SellingFare sellingFare) {
                                this.sellingFare = sellingFare;
                            }

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }

                            /** 
                             * Get the 'MethodType' attribute value.
                             * 
                             * @return value
                             */
                            public String getMethodType() {
                                return methodType;
                            }

                            /** 
                             * Set the 'MethodType' attribute value.
                             * 
                             * @param methodType
                             */
                            public void setMethodType(String methodType) {
                                this.methodType = methodType;
                            }

                            /** 
                             * Get the 'ValueCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getValueCode() {
                                return valueCode;
                            }

                            /** 
                             * Set the 'ValueCode' attribute value.
                             * 
                             * @param valueCode
                             */
                            public void setValueCode(String valueCode) {
                                this.valueCode = valueCode;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFare" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="BaseFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class BaseFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="EquivFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class EquivFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Taxes" minOccurs="0">
                             *         &lt;!-- Reference to inner class Taxes -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalFare -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class NetFare implements Serializable
                            {
                                private BaseFare baseFare;
                                private EquivFare equivFare;
                                private Taxes taxes;
                                private TotalFare totalFare;

                                /** 
                                 * Get the 'BaseFare' element value.
                                 * 
                                 * @return value
                                 */
                                public BaseFare getBaseFare() {
                                    return baseFare;
                                }

                                /** 
                                 * Set the 'BaseFare' element value.
                                 * 
                                 * @param baseFare
                                 */
                                public void setBaseFare(BaseFare baseFare) {
                                    this.baseFare = baseFare;
                                }

                                /** 
                                 * Get the 'EquivFare' element value.
                                 * 
                                 * @return value
                                 */
                                public EquivFare getEquivFare() {
                                    return equivFare;
                                }

                                /** 
                                 * Set the 'EquivFare' element value.
                                 * 
                                 * @param equivFare
                                 */
                                public void setEquivFare(EquivFare equivFare) {
                                    this.equivFare = equivFare;
                                }

                                /** 
                                 * Get the 'Taxes' element value.
                                 * 
                                 * @return value
                                 */
                                public Taxes getTaxes() {
                                    return taxes;
                                }

                                /** 
                                 * Set the 'Taxes' element value.
                                 * 
                                 * @param taxes
                                 */
                                public void setTaxes(Taxes taxes) {
                                    this.taxes = taxes;
                                }

                                /** 
                                 * Get the 'TotalFare' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalFare getTotalFare() {
                                    return totalFare;
                                }

                                /** 
                                 * Set the 'TotalFare' element value.
                                 * 
                                 * @param totalFare
                                 */
                                public void setTotalFare(TotalFare totalFare) {
                                    this.totalFare = totalFare;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class BaseFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class EquivFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="TotalAmount"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Taxes implements
                                    Serializable
                                {
                                    private String totalAmount;

                                    /** 
                                     * Get the 'TotalAmount' attribute value. "TotalAmount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getTotalAmount() {
                                        return totalAmount;
                                    }

                                    /** 
                                     * Set the 'TotalAmount' attribute value. "TotalAmount" is used to return the applicable amount.
                                     * 
                                     * @param totalAmount
                                     */
                                    public void setTotalAmount(
                                            String totalAmount) {
                                        this.totalAmount = totalAmount;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalFare implements
                                    Serializable
                                {
                                    private String amount;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFare" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="BaseFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class BaseFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="EquivFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class EquivFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Taxes" minOccurs="0">
                             *         &lt;!-- Reference to inner class Taxes -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalFare -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class SellingFare implements
                                Serializable
                            {
                                private BaseFare baseFare;
                                private EquivFare equivFare;
                                private Taxes taxes;
                                private TotalFare totalFare;

                                /** 
                                 * Get the 'BaseFare' element value.
                                 * 
                                 * @return value
                                 */
                                public BaseFare getBaseFare() {
                                    return baseFare;
                                }

                                /** 
                                 * Set the 'BaseFare' element value.
                                 * 
                                 * @param baseFare
                                 */
                                public void setBaseFare(BaseFare baseFare) {
                                    this.baseFare = baseFare;
                                }

                                /** 
                                 * Get the 'EquivFare' element value.
                                 * 
                                 * @return value
                                 */
                                public EquivFare getEquivFare() {
                                    return equivFare;
                                }

                                /** 
                                 * Set the 'EquivFare' element value.
                                 * 
                                 * @param equivFare
                                 */
                                public void setEquivFare(EquivFare equivFare) {
                                    this.equivFare = equivFare;
                                }

                                /** 
                                 * Get the 'Taxes' element value.
                                 * 
                                 * @return value
                                 */
                                public Taxes getTaxes() {
                                    return taxes;
                                }

                                /** 
                                 * Set the 'Taxes' element value.
                                 * 
                                 * @param taxes
                                 */
                                public void setTaxes(Taxes taxes) {
                                    this.taxes = taxes;
                                }

                                /** 
                                 * Get the 'TotalFare' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalFare getTotalFare() {
                                    return totalFare;
                                }

                                /** 
                                 * Set the 'TotalFare' element value.
                                 * 
                                 * @param totalFare
                                 */
                                public void setTotalFare(TotalFare totalFare) {
                                    this.totalFare = totalFare;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class BaseFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class EquivFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="TotalAmount"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Taxes implements
                                    Serializable
                                {
                                    private String totalAmount;

                                    /** 
                                     * Get the 'TotalAmount' attribute value. "TotalAmount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getTotalAmount() {
                                        return totalAmount;
                                    }

                                    /** 
                                     * Set the 'TotalAmount' attribute value. "TotalAmount" is used to return the applicable amount.
                                     * 
                                     * @param totalAmount
                                     */
                                    public void setTotalAmount(
                                            String totalAmount) {
                                        this.totalAmount = totalAmount;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalFare implements
                                    Serializable
                                {
                                    private String amount;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SignatureLine" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Banner"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CommissionAmount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CommissionID"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ExpirationDateTime"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PQR_Ind"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Source"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SignatureLine implements
                            Serializable
                        {
                            private String text;
                            private String banner;
                            private String commissionAmount;
                            private String commissionID;
                            private String expirationDateTime;
                            private String PQRInd;
                            private String source;
                            private String status;

                            /** 
                             * Get the 'Text' element value. "Text" is used to return PQ signature line-related information.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value. "Text" is used to return PQ signature line-related information.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }

                            /** 
                             * Get the 'Banner' attribute value. "Banner" is used to return miscellaneous PQ banner-related information.
                             * 
                             * @return value
                             */
                            public String getBanner() {
                                return banner;
                            }

                            /** 
                             * Set the 'Banner' attribute value. "Banner" is used to return miscellaneous PQ banner-related information.
                             * 
                             * @param banner
                             */
                            public void setBanner(String banner) {
                                this.banner = banner;
                            }

                            /** 
                             * Get the 'CommissionAmount' attribute value. "CommissionAmount" is used to return the commission amount if applicable.
                             * 
                             * @return value
                             */
                            public String getCommissionAmount() {
                                return commissionAmount;
                            }

                            /** 
                             * Set the 'CommissionAmount' attribute value. "CommissionAmount" is used to return the commission amount if applicable.
                             * 
                             * @param commissionAmount
                             */
                            public void setCommissionAmount(
                                    String commissionAmount) {
                                this.commissionAmount = commissionAmount;
                            }

                            /** 
                             * Get the 'CommissionID' attribute value. "CommissionID" is used to return the commission ID if applicable.
                             * 
                             * @return value
                             */
                            public String getCommissionID() {
                                return commissionID;
                            }

                            /** 
                             * Set the 'CommissionID' attribute value. "CommissionID" is used to return the commission ID if applicable.
                             * 
                             * @param commissionID
                             */
                            public void setCommissionID(String commissionID) {
                                this.commissionID = commissionID;
                            }

                            /** 
                             * Get the 'ExpirationDateTime' attribute value. "ExpirationDateTime" is used to return the PQ record expiration date/time.
                             * 
                             * @return value
                             */
                            public String getExpirationDateTime() {
                                return expirationDateTime;
                            }

                            /** 
                             * Set the 'ExpirationDateTime' attribute value. "ExpirationDateTime" is used to return the PQ record expiration date/time.
                             * 
                             * @param expirationDateTime
                             */
                            public void setExpirationDateTime(
                                    String expirationDateTime) {
                                this.expirationDateTime = expirationDateTime;
                            }

                            /** 
                             * Get the 'PQR_Ind' attribute value. "PQR_Ind" is used to indicate that the PQ record is a PQ Reissue versus a regular PQ record.
                             * 
                             * @return value
                             */
                            public String getPQRInd() {
                                return PQRInd;
                            }

                            /** 
                             * Set the 'PQR_Ind' attribute value. "PQR_Ind" is used to indicate that the PQ record is a PQ Reissue versus a regular PQ record.
                             * 
                             * @param PQRInd
                             */
                            public void setPQRInd(String PQRInd) {
                                this.PQRInd = PQRInd;
                            }

                            /** 
                             * Get the 'Source' attribute value. "Source" is used to return the pricing source associated with the particular PQ record.
                             * 
                             * @return value
                             */
                            public String getSource() {
                                return source;
                            }

                            /** 
                             * Set the 'Source' attribute value. "Source" is used to return the pricing source associated with the particular PQ record.
                             * 
                             * @param source
                             */
                            public void setSource(String source) {
                                this.source = source;
                            }

                            /** 
                             * Get the 'Status' attribute value. "Status" is used to return the PQ record status.
                             * 
                             * @return value
                             */
                            public String getStatus() {
                                return status;
                            }

                            /** 
                             * Set the 'Status' attribute value. "Status" is used to return the PQ record status.
                             * 
                             * @param status
                             */
                            public void setStatus(String status) {
                                this.status = status;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingFees" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="FeeInformation" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class FeeInformation -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Disclaimer"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TicketingFees implements
                            Serializable
                        {
                            private List<FeeInformation> feeInformationList = new ArrayList<FeeInformation>();
                            private String disclaimer;

                            /** 
                             * Get the list of 'FeeInformation' element items.
                             * 
                             * @return list
                             */
                            public List<FeeInformation> getFeeInformationList() {
                                return feeInformationList;
                            }

                            /** 
                             * Set the list of 'FeeInformation' element items.
                             * 
                             * @param list
                             */
                            public void setFeeInformationList(
                                    List<FeeInformation> list) {
                                feeInformationList = list;
                            }

                            /** 
                             * Get the 'Disclaimer' attribute value. "Disclaimer" is used to return ticketing fee disclaimer-related information.
                             * 
                             * @return value
                             */
                            public String getDisclaimer() {
                                return disclaimer;
                            }

                            /** 
                             * Set the 'Disclaimer' attribute value. "Disclaimer" is used to return ticketing fee disclaimer-related information.
                             * 
                             * @param disclaimer
                             */
                            public void setDisclaimer(String disclaimer) {
                                this.disclaimer = disclaimer;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInformation" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="AssociatedData" minOccurs="0" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class AssociatedData -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AccountData"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="DisplayOnOutputInd"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="FunctionCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="GuaranteeType"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="NonCommissionInd"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="NonRefundableInd"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="OnlineInterlineService"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceType"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class FeeInformation implements
                                Serializable
                            {
                                private List<AssociatedData> associatedDataList = new ArrayList<AssociatedData>();
                                private String accountData;
                                private String amount;
                                private String displayOnOutputInd;
                                private String functionCode;
                                private String guaranteeType;
                                private String nonCommissionInd;
                                private String nonRefundableInd;
                                private String onlineInterlineService;
                                private String serviceType;
                                private String currencyCode;
                                private String description;

                                /** 
                                 * Get the list of 'AssociatedData' element items.
                                 * 
                                 * @return list
                                 */
                                public List<AssociatedData> getAssociatedDataList() {
                                    return associatedDataList;
                                }

                                /** 
                                 * Set the list of 'AssociatedData' element items.
                                 * 
                                 * @param list
                                 */
                                public void setAssociatedDataList(
                                        List<AssociatedData> list) {
                                    associatedDataList = list;
                                }

                                /** 
                                 * Get the 'AccountData' attribute value. "AccountData" is used to return ticketing fee account-related information.
                                 * 
                                 * @return value
                                 */
                                public String getAccountData() {
                                    return accountData;
                                }

                                /** 
                                 * Set the 'AccountData' attribute value. "AccountData" is used to return ticketing fee account-related information.
                                 * 
                                 * @param accountData
                                 */
                                public void setAccountData(String accountData) {
                                    this.accountData = accountData;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. "Amount" is used to return the ticketing fee amount.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. "Amount" is used to return the ticketing fee amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'DisplayOnOutputInd' attribute value. "DisplayOnOutputInd" is used to is used to indicate whether or not the fee is displayed on output.
                                 * 
                                 * @return value
                                 */
                                public String getDisplayOnOutputInd() {
                                    return displayOnOutputInd;
                                }

                                /** 
                                 * Set the 'DisplayOnOutputInd' attribute value. "DisplayOnOutputInd" is used to is used to indicate whether or not the fee is displayed on output.
                                 * 
                                 * @param displayOnOutputInd
                                 */
                                public void setDisplayOnOutputInd(
                                        String displayOnOutputInd) {
                                    this.displayOnOutputInd = displayOnOutputInd;
                                }

                                /** 
                                 * Get the 'FunctionCode' attribute value. "FunctionCode" is used to return the ticketing fee function code.
                                 * 
                                 * @return value
                                 */
                                public String getFunctionCode() {
                                    return functionCode;
                                }

                                /** 
                                 * Set the 'FunctionCode' attribute value. "FunctionCode" is used to return the ticketing fee function code.
                                 * 
                                 * @param functionCode
                                 */
                                public void setFunctionCode(String functionCode) {
                                    this.functionCode = functionCode;
                                }

                                /** 
                                 * Get the 'GuaranteeType' attribute value. "GuaranteeType" is used to return the ticketing fee guarantee type.
                                 * 
                                 * @return value
                                 */
                                public String getGuaranteeType() {
                                    return guaranteeType;
                                }

                                /** 
                                 * Set the 'GuaranteeType' attribute value. "GuaranteeType" is used to return the ticketing fee guarantee type.
                                 * 
                                 * @param guaranteeType
                                 */
                                public void setGuaranteeType(
                                        String guaranteeType) {
                                    this.guaranteeType = guaranteeType;
                                }

                                /** 
                                 * Get the 'NonCommissionInd' attribute value. "NonCommissionInd" is used to is used to indicate whether or not the fee is commission eligible.
                                 * 
                                 * @return value
                                 */
                                public String getNonCommissionInd() {
                                    return nonCommissionInd;
                                }

                                /** 
                                 * Set the 'NonCommissionInd' attribute value. "NonCommissionInd" is used to is used to indicate whether or not the fee is commission eligible.
                                 * 
                                 * @param nonCommissionInd
                                 */
                                public void setNonCommissionInd(
                                        String nonCommissionInd) {
                                    this.nonCommissionInd = nonCommissionInd;
                                }

                                /** 
                                 * Get the 'NonRefundableInd' attribute value. "NonRefundableInd" is used to is used to indicate whether or not the fee is refundable.
                                 * 
                                 * @return value
                                 */
                                public String getNonRefundableInd() {
                                    return nonRefundableInd;
                                }

                                /** 
                                 * Set the 'NonRefundableInd' attribute value. "NonRefundableInd" is used to is used to indicate whether or not the fee is refundable.
                                 * 
                                 * @param nonRefundableInd
                                 */
                                public void setNonRefundableInd(
                                        String nonRefundableInd) {
                                    this.nonRefundableInd = nonRefundableInd;
                                }

                                /** 
                                 * Get the 'OnlineInterlineService' attribute value. "OnlineInterlineService" is used to is used to return online/interline-related information.
                                 * 
                                 * @return value
                                 */
                                public String getOnlineInterlineService() {
                                    return onlineInterlineService;
                                }

                                /** 
                                 * Set the 'OnlineInterlineService' attribute value. "OnlineInterlineService" is used to is used to return online/interline-related information.
                                 * 
                                 * @param onlineInterlineService
                                 */
                                public void setOnlineInterlineService(
                                        String onlineInterlineService) {
                                    this.onlineInterlineService = onlineInterlineService;
                                }

                                /** 
                                 * Get the 'ServiceType' attribute value. "ServiceType" is used to return the ticketing fee service type.
                                 * 
                                 * @return value
                                 */
                                public String getServiceType() {
                                    return serviceType;
                                }

                                /** 
                                 * Set the 'ServiceType' attribute value. "ServiceType" is used to return the ticketing fee service type.
                                 * 
                                 * @param serviceType
                                 */
                                public void setServiceType(String serviceType) {
                                    this.serviceType = serviceType;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. Ob Fee Currency Code.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. Ob Fee Currency Code.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'Description' attribute value. Ob Fee Description
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value. Ob Fee Description
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedData" minOccurs="0" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="AssociatedDataItem" minOccurs="0" maxOccurs="unbounded">
                                 *         &lt;!-- Reference to inner class AssociatedDataItem -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class AssociatedData implements
                                    Serializable
                                {
                                    private List<AssociatedDataItem> associatedDataItemList = new ArrayList<AssociatedDataItem>();

                                    /** 
                                     * Get the list of 'AssociatedDataItem' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<AssociatedDataItem> getAssociatedDataItemList() {
                                        return associatedDataItemList;
                                    }

                                    /** 
                                     * Set the list of 'AssociatedDataItem' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setAssociatedDataItemList(
                                            List<AssociatedDataItem> list) {
                                        associatedDataItemList = list;
                                    }
                                    /** 
                                     * "AssociatedDataItem" is used to
                                    																										create the relationship between passenger
                                    																										name data and waiver code
                                    																									
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedDataItem" minOccurs="0" maxOccurs="unbounded">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:string" use="optional" name="WaiverCode"/>
                                     *         &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class AssociatedDataItem
                                        implements Serializable
                                    {
                                        private String string;
                                        private String waiverCode;
                                        private String nameNumber;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'WaiverCode' attribute value. "WaiverCode" is used to associate the passenger name number to a particular fee waiver code.
                                        																													
                                         * 
                                         * @return value
                                         */
                                        public String getWaiverCode() {
                                            return waiverCode;
                                        }

                                        /** 
                                         * Set the 'WaiverCode' attribute value. "WaiverCode" is used to associate the passenger name number to a particular fee waiver code.
                                        																													
                                         * 
                                         * @param waiverCode
                                         */
                                        public void setWaiverCode(
                                                String waiverCode) {
                                            this.waiverCode = waiverCode;
                                        }

                                        /** 
                                         * Get the 'NameNumber' attribute value. "NameNumber" is used to associate the particular Waiver code number to a particular passenger within the record.
                                        																													
                                         * 
                                         * @return value
                                         */
                                        public String getNameNumber() {
                                            return nameNumber;
                                        }

                                        /** 
                                         * Set the 'NameNumber' attribute value. "NameNumber" is used to associate the particular Waiver code number to a particular passenger within the record.
                                        																													
                                         * 
                                         * @param nameNumber
                                         */
                                        public void setNameNumber(
                                                String nameNumber) {
                                            this.nameNumber = nameNumber;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0">
                     *         &lt;!-- Reference to inner class AirItineraryPricingInfo -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="NetTicketingInfo" minOccurs="0">
                     *         &lt;!-- Reference to inner class NetTicketingInfo -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DeletedBy"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="DisplayOnly"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="InputMessage"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="StatusCode"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="TaxExempt"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ValidatingCarrier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="StoredDateTime"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PricedItinerary implements Serializable
                    {
                        private AirItineraryPricingInfo airItineraryPricingInfo;
                        private NetTicketingInfo netTicketingInfo;
                        private String deletedBy;
                        private Boolean displayOnly;
                        private String inputMessage;
                        private String RPH;
                        private String statusCode;
                        private Boolean taxExempt;
                        private String validatingCarrier;
                        private String storedDateTime;

                        /** 
                         * Get the 'AirItineraryPricingInfo' element value.
                         * 
                         * @return value
                         */
                        public AirItineraryPricingInfo getAirItineraryPricingInfo() {
                            return airItineraryPricingInfo;
                        }

                        /** 
                         * Set the 'AirItineraryPricingInfo' element value.
                         * 
                         * @param airItineraryPricingInfo
                         */
                        public void setAirItineraryPricingInfo(
                                AirItineraryPricingInfo airItineraryPricingInfo) {
                            this.airItineraryPricingInfo = airItineraryPricingInfo;
                        }

                        /** 
                         * Get the 'NetTicketingInfo' element value.
                         * 
                         * @return value
                         */
                        public NetTicketingInfo getNetTicketingInfo() {
                            return netTicketingInfo;
                        }

                        /** 
                         * Set the 'NetTicketingInfo' element value.
                         * 
                         * @param netTicketingInfo
                         */
                        public void setNetTicketingInfo(
                                NetTicketingInfo netTicketingInfo) {
                            this.netTicketingInfo = netTicketingInfo;
                        }

                        /** 
                         * Get the 'DeletedBy' attribute value. "DeletedBy" is used to return deletion information associated with the particular price quote if applicable.
                         * 
                         * @return value
                         */
                        public String getDeletedBy() {
                            return deletedBy;
                        }

                        /** 
                         * Set the 'DeletedBy' attribute value. "DeletedBy" is used to return deletion information associated with the particular price quote if applicable.
                         * 
                         * @param deletedBy
                         */
                        public void setDeletedBy(String deletedBy) {
                            this.deletedBy = deletedBy;
                        }

                        /** 
                         * Get the 'DisplayOnly' attribute value. "DisplayOnly" is used to indicate that the global net remit-related data is display only.
                         * 
                         * @return value
                         */
                        public Boolean getDisplayOnly() {
                            return displayOnly;
                        }

                        /** 
                         * Set the 'DisplayOnly' attribute value. "DisplayOnly" is used to indicate that the global net remit-related data is display only.
                         * 
                         * @param displayOnly
                         */
                        public void setDisplayOnly(Boolean displayOnly) {
                            this.displayOnly = displayOnly;
                        }

                        /** 
                         * Get the 'InputMessage' attribute value. "InputMessage" is used to return the host command associated with the particular price quote.
                         * 
                         * @return value
                         */
                        public String getInputMessage() {
                            return inputMessage;
                        }

                        /** 
                         * Set the 'InputMessage' attribute value. "InputMessage" is used to return the host command associated with the particular price quote.
                         * 
                         * @param inputMessage
                         */
                        public void setInputMessage(String inputMessage) {
                            this.inputMessage = inputMessage;
                        }

                        /** 
                         * Get the 'RPH' attribute value. "RPH" is used as a reference place holder.
                         * 
                         * @return value
                         */
                        public String getRPH() {
                            return RPH;
                        }

                        /** 
                         * Set the 'RPH' attribute value. "RPH" is used as a reference place holder.
                         * 
                         * @param RPH
                         */
                        public void setRPH(String RPH) {
                            this.RPH = RPH;
                        }

                        /** 
                         * Get the 'StatusCode' attribute value. "StatusCode" is used to return the status code associated with the particular price quote. --&gt;
                         * 
                         * @return value
                         */
                        public String getStatusCode() {
                            return statusCode;
                        }

                        /** 
                         * Set the 'StatusCode' attribute value. "StatusCode" is used to return the status code associated with the particular price quote. --&gt;
                         * 
                         * @param statusCode
                         */
                        public void setStatusCode(String statusCode) {
                            this.statusCode = statusCode;
                        }

                        /** 
                         * Get the 'TaxExempt' attribute value. "TaxExempt" is used to indicate whether or not the particular priced itinerary is classified as tax exempt
                         * 
                         * @return value
                         */
                        public Boolean getTaxExempt() {
                            return taxExempt;
                        }

                        /** 
                         * Set the 'TaxExempt' attribute value. "TaxExempt" is used to indicate whether or not the particular priced itinerary is classified as tax exempt
                         * 
                         * @param taxExempt
                         */
                        public void setTaxExempt(Boolean taxExempt) {
                            this.taxExempt = taxExempt;
                        }

                        /** 
                         * Get the 'ValidatingCarrier' attribute value. "ValidatingCarrier" is used to return validating carrier-related information associated with the particular price quote.
                         * 
                         * @return value
                         */
                        public String getValidatingCarrier() {
                            return validatingCarrier;
                        }

                        /** 
                         * Set the 'ValidatingCarrier' attribute value. "ValidatingCarrier" is used to return validating carrier-related information associated with the particular price quote.
                         * 
                         * @param validatingCarrier
                         */
                        public void setValidatingCarrier(
                                String validatingCarrier) {
                            this.validatingCarrier = validatingCarrier;
                        }

                        /** 
                         * Get the 'StoredDateTime' attribute value. "StoredDateTime" is used to return a date when data were stored in PQ.
                         * 
                         * @return value
                         */
                        public String getStoredDateTime() {
                            return storedDateTime;
                        }

                        /** 
                         * Set the 'StoredDateTime' attribute value. "StoredDateTime" is used to return a date when data were stored in PQ.
                         * 
                         * @param storedDateTime
                         */
                        public void setStoredDateTime(String storedDateTime) {
                            this.storedDateTime = storedDateTime;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="ItinTotalFare" minOccurs="0" maxOccurs="7">
                         *         &lt;!-- Reference to inner class ItinTotalFare -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="PassengerTypeQuantity" minOccurs="0" maxOccurs="7">
                         *         &lt;!-- Reference to inner class PassengerTypeQuantity -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="PrivateFareInformation" minOccurs="0">
                         *         &lt;!-- Reference to inner class PrivateFareInformation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="PTC_FareBreakdown" minOccurs="0" maxOccurs="7">
                         *         &lt;!-- Reference to inner class PTCFareBreakdown -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class AirItineraryPricingInfo implements
                            Serializable
                        {
                            private List<ItinTotalFare> itinTotalFareList = new ArrayList<ItinTotalFare>();
                            private List<PassengerTypeQuantity> passengerTypeQuantityList = new ArrayList<PassengerTypeQuantity>();
                            private PrivateFareInformation privateFareInformation;
                            private List<PTCFareBreakdown> PTCFareBreakdownList = new ArrayList<PTCFareBreakdown>();

                            /** 
                             * Get the list of 'ItinTotalFare' element items.
                             * 
                             * @return list
                             */
                            public List<ItinTotalFare> getItinTotalFareList() {
                                return itinTotalFareList;
                            }

                            /** 
                             * Set the list of 'ItinTotalFare' element items.
                             * 
                             * @param list
                             */
                            public void setItinTotalFareList(
                                    List<ItinTotalFare> list) {
                                itinTotalFareList = list;
                            }

                            /** 
                             * Get the list of 'PassengerTypeQuantity' element items.
                             * 
                             * @return list
                             */
                            public List<PassengerTypeQuantity> getPassengerTypeQuantityList() {
                                return passengerTypeQuantityList;
                            }

                            /** 
                             * Set the list of 'PassengerTypeQuantity' element items.
                             * 
                             * @param list
                             */
                            public void setPassengerTypeQuantityList(
                                    List<PassengerTypeQuantity> list) {
                                passengerTypeQuantityList = list;
                            }

                            /** 
                             * Get the 'PrivateFareInformation' element value.
                             * 
                             * @return value
                             */
                            public PrivateFareInformation getPrivateFareInformation() {
                                return privateFareInformation;
                            }

                            /** 
                             * Set the 'PrivateFareInformation' element value.
                             * 
                             * @param privateFareInformation
                             */
                            public void setPrivateFareInformation(
                                    PrivateFareInformation privateFareInformation) {
                                this.privateFareInformation = privateFareInformation;
                            }

                            /** 
                             * Get the list of 'PTC_FareBreakdown' element items.
                             * 
                             * @return list
                             */
                            public List<PTCFareBreakdown> getPTCFareBreakdownList() {
                                return PTCFareBreakdownList;
                            }

                            /** 
                             * Set the list of 'PTC_FareBreakdown' element items.
                             * 
                             * @param list
                             */
                            public void setPTCFareBreakdownList(
                                    List<PTCFareBreakdown> list) {
                                PTCFareBreakdownList = list;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinTotalFare" minOccurs="0" maxOccurs="7">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="BaseFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class BaseFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="EquivFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class EquivFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Taxes" minOccurs="0">
                             *         &lt;!-- Reference to inner class Taxes -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Totals" minOccurs="0">
                             *         &lt;!-- Reference to inner class Totals -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class ItinTotalFare implements
                                Serializable
                            {
                                private BaseFare baseFare;
                                private EquivFare equivFare;
                                private Taxes taxes;
                                private TotalFare totalFare;
                                private Totals totals;

                                /** 
                                 * Get the 'BaseFare' element value.
                                 * 
                                 * @return value
                                 */
                                public BaseFare getBaseFare() {
                                    return baseFare;
                                }

                                /** 
                                 * Set the 'BaseFare' element value.
                                 * 
                                 * @param baseFare
                                 */
                                public void setBaseFare(BaseFare baseFare) {
                                    this.baseFare = baseFare;
                                }

                                /** 
                                 * Get the 'EquivFare' element value.
                                 * 
                                 * @return value
                                 */
                                public EquivFare getEquivFare() {
                                    return equivFare;
                                }

                                /** 
                                 * Set the 'EquivFare' element value.
                                 * 
                                 * @param equivFare
                                 */
                                public void setEquivFare(EquivFare equivFare) {
                                    this.equivFare = equivFare;
                                }

                                /** 
                                 * Get the 'Taxes' element value.
                                 * 
                                 * @return value
                                 */
                                public Taxes getTaxes() {
                                    return taxes;
                                }

                                /** 
                                 * Set the 'Taxes' element value.
                                 * 
                                 * @param taxes
                                 */
                                public void setTaxes(Taxes taxes) {
                                    this.taxes = taxes;
                                }

                                /** 
                                 * Get the 'TotalFare' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalFare getTotalFare() {
                                    return totalFare;
                                }

                                /** 
                                 * Set the 'TotalFare' element value.
                                 * 
                                 * @param totalFare
                                 */
                                public void setTotalFare(TotalFare totalFare) {
                                    this.totalFare = totalFare;
                                }

                                /** 
                                 * Get the 'Totals' element value.
                                 * 
                                 * @return value
                                 */
                                public Totals getTotals() {
                                    return totals;
                                }

                                /** 
                                 * Set the 'Totals' element value.
                                 * 
                                 * @param totals
                                 */
                                public void setTotals(Totals totals) {
                                    this.totals = totals;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class BaseFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class EquivFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Tax" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Tax -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="TaxBreakdownCode" minOccurs="0" maxOccurs="unbounded">
                                 *         &lt;!-- Reference to inner class TaxBreakdownCode -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Taxes implements
                                    Serializable
                                {
                                    private Tax tax;
                                    private List<TaxBreakdownCode> taxBreakdownCodeList = new ArrayList<TaxBreakdownCode>();

                                    /** 
                                     * Get the 'Tax' element value.
                                     * 
                                     * @return value
                                     */
                                    public Tax getTax() {
                                        return tax;
                                    }

                                    /** 
                                     * Set the 'Tax' element value.
                                     * 
                                     * @param tax
                                     */
                                    public void setTax(Tax tax) {
                                        this.tax = tax;
                                    }

                                    /** 
                                     * Get the list of 'TaxBreakdownCode' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<TaxBreakdownCode> getTaxBreakdownCodeList() {
                                        return taxBreakdownCodeList;
                                    }

                                    /** 
                                     * Set the list of 'TaxBreakdownCode' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setTaxBreakdownCodeList(
                                            List<TaxBreakdownCode> list) {
                                        taxBreakdownCodeList = list;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Tax implements
                                        Serializable
                                    {
                                        private String amount;
                                        private String taxCode;

                                        /** 
                                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'TaxCode' attribute value. "TaxCode" is used to return the applicable tax code.
                                         * 
                                         * @return value
                                         */
                                        public String getTaxCode() {
                                            return taxCode;
                                        }

                                        /** 
                                         * Set the 'TaxCode' attribute value. "TaxCode" is used to return the applicable tax code.
                                         * 
                                         * @param taxCode
                                         */
                                        public void setTaxCode(String taxCode) {
                                            this.taxCode = taxCode;
                                        }
                                    }
                                    /** 
                                     * "TaxBreakdownCode" is used to return the applicable tax breakdown code.
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxBreakdownCode" minOccurs="0" maxOccurs="unbounded">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:boolean" name="TaxPaid"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class TaxBreakdownCode
                                        implements Serializable
                                    {
                                        private String string;
                                        private Boolean taxPaid;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'TaxPaid' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public Boolean getTaxPaid() {
                                            return taxPaid;
                                        }

                                        /** 
                                         * Set the 'TaxPaid' attribute value.
                                         * 
                                         * @param taxPaid
                                         */
                                        public void setTaxPaid(Boolean taxPaid) {
                                            this.taxPaid = taxPaid;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Totals" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                                 *         &lt;!-- Reference to inner class BaseFare -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="EquivFare" minOccurs="0">
                                 *         &lt;!-- Reference to inner class EquivFare -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Taxes" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Taxes -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                                 *         &lt;!-- Reference to inner class TotalFare -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Totals implements
                                    Serializable
                                {
                                    private BaseFare baseFare;
                                    private EquivFare equivFare;
                                    private Taxes taxes;
                                    private TotalFare totalFare;

                                    /** 
                                     * Get the 'BaseFare' element value.
                                     * 
                                     * @return value
                                     */
                                    public BaseFare getBaseFare() {
                                        return baseFare;
                                    }

                                    /** 
                                     * Set the 'BaseFare' element value.
                                     * 
                                     * @param baseFare
                                     */
                                    public void setBaseFare(BaseFare baseFare) {
                                        this.baseFare = baseFare;
                                    }

                                    /** 
                                     * Get the 'EquivFare' element value.
                                     * 
                                     * @return value
                                     */
                                    public EquivFare getEquivFare() {
                                        return equivFare;
                                    }

                                    /** 
                                     * Set the 'EquivFare' element value.
                                     * 
                                     * @param equivFare
                                     */
                                    public void setEquivFare(EquivFare equivFare) {
                                        this.equivFare = equivFare;
                                    }

                                    /** 
                                     * Get the 'Taxes' element value.
                                     * 
                                     * @return value
                                     */
                                    public Taxes getTaxes() {
                                        return taxes;
                                    }

                                    /** 
                                     * Set the 'Taxes' element value.
                                     * 
                                     * @param taxes
                                     */
                                    public void setTaxes(Taxes taxes) {
                                        this.taxes = taxes;
                                    }

                                    /** 
                                     * Get the 'TotalFare' element value.
                                     * 
                                     * @return value
                                     */
                                    public TotalFare getTotalFare() {
                                        return totalFare;
                                    }

                                    /** 
                                     * Set the 'TotalFare' element value.
                                     * 
                                     * @param totalFare
                                     */
                                    public void setTotalFare(TotalFare totalFare) {
                                        this.totalFare = totalFare;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class BaseFare implements
                                        Serializable
                                    {
                                        private String amount;

                                        /** 
                                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class EquivFare implements
                                        Serializable
                                    {
                                        private String amount;

                                        /** 
                                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="Tax" minOccurs="0">
                                     *         &lt;!-- Reference to inner class Tax -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Taxes implements
                                        Serializable
                                    {
                                        private Tax tax;

                                        /** 
                                         * Get the 'Tax' element value.
                                         * 
                                         * @return value
                                         */
                                        public Tax getTax() {
                                            return tax;
                                        }

                                        /** 
                                         * Set the 'Tax' element value.
                                         * 
                                         * @param tax
                                         */
                                        public void setTax(Tax tax) {
                                            this.tax = tax;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Tax implements
                                            Serializable
                                        {
                                            private String amount;

                                            /** 
                                             * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                             * 
                                             * @return value
                                             */
                                            public String getAmount() {
                                                return amount;
                                            }

                                            /** 
                                             * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                             * 
                                             * @param amount
                                             */
                                            public void setAmount(String amount) {
                                                this.amount = amount;
                                            }
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class TotalFare implements
                                        Serializable
                                    {
                                        private String amount;

                                        /** 
                                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }
                                    }
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantity" minOccurs="0" maxOccurs="7">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PassengerTypeQuantity implements
                                Serializable
                            {
                                private String code;
                                private String quantity;

                                /** 
                                 * Get the 'Code' attribute value. "Code" is used to return the passenger type code associated with the particular price quote.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value. "Code" is used to return the passenger type code associated with the particular price quote.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Quantity' attribute value. "Quantity" is used to return the number of passengers associated with the particular passenger type code.
                                 * 
                                 * @return value
                                 */
                                public String getQuantity() {
                                    return quantity;
                                }

                                /** 
                                 * Set the 'Quantity' attribute value. "Quantity" is used to return the number of passengers associated with the particular passenger type code.
                                 * 
                                 * @param quantity
                                 */
                                public void setQuantity(String quantity) {
                                    this.quantity = quantity;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFareInformation" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="7"/>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PrivateFareType"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="PrivateFareInd"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PrivateFareInformation
                                implements Serializable
                            {
                                private List<String> textList = new ArrayList<String>();
                                private String privateFareType;
                                private Boolean privateFareInd;

                                /** 
                                 * Get the list of 'Text' element items. "Text" is used to return the miscellaneous private fare-related information if applicable.
                                 * 
                                 * @return list
                                 */
                                public List<String> getTextList() {
                                    return textList;
                                }

                                /** 
                                 * Set the list of 'Text' element items. "Text" is used to return the miscellaneous private fare-related information if applicable.
                                 * 
                                 * @param list
                                 */
                                public void setTextList(List<String> list) {
                                    textList = list;
                                }

                                /** 
                                 * Get the 'PrivateFareType' attribute value. "PrivateFareType" is used to return the miscellaneous private fare-related information if applicable.
                                 * 
                                 * @return value
                                 */
                                public String getPrivateFareType() {
                                    return privateFareType;
                                }

                                /** 
                                 * Set the 'PrivateFareType' attribute value. "PrivateFareType" is used to return the miscellaneous private fare-related information if applicable.
                                 * 
                                 * @param privateFareType
                                 */
                                public void setPrivateFareType(
                                        String privateFareType) {
                                    this.privateFareType = privateFareType;
                                }

                                /** 
                                 * Get the 'PrivateFareInd' attribute value. "PrivateFareInd" is a private fare indicator.
                                 * 
                                 * @return value
                                 */
                                public Boolean getPrivateFareInd() {
                                    return privateFareInd;
                                }

                                /** 
                                 * Set the 'PrivateFareInd' attribute value. "PrivateFareInd" is a private fare indicator.
                                 * 
                                 * @param privateFareInd
                                 */
                                public void setPrivateFareInd(
                                        Boolean privateFareInd) {
                                    this.privateFareInd = privateFareInd;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_FareBreakdown" minOccurs="0" maxOccurs="7">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="NetRemits" minOccurs="0">
                             *         &lt;!-- Reference to inner class NetRemits -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Endorsements" minOccurs="0">
                             *         &lt;!-- Reference to inner class Endorsements -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="FareBasis" minOccurs="0" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class FareBasis -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="FareCalculation" minOccurs="0">
                             *         &lt;!-- Reference to inner class FareCalculation -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element type="xs:string" name="FareSource" minOccurs="0"/>
                             *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class FlightSegment -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="FareComponent" minOccurs="0" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class FareComponent -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element type="xs:string" name="ResTicketingRestrictions" minOccurs="0" maxOccurs="unbounded"/>
                             *       &lt;xs:element name="TourCode" minOccurs="0">
                             *         &lt;!-- Reference to inner class TourCode -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PTCFareBreakdown implements
                                Serializable
                            {
                                private NetRemits netRemits;
                                private Endorsements endorsements;
                                private List<FareBasis> fareBasiList = new ArrayList<FareBasis>();
                                private FareCalculation fareCalculation;
                                private String fareSource;
                                private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
                                private List<FareComponent> fareComponentList = new ArrayList<FareComponent>();
                                private List<String> resTicketingRestrictionList = new ArrayList<String>();
                                private TourCode tourCode;

                                /** 
                                 * Get the 'NetRemits' element value.
                                 * 
                                 * @return value
                                 */
                                public NetRemits getNetRemits() {
                                    return netRemits;
                                }

                                /** 
                                 * Set the 'NetRemits' element value.
                                 * 
                                 * @param netRemits
                                 */
                                public void setNetRemits(NetRemits netRemits) {
                                    this.netRemits = netRemits;
                                }

                                /** 
                                 * Get the 'Endorsements' element value.
                                 * 
                                 * @return value
                                 */
                                public Endorsements getEndorsements() {
                                    return endorsements;
                                }

                                /** 
                                 * Set the 'Endorsements' element value.
                                 * 
                                 * @param endorsements
                                 */
                                public void setEndorsements(
                                        Endorsements endorsements) {
                                    this.endorsements = endorsements;
                                }

                                /** 
                                 * Get the list of 'FareBasis' element items.
                                 * 
                                 * @return list
                                 */
                                public List<FareBasis> getFareBasiList() {
                                    return fareBasiList;
                                }

                                /** 
                                 * Set the list of 'FareBasis' element items.
                                 * 
                                 * @param list
                                 */
                                public void setFareBasiList(List<FareBasis> list) {
                                    fareBasiList = list;
                                }

                                /** 
                                 * Get the 'FareCalculation' element value.
                                 * 
                                 * @return value
                                 */
                                public FareCalculation getFareCalculation() {
                                    return fareCalculation;
                                }

                                /** 
                                 * Set the 'FareCalculation' element value.
                                 * 
                                 * @param fareCalculation
                                 */
                                public void setFareCalculation(
                                        FareCalculation fareCalculation) {
                                    this.fareCalculation = fareCalculation;
                                }

                                /** 
                                 * Get the 'FareSource' element value. "FareSource" is used to return the fare source.
                                 * 
                                 * @return value
                                 */
                                public String getFareSource() {
                                    return fareSource;
                                }

                                /** 
                                 * Set the 'FareSource' element value. "FareSource" is used to return the fare source.
                                 * 
                                 * @param fareSource
                                 */
                                public void setFareSource(String fareSource) {
                                    this.fareSource = fareSource;
                                }

                                /** 
                                 * Get the list of 'FlightSegment' element items.
                                 * 
                                 * @return list
                                 */
                                public List<FlightSegment> getFlightSegmentList() {
                                    return flightSegmentList;
                                }

                                /** 
                                 * Set the list of 'FlightSegment' element items.
                                 * 
                                 * @param list
                                 */
                                public void setFlightSegmentList(
                                        List<FlightSegment> list) {
                                    flightSegmentList = list;
                                }

                                /** 
                                 * Get the list of 'FareComponent' element items.
                                 * 
                                 * @return list
                                 */
                                public List<FareComponent> getFareComponentList() {
                                    return fareComponentList;
                                }

                                /** 
                                 * Set the list of 'FareComponent' element items.
                                 * 
                                 * @param list
                                 */
                                public void setFareComponentList(
                                        List<FareComponent> list) {
                                    fareComponentList = list;
                                }

                                /** 
                                 * Get the list of 'ResTicketingRestrictions' element items. "ResTicketingRestrictions" is used to return last day to purchase-related information
                                 * 
                                 * @return list
                                 */
                                public List<String> getResTicketingRestrictionList() {
                                    return resTicketingRestrictionList;
                                }

                                /** 
                                 * Set the list of 'ResTicketingRestrictions' element items. "ResTicketingRestrictions" is used to return last day to purchase-related information
                                 * 
                                 * @param list
                                 */
                                public void setResTicketingRestrictionList(
                                        List<String> list) {
                                    resTicketingRestrictionList = list;
                                }

                                /** 
                                 * Get the 'TourCode' element value.
                                 * 
                                 * @return value
                                 */
                                public TourCode getTourCode() {
                                    return tourCode;
                                }

                                /** 
                                 * Set the 'TourCode' element value.
                                 * 
                                 * @param tourCode
                                 */
                                public void setTourCode(TourCode tourCode) {
                                    this.tourCode = tourCode;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemits" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="NetRemit" minOccurs="0" maxOccurs="unbounded">
                                 *         &lt;!-- Reference to inner class NetRemit -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class NetRemits implements
                                    Serializable
                                {
                                    private List<NetRemit> netRemitList = new ArrayList<NetRemit>();

                                    /** 
                                     * Get the list of 'NetRemit' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<NetRemit> getNetRemitList() {
                                        return netRemitList;
                                    }

                                    /** 
                                     * Set the list of 'NetRemit' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setNetRemitList(
                                            List<NetRemit> list) {
                                        netRemitList = list;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0" maxOccurs="unbounded">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class NetRemit implements
                                        Serializable
                                    {
                                        private String text;

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Endorsement" minOccurs="0" maxOccurs="unbounded">
                                 *         &lt;!-- Reference to inner class Endorsement -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Endorsements implements
                                    Serializable
                                {
                                    private List<Endorsement> endorsementList = new ArrayList<Endorsement>();

                                    /** 
                                     * Get the list of 'Endorsement' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<Endorsement> getEndorsementList() {
                                        return endorsementList;
                                    }

                                    /** 
                                     * Set the list of 'Endorsement' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setEndorsementList(
                                            List<Endorsement> list) {
                                        endorsementList = list;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsement" minOccurs="0" maxOccurs="unbounded">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text"/>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" use="required" name="type"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Endorsement implements
                                        Serializable
                                    {
                                        private String text;
                                        private String type;

                                        /** 
                                         * Get the 'Text' element value. "Text" is used to return miscellaneous endorsement-related information associated with the particular price quote.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value. "Text" is used to return miscellaneous endorsement-related information associated with the particular price quote.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }

                                        /** 
                                         * Get the 'type' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getType() {
                                            return type;
                                        }

                                        /** 
                                         * Set the 'type' attribute value.
                                         * 
                                         * @param type
                                         */
                                        public void setType(String type) {
                                            this.type = type;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class FareBasis implements
                                    Serializable
                                {
                                    private String code;

                                    /** 
                                     * Get the 'Code' attribute value. "Code" is used to return the fare basis code associated with the particular price quote.
                                     * 
                                     * @return value
                                     */
                                    public String getCode() {
                                        return code;
                                    }

                                    /** 
                                     * Set the 'Code' attribute value. "Code" is used to return the fare basis code associated with the particular price quote.
                                     * 
                                     * @param code
                                     */
                                    public void setCode(String code) {
                                        this.code = code;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class FareCalculation implements
                                    Serializable
                                {
                                    private List<String> textList = new ArrayList<String>();

                                    /** 
                                     * Get the list of 'Text' element items. "Text" is used to return the fare calculation line associated with the particular price quote.
                                     * 
                                     * @return list
                                     */
                                    public List<String> getTextList() {
                                        return textList;
                                    }

                                    /** 
                                     * Set the list of 'Text' element items. "Text" is used to return the fare calculation line associated with the particular price quote.
                                     * 
                                     * @param list
                                     */
                                    public void setTextList(List<String> list) {
                                        textList = list;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="BaggageAllowance" minOccurs="0">
                                 *         &lt;!-- Reference to inner class BaggageAllowance -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="FareBasis" minOccurs="0">
                                 *         &lt;!-- Reference to inner class FareBasis -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                                 *         &lt;!-- Reference to inner class MarketingAirline -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="OriginLocation" minOccurs="0">
                                 *         &lt;!-- Reference to inner class OriginLocation -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="ValidityDates" minOccurs="0">
                                 *         &lt;!-- Reference to inner class ValidityDates -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class FlightSegment implements
                                    Serializable
                                {
                                    private BaggageAllowance baggageAllowance;
                                    private FareBasis fareBasis;
                                    private MarketingAirline marketingAirline;
                                    private OriginLocation originLocation;
                                    private ValidityDates validityDates;
                                    private String connectionInd;
                                    private String departureDateTime;
                                    private String flightNumber;
                                    private String resBookDesigCode;
                                    private String segmentNumber;
                                    private String status;
                                    private String id;

                                    /** 
                                     * Get the 'BaggageAllowance' element value.
                                     * 
                                     * @return value
                                     */
                                    public BaggageAllowance getBaggageAllowance() {
                                        return baggageAllowance;
                                    }

                                    /** 
                                     * Set the 'BaggageAllowance' element value.
                                     * 
                                     * @param baggageAllowance
                                     */
                                    public void setBaggageAllowance(
                                            BaggageAllowance baggageAllowance) {
                                        this.baggageAllowance = baggageAllowance;
                                    }

                                    /** 
                                     * Get the 'FareBasis' element value.
                                     * 
                                     * @return value
                                     */
                                    public FareBasis getFareBasis() {
                                        return fareBasis;
                                    }

                                    /** 
                                     * Set the 'FareBasis' element value.
                                     * 
                                     * @param fareBasis
                                     */
                                    public void setFareBasis(FareBasis fareBasis) {
                                        this.fareBasis = fareBasis;
                                    }

                                    /** 
                                     * Get the 'MarketingAirline' element value.
                                     * 
                                     * @return value
                                     */
                                    public MarketingAirline getMarketingAirline() {
                                        return marketingAirline;
                                    }

                                    /** 
                                     * Set the 'MarketingAirline' element value.
                                     * 
                                     * @param marketingAirline
                                     */
                                    public void setMarketingAirline(
                                            MarketingAirline marketingAirline) {
                                        this.marketingAirline = marketingAirline;
                                    }

                                    /** 
                                     * Get the 'OriginLocation' element value.
                                     * 
                                     * @return value
                                     */
                                    public OriginLocation getOriginLocation() {
                                        return originLocation;
                                    }

                                    /** 
                                     * Set the 'OriginLocation' element value.
                                     * 
                                     * @param originLocation
                                     */
                                    public void setOriginLocation(
                                            OriginLocation originLocation) {
                                        this.originLocation = originLocation;
                                    }

                                    /** 
                                     * Get the 'ValidityDates' element value.
                                     * 
                                     * @return value
                                     */
                                    public ValidityDates getValidityDates() {
                                        return validityDates;
                                    }

                                    /** 
                                     * Set the 'ValidityDates' element value.
                                     * 
                                     * @param validityDates
                                     */
                                    public void setValidityDates(
                                            ValidityDates validityDates) {
                                        this.validityDates = validityDates;
                                    }

                                    /** 
                                     * Get the 'ConnectionInd' attribute value. "ConnectionInd" is used to return the connection indicator associated with the particular flight segment.
                                     * 
                                     * @return value
                                     */
                                    public String getConnectionInd() {
                                        return connectionInd;
                                    }

                                    /** 
                                     * Set the 'ConnectionInd' attribute value. "ConnectionInd" is used to return the connection indicator associated with the particular flight segment.
                                     * 
                                     * @param connectionInd
                                     */
                                    public void setConnectionInd(
                                            String connectionInd) {
                                        this.connectionInd = connectionInd;
                                    }

                                    /** 
                                     * Get the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the time and date of flight departure associated with the particular flight segment.
                                    																									"DepartureDateTime" follows this format: MM:DDTHH:MM
                                     * 
                                     * @return value
                                     */
                                    public String getDepartureDateTime() {
                                        return departureDateTime;
                                    }

                                    /** 
                                     * Set the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the time and date of flight departure associated with the particular flight segment.
                                    																									"DepartureDateTime" follows this format: MM:DDTHH:MM
                                     * 
                                     * @param departureDateTime
                                     */
                                    public void setDepartureDateTime(
                                            String departureDateTime) {
                                        this.departureDateTime = departureDateTime;
                                    }

                                    /** 
                                     * Get the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular flight segment.
                                     * 
                                     * @return value
                                     */
                                    public String getFlightNumber() {
                                        return flightNumber;
                                    }

                                    /** 
                                     * Set the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular flight segment.
                                     * 
                                     * @param flightNumber
                                     */
                                    public void setFlightNumber(
                                            String flightNumber) {
                                        this.flightNumber = flightNumber;
                                    }

                                    /** 
                                     * Get the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                                     * 
                                     * @return value
                                     */
                                    public String getResBookDesigCode() {
                                        return resBookDesigCode;
                                    }

                                    /** 
                                     * Set the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                                     * 
                                     * @param resBookDesigCode
                                     */
                                    public void setResBookDesigCode(
                                            String resBookDesigCode) {
                                        this.resBookDesigCode = resBookDesigCode;
                                    }

                                    /** 
                                     * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the internal order segment number that was used to price the segments.
                                     * 
                                     * @return value
                                     */
                                    public String getSegmentNumber() {
                                        return segmentNumber;
                                    }

                                    /** 
                                     * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the internal order segment number that was used to price the segments.
                                     * 
                                     * @param segmentNumber
                                     */
                                    public void setSegmentNumber(
                                            String segmentNumber) {
                                        this.segmentNumber = segmentNumber;
                                    }

                                    /** 
                                     * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                                     * 
                                     * @return value
                                     */
                                    public String getStatus() {
                                        return status;
                                    }

                                    /** 
                                     * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                                     * 
                                     * @param status
                                     */
                                    public void setStatus(String status) {
                                        this.status = status;
                                    }

                                    /** 
                                     * Get the 'Id' attribute value. "Id" is used to return the id of FlightSegment
                                     * 
                                     * @return value
                                     */
                                    public String getId() {
                                        return id;
                                    }

                                    /** 
                                     * Set the 'Id' attribute value. "Id" is used to return the id of FlightSegment
                                     * 
                                     * @param id
                                     */
                                    public void setId(String id) {
                                        this.id = id;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class BaggageAllowance
                                        implements Serializable
                                    {
                                        private String number;

                                        /** 
                                         * Get the 'Number' attribute value. "Number" is used to return the baggage allowance type associated with the particular flight segment.
                                         * 
                                         * @return value
                                         */
                                        public String getNumber() {
                                            return number;
                                        }

                                        /** 
                                         * Set the 'Number' attribute value. "Number" is used to return the baggage allowance type associated with the particular flight segment.
                                         * 
                                         * @param number
                                         */
                                        public void setNumber(String number) {
                                            this.number = number;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class FareBasis implements
                                        Serializable
                                    {
                                        private String code;

                                        /** 
                                         * Get the 'Code' attribute value. "Code" is used to return the fare basis code associated with the particular flight segment.
                                         * 
                                         * @return value
                                         */
                                        public String getCode() {
                                            return code;
                                        }

                                        /** 
                                         * Set the 'Code' attribute value. "Code" is used to return the fare basis code associated with the particular flight segment.
                                         * 
                                         * @param code
                                         */
                                        public void setCode(String code) {
                                            this.code = code;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class MarketingAirline
                                        implements Serializable
                                    {
                                        private String code;
                                        private String flightNumber;

                                        /** 
                                         * Get the 'Code' attribute value. "Code" is used to return the marketing airline code associated with the particular flight segment.
                                         * 
                                         * @return value
                                         */
                                        public String getCode() {
                                            return code;
                                        }

                                        /** 
                                         * Set the 'Code' attribute value. "Code" is used to return the marketing airline code associated with the particular flight segment.
                                         * 
                                         * @param code
                                         */
                                        public void setCode(String code) {
                                            this.code = code;
                                        }

                                        /** 
                                         * Get the 'FlightNumber' attribute value. "FlightNumber" is used to return the marketing airline flight number associated with the particular flight segment.
                                         * 
                                         * @return value
                                         */
                                        public String getFlightNumber() {
                                            return flightNumber;
                                        }

                                        /** 
                                         * Set the 'FlightNumber' attribute value. "FlightNumber" is used to return the marketing airline flight number associated with the particular flight segment.
                                         * 
                                         * @param flightNumber
                                         */
                                        public void setFlightNumber(
                                                String flightNumber) {
                                            this.flightNumber = flightNumber;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class OriginLocation
                                        implements Serializable
                                    {
                                        private String locationCode;

                                        /** 
                                         * Get the 'LocationCode' attribute value. "LocationCode" is used to return the airport code associated with the particular flight segment.
                                         * 
                                         * @return value
                                         */
                                        public String getLocationCode() {
                                            return locationCode;
                                        }

                                        /** 
                                         * Set the 'LocationCode' attribute value. "LocationCode" is used to return the airport code associated with the particular flight segment.
                                         * 
                                         * @param locationCode
                                         */
                                        public void setLocationCode(
                                                String locationCode) {
                                            this.locationCode = locationCode;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidityDates" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="NotValidAfter" minOccurs="0"/>
                                     *       &lt;xs:element type="xs:string" name="NotValidBefore" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class ValidityDates implements
                                        Serializable
                                    {
                                        private String notValidAfter;
                                        private String notValidBefore;

                                        /** 
                                         * Get the 'NotValidAfter' element value. "NotValidAfter" is used to return the ending validity date associated with the particular flight segment.	"NotValidAfter" follows this format: MM:DD
                                         * 
                                         * @return value
                                         */
                                        public String getNotValidAfter() {
                                            return notValidAfter;
                                        }

                                        /** 
                                         * Set the 'NotValidAfter' element value. "NotValidAfter" is used to return the ending validity date associated with the particular flight segment.	"NotValidAfter" follows this format: MM:DD
                                         * 
                                         * @param notValidAfter
                                         */
                                        public void setNotValidAfter(
                                                String notValidAfter) {
                                            this.notValidAfter = notValidAfter;
                                        }

                                        /** 
                                         * Get the 'NotValidBefore' element value. "NotValidBefore" is used to return the beginning validity date associated with the particular flight segment. "NotValidBefore" follows this format: MM:DD
                                         * 
                                         * @return value
                                         */
                                        public String getNotValidBefore() {
                                            return notValidBefore;
                                        }

                                        /** 
                                         * Set the 'NotValidBefore' element value. "NotValidBefore" is used to return the beginning validity date associated with the particular flight segment. "NotValidBefore" follows this format: MM:DD
                                         * 
                                         * @param notValidBefore
                                         */
                                        public void setNotValidBefore(
                                                String notValidBefore) {
                                            this.notValidBefore = notValidBefore;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent" minOccurs="0" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Location" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Location -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Dates" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Dates -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="FlightSegmentNumbers" minOccurs="0">
                                 *         &lt;!-- Reference to inner class FlightSegmentNumbers -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="FareBasisCode"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="FareDirectionality"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="GoverningCarrier"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="FareComponentNumber"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CorporateId"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class FareComponent implements
                                    Serializable
                                {
                                    private Location location;
                                    private Dates dates;
                                    private FlightSegmentNumbers flightSegmentNumbers;
                                    private String fareBasisCode;
                                    private String fareDirectionality;
                                    private String amount;
                                    private String ticketDesignator;
                                    private String governingCarrier;
                                    private String fareComponentNumber;
                                    private String corporateId;

                                    /** 
                                     * Get the 'Location' element value.
                                     * 
                                     * @return value
                                     */
                                    public Location getLocation() {
                                        return location;
                                    }

                                    /** 
                                     * Set the 'Location' element value.
                                     * 
                                     * @param location
                                     */
                                    public void setLocation(Location location) {
                                        this.location = location;
                                    }

                                    /** 
                                     * Get the 'Dates' element value.
                                     * 
                                     * @return value
                                     */
                                    public Dates getDates() {
                                        return dates;
                                    }

                                    /** 
                                     * Set the 'Dates' element value.
                                     * 
                                     * @param dates
                                     */
                                    public void setDates(Dates dates) {
                                        this.dates = dates;
                                    }

                                    /** 
                                     * Get the 'FlightSegmentNumbers' element value.
                                     * 
                                     * @return value
                                     */
                                    public FlightSegmentNumbers getFlightSegmentNumbers() {
                                        return flightSegmentNumbers;
                                    }

                                    /** 
                                     * Set the 'FlightSegmentNumbers' element value.
                                     * 
                                     * @param flightSegmentNumbers
                                     */
                                    public void setFlightSegmentNumbers(
                                            FlightSegmentNumbers flightSegmentNumbers) {
                                        this.flightSegmentNumbers = flightSegmentNumbers;
                                    }

                                    /** 
                                     * Get the 'FareBasisCode' attribute value. 
                                    																									"FareBasisCode" is used to return Fare Basis Code for particular Fare Component.
                                    																								
                                     * 
                                     * @return value
                                     */
                                    public String getFareBasisCode() {
                                        return fareBasisCode;
                                    }

                                    /** 
                                     * Set the 'FareBasisCode' attribute value. 
                                    																									"FareBasisCode" is used to return Fare Basis Code for particular Fare Component.
                                    																								
                                     * 
                                     * @param fareBasisCode
                                     */
                                    public void setFareBasisCode(
                                            String fareBasisCode) {
                                        this.fareBasisCode = fareBasisCode;
                                    }

                                    /** 
                                     * Get the 'FareDirectionality' attribute value. 
                                    																									"FareDirectionality" is used to return directionality of the fare ("FROM" or "TO").
                                    																								
                                     * 
                                     * @return value
                                     */
                                    public String getFareDirectionality() {
                                        return fareDirectionality;
                                    }

                                    /** 
                                     * Set the 'FareDirectionality' attribute value. 
                                    																									"FareDirectionality" is used to return directionality of the fare ("FROM" or "TO").
                                    																								
                                     * 
                                     * @param fareDirectionality
                                     */
                                    public void setFareDirectionality(
                                            String fareDirectionality) {
                                        this.fareDirectionality = fareDirectionality;
                                    }

                                    /** 
                                     * Get the 'Amount' attribute value. 
                                    																									"Amount" is used to return NUC amount for particular Fare Component.
                                    																								
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. 
                                    																									"Amount" is used to return NUC amount for particular Fare Component.
                                    																								
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'TicketDesignator' attribute value. 
                                    																									"TicketDesignator" is used to return Ticket Designator Code attached to Fare Basis Code.
                                    																								
                                     * 
                                     * @return value
                                     */
                                    public String getTicketDesignator() {
                                        return ticketDesignator;
                                    }

                                    /** 
                                     * Set the 'TicketDesignator' attribute value. 
                                    																									"TicketDesignator" is used to return Ticket Designator Code attached to Fare Basis Code.
                                    																								
                                     * 
                                     * @param ticketDesignator
                                     */
                                    public void setTicketDesignator(
                                            String ticketDesignator) {
                                        this.ticketDesignator = ticketDesignator;
                                    }

                                    /** 
                                     * Get the 'GoverningCarrier' attribute value. 
                                    																									"GoverningCarrier" is used to return Governing Carrier Code e.g. EY, AA, LH.
                                    																								
                                     * 
                                     * @return value
                                     */
                                    public String getGoverningCarrier() {
                                        return governingCarrier;
                                    }

                                    /** 
                                     * Set the 'GoverningCarrier' attribute value. 
                                    																									"GoverningCarrier" is used to return Governing Carrier Code e.g. EY, AA, LH.
                                    																								
                                     * 
                                     * @param governingCarrier
                                     */
                                    public void setGoverningCarrier(
                                            String governingCarrier) {
                                        this.governingCarrier = governingCarrier;
                                    }

                                    /** 
                                     * Get the 'FareComponentNumber' attribute value. 
                                    																									"FareComponentNumber" is used to display number of fare component stored in PQ.
                                    																								
                                     * 
                                     * @return value
                                     */
                                    public String getFareComponentNumber() {
                                        return fareComponentNumber;
                                    }

                                    /** 
                                     * Set the 'FareComponentNumber' attribute value. 
                                    																									"FareComponentNumber" is used to display number of fare component stored in PQ.
                                    																								
                                     * 
                                     * @param fareComponentNumber
                                     */
                                    public void setFareComponentNumber(
                                            String fareComponentNumber) {
                                        this.fareComponentNumber = fareComponentNumber;
                                    }

                                    /** 
                                     * Get the 'CorporateId' attribute value. "CorporateId" returns the Corporate Id
                                     * 
                                     * @return value
                                     */
                                    public String getCorporateId() {
                                        return corporateId;
                                    }

                                    /** 
                                     * Set the 'CorporateId' attribute value. "CorporateId" returns the Corporate Id
                                     * 
                                     * @param corporateId
                                     */
                                    public void setCorporateId(
                                            String corporateId) {
                                        this.corporateId = corporateId;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Origin"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Destination"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Location implements
                                        Serializable
                                    {
                                        private String origin;
                                        private String destination;

                                        /** 
                                         * Get the 'Origin' attribute value. 
                                        																												"Origin" is used to return first city of particular Fare Component.
                                        																											
                                         * 
                                         * @return value
                                         */
                                        public String getOrigin() {
                                            return origin;
                                        }

                                        /** 
                                         * Set the 'Origin' attribute value. 
                                        																												"Origin" is used to return first city of particular Fare Component.
                                        																											
                                         * 
                                         * @param origin
                                         */
                                        public void setOrigin(String origin) {
                                            this.origin = origin;
                                        }

                                        /** 
                                         * Get the 'Destination' attribute value. 
                                        																												"Destination" is used to return last city of particular Fare Component.
                                        																											
                                         * 
                                         * @return value
                                         */
                                        public String getDestination() {
                                            return destination;
                                        }

                                        /** 
                                         * Set the 'Destination' attribute value. 
                                        																												"Destination" is used to return last city of particular Fare Component.
                                        																											
                                         * 
                                         * @param destination
                                         */
                                        public void setDestination(
                                                String destination) {
                                            this.destination = destination;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Dates" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Dates implements
                                        Serializable
                                    {
                                        private String departureDateTime;
                                        private String arrivalDateTime;

                                        /** 
                                         * Get the 'DepartureDateTime' attribute value. 
                                        																												"DepartureDateTime" is used to return date and time for departure from first city of Fare component.
                                        																											
                                         * 
                                         * @return value
                                         */
                                        public String getDepartureDateTime() {
                                            return departureDateTime;
                                        }

                                        /** 
                                         * Set the 'DepartureDateTime' attribute value. 
                                        																												"DepartureDateTime" is used to return date and time for departure from first city of Fare component.
                                        																											
                                         * 
                                         * @param departureDateTime
                                         */
                                        public void setDepartureDateTime(
                                                String departureDateTime) {
                                            this.departureDateTime = departureDateTime;
                                        }

                                        /** 
                                         * Get the 'ArrivalDateTime' attribute value. 
                                        																												"ArrivalDateTime" is used to return date and time for arrival to last city of Fare component.
                                        																											
                                         * 
                                         * @return value
                                         */
                                        public String getArrivalDateTime() {
                                            return arrivalDateTime;
                                        }

                                        /** 
                                         * Set the 'ArrivalDateTime' attribute value. 
                                        																												"ArrivalDateTime" is used to return date and time for arrival to last city of Fare component.
                                        																											
                                         * 
                                         * @param arrivalDateTime
                                         */
                                        public void setArrivalDateTime(
                                                String arrivalDateTime) {
                                            this.arrivalDateTime = arrivalDateTime;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentNumbers" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="FlightSegmentNumber" minOccurs="0" maxOccurs="unbounded"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class FlightSegmentNumbers
                                        implements Serializable
                                    {
                                        private List<String> flightSegmentNumberList = new ArrayList<String>();

                                        /** 
                                         * Get the list of 'FlightSegmentNumber' element items. 
                                        																													"FlightSegmentNumber" is used to display flight segments number covered by this particular fare component.
                                        																												
                                         * 
                                         * @return list
                                         */
                                        public List<String> getFlightSegmentNumberList() {
                                            return flightSegmentNumberList;
                                        }

                                        /** 
                                         * Set the list of 'FlightSegmentNumber' element items. 
                                        																													"FlightSegmentNumber" is used to display flight segments number covered by this particular fare component.
                                        																												
                                         * 
                                         * @param list
                                         */
                                        public void setFlightSegmentNumberList(
                                                List<String> list) {
                                            flightSegmentNumberList = list;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TourCode implements
                                    Serializable
                                {
                                    private String text;

                                    /** 
                                     * Get the 'Text' element value. "Text" is used to return the tour code.
                                     * 
                                     * @return value
                                     */
                                    public String getText() {
                                        return text;
                                    }

                                    /** 
                                     * Set the 'Text' element value. "Text" is used to return the tour code.
                                     * 
                                     * @param text
                                     */
                                    public void setText(String text) {
                                        this.text = text;
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetTicketingInfo" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="NetFareDetails" minOccurs="0">
                         *         &lt;!-- Reference to inner class NetFareDetails -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="SellingFareDetails" minOccurs="0">
                         *         &lt;!-- Reference to inner class SellingFareDetails -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="AccountCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CorporateId"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class NetTicketingInfo implements
                            Serializable
                        {
                            private NetFareDetails netFareDetails;
                            private SellingFareDetails sellingFareDetails;
                            private String accountCode;
                            private String corporateId;

                            /** 
                             * Get the 'NetFareDetails' element value.
                             * 
                             * @return value
                             */
                            public NetFareDetails getNetFareDetails() {
                                return netFareDetails;
                            }

                            /** 
                             * Set the 'NetFareDetails' element value.
                             * 
                             * @param netFareDetails
                             */
                            public void setNetFareDetails(
                                    NetFareDetails netFareDetails) {
                                this.netFareDetails = netFareDetails;
                            }

                            /** 
                             * Get the 'SellingFareDetails' element value.
                             * 
                             * @return value
                             */
                            public SellingFareDetails getSellingFareDetails() {
                                return sellingFareDetails;
                            }

                            /** 
                             * Set the 'SellingFareDetails' element value.
                             * 
                             * @param sellingFareDetails
                             */
                            public void setSellingFareDetails(
                                    SellingFareDetails sellingFareDetails) {
                                this.sellingFareDetails = sellingFareDetails;
                            }

                            /** 
                             * Get the 'AccountCode' attribute value. "AccountCode" returns the account code
                             * 
                             * @return value
                             */
                            public String getAccountCode() {
                                return accountCode;
                            }

                            /** 
                             * Set the 'AccountCode' attribute value. "AccountCode" returns the account code
                             * 
                             * @param accountCode
                             */
                            public void setAccountCode(String accountCode) {
                                this.accountCode = accountCode;
                            }

                            /** 
                             * Get the 'CorporateId' attribute value. "CorporateId" returns the Corporate Id
                             * 
                             * @return value
                             */
                            public String getCorporateId() {
                                return corporateId;
                            }

                            /** 
                             * Set the 'CorporateId' attribute value. "CorporateId" returns the Corporate Id
                             * 
                             * @param corporateId
                             */
                            public void setCorporateId(String corporateId) {
                                this.corporateId = corporateId;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFareDetails" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="BaseFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class BaseFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="EquivFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class EquivFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalTax" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalTax -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Commission" minOccurs="0">
                             *         &lt;!-- Reference to inner class Commission -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element type="xs:string" name="FareCalc" minOccurs="0"/>
                             *       &lt;xs:element name="Taxes" minOccurs="0">
                             *         &lt;!-- Reference to inner class Taxes -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class NetFareDetails implements
                                Serializable
                            {
                                private BaseFare baseFare;
                                private EquivFare equivFare;
                                private TotalTax totalTax;
                                private TotalFare totalFare;
                                private Commission commission;
                                private String fareCalc;
                                private Taxes taxes;

                                /** 
                                 * Get the 'BaseFare' element value.
                                 * 
                                 * @return value
                                 */
                                public BaseFare getBaseFare() {
                                    return baseFare;
                                }

                                /** 
                                 * Set the 'BaseFare' element value.
                                 * 
                                 * @param baseFare
                                 */
                                public void setBaseFare(BaseFare baseFare) {
                                    this.baseFare = baseFare;
                                }

                                /** 
                                 * Get the 'EquivFare' element value.
                                 * 
                                 * @return value
                                 */
                                public EquivFare getEquivFare() {
                                    return equivFare;
                                }

                                /** 
                                 * Set the 'EquivFare' element value.
                                 * 
                                 * @param equivFare
                                 */
                                public void setEquivFare(EquivFare equivFare) {
                                    this.equivFare = equivFare;
                                }

                                /** 
                                 * Get the 'TotalTax' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalTax getTotalTax() {
                                    return totalTax;
                                }

                                /** 
                                 * Set the 'TotalTax' element value.
                                 * 
                                 * @param totalTax
                                 */
                                public void setTotalTax(TotalTax totalTax) {
                                    this.totalTax = totalTax;
                                }

                                /** 
                                 * Get the 'TotalFare' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalFare getTotalFare() {
                                    return totalFare;
                                }

                                /** 
                                 * Set the 'TotalFare' element value.
                                 * 
                                 * @param totalFare
                                 */
                                public void setTotalFare(TotalFare totalFare) {
                                    this.totalFare = totalFare;
                                }

                                /** 
                                 * Get the 'Commission' element value.
                                 * 
                                 * @return value
                                 */
                                public Commission getCommission() {
                                    return commission;
                                }

                                /** 
                                 * Set the 'Commission' element value.
                                 * 
                                 * @param commission
                                 */
                                public void setCommission(Commission commission) {
                                    this.commission = commission;
                                }

                                /** 
                                 * Get the 'FareCalc' element value. "FareCalc" returns the fare calculation line .
                                 * 
                                 * @return value
                                 */
                                public String getFareCalc() {
                                    return fareCalc;
                                }

                                /** 
                                 * Set the 'FareCalc' element value. "FareCalc" returns the fare calculation line .
                                 * 
                                 * @param fareCalc
                                 */
                                public void setFareCalc(String fareCalc) {
                                    this.fareCalc = fareCalc;
                                }

                                /** 
                                 * Get the 'Taxes' element value.
                                 * 
                                 * @return value
                                 */
                                public Taxes getTaxes() {
                                    return taxes;
                                }

                                /** 
                                 * Set the 'Taxes' element value.
                                 * 
                                 * @param taxes
                                 */
                                public void setTaxes(Taxes taxes) {
                                    this.taxes = taxes;
                                }
                                /** 
                                 * "BaseFare" is used to return the Base fare details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class BaseFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "EquivFare" is used to reflect the Equivalent fare details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class EquivFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "TotalTax" is used to return the total tax details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalTax implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "TotalFare" is used to return the total fare details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "Commission" is used to return commission-related information.
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Percent" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Percent -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Commission implements
                                    Serializable
                                {
                                    private Percent percent;
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Percent' element value.
                                     * 
                                     * @return value
                                     */
                                    public Percent getPercent() {
                                        return percent;
                                    }

                                    /** 
                                     * Set the 'Percent' element value.
                                     * 
                                     * @param percent
                                     */
                                    public void setPercent(Percent percent) {
                                        this.percent = percent;
                                    }

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                    /** 
                                     * "Percent" is used to return the commission type and the associated percentage.
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Percent" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Percent implements
                                        Serializable
                                    {
                                        private String string;
                                        private String type;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'Type' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getType() {
                                            return type;
                                        }

                                        /** 
                                         * Set the 'Type' attribute value.
                                         * 
                                         * @param type
                                         */
                                        public void setType(String type) {
                                            this.type = type;
                                        }
                                    }
                                }
                                /** 
                                 * "Taxes" is used to reflect the total tax details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                                 *         &lt;!-- Reference to inner class Tax -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Taxes implements
                                    Serializable
                                {
                                    private List<Tax> taxList = new ArrayList<Tax>();

                                    /** 
                                     * Get the list of 'Tax' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<Tax> getTaxList() {
                                        return taxList;
                                    }

                                    /** 
                                     * Set the list of 'Tax' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setTaxList(List<Tax> list) {
                                        taxList = list;
                                    }
                                    /** 
                                     * "Tax" returns the individual Tax details
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exempt"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Tax implements
                                        Serializable
                                    {
                                        private String amount;
                                        private String taxCode;
                                        private Boolean exempt;

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'TaxCode' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getTaxCode() {
                                            return taxCode;
                                        }

                                        /** 
                                         * Set the 'TaxCode' attribute value.
                                         * 
                                         * @param taxCode
                                         */
                                        public void setTaxCode(String taxCode) {
                                            this.taxCode = taxCode;
                                        }

                                        /** 
                                         * Get the 'Exempt' attribute value. "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt
                                         * 
                                         * @return value
                                         */
                                        public Boolean getExempt() {
                                            return exempt;
                                        }

                                        /** 
                                         * Set the 'Exempt' attribute value. "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt
                                         * 
                                         * @param exempt
                                         */
                                        public void setExempt(Boolean exempt) {
                                            this.exempt = exempt;
                                        }
                                    }
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareDetails" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="BaseFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class BaseFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="EquivFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class EquivFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalTax" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalTax -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="TotalFare" minOccurs="0">
                             *         &lt;!-- Reference to inner class TotalFare -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Commission" minOccurs="0">
                             *         &lt;!-- Reference to inner class Commission -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element type="xs:string" name="FareCalc" minOccurs="0"/>
                             *       &lt;xs:element name="Taxes" minOccurs="0">
                             *         &lt;!-- Reference to inner class Taxes -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class SellingFareDetails implements
                                Serializable
                            {
                                private BaseFare baseFare;
                                private EquivFare equivFare;
                                private TotalTax totalTax;
                                private TotalFare totalFare;
                                private Commission commission;
                                private String fareCalc;
                                private Taxes taxes;

                                /** 
                                 * Get the 'BaseFare' element value.
                                 * 
                                 * @return value
                                 */
                                public BaseFare getBaseFare() {
                                    return baseFare;
                                }

                                /** 
                                 * Set the 'BaseFare' element value.
                                 * 
                                 * @param baseFare
                                 */
                                public void setBaseFare(BaseFare baseFare) {
                                    this.baseFare = baseFare;
                                }

                                /** 
                                 * Get the 'EquivFare' element value.
                                 * 
                                 * @return value
                                 */
                                public EquivFare getEquivFare() {
                                    return equivFare;
                                }

                                /** 
                                 * Set the 'EquivFare' element value.
                                 * 
                                 * @param equivFare
                                 */
                                public void setEquivFare(EquivFare equivFare) {
                                    this.equivFare = equivFare;
                                }

                                /** 
                                 * Get the 'TotalTax' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalTax getTotalTax() {
                                    return totalTax;
                                }

                                /** 
                                 * Set the 'TotalTax' element value.
                                 * 
                                 * @param totalTax
                                 */
                                public void setTotalTax(TotalTax totalTax) {
                                    this.totalTax = totalTax;
                                }

                                /** 
                                 * Get the 'TotalFare' element value.
                                 * 
                                 * @return value
                                 */
                                public TotalFare getTotalFare() {
                                    return totalFare;
                                }

                                /** 
                                 * Set the 'TotalFare' element value.
                                 * 
                                 * @param totalFare
                                 */
                                public void setTotalFare(TotalFare totalFare) {
                                    this.totalFare = totalFare;
                                }

                                /** 
                                 * Get the 'Commission' element value.
                                 * 
                                 * @return value
                                 */
                                public Commission getCommission() {
                                    return commission;
                                }

                                /** 
                                 * Set the 'Commission' element value.
                                 * 
                                 * @param commission
                                 */
                                public void setCommission(Commission commission) {
                                    this.commission = commission;
                                }

                                /** 
                                 * Get the 'FareCalc' element value. "FareCalc" returns the fare calculation line .
                                 * 
                                 * @return value
                                 */
                                public String getFareCalc() {
                                    return fareCalc;
                                }

                                /** 
                                 * Set the 'FareCalc' element value. "FareCalc" returns the fare calculation line .
                                 * 
                                 * @param fareCalc
                                 */
                                public void setFareCalc(String fareCalc) {
                                    this.fareCalc = fareCalc;
                                }

                                /** 
                                 * Get the 'Taxes' element value.
                                 * 
                                 * @return value
                                 */
                                public Taxes getTaxes() {
                                    return taxes;
                                }

                                /** 
                                 * Set the 'Taxes' element value.
                                 * 
                                 * @param taxes
                                 */
                                public void setTaxes(Taxes taxes) {
                                    this.taxes = taxes;
                                }
                                /** 
                                 * "BaseFare" is used to return the Base fare details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class BaseFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "EquivFare" is used to reflect the Equivalent fare details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class EquivFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value. "Amount" is used to return the applicable amount
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value. "Amount" is used to return the applicable amount
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the applicable currency code
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "TotalTax" is used to return the total tax details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalTax implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class TotalFare implements
                                    Serializable
                                {
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                }
                                /** 
                                 * "Commission" is used to return commission-related information.
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Percent" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Percent -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Commission implements
                                    Serializable
                                {
                                    private Percent percent;
                                    private String amount;
                                    private String currencyCode;

                                    /** 
                                     * Get the 'Percent' element value.
                                     * 
                                     * @return value
                                     */
                                    public Percent getPercent() {
                                        return percent;
                                    }

                                    /** 
                                     * Set the 'Percent' element value.
                                     * 
                                     * @param percent
                                     */
                                    public void setPercent(Percent percent) {
                                        this.percent = percent;
                                    }

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }
                                    /** 
                                     * "Percent" is used to return the commission type and the associated percentage.
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Percent" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Percent implements
                                        Serializable
                                    {
                                        private String string;
                                        private String type;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'Type' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getType() {
                                            return type;
                                        }

                                        /** 
                                         * Set the 'Type' attribute value.
                                         * 
                                         * @param type
                                         */
                                        public void setType(String type) {
                                            this.type = type;
                                        }
                                    }
                                }
                                /** 
                                 * "Taxes" is used to reflect the total tax details
                                 * 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                                 *         &lt;!-- Reference to inner class Tax -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Taxes implements
                                    Serializable
                                {
                                    private List<Tax> taxList = new ArrayList<Tax>();

                                    /** 
                                     * Get the list of 'Tax' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<Tax> getTaxList() {
                                        return taxList;
                                    }

                                    /** 
                                     * Set the list of 'Tax' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setTaxList(List<Tax> list) {
                                        taxList = list;
                                    }
                                    /** 
                                     * "Tax' returns the individual Tax details
                                     * 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exempt"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Tax implements
                                        Serializable
                                    {
                                        private String amount;
                                        private String taxCode;
                                        private Boolean exempt;

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'TaxCode' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getTaxCode() {
                                            return taxCode;
                                        }

                                        /** 
                                         * Set the 'TaxCode' attribute value.
                                         * 
                                         * @param taxCode
                                         */
                                        public void setTaxCode(String taxCode) {
                                            this.taxCode = taxCode;
                                        }

                                        /** 
                                         * Get the 'Exempt' attribute value. "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt
                                         * 
                                         * @return value
                                         */
                                        public Boolean getExempt() {
                                            return exempt;
                                        }

                                        /** 
                                         * Set the 'Exempt' attribute value. "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt
                                         * 
                                         * @param exempt
                                         */
                                        public void setExempt(Boolean exempt) {
                                            this.exempt = exempt;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseHeader" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ResponseHeader implements Serializable
                    {
                        private List<String> textList = new ArrayList<String>();

                        /** 
                         * Get the list of 'Text' element items. "Text" is used to return response header-related information.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. "Text" is used to return response header-related information.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuotePlus" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Header" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="PassengerInfo" minOccurs="0" maxOccurs="1">
                     *         &lt;!-- Reference to inner class PassengerInfo -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="TicketingInstructionsInfo" minOccurs="0" maxOccurs="1">
                     *         &lt;!-- Reference to inner class TicketingInstructionsInfo -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FuturePricingInfo" minOccurs="0" maxOccurs="1">
                     *         &lt;!-- Reference to inner class FuturePricingInfo -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PACInfo" minOccurs="0" maxOccurs="1">
                     *         &lt;!-- Reference to inner class PACInfo -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" name="DomesticIntlInd"/>
                     *     &lt;xs:attribute type="xs:string" name="PricingStatus"/>
                     *     &lt;xs:attribute type="xs:boolean" name="VerifyFareCalc"/>
                     *     &lt;xs:attribute type="xs:boolean" name="ItineraryChanged"/>
                     *     &lt;xs:attribute type="xs:boolean" name="ManualFare"/>
                     *     &lt;xs:attribute type="xs:boolean" name="NegotiatedFare"/>
                     *     &lt;xs:attribute type="xs:string" name="SystemIndicator"/>
                     *     &lt;xs:attribute type="xs:boolean" name="NUCSuppresion"/>
                     *     &lt;xs:attribute type="xs:boolean" name="SubjToGovtApproval"/>
                     *     &lt;xs:attribute type="xs:string" name="IT_BT_Fare"/>
                     *     &lt;xs:attribute type="xs:boolean" name="DisplayOnly"/>
                     *     &lt;xs:attribute type="xs:string" name="TourCode"/>
                     *     &lt;xs:attribute type="xs:string" name="DiscountAmount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PriceQuotePlus implements Serializable
                    {
                        private List<String> headerList = new ArrayList<String>();
                        private PassengerInfo passengerInfo;
                        private TicketingInstructionsInfo ticketingInstructionsInfo;
                        private FuturePricingInfo futurePricingInfo;
                        private PACInfo PACInfo1;
                        private String domesticIntlInd;
                        private String pricingStatus;
                        private Boolean verifyFareCalc;
                        private Boolean itineraryChanged;
                        private Boolean manualFare;
                        private Boolean negotiatedFare;
                        private String systemIndicator;
                        private Boolean NUCSuppresion;
                        private Boolean subjToGovtApproval;
                        private String ITBTFare;
                        private Boolean displayOnly;
                        private String tourCode;
                        private String discountAmount;

                        /** 
                         * Get the list of 'Header' element items. When the value in the element is PQPLUS RESTRICTED, indicates the wholesaler does not have access to price quote the PNR
                         * 
                         * @return list
                         */
                        public List<String> getHeaderList() {
                            return headerList;
                        }

                        /** 
                         * Set the list of 'Header' element items. When the value in the element is PQPLUS RESTRICTED, indicates the wholesaler does not have access to price quote the PNR
                         * 
                         * @param list
                         */
                        public void setHeaderList(List<String> list) {
                            headerList = list;
                        }

                        /** 
                         * Get the 'PassengerInfo' element value.
                         * 
                         * @return value
                         */
                        public PassengerInfo getPassengerInfo() {
                            return passengerInfo;
                        }

                        /** 
                         * Set the 'PassengerInfo' element value.
                         * 
                         * @param passengerInfo
                         */
                        public void setPassengerInfo(PassengerInfo passengerInfo) {
                            this.passengerInfo = passengerInfo;
                        }

                        /** 
                         * Get the 'TicketingInstructionsInfo' element value.
                         * 
                         * @return value
                         */
                        public TicketingInstructionsInfo getTicketingInstructionsInfo() {
                            return ticketingInstructionsInfo;
                        }

                        /** 
                         * Set the 'TicketingInstructionsInfo' element value.
                         * 
                         * @param ticketingInstructionsInfo
                         */
                        public void setTicketingInstructionsInfo(
                                TicketingInstructionsInfo ticketingInstructionsInfo) {
                            this.ticketingInstructionsInfo = ticketingInstructionsInfo;
                        }

                        /** 
                         * Get the 'FuturePricingInfo' element value.
                         * 
                         * @return value
                         */
                        public FuturePricingInfo getFuturePricingInfo() {
                            return futurePricingInfo;
                        }

                        /** 
                         * Set the 'FuturePricingInfo' element value.
                         * 
                         * @param futurePricingInfo
                         */
                        public void setFuturePricingInfo(
                                FuturePricingInfo futurePricingInfo) {
                            this.futurePricingInfo = futurePricingInfo;
                        }

                        /** 
                         * Get the 'PACInfo' element value.
                         * 
                         * @return value
                         */
                        public PACInfo getPACInfo1() {
                            return PACInfo1;
                        }

                        /** 
                         * Set the 'PACInfo' element value.
                         * 
                         * @param PACInfo1
                         */
                        public void setPACInfo1(PACInfo PACInfo1) {
                            this.PACInfo1 = PACInfo1;
                        }

                        /** 
                         * Get the 'DomesticIntlInd' attribute value. DomesticIntlInd is used to indicate if Itinerary is domestic or international.
                         * 
                         * @return value
                         */
                        public String getDomesticIntlInd() {
                            return domesticIntlInd;
                        }

                        /** 
                         * Set the 'DomesticIntlInd' attribute value. DomesticIntlInd is used to indicate if Itinerary is domestic or international.
                         * 
                         * @param domesticIntlInd
                         */
                        public void setDomesticIntlInd(String domesticIntlInd) {
                            this.domesticIntlInd = domesticIntlInd;
                        }

                        /** 
                         * Get the 'PricingStatus' attribute value. PricingStatus is used to indicate status of the fare stored in the PQ. The values can be different depending on invoking GDS (Sabre, Abacus, Infini).
                         * 
                         * @return value
                         */
                        public String getPricingStatus() {
                            return pricingStatus;
                        }

                        /** 
                         * Set the 'PricingStatus' attribute value. PricingStatus is used to indicate status of the fare stored in the PQ. The values can be different depending on invoking GDS (Sabre, Abacus, Infini).
                         * 
                         * @param pricingStatus
                         */
                        public void setPricingStatus(String pricingStatus) {
                            this.pricingStatus = pricingStatus;
                        }

                        /** 
                         * Get the 'VerifyFareCalc' attribute value. VerifyFareCalc is used to denote if Fare Calc requires any update/verification.
                         * 
                         * @return value
                         */
                        public Boolean getVerifyFareCalc() {
                            return verifyFareCalc;
                        }

                        /** 
                         * Set the 'VerifyFareCalc' attribute value. VerifyFareCalc is used to denote if Fare Calc requires any update/verification.
                         * 
                         * @param verifyFareCalc
                         */
                        public void setVerifyFareCalc(Boolean verifyFareCalc) {
                            this.verifyFareCalc = verifyFareCalc;
                        }

                        /** 
                         * Get the 'ItineraryChanged' attribute value. ItineraryChanged is used to indicate if original Itinerary has changed.
                         * 
                         * @return value
                         */
                        public Boolean getItineraryChanged() {
                            return itineraryChanged;
                        }

                        /** 
                         * Set the 'ItineraryChanged' attribute value. ItineraryChanged is used to indicate if original Itinerary has changed.
                         * 
                         * @param itineraryChanged
                         */
                        public void setItineraryChanged(Boolean itineraryChanged) {
                            this.itineraryChanged = itineraryChanged;
                        }

                        /** 
                         * Get the 'ManualFare' attribute value. ManualFare is set when the PQ is created manually or when a fare is stored in the PQ as a manual fare.
                         * 
                         * @return value
                         */
                        public Boolean getManualFare() {
                            return manualFare;
                        }

                        /** 
                         * Set the 'ManualFare' attribute value. ManualFare is set when the PQ is created manually or when a fare is stored in the PQ as a manual fare.
                         * 
                         * @param manualFare
                         */
                        public void setManualFare(Boolean manualFare) {
                            this.manualFare = manualFare;
                        }

                        /** 
                         * Get the 'NegotiatedFare' attribute value. NegotiatedFare is an indicator Pricing sends for certain types of fares to denote that the fare is not a published fare but is negotiated between the Carrier and the Agency.
                         * 
                         * @return value
                         */
                        public Boolean getNegotiatedFare() {
                            return negotiatedFare;
                        }

                        /** 
                         * Set the 'NegotiatedFare' attribute value. NegotiatedFare is an indicator Pricing sends for certain types of fares to denote that the fare is not a published fare but is negotiated between the Carrier and the Agency.
                         * 
                         * @param negotiatedFare
                         */
                        public void setNegotiatedFare(Boolean negotiatedFare) {
                            this.negotiatedFare = negotiatedFare;
                        }

                        /** 
                         * Get the 'SystemIndicator' attribute value. SystemIndicator can have following values S(System), M(Manual) or A(Amended).
                         * 
                         * @return value
                         */
                        public String getSystemIndicator() {
                            return systemIndicator;
                        }

                        /** 
                         * Set the 'SystemIndicator' attribute value. SystemIndicator can have following values S(System), M(Manual) or A(Amended).
                         * 
                         * @param systemIndicator
                         */
                        public void setSystemIndicator(String systemIndicator) {
                            this.systemIndicator = systemIndicator;
                        }

                        /** 
                         * Get the 'NUCSuppresion' attribute value. NUCSuppresion is an indicator that INFINI uses to cause the amounts in the fare calculation to be overlaid with "IT" at time of ticket issuance.
                         * 
                         * @return value
                         */
                        public Boolean getNUCSuppresion() {
                            return NUCSuppresion;
                        }

                        /** 
                         * Set the 'NUCSuppresion' attribute value. NUCSuppresion is an indicator that INFINI uses to cause the amounts in the fare calculation to be overlaid with "IT" at time of ticket issuance.
                         * 
                         * @param NUCSuppresion
                         */
                        public void setNUCSuppresion(Boolean NUCSuppresion) {
                            this.NUCSuppresion = NUCSuppresion;
                        }

                        /** 
                         * Get the 'SubjToGovtApproval' attribute value. SubjToGovtApproval is and indicator that INFINI uses to denote that the fare is subject to Government approval.
                         * 
                         * @return value
                         */
                        public Boolean getSubjToGovtApproval() {
                            return subjToGovtApproval;
                        }

                        /** 
                         * Set the 'SubjToGovtApproval' attribute value. SubjToGovtApproval is and indicator that INFINI uses to denote that the fare is subject to Government approval.
                         * 
                         * @param subjToGovtApproval
                         */
                        public void setSubjToGovtApproval(
                                Boolean subjToGovtApproval) {
                            this.subjToGovtApproval = subjToGovtApproval;
                        }

                        /** 
                         * Get the 'IT_BT_Fare' attribute value. IT_BT_Fare is used to indicate if the amount in the Fare box and Total box on the ticket should be overlaid with Bulk Ticket or Inclusive Tour Fare.
                         * 
                         * @return value
                         */
                        public String getITBTFare() {
                            return ITBTFare;
                        }

                        /** 
                         * Set the 'IT_BT_Fare' attribute value. IT_BT_Fare is used to indicate if the amount in the Fare box and Total box on the ticket should be overlaid with Bulk Ticket or Inclusive Tour Fare.
                         * 
                         * @param ITBTFare
                         */
                        public void setITBTFare(String ITBTFare) {
                            this.ITBTFare = ITBTFare;
                        }

                        /** 
                         * Get the 'DisplayOnly' attribute value. DisplayOnly is used to denote that stored fare cannot be ticketed for some reason.
                         * 
                         * @return value
                         */
                        public Boolean getDisplayOnly() {
                            return displayOnly;
                        }

                        /** 
                         * Set the 'DisplayOnly' attribute value. DisplayOnly is used to denote that stored fare cannot be ticketed for some reason.
                         * 
                         * @param displayOnly
                         */
                        public void setDisplayOnly(Boolean displayOnly) {
                            this.displayOnly = displayOnly;
                        }

                        /** 
                         * Get the 'TourCode' attribute value. TourCode is a code that the airline may require to be present on a ticket for a particular fare.
                         * 
                         * @return value
                         */
                        public String getTourCode() {
                            return tourCode;
                        }

                        /** 
                         * Set the 'TourCode' attribute value. TourCode is a code that the airline may require to be present on a ticket for a particular fare.
                         * 
                         * @param tourCode
                         */
                        public void setTourCode(String tourCode) {
                            this.tourCode = tourCode;
                        }

                        /** 
                         * Get the 'DiscountAmount' attribute value. DiscountAmount is used by Abacus to indicate amount of used discount on a negotiated fare ticket.
                         * 
                         * @return value
                         */
                        public String getDiscountAmount() {
                            return discountAmount;
                        }

                        /** 
                         * Set the 'DiscountAmount' attribute value. DiscountAmount is used by Abacus to indicate amount of used discount on a negotiated fare ticket.
                         * 
                         * @param discountAmount
                         */
                        public void setDiscountAmount(String discountAmount) {
                            this.discountAmount = discountAmount;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerInfo" minOccurs="0" maxOccurs="1">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PassengerData" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class PassengerData -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PassengerType"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PassengerInfo implements
                            Serializable
                        {
                            private List<PassengerData> passengerDataList = new ArrayList<PassengerData>();
                            private String passengerType;

                            /** 
                             * Get the list of 'PassengerData' element items.
                             * 
                             * @return list
                             */
                            public List<PassengerData> getPassengerDataList() {
                                return passengerDataList;
                            }

                            /** 
                             * Set the list of 'PassengerData' element items.
                             * 
                             * @param list
                             */
                            public void setPassengerDataList(
                                    List<PassengerData> list) {
                                passengerDataList = list;
                            }

                            /** 
                             * Get the 'PassengerType' attribute value. 
                            																				"PassengerType" is used to return PAX type for particular fare component.
                            																			
                             * 
                             * @return value
                             */
                            public String getPassengerType() {
                                return passengerType;
                            }

                            /** 
                             * Set the 'PassengerType' attribute value. 
                            																				"PassengerType" is used to return PAX type for particular fare component.
                            																			
                             * 
                             * @param passengerType
                             */
                            public void setPassengerType(String passengerType) {
                                this.passengerType = passengerType;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerData" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:simpleContent>
                             *       &lt;xs:extension base="xs:string">
                             *         &lt;xs:attribute type="xs:string" name="NameNumber"/>
                             *       &lt;/xs:extension>
                             *     &lt;/xs:simpleContent>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PassengerData implements
                                Serializable
                            {
                                private String string;
                                private String nameNumber;

                                /** 
                                 * Get the extension value.
                                 * 
                                 * @return value
                                 */
                                public String getString() {
                                    return string;
                                }

                                /** 
                                 * Set the extension value.
                                 * 
                                 * @param string
                                 */
                                public void setString(String string) {
                                    this.string = string;
                                }

                                /** 
                                 * Get the 'NameNumber' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getNameNumber() {
                                    return nameNumber;
                                }

                                /** 
                                 * Set the 'NameNumber' attribute value.
                                 * 
                                 * @param nameNumber
                                 */
                                public void setNameNumber(String nameNumber) {
                                    this.nameNumber = nameNumber;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInstructionsInfo" minOccurs="0" maxOccurs="1">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="TicketingInstruction" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class TicketingInstruction -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TicketingInstructionsInfo implements
                            Serializable
                        {
                            private List<TicketingInstruction> ticketingInstructionList = new ArrayList<TicketingInstruction>();

                            /** 
                             * Get the list of 'TicketingInstruction' element items.
                             * 
                             * @return list
                             */
                            public List<TicketingInstruction> getTicketingInstructionList() {
                                return ticketingInstructionList;
                            }

                            /** 
                             * Set the list of 'TicketingInstruction' element items.
                             * 
                             * @param list
                             */
                            public void setTicketingInstructionList(
                                    List<TicketingInstruction> list) {
                                ticketingInstructionList = list;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInstruction" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" name="Text"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class TicketingInstruction implements
                                Serializable
                            {
                                private String text;
                                private String id;

                                /** 
                                 * Get the 'Text' attribute value. "Text" is used to pass back miscellaneous remark-related free text
                                 * 
                                 * @return value
                                 */
                                public String getText() {
                                    return text;
                                }

                                /** 
                                 * Set the 'Text' attribute value. "Text" is used to pass back miscellaneous remark-related free text
                                 * 
                                 * @param text
                                 */
                                public void setText(String text) {
                                    this.text = text;
                                }

                                /** 
                                 * Get the 'Id' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getId() {
                                    return id;
                                }

                                /** 
                                 * Set the 'Id' attribute value.
                                 * 
                                 * @param id
                                 */
                                public void setId(String id) {
                                    this.id = id;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FuturePricingInfo" minOccurs="0" maxOccurs="1">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="FuturePrice" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class FuturePrice -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FuturePricingInfo implements
                            Serializable
                        {
                            private List<FuturePrice> futurePriceList = new ArrayList<FuturePrice>();

                            /** 
                             * Get the list of 'FuturePrice' element items.
                             * 
                             * @return list
                             */
                            public List<FuturePrice> getFuturePriceList() {
                                return futurePriceList;
                            }

                            /** 
                             * Set the list of 'FuturePrice' element items.
                             * 
                             * @param list
                             */
                            public void setFuturePriceList(
                                    List<FuturePrice> list) {
                                futurePriceList = list;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FuturePrice" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" name="Text"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class FuturePrice implements
                                Serializable
                            {
                                private String text;

                                /** 
                                 * Get the 'Text' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getText() {
                                    return text;
                                }

                                /** 
                                 * Set the 'Text' attribute value.
                                 * 
                                 * @param text
                                 */
                                public void setText(String text) {
                                    this.text = text;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PACInfo" minOccurs="0" maxOccurs="1">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="PAC" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class PAC -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PACInfo implements Serializable
                        {
                            private List<PAC> PACList = new ArrayList<PAC>();

                            /** 
                             * Get the list of 'PAC' element items.
                             * 
                             * @return list
                             */
                            public List<PAC> getPACList() {
                                return PACList;
                            }

                            /** 
                             * Set the list of 'PAC' element items.
                             * 
                             * @param list
                             */
                            public void setPACList(List<PAC> list) {
                                PACList = list;
                            }
                            /** 
                             * "PAC" is used to reflect Passenger Account Code Banner.
                             * 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PAC" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" name="Text"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PAC implements Serializable
                            {
                                private String text;
                                private String id;

                                /** 
                                 * Get the 'Text' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getText() {
                                    return text;
                                }

                                /** 
                                 * Set the 'Text' attribute value.
                                 * 
                                 * @param text
                                 */
                                public void setText(String text) {
                                    this.text = text;
                                }

                                /** 
                                 * Get the 'Id' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getId() {
                                    return id;
                                }

                                /** 
                                 * Set the 'Id' attribute value.
                                 * 
                                 * @param id
                                 */
                                public void setId(String id) {
                                    this.id = id;
                                }
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteTotals" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PriceQuoteTotals implements Serializable
                {
                    private BaseFare baseFare;
                    private EquivFare equivFare;
                    private Taxes taxes;
                    private TotalFare totalFare;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'EquivFare' element value.
                     * 
                     * @return value
                     */
                    public EquivFare getEquivFare() {
                        return equivFare;
                    }

                    /** 
                     * Set the 'EquivFare' element value.
                     * 
                     * @param equivFare
                     */
                    public void setEquivFare(EquivFare equivFare) {
                        this.equivFare = equivFare;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private String amount;

                        /** 
                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable base fare amount
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable base fare amount
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivFare implements Serializable
                    {
                        private String amount;

                        /** 
                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable Equivalent fare amount
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable Equivalent fare amount
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" minOccurs="0">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private Tax tax;

                        /** 
                         * Get the 'Tax' element value.
                         * 
                         * @return value
                         */
                        public Tax getTax() {
                            return tax;
                        }

                        /** 
                         * Set the 'Tax' element value.
                         * 
                         * @param tax
                         */
                        public void setTax(Tax tax) {
                            this.tax = tax;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value. "Amount" is used to return the applicable tax amount
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. "Amount" is used to return the applicable tax amount
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private String amount;

                        /** 
                         * Get the 'Amount' attribute value. "Amount" is used to return the applicable total fare amount
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value. "Amount" is used to return the applicable total fare amount
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationItems" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Item" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Item -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ReservationItems implements Serializable
            {
                private List<Item> itemList = new ArrayList<Item>();

                /** 
                 * Get the list of 'Item' element items.
                 * 
                 * @return list
                 */
                public List<Item> getItemList() {
                    return itemList;
                }

                /** 
                 * Set the list of 'Item' element items.
                 * 
                 * @param list
                 */
                public void setItemList(List<Item> list) {
                    itemList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:ns1="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Item" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="AirTaxi" minOccurs="0">
                 *         &lt;!-- Reference to inner class AirTaxi -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Arunk" minOccurs="0">
                 *         &lt;!-- Reference to inner class Arunk -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Cruise" minOccurs="0">
                 *         &lt;!-- Reference to inner class Cruise -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class FlightSegment -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Hotel" minOccurs="0">
                 *         &lt;!-- Reference to inner class Hotel -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Insurance" minOccurs="0">
                 *         &lt;!-- Reference to inner class Insurance -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="MiscSegment" minOccurs="0">
                 *         &lt;!-- Reference to inner class MiscSegment -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Rail" minOccurs="0">
                 *         &lt;!-- Reference to inner class Rail -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Seats" minOccurs="0">
                 *         &lt;!-- Reference to inner class Seats -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Surface" minOccurs="0">
                 *         &lt;!-- Reference to inner class Surface -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Tour" minOccurs="0">
                 *         &lt;!-- Reference to inner class Tour -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Vehicle" minOccurs="0">
                 *         &lt;!-- Reference to inner class Vehicle -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="ns1:ProductType" name="Product" minOccurs="0"/>
                 *       &lt;xs:element name="Ancillaries" minOccurs="0">
                 *         &lt;!-- Reference to inner class Ancillaries -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Item implements Serializable
                {
                    private AirTaxi airTaxi;
                    private Arunk arunk;
                    private Cruise cruise;
                    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
                    private Hotel hotel;
                    private Insurance insurance;
                    private MiscSegment miscSegment;
                    private Rail rail;
                    private Seats seats;
                    private Surface surface;
                    private Tour tour;
                    private Vehicle vehicle;
                    private ProductType product;
                    private Ancillaries ancillaries;
                    private String RPH;
                    private String id;

                    /** 
                     * Get the 'AirTaxi' element value.
                     * 
                     * @return value
                     */
                    public AirTaxi getAirTaxi() {
                        return airTaxi;
                    }

                    /** 
                     * Set the 'AirTaxi' element value.
                     * 
                     * @param airTaxi
                     */
                    public void setAirTaxi(AirTaxi airTaxi) {
                        this.airTaxi = airTaxi;
                    }

                    /** 
                     * Get the 'Arunk' element value.
                     * 
                     * @return value
                     */
                    public Arunk getArunk() {
                        return arunk;
                    }

                    /** 
                     * Set the 'Arunk' element value.
                     * 
                     * @param arunk
                     */
                    public void setArunk(Arunk arunk) {
                        this.arunk = arunk;
                    }

                    /** 
                     * Get the 'Cruise' element value.
                     * 
                     * @return value
                     */
                    public Cruise getCruise() {
                        return cruise;
                    }

                    /** 
                     * Set the 'Cruise' element value.
                     * 
                     * @param cruise
                     */
                    public void setCruise(Cruise cruise) {
                        this.cruise = cruise;
                    }

                    /** 
                     * Get the list of 'FlightSegment' element items.
                     * 
                     * @return list
                     */
                    public List<FlightSegment> getFlightSegmentList() {
                        return flightSegmentList;
                    }

                    /** 
                     * Set the list of 'FlightSegment' element items.
                     * 
                     * @param list
                     */
                    public void setFlightSegmentList(List<FlightSegment> list) {
                        flightSegmentList = list;
                    }

                    /** 
                     * Get the 'Hotel' element value.
                     * 
                     * @return value
                     */
                    public Hotel getHotel() {
                        return hotel;
                    }

                    /** 
                     * Set the 'Hotel' element value.
                     * 
                     * @param hotel
                     */
                    public void setHotel(Hotel hotel) {
                        this.hotel = hotel;
                    }

                    /** 
                     * Get the 'Insurance' element value.
                     * 
                     * @return value
                     */
                    public Insurance getInsurance() {
                        return insurance;
                    }

                    /** 
                     * Set the 'Insurance' element value.
                     * 
                     * @param insurance
                     */
                    public void setInsurance(Insurance insurance) {
                        this.insurance = insurance;
                    }

                    /** 
                     * Get the 'MiscSegment' element value.
                     * 
                     * @return value
                     */
                    public MiscSegment getMiscSegment() {
                        return miscSegment;
                    }

                    /** 
                     * Set the 'MiscSegment' element value.
                     * 
                     * @param miscSegment
                     */
                    public void setMiscSegment(MiscSegment miscSegment) {
                        this.miscSegment = miscSegment;
                    }

                    /** 
                     * Get the 'Rail' element value.
                     * 
                     * @return value
                     */
                    public Rail getRail() {
                        return rail;
                    }

                    /** 
                     * Set the 'Rail' element value.
                     * 
                     * @param rail
                     */
                    public void setRail(Rail rail) {
                        this.rail = rail;
                    }

                    /** 
                     * Get the 'Seats' element value.
                     * 
                     * @return value
                     */
                    public Seats getSeats() {
                        return seats;
                    }

                    /** 
                     * Set the 'Seats' element value.
                     * 
                     * @param seats
                     */
                    public void setSeats(Seats seats) {
                        this.seats = seats;
                    }

                    /** 
                     * Get the 'Surface' element value.
                     * 
                     * @return value
                     */
                    public Surface getSurface() {
                        return surface;
                    }

                    /** 
                     * Set the 'Surface' element value.
                     * 
                     * @param surface
                     */
                    public void setSurface(Surface surface) {
                        this.surface = surface;
                    }

                    /** 
                     * Get the 'Tour' element value.
                     * 
                     * @return value
                     */
                    public Tour getTour() {
                        return tour;
                    }

                    /** 
                     * Set the 'Tour' element value.
                     * 
                     * @param tour
                     */
                    public void setTour(Tour tour) {
                        this.tour = tour;
                    }

                    /** 
                     * Get the 'Vehicle' element value.
                     * 
                     * @return value
                     */
                    public Vehicle getVehicle() {
                        return vehicle;
                    }

                    /** 
                     * Set the 'Vehicle' element value.
                     * 
                     * @param vehicle
                     */
                    public void setVehicle(Vehicle vehicle) {
                        this.vehicle = vehicle;
                    }

                    /** 
                     * Get the 'Product' element value.
                     * 
                     * @return value
                     */
                    public ProductType getProduct() {
                        return product;
                    }

                    /** 
                     * Set the 'Product' element value.
                     * 
                     * @param product
                     */
                    public void setProduct(ProductType product) {
                        this.product = product;
                    }

                    /** 
                     * Get the 'Ancillaries' element value.
                     * 
                     * @return value
                     */
                    public Ancillaries getAncillaries() {
                        return ancillaries;
                    }

                    /** 
                     * Set the 'Ancillaries' element value.
                     * 
                     * @param ancillaries
                     */
                    public void setAncillaries(Ancillaries ancillaries) {
                        this.ancillaries = ancillaries;
                    }

                    /** 
                     * Get the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value. "RPH" is used as a reference placeholder.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTaxi" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="Vendor" minOccurs="0">
                     *         &lt;!-- Reference to inner class Vendor -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AirTaxi implements Serializable
                    {
                        private DestinationLocation destinationLocation;
                        private OriginLocation originLocation;
                        private List<String> textList = new ArrayList<String>();
                        private Vendor vendor;
                        private String dayOfWeekInd;
                        private String departureDateTime;
                        private String linkCode;
                        private String numberInParty;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;
                        private String id;

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the list of 'Text' element items. "Text" is used to return miscellaneous free text associated with the particular segment.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. "Text" is used to return miscellaneous free text associated with the particular segment.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }

                        /** 
                         * Get the 'Vendor' element value.
                         * 
                         * @return value
                         */
                        public Vendor getVendor() {
                            return vendor;
                        }

                        /** 
                         * Set the 'Vendor' element value.
                         * 
                         * @param vendor
                         */
                        public void setVendor(Vendor vendor) {
                            this.vendor = vendor;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the scheduled departure date/time associated with the particular segment.
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the scheduled departure date/time associated with the particular segment.
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular cruise segment.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular cruise segment.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value. Type" is used to return the segment type
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. Type" is used to return the segment type
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on AirTaxi - @DepartureDateTime, AirTaxi - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on AirTaxi - @DepartureDateTime, AirTaxi - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of AirTaxi (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of AirTaxi (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the destination location code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the destination location code associated with the particular segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the origin location code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the origin location code associated with the particular segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Vendor implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arunk" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Arunk implements Serializable
                    {
                        private String segmentNumber;
                        private String type;
                        private String id;

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Type' attribute value. "Type" is used to return the segment type.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. "Type" is used to return the segment type.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Arunk (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Arunk (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cruise" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Berth" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="Cabin" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="CarRate" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Passenger" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="Seat" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="ServiceInformation" minOccurs="0">
                     *         &lt;!-- Reference to inner class ServiceInformation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="ShipName" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="SpaceReserved" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="TotalFare" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="TrailerPrice" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="Vendor" minOccurs="0">
                     *         &lt;!-- Reference to inner class Vendor -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Cruise implements Serializable
                    {
                        private List<String> berthList = new ArrayList<String>();
                        private List<String> cabinList = new ArrayList<String>();
                        private List<String> carRateList = new ArrayList<String>();
                        private List<String> confirmationNumberList = new ArrayList<String>();
                        private DestinationLocation destinationLocation;
                        private OriginLocation originLocation;
                        private List<String> passengerList = new ArrayList<String>();
                        private List<String> seatList = new ArrayList<String>();
                        private ServiceInformation serviceInformation;
                        private List<String> shipNameList = new ArrayList<String>();
                        private List<String> spaceReservedList = new ArrayList<String>();
                        private List<String> textList = new ArrayList<String>();
                        private List<String> totalFareList = new ArrayList<String>();
                        private List<String> trailerPriceList = new ArrayList<String>();
                        private Vendor vendor;
                        private String dayOfWeekInd;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String numberInParty;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;
                        private String id;

                        /** 
                         * Get the list of 'Berth' element items. "Berth" is used to return the berth associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getBerthList() {
                            return berthList;
                        }

                        /** 
                         * Set the list of 'Berth' element items. "Berth" is used to return the berth associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setBerthList(List<String> list) {
                            berthList = list;
                        }

                        /** 
                         * Get the list of 'Cabin' element items. "Cabin" is used to return the cabin associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getCabinList() {
                            return cabinList;
                        }

                        /** 
                         * Set the list of 'Cabin' element items. "Cabin" is used to return the cabin associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setCabinList(List<String> list) {
                            cabinList = list;
                        }

                        /** 
                         * Get the list of 'CarRate' element items. "CarRate" is used to return car rate-related information associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getCarRateList() {
                            return carRateList;
                        }

                        /** 
                         * Set the list of 'CarRate' element items. "CarRate" is used to return car rate-related information associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setCarRateList(List<String> list) {
                            carRateList = list;
                        }

                        /** 
                         * Get the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the confirmation number associated with the particular cruise segment.
                         * 
                         * @return list
                         */
                        public List<String> getConfirmationNumberList() {
                            return confirmationNumberList;
                        }

                        /** 
                         * Set the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the confirmation number associated with the particular cruise segment.
                         * 
                         * @param list
                         */
                        public void setConfirmationNumberList(List<String> list) {
                            confirmationNumberList = list;
                        }

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the list of 'Passenger' element items. "Passenger" is used to return passenger-related information associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getPassengerList() {
                            return passengerList;
                        }

                        /** 
                         * Set the list of 'Passenger' element items. "Passenger" is used to return passenger-related information associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setPassengerList(List<String> list) {
                            passengerList = list;
                        }

                        /** 
                         * Get the list of 'Seat' element items. "Seat" is used to return the seat number associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getSeatList() {
                            return seatList;
                        }

                        /** 
                         * Set the list of 'Seat' element items. "Seat" is used to return the seat number associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setSeatList(List<String> list) {
                            seatList = list;
                        }

                        /** 
                         * Get the 'ServiceInformation' element value.
                         * 
                         * @return value
                         */
                        public ServiceInformation getServiceInformation() {
                            return serviceInformation;
                        }

                        /** 
                         * Set the 'ServiceInformation' element value.
                         * 
                         * @param serviceInformation
                         */
                        public void setServiceInformation(
                                ServiceInformation serviceInformation) {
                            this.serviceInformation = serviceInformation;
                        }

                        /** 
                         * Get the list of 'ShipName' element items. "ShipName" is used to return the ship name associated with the particular cruise segment.
                         * 
                         * @return list
                         */
                        public List<String> getShipNameList() {
                            return shipNameList;
                        }

                        /** 
                         * Set the list of 'ShipName' element items. "ShipName" is used to return the ship name associated with the particular cruise segment.
                         * 
                         * @param list
                         */
                        public void setShipNameList(List<String> list) {
                            shipNameList = list;
                        }

                        /** 
                         * Get the list of 'SpaceReserved' element items. "SpaceReserved" is used to return space reserved-related information.
                         * 
                         * @return list
                         */
                        public List<String> getSpaceReservedList() {
                            return spaceReservedList;
                        }

                        /** 
                         * Set the list of 'SpaceReserved' element items. "SpaceReserved" is used to return space reserved-related information.
                         * 
                         * @param list
                         */
                        public void setSpaceReservedList(List<String> list) {
                            spaceReservedList = list;
                        }

                        /** 
                         * Get the list of 'Text' element items. "Text" is used to return miscellaneous free text associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. "Text" is used to return miscellaneous free text associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }

                        /** 
                         * Get the list of 'TotalFare' element items. "TotalFare" is used to return the total fare associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getTotalFareList() {
                            return totalFareList;
                        }

                        /** 
                         * Set the list of 'TotalFare' element items. "TotalFare" is used to return the total fare associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setTotalFareList(List<String> list) {
                            totalFareList = list;
                        }

                        /** 
                         * Get the list of 'TrailerPrice' element items. "TrailerPrice" is used to return the trailer price associated with the particular cruise segment if applicable.
                         * 
                         * @return list
                         */
                        public List<String> getTrailerPriceList() {
                            return trailerPriceList;
                        }

                        /** 
                         * Set the list of 'TrailerPrice' element items. "TrailerPrice" is used to return the trailer price associated with the particular cruise segment if applicable.
                         * 
                         * @param list
                         */
                        public void setTrailerPriceList(List<String> list) {
                            trailerPriceList = list;
                        }

                        /** 
                         * Get the 'Vendor' element value.
                         * 
                         * @return value
                         */
                        public Vendor getVendor() {
                            return vendor;
                        }

                        /** 
                         * Set the 'Vendor' element value.
                         * 
                         * @param vendor
                         */
                        public void setVendor(Vendor vendor) {
                            this.vendor = vendor;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular tour reservation if applicable.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular tour reservation if applicable.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular flight segment.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Cruise - DestinationLocation - ArrivalDate, Cruise - DestinationLocation - ArrivalTime, Cruise - DestinationLocation - @LocationCode.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Cruise - DestinationLocation - ArrivalDate, Cruise - DestinationLocation - ArrivalTime, Cruise - DestinationLocation - @LocationCode.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Cruise (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Cruise (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ArrivalDate" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="ArrivalTime" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="Point" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationName"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private List<String> arrivalDateList = new ArrayList<String>();
                            private List<String> arrivalTimeList = new ArrayList<String>();
                            private List<String> pointList = new ArrayList<String>();
                            private String locationCode;
                            private String locationName;

                            /** 
                             * Get the list of 'ArrivalDate' element items. ArrivalDate" is used to return the arrival date associated with the particular cruise segment.	ArrivalDate" follows this format: MM:DD
                             * 
                             * @return list
                             */
                            public List<String> getArrivalDateList() {
                                return arrivalDateList;
                            }

                            /** 
                             * Set the list of 'ArrivalDate' element items. ArrivalDate" is used to return the arrival date associated with the particular cruise segment.	ArrivalDate" follows this format: MM:DD
                             * 
                             * @param list
                             */
                            public void setArrivalDateList(List<String> list) {
                                arrivalDateList = list;
                            }

                            /** 
                             * Get the list of 'ArrivalTime' element items. ArrivalTime" is used to return the arrival time associated with the particular cruise segment.	"ArrivalTime" follows this format: MM:DD
                             * 
                             * @return list
                             */
                            public List<String> getArrivalTimeList() {
                                return arrivalTimeList;
                            }

                            /** 
                             * Set the list of 'ArrivalTime' element items. ArrivalTime" is used to return the arrival time associated with the particular cruise segment.	"ArrivalTime" follows this format: MM:DD
                             * 
                             * @param list
                             */
                            public void setArrivalTimeList(List<String> list) {
                                arrivalTimeList = list;
                            }

                            /** 
                             * Get the list of 'Point' element items. "Point" is used to return the arrival location point associated with the particular cruise segment.
                             * 
                             * @return list
                             */
                            public List<String> getPointList() {
                                return pointList;
                            }

                            /** 
                             * Set the list of 'Point' element items. "Point" is used to return the arrival location point associated with the particular cruise segment.
                             * 
                             * @param list
                             */
                            public void setPointList(List<String> list) {
                                pointList = list;
                            }

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the location code associated with the particular cruise segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the location code associated with the particular cruise segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'LocationName' attribute value. "LocationName" is used to return the arrival location name associated with the particular cruise segment.
                             * 
                             * @return value
                             */
                            public String getLocationName() {
                                return locationName;
                            }

                            /** 
                             * Set the 'LocationName' attribute value. "LocationName" is used to return the arrival location name associated with the particular cruise segment.
                             * 
                             * @param locationName
                             */
                            public void setLocationName(String locationName) {
                                this.locationName = locationName;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="DepartureDate" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="DepartureTime" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="Point" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationName"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String departureDate;
                            private List<String> departureTimeList = new ArrayList<String>();
                            private List<String> pointList = new ArrayList<String>();
                            private String locationCode;
                            private String locationName;

                            /** 
                             * Get the 'DepartureDate' element value. "DepartureDate" is used to return the departure dates associated with the particular cruise segment. 	DepartureDate" follows this format: MM:DD
                             * 
                             * @return value
                             */
                            public String getDepartureDate() {
                                return departureDate;
                            }

                            /** 
                             * Set the 'DepartureDate' element value. "DepartureDate" is used to return the departure dates associated with the particular cruise segment. 	DepartureDate" follows this format: MM:DD
                             * 
                             * @param departureDate
                             */
                            public void setDepartureDate(String departureDate) {
                                this.departureDate = departureDate;
                            }

                            /** 
                             * Get the list of 'DepartureTime' element items. "DepartureTime" is used to return the departure time associated with the particular cruise segment. 	"DepartureTime" follows this format: HH:MM
                             * 
                             * @return list
                             */
                            public List<String> getDepartureTimeList() {
                                return departureTimeList;
                            }

                            /** 
                             * Set the list of 'DepartureTime' element items. "DepartureTime" is used to return the departure time associated with the particular cruise segment. 	"DepartureTime" follows this format: HH:MM
                             * 
                             * @param list
                             */
                            public void setDepartureTimeList(List<String> list) {
                                departureTimeList = list;
                            }

                            /** 
                             * Get the list of 'Point' element items. "Point" is used to return the departure location point associated with the particular cruise segment.
                             * 
                             * @return list
                             */
                            public List<String> getPointList() {
                                return pointList;
                            }

                            /** 
                             * Set the list of 'Point' element items. "Point" is used to return the departure location point associated with the particular cruise segment.
                             * 
                             * @param list
                             */
                            public void setPointList(List<String> list) {
                                pointList = list;
                            }

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the location code associated with the particular cruise segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the location code associated with the particular cruise segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'LocationName' attribute value. "LocationName" is used to return the arrival location name associated with the particular cruise segment.
                             * 
                             * @return value
                             */
                            public String getLocationName() {
                                return locationName;
                            }

                            /** 
                             * Set the 'LocationName' attribute value. "LocationName" is used to return the arrival location name associated with the particular cruise segment.
                             * 
                             * @param locationName
                             */
                            public void setLocationName(String locationName) {
                                this.locationName = locationName;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInformation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ServiceInformation implements
                            Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items. "Text" is used to return miscellaneous service-related information.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items. "Text" is used to return miscellaneous service-related information.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Vendor implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular cruise segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular cruise segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BSG_Record" minOccurs="0">
                     *         &lt;!-- Reference to inner class BSGRecord -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CheckInAirline" minOccurs="0">
                     *         &lt;!-- Reference to inner class CheckInAirline -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CodeshareRecord" minOccurs="0">
                     *         &lt;!-- Reference to inner class CodeshareRecord -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Equipment" minOccurs="0">
                     *         &lt;!-- Reference to inner class Equipment -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                     *         &lt;!-- Reference to inner class MarketingAirline -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MarketingCodeshareRecord" minOccurs="0">
                     *         &lt;!-- Reference to inner class MarketingCodeshareRecord -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MarriageGrp" minOccurs="0">
                     *         &lt;!-- Reference to inner class MarriageGrp -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Meal" minOccurs="0" maxOccurs="3">
                     *         &lt;!-- Reference to inner class Meal -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OperatingAirline" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class OperatingAirline -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OperatingAirlinePricing" minOccurs="0" maxOccurs="1">
                     *         &lt;!-- Reference to inner class OperatingAirlinePricing -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OperatingAirlineRecord" minOccurs="0">
                     *         &lt;!-- Reference to inner class OperatingAirlineRecord -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="DisclosureCarrier" minOccurs="0" maxOccurs="1">
                     *         &lt;!-- Reference to inner class DisclosureCarrier -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SupplierRef" minOccurs="0">
                     *         &lt;!-- Reference to inner class SupplierRef -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="BSGIndicator" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="UpdatedArrivalTime" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="UpdatedDepartureTime" minOccurs="0"/>
                     *       &lt;xs:element name="Cabin" minOccurs="0">
                     *         &lt;!-- Reference to inner class Cabin -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="AirMilesFlown"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentBookedDate"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ElapsedTime"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="eTicket"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SmokingAllowed"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SpecialMeal"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="StopQuantity"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="CodeShare"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Wetlease"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FlightSegment implements Serializable
                    {
                        private BSGRecord BSGRecord1;
                        private CheckInAirline checkInAirline;
                        private CodeshareRecord codeshareRecord;
                        private DestinationLocation destinationLocation;
                        private Equipment equipment;
                        private MarketingAirline marketingAirline;
                        private MarketingCodeshareRecord marketingCodeshareRecord;
                        private MarriageGrp marriageGrp;
                        private List<Meal> mealList = new ArrayList<Meal>();
                        private List<OperatingAirline> operatingAirlineList = new ArrayList<OperatingAirline>();
                        private OperatingAirlinePricing operatingAirlinePricing;
                        private OperatingAirlineRecord operatingAirlineRecord;
                        private DisclosureCarrier disclosureCarrier;
                        private OriginLocation originLocation;
                        private SupplierRef supplierRef;
                        private String text;
                        private String BSGIndicator;
                        private String updatedArrivalTime;
                        private String updatedDepartureTime;
                        private Cabin cabin;
                        private String airMilesFlown;
                        private String arrivalDateTime;
                        private String connectionInd;
                        private String dayOfWeekInd;
                        private String departureDateTime;
                        private String segmentBookedDate;
                        private String elapsedTime;
                        private Boolean ETicket;
                        private String flightNumber;
                        private String numberInParty;
                        private String resBookDesigCode;
                        private String segmentNumber;
                        private Boolean smokingAllowed;
                        private Boolean specialMeal;
                        private String status;
                        private String stopQuantity;
                        private Boolean isPast;
                        private Boolean codeShare;
                        private Boolean wetlease;
                        private String id;

                        /** 
                         * Get the 'BSG_Record' element value.
                         * 
                         * @return value
                         */
                        public BSGRecord getBSGRecord1() {
                            return BSGRecord1;
                        }

                        /** 
                         * Set the 'BSG_Record' element value.
                         * 
                         * @param BSGRecord1
                         */
                        public void setBSGRecord1(BSGRecord BSGRecord1) {
                            this.BSGRecord1 = BSGRecord1;
                        }

                        /** 
                         * Get the 'CheckInAirline' element value.
                         * 
                         * @return value
                         */
                        public CheckInAirline getCheckInAirline() {
                            return checkInAirline;
                        }

                        /** 
                         * Set the 'CheckInAirline' element value.
                         * 
                         * @param checkInAirline
                         */
                        public void setCheckInAirline(
                                CheckInAirline checkInAirline) {
                            this.checkInAirline = checkInAirline;
                        }

                        /** 
                         * Get the 'CodeshareRecord' element value.
                         * 
                         * @return value
                         */
                        public CodeshareRecord getCodeshareRecord() {
                            return codeshareRecord;
                        }

                        /** 
                         * Set the 'CodeshareRecord' element value.
                         * 
                         * @param codeshareRecord
                         */
                        public void setCodeshareRecord(
                                CodeshareRecord codeshareRecord) {
                            this.codeshareRecord = codeshareRecord;
                        }

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the 'Equipment' element value.
                         * 
                         * @return value
                         */
                        public Equipment getEquipment() {
                            return equipment;
                        }

                        /** 
                         * Set the 'Equipment' element value.
                         * 
                         * @param equipment
                         */
                        public void setEquipment(Equipment equipment) {
                            this.equipment = equipment;
                        }

                        /** 
                         * Get the 'MarketingAirline' element value.
                         * 
                         * @return value
                         */
                        public MarketingAirline getMarketingAirline() {
                            return marketingAirline;
                        }

                        /** 
                         * Set the 'MarketingAirline' element value.
                         * 
                         * @param marketingAirline
                         */
                        public void setMarketingAirline(
                                MarketingAirline marketingAirline) {
                            this.marketingAirline = marketingAirline;
                        }

                        /** 
                         * Get the 'MarketingCodeshareRecord' element value.
                         * 
                         * @return value
                         */
                        public MarketingCodeshareRecord getMarketingCodeshareRecord() {
                            return marketingCodeshareRecord;
                        }

                        /** 
                         * Set the 'MarketingCodeshareRecord' element value.
                         * 
                         * @param marketingCodeshareRecord
                         */
                        public void setMarketingCodeshareRecord(
                                MarketingCodeshareRecord marketingCodeshareRecord) {
                            this.marketingCodeshareRecord = marketingCodeshareRecord;
                        }

                        /** 
                         * Get the 'MarriageGrp' element value.
                         * 
                         * @return value
                         */
                        public MarriageGrp getMarriageGrp() {
                            return marriageGrp;
                        }

                        /** 
                         * Set the 'MarriageGrp' element value.
                         * 
                         * @param marriageGrp
                         */
                        public void setMarriageGrp(MarriageGrp marriageGrp) {
                            this.marriageGrp = marriageGrp;
                        }

                        /** 
                         * Get the list of 'Meal' element items.
                         * 
                         * @return list
                         */
                        public List<Meal> getMealList() {
                            return mealList;
                        }

                        /** 
                         * Set the list of 'Meal' element items.
                         * 
                         * @param list
                         */
                        public void setMealList(List<Meal> list) {
                            mealList = list;
                        }

                        /** 
                         * Get the list of 'OperatingAirline' element items.
                         * 
                         * @return list
                         */
                        public List<OperatingAirline> getOperatingAirlineList() {
                            return operatingAirlineList;
                        }

                        /** 
                         * Set the list of 'OperatingAirline' element items.
                         * 
                         * @param list
                         */
                        public void setOperatingAirlineList(
                                List<OperatingAirline> list) {
                            operatingAirlineList = list;
                        }

                        /** 
                         * Get the 'OperatingAirlinePricing' element value.
                         * 
                         * @return value
                         */
                        public OperatingAirlinePricing getOperatingAirlinePricing() {
                            return operatingAirlinePricing;
                        }

                        /** 
                         * Set the 'OperatingAirlinePricing' element value.
                         * 
                         * @param operatingAirlinePricing
                         */
                        public void setOperatingAirlinePricing(
                                OperatingAirlinePricing operatingAirlinePricing) {
                            this.operatingAirlinePricing = operatingAirlinePricing;
                        }

                        /** 
                         * Get the 'OperatingAirlineRecord' element value.
                         * 
                         * @return value
                         */
                        public OperatingAirlineRecord getOperatingAirlineRecord() {
                            return operatingAirlineRecord;
                        }

                        /** 
                         * Set the 'OperatingAirlineRecord' element value.
                         * 
                         * @param operatingAirlineRecord
                         */
                        public void setOperatingAirlineRecord(
                                OperatingAirlineRecord operatingAirlineRecord) {
                            this.operatingAirlineRecord = operatingAirlineRecord;
                        }

                        /** 
                         * Get the 'DisclosureCarrier' element value.
                         * 
                         * @return value
                         */
                        public DisclosureCarrier getDisclosureCarrier() {
                            return disclosureCarrier;
                        }

                        /** 
                         * Set the 'DisclosureCarrier' element value.
                         * 
                         * @param disclosureCarrier
                         */
                        public void setDisclosureCarrier(
                                DisclosureCarrier disclosureCarrier) {
                            this.disclosureCarrier = disclosureCarrier;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the 'SupplierRef' element value.
                         * 
                         * @return value
                         */
                        public SupplierRef getSupplierRef() {
                            return supplierRef;
                        }

                        /** 
                         * Set the 'SupplierRef' element value.
                         * 
                         * @param supplierRef
                         */
                        public void setSupplierRef(SupplierRef supplierRef) {
                            this.supplierRef = supplierRef;
                        }

                        /** 
                         * Get the 'Text' element value. "Text" is used to return miscellaneous free text-based information.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value. "Text" is used to return miscellaneous free text-based information.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'BSGIndicator' element value. "BSGIndicator" is used to indicate he flight segment has a BSG PNR
                         * 
                         * @return value
                         */
                        public String getBSGIndicator() {
                            return BSGIndicator;
                        }

                        /** 
                         * Set the 'BSGIndicator' element value. "BSGIndicator" is used to indicate he flight segment has a BSG PNR
                         * 
                         * @param BSGIndicator
                         */
                        public void setBSGIndicator(String BSGIndicator) {
                            this.BSGIndicator = BSGIndicator;
                        }

                        /** 
                         * Get the 'UpdatedArrivalTime' element value. "UpdatedArrivalTime" is used to return updated arrival information if applicable.	"UpdatedArrivalTime" follows this format: MM-DDTHH:MM
                         * 
                         * @return value
                         */
                        public String getUpdatedArrivalTime() {
                            return updatedArrivalTime;
                        }

                        /** 
                         * Set the 'UpdatedArrivalTime' element value. "UpdatedArrivalTime" is used to return updated arrival information if applicable.	"UpdatedArrivalTime" follows this format: MM-DDTHH:MM
                         * 
                         * @param updatedArrivalTime
                         */
                        public void setUpdatedArrivalTime(
                                String updatedArrivalTime) {
                            this.updatedArrivalTime = updatedArrivalTime;
                        }

                        /** 
                         * Get the 'UpdatedDepartureTime' element value. "UpdatedDepartureTime" is used to return updated departure information if applicable.	"UpdatedDepartureTime" follows this format: MM-DDTHH:MM
                         * 
                         * @return value
                         */
                        public String getUpdatedDepartureTime() {
                            return updatedDepartureTime;
                        }

                        /** 
                         * Set the 'UpdatedDepartureTime' element value. "UpdatedDepartureTime" is used to return updated departure information if applicable.	"UpdatedDepartureTime" follows this format: MM-DDTHH:MM
                         * 
                         * @param updatedDepartureTime
                         */
                        public void setUpdatedDepartureTime(
                                String updatedDepartureTime) {
                            this.updatedDepartureTime = updatedDepartureTime;
                        }

                        /** 
                         * Get the 'Cabin' element value.
                         * 
                         * @return value
                         */
                        public Cabin getCabin() {
                            return cabin;
                        }

                        /** 
                         * Set the 'Cabin' element value.
                         * 
                         * @param cabin
                         */
                        public void setCabin(Cabin cabin) {
                            this.cabin = cabin;
                        }

                        /** 
                         * Get the 'AirMilesFlown' attribute value. "AirMilesFlown" is used to return the air miles flown associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getAirMilesFlown() {
                            return airMilesFlown;
                        }

                        /** 
                         * Set the 'AirMilesFlown' attribute value. "AirMilesFlown" is used to return the air miles flown associated with the particular flight segment.
                         * 
                         * @param airMilesFlown
                         */
                        public void setAirMilesFlown(String airMilesFlown) {
                            this.airMilesFlown = airMilesFlown;
                        }

                        /** 
                         * Get the 'ArrivalDateTime' attribute value. "ArrivalDateTime" is used to return the scheduled arrival date/time associated with the particular flight segment.  Please note that updated information is provided via .../Air/UpdatedArrivalTime if applicable.
                        																		"ArrivalDateTime" follows this format: MM-DDTHH:MM
                         * 
                         * @return value
                         */
                        public String getArrivalDateTime() {
                            return arrivalDateTime;
                        }

                        /** 
                         * Set the 'ArrivalDateTime' attribute value. "ArrivalDateTime" is used to return the scheduled arrival date/time associated with the particular flight segment.  Please note that updated information is provided via .../Air/UpdatedArrivalTime if applicable.
                        																		"ArrivalDateTime" follows this format: MM-DDTHH:MM
                         * 
                         * @param arrivalDateTime
                         */
                        public void setArrivalDateTime(String arrivalDateTime) {
                            this.arrivalDateTime = arrivalDateTime;
                        }

                        /** 
                         * Get the 'ConnectionInd' attribute value. "ConnectionInd" is used to return the connection indicator associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getConnectionInd() {
                            return connectionInd;
                        }

                        /** 
                         * Set the 'ConnectionInd' attribute value. "ConnectionInd" is used to return the connection indicator associated with the particular flight segment.
                         * 
                         * @param connectionInd
                         */
                        public void setConnectionInd(String connectionInd) {
                            this.connectionInd = connectionInd;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the scheduled departure date/time associated with the particular flight segment.  Please note that updated information is provided via .../Air/UpdatedDepartureTime if applicable.
                        																		"DepartureDateTime" follows this format: YYYY-MM-DDTHH:MM
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the scheduled departure date/time associated with the particular flight segment.  Please note that updated information is provided via .../Air/UpdatedDepartureTime if applicable.
                        																		"DepartureDateTime" follows this format: YYYY-MM-DDTHH:MM
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'SegmentBookedDate' attribute value. Segment Booked date and time with format: YYYY-MM-DDThh:mm:ss
                         * 
                         * @return value
                         */
                        public String getSegmentBookedDate() {
                            return segmentBookedDate;
                        }

                        /** 
                         * Set the 'SegmentBookedDate' attribute value. Segment Booked date and time with format: YYYY-MM-DDThh:mm:ss
                         * 
                         * @param segmentBookedDate
                         */
                        public void setSegmentBookedDate(
                                String segmentBookedDate) {
                            this.segmentBookedDate = segmentBookedDate;
                        }

                        /** 
                         * Get the 'ElapsedTime' attribute value. "ElapsedTime" is used to return the elapsed time associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getElapsedTime() {
                            return elapsedTime;
                        }

                        /** 
                         * Set the 'ElapsedTime' attribute value. "ElapsedTime" is used to return the elapsed time associated with the particular flight segment.
                         * 
                         * @param elapsedTime
                         */
                        public void setElapsedTime(String elapsedTime) {
                            this.elapsedTime = elapsedTime;
                        }

                        /** 
                         * Get the 'eTicket' attribute value. "eTicket" is used to indicate whether or not the particular flight segment is eTicket-eligible.
                         * 
                         * @return value
                         */
                        public Boolean getETicket() {
                            return ETicket;
                        }

                        /** 
                         * Set the 'eTicket' attribute value. "eTicket" is used to indicate whether or not the particular flight segment is eTicket-eligible.
                         * 
                         * @param eTicket
                         */
                        public void setETicket(Boolean eTicket) {
                            ETicket = eTicket;
                        }

                        /** 
                         * Get the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getFlightNumber() {
                            return flightNumber;
                        }

                        /** 
                         * Set the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular flight segment.
                         * 
                         * @param flightNumber
                         */
                        public void setFlightNumber(String flightNumber) {
                            this.flightNumber = flightNumber;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getResBookDesigCode() {
                            return resBookDesigCode;
                        }

                        /** 
                         * Set the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                         * 
                         * @param resBookDesigCode
                         */
                        public void setResBookDesigCode(String resBookDesigCode) {
                            this.resBookDesigCode = resBookDesigCode;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'SmokingAllowed' attribute value. "SmokingAllowed" is used to indicate whether or not smoking is permitted on the particular flight segment.
                         * 
                         * @return value
                         */
                        public Boolean getSmokingAllowed() {
                            return smokingAllowed;
                        }

                        /** 
                         * Set the 'SmokingAllowed' attribute value. "SmokingAllowed" is used to indicate whether or not smoking is permitted on the particular flight segment.
                         * 
                         * @param smokingAllowed
                         */
                        public void setSmokingAllowed(Boolean smokingAllowed) {
                            this.smokingAllowed = smokingAllowed;
                        }

                        /** 
                         * Get the 'SpecialMeal' attribute value. "SpecialMeal" is used to indicate whether or not a special meal is associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public Boolean getSpecialMeal() {
                            return specialMeal;
                        }

                        /** 
                         * Set the 'SpecialMeal' attribute value. "SpecialMeal" is used to indicate whether or not a special meal is associated with the particular flight segment.
                         * 
                         * @param specialMeal
                         */
                        public void setSpecialMeal(Boolean specialMeal) {
                            this.specialMeal = specialMeal;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'StopQuantity' attribute value. "StopQuantity" is used to return the  number of stops associated with the particular flight segment.
                         * 
                         * @return value
                         */
                        public String getStopQuantity() {
                            return stopQuantity;
                        }

                        /** 
                         * Set the 'StopQuantity' attribute value. "StopQuantity" is used to return the  number of stops associated with the particular flight segment.
                         * 
                         * @param stopQuantity
                         */
                        public void setStopQuantity(String stopQuantity) {
                            this.stopQuantity = stopQuantity;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on FlightSegment - @DepartureDateTime, FlightSegment - OriginLocation - @LocationCode.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on FlightSegment - @DepartureDateTime, FlightSegment - OriginLocation - @LocationCode.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'CodeShare' attribute value. "CodeShare" is used to indicate if this is a codeshare flight.
                         * 
                         * @return value
                         */
                        public Boolean getCodeShare() {
                            return codeShare;
                        }

                        /** 
                         * Set the 'CodeShare' attribute value. "CodeShare" is used to indicate if this is a codeshare flight.
                         * 
                         * @param codeShare
                         */
                        public void setCodeShare(Boolean codeShare) {
                            this.codeShare = codeShare;
                        }

                        /** 
                         * Get the 'Wetlease' attribute value. "Wetlease" is used to indicate if this flight is operated as a wetlease flight.
                         * 
                         * @return value
                         */
                        public Boolean getWetlease() {
                            return wetlease;
                        }

                        /** 
                         * Set the 'Wetlease' attribute value. "Wetlease" is used to indicate if this flight is operated as a wetlease flight.
                         * 
                         * @param wetlease
                         */
                        public void setWetlease(Boolean wetlease) {
                            this.wetlease = wetlease;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of FlightSegment (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of FlightSegment (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSG_Record" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="BSGPNRCreatedDate"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BSGRecord implements Serializable
                        {
                            private String ID;
                            private String BSGPNRCreatedDate;

                            /** 
                             * Get the 'ID' attribute value. "ID" is used to return the block space group record locator if applicable
                             * 
                             * @return value
                             */
                            public String getID() {
                                return ID;
                            }

                            /** 
                             * Set the 'ID' attribute value. "ID" is used to return the block space group record locator if applicable
                             * 
                             * @param ID
                             */
                            public void setID(String ID) {
                                this.ID = ID;
                            }

                            /** 
                             * Get the 'BSGPNRCreatedDate' attribute value. "BSGPNRCreatedDate" is used to return the date BSG PNR was created
                             * 
                             * @return value
                             */
                            public String getBSGPNRCreatedDate() {
                                return BSGPNRCreatedDate;
                            }

                            /** 
                             * Set the 'BSGPNRCreatedDate' attribute value. "BSGPNRCreatedDate" is used to return the date BSG PNR was created
                             * 
                             * @param BSGPNRCreatedDate
                             */
                            public void setBSGPNRCreatedDate(
                                    String BSGPNRCreatedDate) {
                                this.BSGPNRCreatedDate = BSGPNRCreatedDate;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckInAirline" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CheckInAirline implements
                            Serializable
                        {
                            private String code;
                            private String companyShortName;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
                             * 
                             * @return value
                             */
                            public String getCompanyShortName() {
                                return companyShortName;
                            }

                            /** 
                             * Set the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
                             * 
                             * @param companyShortName
                             */
                            public void setCompanyShortName(
                                    String companyShortName) {
                                this.companyShortName = companyShortName;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodeshareRecord" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CodeshareRecord implements
                            Serializable
                        {
                            private String ID;

                            /** 
                             * Get the 'ID' attribute value. "ID" is used to return the codeshare record locator if applicable.
                             * 
                             * @return value
                             */
                            public String getID() {
                                return ID;
                            }

                            /** 
                             * Set the 'ID' attribute value. "ID" is used to return the codeshare record locator if applicable.
                             * 
                             * @param ID
                             */
                            public void setID(String ID) {
                                this.ID = ID;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Terminal"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TerminalCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private String locationCode;
                            private String terminal;
                            private String terminalCode;

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the arrival airport code.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the arrival airport code.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'Terminal' attribute value. "Terminal" is used to return the arrival airport terminal.
                             * 
                             * @return value
                             */
                            public String getTerminal() {
                                return terminal;
                            }

                            /** 
                             * Set the 'Terminal' attribute value. "Terminal" is used to return the arrival airport terminal.
                             * 
                             * @param terminal
                             */
                            public void setTerminal(String terminal) {
                                this.terminal = terminal;
                            }

                            /** 
                             * Get the 'TerminalCode' attribute value. "TerminalCode" is used to return the arrival airport terminal code.
                             * 
                             * @return value
                             */
                            public String getTerminalCode() {
                                return terminalCode;
                            }

                            /** 
                             * Set the 'TerminalCode' attribute value. "TerminalCode" is used to return the arrival airport terminal code.
                             * 
                             * @param terminalCode
                             */
                            public void setTerminalCode(String terminalCode) {
                                this.terminalCode = terminalCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Equipment implements Serializable
                        {
                            private String airEquipType;

                            /** 
                             * Get the 'AirEquipType' attribute value. "AirEquipType" is used to return the aircraft equipment type associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getAirEquipType() {
                                return airEquipType;
                            }

                            /** 
                             * Set the 'AirEquipType' attribute value. "AirEquipType" is used to return the aircraft equipment type associated with the particular flight segment.
                             * 
                             * @param airEquipType
                             */
                            public void setAirEquipType(String airEquipType) {
                                this.airEquipType = airEquipType;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Banner" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MarketingAirline implements
                            Serializable
                        {
                            private String banner;
                            private String code;
                            private String flightNumber;
                            private String resBookDesigCode;

                            /** 
                             * Get the 'Banner' element value. "MarketingAirline/Banner" is used to return the marketing airline name.
                             * 
                             * @return value
                             */
                            public String getBanner() {
                                return banner;
                            }

                            /** 
                             * Set the 'Banner' element value. "MarketingAirline/Banner" is used to return the marketing airline name.
                             * 
                             * @param banner
                             */
                            public void setBanner(String banner) {
                                this.banner = banner;
                            }

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the marketing airline code associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the marketing airline code associated with the particular flight segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getFlightNumber() {
                                return flightNumber;
                            }

                            /** 
                             * Set the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular flight segment.
                             * 
                             * @param flightNumber
                             */
                            public void setFlightNumber(String flightNumber) {
                                this.flightNumber = flightNumber;
                            }

                            /** 
                             * Get the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getResBookDesigCode() {
                                return resBookDesigCode;
                            }

                            /** 
                             * Set the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                             * 
                             * @param resBookDesigCode
                             */
                            public void setResBookDesigCode(
                                    String resBookDesigCode) {
                                this.resBookDesigCode = resBookDesigCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingCodeshareRecord" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MarketingCodeshareRecord implements
                            Serializable
                        {
                            private String ID;

                            /** 
                             * Get the 'ID' attribute value. "ID" is used to return the marketing codeshare record locator if applicable.
                             * 
                             * @return value
                             */
                            public String getID() {
                                return ID;
                            }

                            /** 
                             * Set the 'ID' attribute value. "ID" is used to return the marketing codeshare record locator if applicable.
                             * 
                             * @param ID
                             */
                            public void setID(String ID) {
                                this.ID = ID;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Group"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Sequence"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MarriageGrp implements Serializable
                        {
                            private String group;
                            private String ind;
                            private String sequence;

                            /** 
                             * Get the 'Group' attribute value. "Group" is used to return the marraige group number if applicable.
                             * 
                             * @return value
                             */
                            public String getGroup() {
                                return group;
                            }

                            /** 
                             * Set the 'Group' attribute value. "Group" is used to return the marraige group number if applicable.
                             * 
                             * @param group
                             */
                            public void setGroup(String group) {
                                this.group = group;
                            }

                            /** 
                             * Get the 'Ind' attribute value. "Ind" is used to indicate that the particular flight segment is part of a married connection.
                             * 
                             * @return value
                             */
                            public String getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value. "Ind" is used to indicate that the particular flight segment is part of a married connection.
                             * 
                             * @param ind
                             */
                            public void setInd(String ind) {
                                this.ind = ind;
                            }

                            /** 
                             * Get the 'Sequence' attribute value. "Sequence" is used to return the marraige sequence number if applicable.
                             * 
                             * @return value
                             */
                            public String getSequence() {
                                return sequence;
                            }

                            /** 
                             * Set the 'Sequence' attribute value. "Sequence" is used to return the marraige sequence number if applicable.
                             * 
                             * @param sequence
                             */
                            public void setSequence(String sequence) {
                                this.sequence = sequence;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0" maxOccurs="3">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Meal implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the meal code associated with the particular flight segment if applicable.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the meal code associated with the particular flight segment if applicable.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Banner" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="OwningCarrier"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OperatingAirline implements
                            Serializable
                        {
                            private String banner;
                            private String code;
                            private String flightNumber;
                            private String resBookDesigCode;
                            private String owningCarrier;

                            /** 
                             * Get the 'Banner' element value. "OperatingAirline/Banner" is used to return the marketing airline name.
                             * 
                             * @return value
                             */
                            public String getBanner() {
                                return banner;
                            }

                            /** 
                             * Set the 'Banner' element value. "OperatingAirline/Banner" is used to return the marketing airline name.
                             * 
                             * @param banner
                             */
                            public void setBanner(String banner) {
                                this.banner = banner;
                            }

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the operating airline code associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the operating airline code associated with the particular flight segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number
                            																				associated with the operating airline's flight segment.
                            																			
                             * 
                             * @return value
                             */
                            public String getFlightNumber() {
                                return flightNumber;
                            }

                            /** 
                             * Set the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number
                            																				associated with the operating airline's flight segment.
                            																			
                             * 
                             * @param flightNumber
                             */
                            public void setFlightNumber(String flightNumber) {
                                this.flightNumber = flightNumber;
                            }

                            /** 
                             * Get the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getResBookDesigCode() {
                                return resBookDesigCode;
                            }

                            /** 
                             * Set the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
                             * 
                             * @param resBookDesigCode
                             */
                            public void setResBookDesigCode(
                                    String resBookDesigCode) {
                                this.resBookDesigCode = resBookDesigCode;
                            }

                            /** 
                             * Get the 'OwningCarrier' attribute value. "OwningCarrier" is used to return the code of the airline that owns the flight, which can be different to the operator.
                             * 
                             * @return value
                             */
                            public String getOwningCarrier() {
                                return owningCarrier;
                            }

                            /** 
                             * Set the 'OwningCarrier' attribute value. "OwningCarrier" is used to return the code of the airline that owns the flight, which can be different to the operator.
                             * 
                             * @param owningCarrier
                             */
                            public void setOwningCarrier(String owningCarrier) {
                                this.owningCarrier = owningCarrier;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirlinePricing" minOccurs="0" maxOccurs="1">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OperatingAirlinePricing implements
                            Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the operating airline code used for pricing associated with the particular flight segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the operating airline code used for pricing associated with the particular flight segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirlineRecord" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OperatingAirlineRecord implements
                            Serializable
                        {
                            private String ID;

                            /** 
                             * Get the 'ID' attribute value. "ID" is used to return the operating airline record locator if applicable.
                             * 
                             * @return value
                             */
                            public String getID() {
                                return ID;
                            }

                            /** 
                             * Set the 'ID' attribute value. "ID" is used to return the operating airline record locator if applicable.
                             * 
                             * @param ID
                             */
                            public void setID(String ID) {
                                this.ID = ID;
                            }
                        }
                        /** 
                         * Disclosure carrier field (DCX) added. Optional data from DSS. If the DCX is not available, whole section is excluded from the RS.
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisclosureCarrier" minOccurs="0" maxOccurs="1">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Banner" minOccurs="0" maxOccurs="1"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="DOT"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DisclosureCarrier implements
                            Serializable
                        {
                            private String banner;
                            private String code;
                            private Boolean DOT;

                            /** 
                             * Get the 'Banner' element value. "DisclosureCarrier/Banner" is used to return the disclosure carrier name
                             * 
                             * @return value
                             */
                            public String getBanner() {
                                return banner;
                            }

                            /** 
                             * Set the 'Banner' element value. "DisclosureCarrier/Banner" is used to return the disclosure carrier name
                             * 
                             * @param banner
                             */
                            public void setBanner(String banner) {
                                this.banner = banner;
                            }

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the disclosure carrier code associated with the particular vehicle segment
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the disclosure carrier code associated with the particular vehicle segment
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'DOT' attribute value. "DOT" is optional data from DSS (DOT) it determines Banner appearance
                             * 
                             * @return value
                             */
                            public Boolean getDOT() {
                                return DOT;
                            }

                            /** 
                             * Set the 'DOT' attribute value. "DOT" is optional data from DSS (DOT) it determines Banner appearance
                             * 
                             * @param DOT
                             */
                            public void setDOT(Boolean DOT) {
                                this.DOT = DOT;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Terminal"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TerminalCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;
                            private String terminal;
                            private String terminalCode;

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the departure airport code.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the departure airport code.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'Terminal' attribute value. "Terminal" is used to return the departure airport terminal.
                             * 
                             * @return value
                             */
                            public String getTerminal() {
                                return terminal;
                            }

                            /** 
                             * Set the 'Terminal' attribute value. "Terminal" is used to return the departure airport terminal.
                             * 
                             * @param terminal
                             */
                            public void setTerminal(String terminal) {
                                this.terminal = terminal;
                            }

                            /** 
                             * Get the 'TerminalCode' attribute value. "TerminalCode" is used to return the departure airport terminal code.
                             * 
                             * @return value
                             */
                            public String getTerminalCode() {
                                return terminalCode;
                            }

                            /** 
                             * Set the 'TerminalCode' attribute value. "TerminalCode" is used to return the departure airport terminal code.
                             * 
                             * @param terminalCode
                             */
                            public void setTerminalCode(String terminalCode) {
                                this.terminalCode = terminalCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SupplierRef" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SupplierRef implements Serializable
                        {
                            private String ID;

                            /** 
                             * Get the 'ID' attribute value. "ID" is used to return the supplier record locator if applicable.
                             * 
                             * @return value
                             */
                            public String getID() {
                                return ID;
                            }

                            /** 
                             * Set the 'ID' attribute value. "ID" is used to return the supplier record locator if applicable.
                             * 
                             * @param ID
                             */
                            public void setID(String ID) {
                                this.ID = ID;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="SabreCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ShortName"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Lang"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Cabin implements Serializable
                        {
                            private String code;
                            private String sabreCode;
                            private String name;
                            private String shortName;
                            private String lang;

                            /** 
                             * Get the 'Code' attribute value. Reservation Booking Designator code
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. Reservation Booking Designator code
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'SabreCode' attribute value. Reservation Booking Designator sabre code
                             * 
                             * @return value
                             */
                            public String getSabreCode() {
                                return sabreCode;
                            }

                            /** 
                             * Set the 'SabreCode' attribute value. Reservation Booking Designator sabre code
                             * 
                             * @param sabreCode
                             */
                            public void setSabreCode(String sabreCode) {
                                this.sabreCode = sabreCode;
                            }

                            /** 
                             * Get the 'Name' attribute value. Long name of the Reservation booking designator. Example: Premium Economy 
                             * 
                             * @return value
                             */
                            public String getName() {
                                return name;
                            }

                            /** 
                             * Set the 'Name' attribute value. Long name of the Reservation booking designator. Example: Premium Economy 
                             * 
                             * @param name
                             */
                            public void setName(String name) {
                                this.name = name;
                            }

                            /** 
                             * Get the 'ShortName' attribute value. Short name of the Reservation booking designator. Example: PR ECON
                             * 
                             * @return value
                             */
                            public String getShortName() {
                                return shortName;
                            }

                            /** 
                             * Set the 'ShortName' attribute value. Short name of the Reservation booking designator. Example: PR ECON
                             * 
                             * @param shortName
                             */
                            public void setShortName(String shortName) {
                                this.shortName = shortName;
                            }

                            /** 
                             * Get the 'Lang' attribute value. Language of the names
                             * 
                             * @return value
                             */
                            public String getLang() {
                                return lang;
                            }

                            /** 
                             * Set the 'Lang' attribute value. Language of the names
                             * 
                             * @param lang
                             */
                            public void setLang(String lang) {
                                this.lang = lang;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hotel" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BasicPropertyInfo" minOccurs="0">
                     *         &lt;!-- Reference to inner class BasicPropertyInfo -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Customer" minOccurs="0">
                     *         &lt;!-- Reference to inner class Customer -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Guarantee" minOccurs="0"/>
                     *       &lt;xs:element name="POS" minOccurs="0">
                     *         &lt;!-- Reference to inner class POS -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="RoomRates" minOccurs="0">
                     *         &lt;!-- Reference to inner class RoomRates -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SpecialPrefs" minOccurs="0">
                     *         &lt;!-- Reference to inner class SpecialPrefs -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="TimeSpan" minOccurs="0">
                     *         &lt;!-- Reference to inner class TimeSpan -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberOfUnits"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Hotel implements Serializable
                    {
                        private BasicPropertyInfo basicPropertyInfo;
                        private Customer customer;
                        private String guarantee;
                        private POS POS1;
                        private RoomRates roomRates;
                        private SpecialPrefs specialPrefs;
                        private List<String> textList = new ArrayList<String>();
                        private TimeSpan timeSpan;
                        private String dayOfWeekInd;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String numberInParty;
                        private String numberOfUnits;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;
                        private String id;

                        /** 
                         * Get the 'BasicPropertyInfo' element value.
                         * 
                         * @return value
                         */
                        public BasicPropertyInfo getBasicPropertyInfo() {
                            return basicPropertyInfo;
                        }

                        /** 
                         * Set the 'BasicPropertyInfo' element value.
                         * 
                         * @param basicPropertyInfo
                         */
                        public void setBasicPropertyInfo(
                                BasicPropertyInfo basicPropertyInfo) {
                            this.basicPropertyInfo = basicPropertyInfo;
                        }

                        /** 
                         * Get the 'Customer' element value.
                         * 
                         * @return value
                         */
                        public Customer getCustomer() {
                            return customer;
                        }

                        /** 
                         * Set the 'Customer' element value.
                         * 
                         * @param customer
                         */
                        public void setCustomer(Customer customer) {
                            this.customer = customer;
                        }

                        /** 
                         * Get the 'Guarantee' element value. "Guarantee" is used to return guarantee-related information.
                         * 
                         * @return value
                         */
                        public String getGuarantee() {
                            return guarantee;
                        }

                        /** 
                         * Set the 'Guarantee' element value. "Guarantee" is used to return guarantee-related information.
                         * 
                         * @param guarantee
                         */
                        public void setGuarantee(String guarantee) {
                            this.guarantee = guarantee;
                        }

                        /** 
                         * Get the 'POS' element value.
                         * 
                         * @return value
                         */
                        public POS getPOS1() {
                            return POS1;
                        }

                        /** 
                         * Set the 'POS' element value.
                         * 
                         * @param POS1
                         */
                        public void setPOS1(POS POS1) {
                            this.POS1 = POS1;
                        }

                        /** 
                         * Get the 'RoomRates' element value.
                         * 
                         * @return value
                         */
                        public RoomRates getRoomRates() {
                            return roomRates;
                        }

                        /** 
                         * Set the 'RoomRates' element value.
                         * 
                         * @param roomRates
                         */
                        public void setRoomRates(RoomRates roomRates) {
                            this.roomRates = roomRates;
                        }

                        /** 
                         * Get the 'SpecialPrefs' element value.
                         * 
                         * @return value
                         */
                        public SpecialPrefs getSpecialPrefs() {
                            return specialPrefs;
                        }

                        /** 
                         * Set the 'SpecialPrefs' element value.
                         * 
                         * @param specialPrefs
                         */
                        public void setSpecialPrefs(SpecialPrefs specialPrefs) {
                            this.specialPrefs = specialPrefs;
                        }

                        /** 
                         * Get the list of 'Text' element items. "Text" is used to return miscellaneous hotel-related information.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. "Text" is used to return miscellaneous hotel-related information.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }

                        /** 
                         * Get the 'TimeSpan' element value.
                         * 
                         * @return value
                         */
                        public TimeSpan getTimeSpan() {
                            return timeSpan;
                        }

                        /** 
                         * Set the 'TimeSpan' element value.
                         * 
                         * @param timeSpan
                         */
                        public void setTimeSpan(TimeSpan timeSpan) {
                            this.timeSpan = timeSpan;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'NumberOfUnits' attribute value. "NumberOfUnits" is used to return the number of rooms associated with the particular hotel segment.
                         * 
                         * @return value
                         */
                        public String getNumberOfUnits() {
                            return numberOfUnits;
                        }

                        /** 
                         * Set the 'NumberOfUnits' attribute value. "NumberOfUnits" is used to return the number of rooms associated with the particular hotel segment.
                         * 
                         * @param numberOfUnits
                         */
                        public void setNumberOfUnits(String numberOfUnits) {
                            this.numberOfUnits = numberOfUnits;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value. "Type" is used to return the segment type .
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. "Type" is used to return the segment type .
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. IsPast attribute is populated based on Hotel - TimeSpan - @End, Hotel - BasicPropertyInfo - @HotelCityCode.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. IsPast attribute is populated based on Hotel - TimeSpan - @End, Hotel - BasicPropertyInfo - @HotelCityCode.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Hotel
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Hotel
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicPropertyInfo" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Address" minOccurs="0">
                         *         &lt;!-- Reference to inner class Address -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="CancelPenalty" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class CancelPenalty -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="DirectConnect" minOccurs="0"/>
                         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
                         *         &lt;!-- Reference to inner class ContactNumbers -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ChainCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="HotelCityCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="HotelCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="HotelName"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceCityName"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BasicPropertyInfo implements
                            Serializable
                        {
                            private Address address;
                            private List<CancelPenalty> cancelPenaltyList = new ArrayList<CancelPenalty>();
                            private List<String> confirmationNumberList = new ArrayList<String>();
                            private String directConnect;
                            private ContactNumbers contactNumbers;
                            private String chainCode;
                            private String hotelCityCode;
                            private String hotelCode;
                            private String hotelName;
                            private String serviceCityName;

                            /** 
                             * Get the 'Address' element value.
                             * 
                             * @return value
                             */
                            public Address getAddress() {
                                return address;
                            }

                            /** 
                             * Set the 'Address' element value.
                             * 
                             * @param address
                             */
                            public void setAddress(Address address) {
                                this.address = address;
                            }

                            /** 
                             * Get the list of 'CancelPenalty' element items.
                             * 
                             * @return list
                             */
                            public List<CancelPenalty> getCancelPenaltyList() {
                                return cancelPenaltyList;
                            }

                            /** 
                             * Set the list of 'CancelPenalty' element items.
                             * 
                             * @param list
                             */
                            public void setCancelPenaltyList(
                                    List<CancelPenalty> list) {
                                cancelPenaltyList = list;
                            }

                            /** 
                             * Get the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the booking confirmation number associated with the particular hotel reservation.
                             * 
                             * @return list
                             */
                            public List<String> getConfirmationNumberList() {
                                return confirmationNumberList;
                            }

                            /** 
                             * Set the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the booking confirmation number associated with the particular hotel reservation.
                             * 
                             * @param list
                             */
                            public void setConfirmationNumberList(
                                    List<String> list) {
                                confirmationNumberList = list;
                            }

                            /** 
                             * Get the 'DirectConnect' element value. "DirectConnect" is used to return miscellaneous direct connect-related information
                             * 
                             * @return value
                             */
                            public String getDirectConnect() {
                                return directConnect;
                            }

                            /** 
                             * Set the 'DirectConnect' element value. "DirectConnect" is used to return miscellaneous direct connect-related information
                             * 
                             * @param directConnect
                             */
                            public void setDirectConnect(String directConnect) {
                                this.directConnect = directConnect;
                            }

                            /** 
                             * Get the 'ContactNumbers' element value.
                             * 
                             * @return value
                             */
                            public ContactNumbers getContactNumbers() {
                                return contactNumbers;
                            }

                            /** 
                             * Set the 'ContactNumbers' element value.
                             * 
                             * @param contactNumbers
                             */
                            public void setContactNumbers(
                                    ContactNumbers contactNumbers) {
                                this.contactNumbers = contactNumbers;
                            }

                            /** 
                             * Get the 'ChainCode' attribute value. "ChainCode" is used to return the hotel chain code associated with the particular hotel reservation.
                             * 
                             * @return value
                             */
                            public String getChainCode() {
                                return chainCode;
                            }

                            /** 
                             * Set the 'ChainCode' attribute value. "ChainCode" is used to return the hotel chain code associated with the particular hotel reservation.
                             * 
                             * @param chainCode
                             */
                            public void setChainCode(String chainCode) {
                                this.chainCode = chainCode;
                            }

                            /** 
                             * Get the 'HotelCityCode' attribute value. "HotelCityCode" is used to return the hotel location code associated with the particular hotel reservation.
                             * 
                             * @return value
                             */
                            public String getHotelCityCode() {
                                return hotelCityCode;
                            }

                            /** 
                             * Set the 'HotelCityCode' attribute value. "HotelCityCode" is used to return the hotel location code associated with the particular hotel reservation.
                             * 
                             * @param hotelCityCode
                             */
                            public void setHotelCityCode(String hotelCityCode) {
                                this.hotelCityCode = hotelCityCode;
                            }

                            /** 
                             * Get the 'HotelCode' attribute value. "HotelCode" is used to return the hotel property code associated with the particular hotel reservation.
                             * 
                             * @return value
                             */
                            public String getHotelCode() {
                                return hotelCode;
                            }

                            /** 
                             * Set the 'HotelCode' attribute value. "HotelCode" is used to return the hotel property code associated with the particular hotel reservation.
                             * 
                             * @param hotelCode
                             */
                            public void setHotelCode(String hotelCode) {
                                this.hotelCode = hotelCode;
                            }

                            /** 
                             * Get the 'HotelName' attribute value. "HotelName" is used to return the hotel name associated with the particular hotel reservation.
                             * 
                             * @return value
                             */
                            public String getHotelName() {
                                return hotelName;
                            }

                            /** 
                             * Set the 'HotelName' attribute value. "HotelName" is used to return the hotel name associated with the particular hotel reservation.
                             * 
                             * @param hotelName
                             */
                            public void setHotelName(String hotelName) {
                                this.hotelName = hotelName;
                            }

                            /** 
                             * Get the 'ServiceCityName' attribute value. "ServiceCityName" is used to return the hotel location code associated with the particular hotel reservation.
                             * 
                             * @return value
                             */
                            public String getServiceCityName() {
                                return serviceCityName;
                            }

                            /** 
                             * Set the 'ServiceCityName' attribute value. "ServiceCityName" is used to return the hotel location code associated with the particular hotel reservation.
                             * 
                             * @param serviceCityName
                             */
                            public void setServiceCityName(
                                    String serviceCityName) {
                                this.serviceCityName = serviceCityName;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="3"/>
                             *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Address implements Serializable
                            {
                                private List<String> addressLineList = new ArrayList<String>();
                                private String countryCode;

                                /** 
                                 * Get the list of 'AddressLine' element items. "AddressLine" is used to return hotel address-related information.
                                 * 
                                 * @return list
                                 */
                                public List<String> getAddressLineList() {
                                    return addressLineList;
                                }

                                /** 
                                 * Set the list of 'AddressLine' element items. "AddressLine" is used to return hotel address-related information.
                                 * 
                                 * @param list
                                 */
                                public void setAddressLineList(List<String> list) {
                                    addressLineList = list;
                                }

                                /** 
                                 * Get the 'CountryCode' element value. "CountryCode" is used to return hotel's particular country code.
                                 * 
                                 * @return value
                                 */
                                public String getCountryCode() {
                                    return countryCode;
                                }

                                /** 
                                 * Set the 'CountryCode' element value. "CountryCode" is used to return hotel's particular country code.
                                 * 
                                 * @param countryCode
                                 */
                                public void setCountryCode(String countryCode) {
                                    this.countryCode = countryCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPenalty" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PolicyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class CancelPenalty implements
                                Serializable
                            {
                                private String policyCode;

                                /** 
                                 * Get the 'PolicyCode' attribute value. "PolicyCode" is used to return cancellation penalty information associated with the particular hotel reservation.
                                 * 
                                 * @return value
                                 */
                                public String getPolicyCode() {
                                    return policyCode;
                                }

                                /** 
                                 * Set the 'PolicyCode' attribute value. "PolicyCode" is used to return cancellation penalty information associated with the particular hotel reservation.
                                 * 
                                 * @param policyCode
                                 */
                                public void setPolicyCode(String policyCode) {
                                    this.policyCode = policyCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="ContactNumber" minOccurs="0" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class ContactNumber -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class ContactNumbers implements
                                Serializable
                            {
                                private List<ContactNumber> contactNumberList = new ArrayList<ContactNumber>();

                                /** 
                                 * Get the list of 'ContactNumber' element items.
                                 * 
                                 * @return list
                                 */
                                public List<ContactNumber> getContactNumberList() {
                                    return contactNumberList;
                                }

                                /** 
                                 * Set the list of 'ContactNumber' element items.
                                 * 
                                 * @param list
                                 */
                                public void setContactNumberList(
                                        List<ContactNumber> list) {
                                    contactNumberList = list;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Fax"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class ContactNumber implements
                                    Serializable
                                {
                                    private String fax;
                                    private String phone;

                                    /** 
                                     * Get the 'Fax' attribute value. "Fax" is used to return the hotel's fax number.
                                     * 
                                     * @return value
                                     */
                                    public String getFax() {
                                        return fax;
                                    }

                                    /** 
                                     * Set the 'Fax' attribute value. "Fax" is used to return the hotel's fax number.
                                     * 
                                     * @param fax
                                     */
                                    public void setFax(String fax) {
                                        this.fax = fax;
                                    }

                                    /** 
                                     * Get the 'Phone' attribute value. "Phone" is used to return the hotel's telephone number.
                                     * 
                                     * @return value
                                     */
                                    public String getPhone() {
                                        return phone;
                                    }

                                    /** 
                                     * Set the 'Phone' attribute value. "Phone" is used to return the hotel's telephone number.
                                     * 
                                     * @param phone
                                     */
                                    public void setPhone(String phone) {
                                        this.phone = phone;
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Corporate" minOccurs="0">
                         *         &lt;!-- Reference to inner class Corporate -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class CustLoyalty -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="ID" minOccurs="0">
                         *         &lt;!-- Reference to inner class ID -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Customer implements Serializable
                        {
                            private Corporate corporate;
                            private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
                            private ID ID1;
                            private List<String> reserveUnderNameList = new ArrayList<String>();

                            /** 
                             * Get the 'Corporate' element value.
                             * 
                             * @return value
                             */
                            public Corporate getCorporate() {
                                return corporate;
                            }

                            /** 
                             * Set the 'Corporate' element value.
                             * 
                             * @param corporate
                             */
                            public void setCorporate(Corporate corporate) {
                                this.corporate = corporate;
                            }

                            /** 
                             * Get the list of 'CustLoyalty' element items.
                             * 
                             * @return list
                             */
                            public List<CustLoyalty> getCustLoyaltyList() {
                                return custLoyaltyList;
                            }

                            /** 
                             * Set the list of 'CustLoyalty' element items.
                             * 
                             * @param list
                             */
                            public void setCustLoyaltyList(
                                    List<CustLoyalty> list) {
                                custLoyaltyList = list;
                            }

                            /** 
                             * Get the 'ID' element value.
                             * 
                             * @return value
                             */
                            public ID getID1() {
                                return ID1;
                            }

                            /** 
                             * Set the 'ID' element value.
                             * 
                             * @param ID1
                             */
                            public void setID1(ID ID1) {
                                this.ID1 = ID1;
                            }

                            /** 
                             * Get the list of 'ReserveUnderName' element items. "ReserveUnderName" is used to return name/reservation-related information.
                             * 
                             * @return list
                             */
                            public List<String> getReserveUnderNameList() {
                                return reserveUnderNameList;
                            }

                            /** 
                             * Set the list of 'ReserveUnderName' element items. "ReserveUnderName" is used to return name/reservation-related information.
                             * 
                             * @param list
                             */
                            public void setReserveUnderNameList(
                                    List<String> list) {
                                reserveUnderNameList = list;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="ID" minOccurs="0" maxOccurs="unbounded"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Corporate implements
                                Serializable
                            {
                                private List<String> IDList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'ID' element items. "ID" is used to return the corporate ID associated with the particular hotel reservation if applicable.
                                 * 
                                 * @return list
                                 */
                                public List<String> getIDList() {
                                    return IDList;
                                }

                                /** 
                                 * Set the list of 'ID' element items. "ID" is used to return the corporate ID associated with the particular hotel reservation if applicable.
                                 * 
                                 * @param list
                                 */
                                public void setIDList(List<String> list) {
                                    IDList = list;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class CustLoyalty implements
                                Serializable
                            {
                                private String membershipID;

                                /** 
                                 * Get the 'MembershipID' attribute value. "MembershipID" is used to return the frequent flyer number associated with the particular hotel reservation if applicable.
                                 * 
                                 * @return value
                                 */
                                public String getMembershipID() {
                                    return membershipID;
                                }

                                /** 
                                 * Set the 'MembershipID' attribute value. "MembershipID" is used to return the frequent flyer number associated with the particular hotel reservation if applicable.
                                 * 
                                 * @param membershipID
                                 */
                                public void setMembershipID(String membershipID) {
                                    this.membershipID = membershipID;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ID" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Number" minOccurs="0" maxOccurs="unbounded"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class ID implements Serializable
                            {
                                private List<String> numberList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'Number' element items. "Number" is used to return the Number associated with the particular hotel reservation if applicable.
                                 * 
                                 * @return list
                                 */
                                public List<String> getNumberList() {
                                    return numberList;
                                }

                                /** 
                                 * Set the list of 'Number' element items. "Number" is used to return the Number associated with the particular hotel reservation if applicable.
                                 * 
                                 * @param list
                                 */
                                public void setNumberList(List<String> list) {
                                    numberList = list;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Source" minOccurs="0">
                         *         &lt;!-- Reference to inner class Source -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class POS implements Serializable
                        {
                            private Source source;

                            /** 
                             * Get the 'Source' element value.
                             * 
                             * @return value
                             */
                            public Source getSource() {
                                return source;
                            }

                            /** 
                             * Set the 'Source' element value.
                             * 
                             * @param source
                             */
                            public void setSource(Source source) {
                                this.source = source;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="RequestorID" minOccurs="0" maxOccurs="unbounded"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Source implements Serializable
                            {
                                private List<String> requestorIDList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'RequestorID' element items. "RequestorID" is used to return the ID of the individual who created the particular vehicle reservation.
                                 * 
                                 * @return list
                                 */
                                public List<String> getRequestorIDList() {
                                    return requestorIDList;
                                }

                                /** 
                                 * Set the list of 'RequestorID' element items. "RequestorID" is used to return the ID of the individual who created the particular vehicle reservation.
                                 * 
                                 * @param list
                                 */
                                public void setRequestorIDList(List<String> list) {
                                    requestorIDList = list;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomRates" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Commission" minOccurs="0">
                         *         &lt;!-- Reference to inner class Commission -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Rate" minOccurs="0">
                         *         &lt;!-- Reference to inner class Rate -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class RoomRates implements Serializable
                        {
                            private Commission commission;
                            private Rate rate;

                            /** 
                             * Get the 'Commission' element value.
                             * 
                             * @return value
                             */
                            public Commission getCommission() {
                                return commission;
                            }

                            /** 
                             * Set the 'Commission' element value.
                             * 
                             * @param commission
                             */
                            public void setCommission(Commission commission) {
                                this.commission = commission;
                            }

                            /** 
                             * Get the 'Rate' element value.
                             * 
                             * @return value
                             */
                            public Rate getRate() {
                                return rate;
                            }

                            /** 
                             * Set the 'Rate' element value.
                             * 
                             * @param rate
                             */
                            public void setRate(Rate rate) {
                                this.rate = rate;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:simpleContent>
                             *       &lt;xs:extension base="xs:string">
                             *         &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *         &lt;xs:attribute type="xs:boolean" use="optional" name="NonCommission"/>
                             *         &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                             *       &lt;/xs:extension>
                             *     &lt;/xs:simpleContent>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Commission implements
                                Serializable
                            {
                                private String string;
                                private String amount;
                                private Boolean nonCommission;
                                private String percent;

                                /** 
                                 * Get the extension value.
                                 * 
                                 * @return value
                                 */
                                public String getString() {
                                    return string;
                                }

                                /** 
                                 * Set the extension value.
                                 * 
                                 * @param string
                                 */
                                public void setString(String string) {
                                    this.string = string;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. "Amount" is used to return the commission amount associated with the particular hotel reservation if applicable.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. "Amount" is used to return the commission amount associated with the particular hotel reservation if applicable.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'NonCommission' attribute value. "NonCommission" is used to return non-commission-related information.
                                 * 
                                 * @return value
                                 */
                                public Boolean getNonCommission() {
                                    return nonCommission;
                                }

                                /** 
                                 * Set the 'NonCommission' attribute value. "NonCommission" is used to return non-commission-related information.
                                 * 
                                 * @param nonCommission
                                 */
                                public void setNonCommission(
                                        Boolean nonCommission) {
                                    this.nonCommission = nonCommission;
                                }

                                /** 
                                 * Get the 'Percent' attribute value. "Percent" is used to return the commission percentage associated with the particular hotel reservation if applicable.
                                 * 
                                 * @return value
                                 */
                                public String getPercent() {
                                    return percent;
                                }

                                /** 
                                 * Set the 'Percent' attribute value. "Percent" is used to return the commission percentage associated with the particular hotel reservation if applicable.
                                 * 
                                 * @param percent
                                 */
                                public void setPercent(String percent) {
                                    this.percent = percent;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rate" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="AdditionalGuestAmounts" minOccurs="0">
                             *         &lt;!-- Reference to inner class AdditionalGuestAmounts -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="HotelRateDescripton" minOccurs="0" maxOccurs="1">
                             *         &lt;!-- Reference to inner class HotelRateDescripton -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="HotelTotalPricing" minOccurs="0" maxOccurs="1">
                             *         &lt;!-- Reference to inner class HotelTotalPricing -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="RateAccessCodeBooked" minOccurs="0" maxOccurs="1">
                             *         &lt;!-- Reference to inner class RateAccessCodeBooked -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element type="xs:string" name="RateAccessCodeRequested" minOccurs="0" maxOccurs="1"/>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="DCS_AuxRateCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="RoomTypeCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Rate implements Serializable
                            {
                                private AdditionalGuestAmounts additionalGuestAmounts;
                                private HotelRateDescripton hotelRateDescripton;
                                private HotelTotalPricing hotelTotalPricing;
                                private RateAccessCodeBooked rateAccessCodeBooked;
                                private String rateAccessCodeRequested;
                                private String amount;
                                private String currencyCode;
                                private String DCSAuxRateCode;
                                private String roomTypeCode;

                                /** 
                                 * Get the 'AdditionalGuestAmounts' element value.
                                 * 
                                 * @return value
                                 */
                                public AdditionalGuestAmounts getAdditionalGuestAmounts() {
                                    return additionalGuestAmounts;
                                }

                                /** 
                                 * Set the 'AdditionalGuestAmounts' element value.
                                 * 
                                 * @param additionalGuestAmounts
                                 */
                                public void setAdditionalGuestAmounts(
                                        AdditionalGuestAmounts additionalGuestAmounts) {
                                    this.additionalGuestAmounts = additionalGuestAmounts;
                                }

                                /** 
                                 * Get the 'HotelRateDescripton' element value.
                                 * 
                                 * @return value
                                 */
                                public HotelRateDescripton getHotelRateDescripton() {
                                    return hotelRateDescripton;
                                }

                                /** 
                                 * Set the 'HotelRateDescripton' element value.
                                 * 
                                 * @param hotelRateDescripton
                                 */
                                public void setHotelRateDescripton(
                                        HotelRateDescripton hotelRateDescripton) {
                                    this.hotelRateDescripton = hotelRateDescripton;
                                }

                                /** 
                                 * Get the 'HotelTotalPricing' element value.
                                 * 
                                 * @return value
                                 */
                                public HotelTotalPricing getHotelTotalPricing() {
                                    return hotelTotalPricing;
                                }

                                /** 
                                 * Set the 'HotelTotalPricing' element value.
                                 * 
                                 * @param hotelTotalPricing
                                 */
                                public void setHotelTotalPricing(
                                        HotelTotalPricing hotelTotalPricing) {
                                    this.hotelTotalPricing = hotelTotalPricing;
                                }

                                /** 
                                 * Get the 'RateAccessCodeBooked' element value.
                                 * 
                                 * @return value
                                 */
                                public RateAccessCodeBooked getRateAccessCodeBooked() {
                                    return rateAccessCodeBooked;
                                }

                                /** 
                                 * Set the 'RateAccessCodeBooked' element value.
                                 * 
                                 * @param rateAccessCodeBooked
                                 */
                                public void setRateAccessCodeBooked(
                                        RateAccessCodeBooked rateAccessCodeBooked) {
                                    this.rateAccessCodeBooked = rateAccessCodeBooked;
                                }

                                /** 
                                 * Get the 'RateAccessCodeRequested' element value. "RateAccessCodeRequested" is used to return rate access code requested details for a particular hotel if applicable.
                                 * 
                                 * @return value
                                 */
                                public String getRateAccessCodeRequested() {
                                    return rateAccessCodeRequested;
                                }

                                /** 
                                 * Set the 'RateAccessCodeRequested' element value. "RateAccessCodeRequested" is used to return rate access code requested details for a particular hotel if applicable.
                                 * 
                                 * @param rateAccessCodeRequested
                                 */
                                public void setRateAccessCodeRequested(
                                        String rateAccessCodeRequested) {
                                    this.rateAccessCodeRequested = rateAccessCodeRequested;
                                }

                                /** 
                                 * Get the 'Amount' attribute value. "Amount" is used to return the rate amount.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value. "Amount" is used to return the rate amount.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the currency code associated with the rate amount.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the currency code associated with the rate amount.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'DCS_AuxRateCode' attribute value. "DCS_AuxRateCode" is used to return the DCS rate code associated with the particular hotel reservation if applicable.
                                 * 
                                 * @return value
                                 */
                                public String getDCSAuxRateCode() {
                                    return DCSAuxRateCode;
                                }

                                /** 
                                 * Set the 'DCS_AuxRateCode' attribute value. "DCS_AuxRateCode" is used to return the DCS rate code associated with the particular hotel reservation if applicable.
                                 * 
                                 * @param DCSAuxRateCode
                                 */
                                public void setDCSAuxRateCode(
                                        String DCSAuxRateCode) {
                                    this.DCSAuxRateCode = DCSAuxRateCode;
                                }

                                /** 
                                 * Get the 'RoomTypeCode' attribute value. "RoomTypeCode" is used to return the rate type code associated with the particular hotel reservation.
                                 * 
                                 * @return value
                                 */
                                public String getRoomTypeCode() {
                                    return roomTypeCode;
                                }

                                /** 
                                 * Set the 'RoomTypeCode' attribute value. "RoomTypeCode" is used to return the rate type code associated with the particular hotel reservation.
                                 * 
                                 * @param roomTypeCode
                                 */
                                public void setRoomTypeCode(String roomTypeCode) {
                                    this.roomTypeCode = roomTypeCode;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalGuestAmounts" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element type="xs:string" name="NumCribs" minOccurs="0" maxOccurs="unbounded"/>
                                 *       &lt;xs:element type="xs:string" name="NumExtraPersons" minOccurs="0" maxOccurs="unbounded"/>
                                 *       &lt;xs:element type="xs:string" name="NumRollaways" minOccurs="0" maxOccurs="unbounded"/>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class AdditionalGuestAmounts
                                    implements Serializable
                                {
                                    private List<String> numCribList = new ArrayList<String>();
                                    private List<String> numExtraPersonList = new ArrayList<String>();
                                    private List<String> numRollawayList = new ArrayList<String>();

                                    /** 
                                     * Get the list of 'NumCribs' element items. "NumCribs" is used to return the number of cribs associated with the particular hotel reservation if applicable.
                                     * 
                                     * @return list
                                     */
                                    public List<String> getNumCribList() {
                                        return numCribList;
                                    }

                                    /** 
                                     * Set the list of 'NumCribs' element items. "NumCribs" is used to return the number of cribs associated with the particular hotel reservation if applicable.
                                     * 
                                     * @param list
                                     */
                                    public void setNumCribList(List<String> list) {
                                        numCribList = list;
                                    }

                                    /** 
                                     * Get the list of 'NumExtraPersons' element items. "NumExtraPersons" is used to return the number of extra persons associated with the particular hotel reservation if applicable.
                                     * 
                                     * @return list
                                     */
                                    public List<String> getNumExtraPersonList() {
                                        return numExtraPersonList;
                                    }

                                    /** 
                                     * Set the list of 'NumExtraPersons' element items. "NumExtraPersons" is used to return the number of extra persons associated with the particular hotel reservation if applicable.
                                     * 
                                     * @param list
                                     */
                                    public void setNumExtraPersonList(
                                            List<String> list) {
                                        numExtraPersonList = list;
                                    }

                                    /** 
                                     * Get the list of 'NumRollaways' element items. "NumRollaways" is used to return the number of rollaways associated with the particular hotel reservation if applicable.
                                     * 
                                     * @return list
                                     */
                                    public List<String> getNumRollawayList() {
                                        return numRollawayList;
                                    }

                                    /** 
                                     * Set the list of 'NumRollaways' element items. "NumRollaways" is used to return the number of rollaways associated with the particular hotel reservation if applicable.
                                     * 
                                     * @param list
                                     */
                                    public void setNumRollawayList(
                                            List<String> list) {
                                        numRollawayList = list;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelRateDescripton" minOccurs="0" maxOccurs="1">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="RateDescriptions">
                                 *         &lt;xs:complexType>
                                 *           &lt;xs:sequence>
                                 *             &lt;xs:element name="RateDescription" minOccurs="0" maxOccurs="31">
                                 *               &lt;!-- Reference to inner class RateDescription -->
                                 *             &lt;/xs:element>
                                 *           &lt;/xs:sequence>
                                 *         &lt;/xs:complexType>
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element type="xs:string" name="CancelationsPolicy" minOccurs="0" maxOccurs="1"/>
                                 *       &lt;xs:element type="xs:string" name="GuaranteePolicy" minOccurs="0" maxOccurs="1"/>
                                 *       &lt;xs:element type="xs:string" name="DespositPolicy" minOccurs="0" maxOccurs="1"/>
                                 *       &lt;xs:element type="xs:string" name="LateArrivalPolicy" minOccurs="0" maxOccurs="1"/>
                                 *       &lt;xs:element name="Additionals" minOccurs="0" maxOccurs="1">
                                 *         &lt;!-- Reference to inner class Additionals -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class HotelRateDescripton
                                    implements Serializable
                                {
                                    private List<RateDescription> rateDescriptionList = new ArrayList<RateDescription>();
                                    private String cancelationsPolicy;
                                    private String guaranteePolicy;
                                    private String despositPolicy;
                                    private String lateArrivalPolicy;
                                    private Additionals additionals;

                                    /** 
                                     * Get the list of 'RateDescription' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<RateDescription> getRateDescriptionList() {
                                        return rateDescriptionList;
                                    }

                                    /** 
                                     * Set the list of 'RateDescription' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setRateDescriptionList(
                                            List<RateDescription> list) {
                                        rateDescriptionList = list;
                                    }

                                    /** 
                                     * Get the 'CancelationsPolicy' element value.
                                     * 
                                     * @return value
                                     */
                                    public String getCancelationsPolicy() {
                                        return cancelationsPolicy;
                                    }

                                    /** 
                                     * Set the 'CancelationsPolicy' element value.
                                     * 
                                     * @param cancelationsPolicy
                                     */
                                    public void setCancelationsPolicy(
                                            String cancelationsPolicy) {
                                        this.cancelationsPolicy = cancelationsPolicy;
                                    }

                                    /** 
                                     * Get the 'GuaranteePolicy' element value.
                                     * 
                                     * @return value
                                     */
                                    public String getGuaranteePolicy() {
                                        return guaranteePolicy;
                                    }

                                    /** 
                                     * Set the 'GuaranteePolicy' element value.
                                     * 
                                     * @param guaranteePolicy
                                     */
                                    public void setGuaranteePolicy(
                                            String guaranteePolicy) {
                                        this.guaranteePolicy = guaranteePolicy;
                                    }

                                    /** 
                                     * Get the 'DespositPolicy' element value.
                                     * 
                                     * @return value
                                     */
                                    public String getDespositPolicy() {
                                        return despositPolicy;
                                    }

                                    /** 
                                     * Set the 'DespositPolicy' element value.
                                     * 
                                     * @param despositPolicy
                                     */
                                    public void setDespositPolicy(
                                            String despositPolicy) {
                                        this.despositPolicy = despositPolicy;
                                    }

                                    /** 
                                     * Get the 'LateArrivalPolicy' element value.
                                     * 
                                     * @return value
                                     */
                                    public String getLateArrivalPolicy() {
                                        return lateArrivalPolicy;
                                    }

                                    /** 
                                     * Set the 'LateArrivalPolicy' element value.
                                     * 
                                     * @param lateArrivalPolicy
                                     */
                                    public void setLateArrivalPolicy(
                                            String lateArrivalPolicy) {
                                        this.lateArrivalPolicy = lateArrivalPolicy;
                                    }

                                    /** 
                                     * Get the 'Additionals' element value.
                                     * 
                                     * @return value
                                     */
                                    public Additionals getAdditionals() {
                                        return additionals;
                                    }

                                    /** 
                                     * Set the 'Additionals' element value.
                                     * 
                                     * @param additionals
                                     */
                                    public void setAdditionals(
                                            Additionals additionals) {
                                        this.additionals = additionals;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateDescription" minOccurs="0" maxOccurs="31">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:string" name="Id"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class RateDescription
                                        implements Serializable
                                    {
                                        private String string;
                                        private String id;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'Id' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getId() {
                                            return id;
                                        }

                                        /** 
                                         * Set the 'Id' attribute value.
                                         * 
                                         * @param id
                                         */
                                        public void setId(String id) {
                                            this.id = id;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Additionals" minOccurs="0" maxOccurs="1">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="Additional" minOccurs="0" maxOccurs="99">
                                     *         &lt;!-- Reference to inner class Additional -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Additionals implements
                                        Serializable
                                    {
                                        private List<Additional> additionalList = new ArrayList<Additional>();

                                        /** 
                                         * Get the list of 'Additional' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<Additional> getAdditionalList() {
                                            return additionalList;
                                        }

                                        /** 
                                         * Set the list of 'Additional' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setAdditionalList(
                                                List<Additional> list) {
                                            additionalList = list;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Additional" minOccurs="0" maxOccurs="99">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:simpleContent>
                                         *       &lt;xs:extension base="xs:string">
                                         *         &lt;xs:attribute type="xs:string" name="Id"/>
                                         *       &lt;/xs:extension>
                                         *     &lt;/xs:simpleContent>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Additional
                                            implements Serializable
                                        {
                                            private String string;
                                            private String id;

                                            /** 
                                             * Get the extension value.
                                             * 
                                             * @return value
                                             */
                                            public String getString() {
                                                return string;
                                            }

                                            /** 
                                             * Set the extension value.
                                             * 
                                             * @param string
                                             */
                                            public void setString(String string) {
                                                this.string = string;
                                            }

                                            /** 
                                             * Get the 'Id' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getId() {
                                                return id;
                                            }

                                            /** 
                                             * Set the 'Id' attribute value.
                                             * 
                                             * @param id
                                             */
                                            public void setId(String id) {
                                                this.id = id;
                                            }
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelTotalPricing" minOccurs="0" maxOccurs="1">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="TotalTax" minOccurs="0" maxOccurs="1">
                                 *         &lt;!-- Reference to inner class TotalTax -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="TotalSurcharge" minOccurs="0" maxOccurs="1">
                                 *         &lt;!-- Reference to inner class TotalSurcharge -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="ApproximateTotal" minOccurs="0" maxOccurs="1">
                                 *         &lt;!-- Reference to inner class ApproximateTotal -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="RateChange" minOccurs="0" maxOccurs="8">
                                 *         &lt;!-- Reference to inner class RateChange -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Disclaimer" minOccurs="0" maxOccurs="2">
                                 *         &lt;!-- Reference to inner class Disclaimer -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class HotelTotalPricing implements
                                    Serializable
                                {
                                    private TotalTax totalTax;
                                    private TotalSurcharge totalSurcharge;
                                    private ApproximateTotal approximateTotal;
                                    private List<RateChange> rateChangeList = new ArrayList<RateChange>();
                                    private List<Disclaimer> disclaimerList = new ArrayList<Disclaimer>();

                                    /** 
                                     * Get the 'TotalTax' element value.
                                     * 
                                     * @return value
                                     */
                                    public TotalTax getTotalTax() {
                                        return totalTax;
                                    }

                                    /** 
                                     * Set the 'TotalTax' element value.
                                     * 
                                     * @param totalTax
                                     */
                                    public void setTotalTax(TotalTax totalTax) {
                                        this.totalTax = totalTax;
                                    }

                                    /** 
                                     * Get the 'TotalSurcharge' element value.
                                     * 
                                     * @return value
                                     */
                                    public TotalSurcharge getTotalSurcharge() {
                                        return totalSurcharge;
                                    }

                                    /** 
                                     * Set the 'TotalSurcharge' element value.
                                     * 
                                     * @param totalSurcharge
                                     */
                                    public void setTotalSurcharge(
                                            TotalSurcharge totalSurcharge) {
                                        this.totalSurcharge = totalSurcharge;
                                    }

                                    /** 
                                     * Get the 'ApproximateTotal' element value.
                                     * 
                                     * @return value
                                     */
                                    public ApproximateTotal getApproximateTotal() {
                                        return approximateTotal;
                                    }

                                    /** 
                                     * Set the 'ApproximateTotal' element value.
                                     * 
                                     * @param approximateTotal
                                     */
                                    public void setApproximateTotal(
                                            ApproximateTotal approximateTotal) {
                                        this.approximateTotal = approximateTotal;
                                    }

                                    /** 
                                     * Get the list of 'RateChange' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<RateChange> getRateChangeList() {
                                        return rateChangeList;
                                    }

                                    /** 
                                     * Set the list of 'RateChange' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setRateChangeList(
                                            List<RateChange> list) {
                                        rateChangeList = list;
                                    }

                                    /** 
                                     * Get the list of 'Disclaimer' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<Disclaimer> getDisclaimerList() {
                                        return disclaimerList;
                                    }

                                    /** 
                                     * Set the list of 'Disclaimer' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setDisclaimerList(
                                            List<Disclaimer> list) {
                                        disclaimerList = list;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0" maxOccurs="1">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="4">
                                     *         &lt;!-- Reference to inner class Tax -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" name="Amount"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class TotalTax implements
                                        Serializable
                                    {
                                        private List<Tax> taxList = new ArrayList<Tax>();
                                        private String amount;

                                        /** 
                                         * Get the list of 'Tax' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<Tax> getTaxList() {
                                            return taxList;
                                        }

                                        /** 
                                         * Set the list of 'Tax' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTaxList(List<Tax> list) {
                                            taxList = list;
                                        }

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="4">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:simpleContent>
                                         *       &lt;xs:extension base="xs:string">
                                         *         &lt;xs:attribute type="xs:string" name="Id"/>
                                         *       &lt;/xs:extension>
                                         *     &lt;/xs:simpleContent>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Tax implements
                                            Serializable
                                        {
                                            private String string;
                                            private String id;

                                            /** 
                                             * Get the extension value.
                                             * 
                                             * @return value
                                             */
                                            public String getString() {
                                                return string;
                                            }

                                            /** 
                                             * Set the extension value.
                                             * 
                                             * @param string
                                             */
                                            public void setString(String string) {
                                                this.string = string;
                                            }

                                            /** 
                                             * Get the 'Id' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getId() {
                                                return id;
                                            }

                                            /** 
                                             * Set the 'Id' attribute value.
                                             * 
                                             * @param id
                                             */
                                            public void setId(String id) {
                                                this.id = id;
                                            }
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalSurcharge" minOccurs="0" maxOccurs="1">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="Surcharge" minOccurs="0" maxOccurs="4">
                                     *         &lt;!-- Reference to inner class Surcharge -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" name="Amount"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class TotalSurcharge
                                        implements Serializable
                                    {
                                        private List<Surcharge> surchargeList = new ArrayList<Surcharge>();
                                        private String amount;

                                        /** 
                                         * Get the list of 'Surcharge' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<Surcharge> getSurchargeList() {
                                            return surchargeList;
                                        }

                                        /** 
                                         * Set the list of 'Surcharge' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setSurchargeList(
                                                List<Surcharge> list) {
                                            surchargeList = list;
                                        }

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharge" minOccurs="0" maxOccurs="4">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:simpleContent>
                                         *       &lt;xs:extension base="xs:string">
                                         *         &lt;xs:attribute type="xs:string" name="Id"/>
                                         *       &lt;/xs:extension>
                                         *     &lt;/xs:simpleContent>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Surcharge implements
                                            Serializable
                                        {
                                            private String string;
                                            private String id;

                                            /** 
                                             * Get the extension value.
                                             * 
                                             * @return value
                                             */
                                            public String getString() {
                                                return string;
                                            }

                                            /** 
                                             * Set the extension value.
                                             * 
                                             * @param string
                                             */
                                            public void setString(String string) {
                                                this.string = string;
                                            }

                                            /** 
                                             * Get the 'Id' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getId() {
                                                return id;
                                            }

                                            /** 
                                             * Set the 'Id' attribute value.
                                             * 
                                             * @param id
                                             */
                                            public void setId(String id) {
                                                this.id = id;
                                            }
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApproximateTotal" minOccurs="0" maxOccurs="1">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" name="AmountAndCurrency"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class ApproximateTotal
                                        implements Serializable
                                    {
                                        private String amountAndCurrency;

                                        /** 
                                         * Get the 'AmountAndCurrency' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmountAndCurrency() {
                                            return amountAndCurrency;
                                        }

                                        /** 
                                         * Set the 'AmountAndCurrency' attribute value.
                                         * 
                                         * @param amountAndCurrency
                                         */
                                        public void setAmountAndCurrency(
                                                String amountAndCurrency) {
                                            this.amountAndCurrency = amountAndCurrency;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateChange" minOccurs="0" maxOccurs="8">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" name="Id"/>
                                     *     &lt;xs:attribute type="xs:string" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" name="Effective"/>
                                     *     &lt;xs:attribute type="xs:string" name="Surcharge"/>
                                     *     &lt;xs:attribute type="xs:string" name="Tax"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class RateChange implements
                                        Serializable
                                    {
                                        private String id;
                                        private String amount;
                                        private String effective;
                                        private String surcharge;
                                        private String tax;

                                        /** 
                                         * Get the 'Id' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getId() {
                                            return id;
                                        }

                                        /** 
                                         * Set the 'Id' attribute value.
                                         * 
                                         * @param id
                                         */
                                        public void setId(String id) {
                                            this.id = id;
                                        }

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'Effective' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getEffective() {
                                            return effective;
                                        }

                                        /** 
                                         * Set the 'Effective' attribute value.
                                         * 
                                         * @param effective
                                         */
                                        public void setEffective(
                                                String effective) {
                                            this.effective = effective;
                                        }

                                        /** 
                                         * Get the 'Surcharge' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSurcharge() {
                                            return surcharge;
                                        }

                                        /** 
                                         * Set the 'Surcharge' attribute value.
                                         * 
                                         * @param surcharge
                                         */
                                        public void setSurcharge(
                                                String surcharge) {
                                            this.surcharge = surcharge;
                                        }

                                        /** 
                                         * Get the 'Tax' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getTax() {
                                            return tax;
                                        }

                                        /** 
                                         * Set the 'Tax' attribute value.
                                         * 
                                         * @param tax
                                         */
                                        public void setTax(String tax) {
                                            this.tax = tax;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Disclaimer" minOccurs="0" maxOccurs="2">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:string" name="Id"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Disclaimer implements
                                        Serializable
                                    {
                                        private String string;
                                        private String id;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'Id' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getId() {
                                            return id;
                                        }

                                        /** 
                                         * Set the 'Id' attribute value.
                                         * 
                                         * @param id
                                         */
                                        public void setId(String id) {
                                            this.id = id;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateAccessCodeBooked" minOccurs="0" maxOccurs="1">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element type="xs:string" name="ClientIdentificationCode" minOccurs="0"/>
                                 *       &lt;xs:element type="xs:string" name="RateAccessCode" minOccurs="0"/>
                                 *       &lt;xs:element type="xs:string" name="CategoryTypeCode" minOccurs="0"/>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class RateAccessCodeBooked
                                    implements Serializable
                                {
                                    private String clientIdentificationCode;
                                    private String rateAccessCode;
                                    private String categoryTypeCode;

                                    /** 
                                     * Get the 'ClientIdentificationCode' element value. "ClientIdentificationCode" is used to return the identification code for the vendor associated with the particular hotel reservation.
                                     * 
                                     * @return value
                                     */
                                    public String getClientIdentificationCode() {
                                        return clientIdentificationCode;
                                    }

                                    /** 
                                     * Set the 'ClientIdentificationCode' element value. "ClientIdentificationCode" is used to return the identification code for the vendor associated with the particular hotel reservation.
                                     * 
                                     * @param clientIdentificationCode
                                     */
                                    public void setClientIdentificationCode(
                                            String clientIdentificationCode) {
                                        this.clientIdentificationCode = clientIdentificationCode;
                                    }

                                    /** 
                                     * Get the 'RateAccessCode' element value. "RateAccessCode" is used to return the rate access code of the agency.
                                     * 
                                     * @return value
                                     */
                                    public String getRateAccessCode() {
                                        return rateAccessCode;
                                    }

                                    /** 
                                     * Set the 'RateAccessCode' element value. "RateAccessCode" is used to return the rate access code of the agency.
                                     * 
                                     * @param rateAccessCode
                                     */
                                    public void setRateAccessCode(
                                            String rateAccessCode) {
                                        this.rateAccessCode = rateAccessCode;
                                    }

                                    /** 
                                     * Get the 'CategoryTypeCode' element value. "CategoryTypeCode" is used to return the category type code associated with the particular hotel when applicable.
                                     * 
                                     * @return value
                                     */
                                    public String getCategoryTypeCode() {
                                        return categoryTypeCode;
                                    }

                                    /** 
                                     * Set the 'CategoryTypeCode' element value. "CategoryTypeCode" is used to return the category type code associated with the particular hotel when applicable.
                                     * 
                                     * @param categoryTypeCode
                                     */
                                    public void setCategoryTypeCode(
                                            String categoryTypeCode) {
                                        this.categoryTypeCode = categoryTypeCode;
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialPrefs" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SpecialPrefs implements
                            Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items. "Text" is used to return miscellaneous special preference-related information.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items. "Text" is used to return miscellaneous special preference-related information.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeSpan" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Duration"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="End"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Start"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TimeSpan implements Serializable
                        {
                            private String duration;
                            private String end;
                            private String start;

                            /** 
                             * Get the 'Duration' attribute value.
                             * 
                             * @return value
                             */
                            public String getDuration() {
                                return duration;
                            }

                            /** 
                             * Set the 'Duration' attribute value.
                             * 
                             * @param duration
                             */
                            public void setDuration(String duration) {
                                this.duration = duration;
                            }

                            /** 
                             * Get the 'End' attribute value. "End" follows this format: MM-DDTHH:MM
                             * 
                             * @return value
                             */
                            public String getEnd() {
                                return end;
                            }

                            /** 
                             * Set the 'End' attribute value. "End" follows this format: MM-DDTHH:MM
                             * 
                             * @param end
                             */
                            public void setEnd(String end) {
                                this.end = end;
                            }

                            /** 
                             * Get the 'Start' attribute value. "Start" follows this format: MM-DDTHHMM
                             * 
                             * @return value
                             */
                            public String getStart() {
                                return start;
                            }

                            /** 
                             * Set the 'Start' attribute value. "Start" follows this format: MM-DDTHHMM
                             * 
                             * @param start
                             */
                            public void setStart(String start) {
                                this.start = start;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Insurance" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="InsuranceDetails" minOccurs="0">
                     *         &lt;!-- Reference to inner class InsuranceDetails -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Insurance implements Serializable
                    {
                        private InsuranceDetails insuranceDetails;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;
                        private String id;

                        /** 
                         * Get the 'InsuranceDetails' element value.
                         * 
                         * @return value
                         */
                        public InsuranceDetails getInsuranceDetails() {
                            return insuranceDetails;
                        }

                        /** 
                         * Set the 'InsuranceDetails' element value.
                         * 
                         * @param insuranceDetails
                         */
                        public void setInsuranceDetails(
                                InsuranceDetails insuranceDetails) {
                            this.insuranceDetails = insuranceDetails;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value. "Type" is used to return the type of Misc segment.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. "Type" is used to return the type of Misc segment.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Insurance - InsuranceDetails - @End.  In this case there is no location available, thus DFW time zone will be used.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Insurance - InsuranceDetails - @End.  In this case there is no location available, thus DFW time zone will be used.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Insurance (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Insurance (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InsuranceDetails" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
                         *       &lt;xs:element name="Coverage" minOccurs="0">
                         *         &lt;!-- Reference to inner class Coverage -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="DestinationLocation" minOccurs="0" maxOccurs="2">
                         *         &lt;!-- Reference to inner class DestinationLocation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="OriginLocation" minOccurs="0">
                         *         &lt;!-- Reference to inner class OriginLocation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Payment" minOccurs="0">
                         *         &lt;!-- Reference to inner class Payment -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class PersonName -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *       &lt;xs:element name="Vendor" minOccurs="0">
                         *         &lt;!-- Reference to inner class Vendor -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="End"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="NumPolicies"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PlanType"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PremiumAmount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PurchaseDate"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Start"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="StatusCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class InsuranceDetails implements
                            Serializable
                        {
                            private String confirmationNumber;
                            private Coverage coverage;
                            private List<DestinationLocation> destinationLocationList = new ArrayList<DestinationLocation>();
                            private OriginLocation originLocation;
                            private Payment payment;
                            private List<PersonName> personNameList = new ArrayList<PersonName>();
                            private String text;
                            private Vendor vendor;
                            private String currencyCode;
                            private String end;
                            private String numPolicies;
                            private String planType;
                            private String premiumAmount;
                            private String purchaseDate;
                            private String start;
                            private String statusCode;

                            /** 
                             * Get the 'ConfirmationNumber' element value. "ConfirmationNumber" is used to return the confirmation number associated with the particular insurance segment.
                             * 
                             * @return value
                             */
                            public String getConfirmationNumber() {
                                return confirmationNumber;
                            }

                            /** 
                             * Set the 'ConfirmationNumber' element value. "ConfirmationNumber" is used to return the confirmation number associated with the particular insurance segment.
                             * 
                             * @param confirmationNumber
                             */
                            public void setConfirmationNumber(
                                    String confirmationNumber) {
                                this.confirmationNumber = confirmationNumber;
                            }

                            /** 
                             * Get the 'Coverage' element value.
                             * 
                             * @return value
                             */
                            public Coverage getCoverage() {
                                return coverage;
                            }

                            /** 
                             * Set the 'Coverage' element value.
                             * 
                             * @param coverage
                             */
                            public void setCoverage(Coverage coverage) {
                                this.coverage = coverage;
                            }

                            /** 
                             * Get the list of 'DestinationLocation' element items.
                             * 
                             * @return list
                             */
                            public List<DestinationLocation> getDestinationLocationList() {
                                return destinationLocationList;
                            }

                            /** 
                             * Set the list of 'DestinationLocation' element items.
                             * 
                             * @param list
                             */
                            public void setDestinationLocationList(
                                    List<DestinationLocation> list) {
                                destinationLocationList = list;
                            }

                            /** 
                             * Get the 'OriginLocation' element value.
                             * 
                             * @return value
                             */
                            public OriginLocation getOriginLocation() {
                                return originLocation;
                            }

                            /** 
                             * Set the 'OriginLocation' element value.
                             * 
                             * @param originLocation
                             */
                            public void setOriginLocation(
                                    OriginLocation originLocation) {
                                this.originLocation = originLocation;
                            }

                            /** 
                             * Get the 'Payment' element value.
                             * 
                             * @return value
                             */
                            public Payment getPayment() {
                                return payment;
                            }

                            /** 
                             * Set the 'Payment' element value.
                             * 
                             * @param payment
                             */
                            public void setPayment(Payment payment) {
                                this.payment = payment;
                            }

                            /** 
                             * Get the list of 'PersonName' element items.
                             * 
                             * @return list
                             */
                            public List<PersonName> getPersonNameList() {
                                return personNameList;
                            }

                            /** 
                             * Set the list of 'PersonName' element items.
                             * 
                             * @param list
                             */
                            public void setPersonNameList(List<PersonName> list) {
                                personNameList = list;
                            }

                            /** 
                             * Get the 'Text' element value. "Text" is used to return specialized instructions associated with the particular insurance segment.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value. "Text" is used to return specialized instructions associated with the particular insurance segment.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }

                            /** 
                             * Get the 'Vendor' element value.
                             * 
                             * @return value
                             */
                            public Vendor getVendor() {
                                return vendor;
                            }

                            /** 
                             * Set the 'Vendor' element value.
                             * 
                             * @param vendor
                             */
                            public void setVendor(Vendor vendor) {
                                this.vendor = vendor;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the insurance premium currency code associated with the particular insurance segment.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value. "CurrencyCode" is used to return the insurance premium currency code associated with the particular insurance segment.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'End' attribute value. "End" is used to return the end date of the insurance coverage. The formate is MM:DD
                             * 
                             * @return value
                             */
                            public String getEnd() {
                                return end;
                            }

                            /** 
                             * Set the 'End' attribute value. "End" is used to return the end date of the insurance coverage. The formate is MM:DD
                             * 
                             * @param end
                             */
                            public void setEnd(String end) {
                                this.end = end;
                            }

                            /** 
                             * Get the 'NumPolicies' attribute value. "NumPolicies" is used to return the number of policies associated with the particular insurance segment.
                             * 
                             * @return value
                             */
                            public String getNumPolicies() {
                                return numPolicies;
                            }

                            /** 
                             * Set the 'NumPolicies' attribute value. "NumPolicies" is used to return the number of policies associated with the particular insurance segment.
                             * 
                             * @param numPolicies
                             */
                            public void setNumPolicies(String numPolicies) {
                                this.numPolicies = numPolicies;
                            }

                            /** 
                             * Get the 'PlanType' attribute value. "PlanType" is used to return the insurance plan type.
                             * 
                             * @return value
                             */
                            public String getPlanType() {
                                return planType;
                            }

                            /** 
                             * Set the 'PlanType' attribute value. "PlanType" is used to return the insurance plan type.
                             * 
                             * @param planType
                             */
                            public void setPlanType(String planType) {
                                this.planType = planType;
                            }

                            /** 
                             * Get the 'PremiumAmount' attribute value. "PremiumAmount" is used to return the insurance premium amount associated with the particular insurance segment.
                             * 
                             * @return value
                             */
                            public String getPremiumAmount() {
                                return premiumAmount;
                            }

                            /** 
                             * Set the 'PremiumAmount' attribute value. "PremiumAmount" is used to return the insurance premium amount associated with the particular insurance segment.
                             * 
                             * @param premiumAmount
                             */
                            public void setPremiumAmount(String premiumAmount) {
                                this.premiumAmount = premiumAmount;
                            }

                            /** 
                             * Get the 'PurchaseDate' attribute value. "PurchaseDate" is used to return the purchase date of the insurance. The formate is MM:DD
                             * 
                             * @return value
                             */
                            public String getPurchaseDate() {
                                return purchaseDate;
                            }

                            /** 
                             * Set the 'PurchaseDate' attribute value. "PurchaseDate" is used to return the purchase date of the insurance. The formate is MM:DD
                             * 
                             * @param purchaseDate
                             */
                            public void setPurchaseDate(String purchaseDate) {
                                this.purchaseDate = purchaseDate;
                            }

                            /** 
                             * Get the 'Start' attribute value. "Start" is used to return the start date and time of the insurance coverage. The formate is MM:DDTHH:MM
                             * 
                             * @return value
                             */
                            public String getStart() {
                                return start;
                            }

                            /** 
                             * Set the 'Start' attribute value. "Start" is used to return the start date and time of the insurance coverage. The formate is MM:DDTHH:MM
                             * 
                             * @param start
                             */
                            public void setStart(String start) {
                                this.start = start;
                            }

                            /** 
                             * Get the 'StatusCode' attribute value. "StatusCode" is used to return the reservation status code.
                             * 
                             * @return value
                             */
                            public String getStatusCode() {
                                return statusCode;
                            }

                            /** 
                             * Set the 'StatusCode' attribute value. "StatusCode" is used to return the reservation status code.
                             * 
                             * @param statusCode
                             */
                            public void setStatusCode(String statusCode) {
                                this.statusCode = statusCode;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coverage" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Amount" minOccurs="0" maxOccurs="unbounded"/>
                             *       &lt;xs:element type="xs:string" name="Type" minOccurs="0" maxOccurs="unbounded"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Coverage implements
                                Serializable
                            {
                                private List<String> amountList = new ArrayList<String>();
                                private List<String> typeList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'Amount' element items. "Amount" is used to return the coverage amount associated with the particular insurance segment.
                                 * 
                                 * @return list
                                 */
                                public List<String> getAmountList() {
                                    return amountList;
                                }

                                /** 
                                 * Set the list of 'Amount' element items. "Amount" is used to return the coverage amount associated with the particular insurance segment.
                                 * 
                                 * @param list
                                 */
                                public void setAmountList(List<String> list) {
                                    amountList = list;
                                }

                                /** 
                                 * Get the list of 'Type' element items. "Type" is used to return the coverage type associated with the particular insurance segment.
                                 * 
                                 * @return list
                                 */
                                public List<String> getTypeList() {
                                    return typeList;
                                }

                                /** 
                                 * Set the list of 'Type' element items. "Type" is used to return the coverage type associated with the particular insurance segment.
                                 * 
                                 * @param list
                                 */
                                public void setTypeList(List<String> list) {
                                    typeList = list;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0" maxOccurs="2">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class DestinationLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value. "LocationCode" is used to return the arrival location code associated with the particular insurance segment.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value. "LocationCode" is used to return the arrival location code associated with the particular insurance segment.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class OriginLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular insurance segment.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular insurance segment.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Form" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Payment implements Serializable
                            {
                                private String form;

                                /** 
                                 * Get the 'Form' element value. "Form" is used to return the form of payment used to purchase the insurance.
                                 * 
                                 * @return value
                                 */
                                public String getForm() {
                                    return form;
                                }

                                /** 
                                 * Set the 'Form' element value. "Form" is used to return the form of payment used to purchase the insurance.
                                 * 
                                 * @param form
                                 */
                                public void setForm(String form) {
                                    this.form = form;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                             *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PersonName implements
                                Serializable
                            {
                                private String givenName;
                                private String surname;

                                /** 
                                 * Get the 'GivenName' element value. "GivenName" is used to return the policy holder's first name associated with the particular insurance segment.
                                 * 
                                 * @return value
                                 */
                                public String getGivenName() {
                                    return givenName;
                                }

                                /** 
                                 * Set the 'GivenName' element value. "GivenName" is used to return the policy holder's first name associated with the particular insurance segment.
                                 * 
                                 * @param givenName
                                 */
                                public void setGivenName(String givenName) {
                                    this.givenName = givenName;
                                }

                                /** 
                                 * Get the 'Surname' element value. "Surname" is used to return the policy holder's last name associated with the particular insurance segment.
                                 * 
                                 * @return value
                                 */
                                public String getSurname() {
                                    return surname;
                                }

                                /** 
                                 * Set the 'Surname' element value. "Surname" is used to return the policy holder's last name associated with the particular insurance segment.
                                 * 
                                 * @param surname
                                 */
                                public void setSurname(String surname) {
                                    this.surname = surname;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Vendor implements Serializable
                            {
                                private String code;
                                private String companyShortName;

                                /** 
                                 * Get the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular insurance segment.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular insurance segment.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment.
                                 * 
                                 * @return value
                                 */
                                public String getCompanyShortName() {
                                    return companyShortName;
                                }

                                /** 
                                 * Set the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment.
                                 * 
                                 * @param companyShortName
                                 */
                                public void setCompanyShortName(
                                        String companyShortName) {
                                    this.companyShortName = companyShortName;
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscSegment" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="Vendor" minOccurs="0">
                     *         &lt;!-- Reference to inner class Vendor -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MiscSegment implements Serializable
                    {
                        private OriginLocation originLocation;
                        private List<String> textList = new ArrayList<String>();
                        private Vendor vendor;
                        private String dayOfWeekInd;
                        private String departureDateTime;
                        private String linkCode;
                        private String numberInParty;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;
                        private String id;

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the list of 'Text' element items.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }

                        /** 
                         * Get the 'Vendor' element value.
                         * 
                         * @return value
                         */
                        public Vendor getVendor() {
                            return vendor;
                        }

                        /** 
                         * Set the 'Vendor' element value.
                         * 
                         * @param vendor
                         */
                        public void setVendor(Vendor vendor) {
                            this.vendor = vendor;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the date of the segment associated with the particular segment. "DepartureDateTime" follows this format: MM:DD
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the date of the segment associated with the particular segment. "DepartureDateTime" follows this format: MM:DD
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular rail segment.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular rail segment.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value. "Type" is used to return the type of segment.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. "Type" is used to return the type of segment.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on MiscSegment - @DepartureDateTime, MiscSegment - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on MiscSegment - @DepartureDateTime, MiscSegment - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of MiscSegment (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of MiscSegment (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationName"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;
                            private String locationName;

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the location code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the location code associated with the particular segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'LocationName' attribute value. "LocationName" is used to return the location name associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getLocationName() {
                                return locationName;
                            }

                            /** 
                             * Set the 'LocationName' attribute value. "LocationName" is used to return the location name associated with the particular segment.
                             * 
                             * @param locationName
                             */
                            public void setLocationName(String locationName) {
                                this.locationName = locationName;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Vendor implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rail" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="IssueDate" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ServiceInformation" minOccurs="0">
                     *         &lt;!-- Reference to inner class ServiceInformation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SNCF_Information" minOccurs="0">
                     *         &lt;!-- Reference to inner class SNCFInformation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="SpaceReserved" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="TicketControlNumber" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element name="Train" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Train -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Vendor" minOccurs="0">
                     *         &lt;!-- Reference to inner class Vendor -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Rail implements Serializable
                    {
                        private List<String> confirmationNumberList = new ArrayList<String>();
                        private DestinationLocation destinationLocation;
                        private List<String> issueDateList = new ArrayList<String>();
                        private OriginLocation originLocation;
                        private ServiceInformation serviceInformation;
                        private SNCFInformation SNCFInformation1;
                        private List<String> spaceReservedList = new ArrayList<String>();
                        private List<String> textList = new ArrayList<String>();
                        private List<String> ticketControlNumberList = new ArrayList<String>();
                        private List<Train> trainList = new ArrayList<Train>();
                        private Vendor vendor;
                        private String dayOfWeekInd;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String numberInParty;
                        private String resBookDesigCode;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;
                        private String id;

                        /** 
                         * Get the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the confirmation number associated with the particular rail segment.
                         * 
                         * @return list
                         */
                        public List<String> getConfirmationNumberList() {
                            return confirmationNumberList;
                        }

                        /** 
                         * Set the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the confirmation number associated with the particular rail segment.
                         * 
                         * @param list
                         */
                        public void setConfirmationNumberList(List<String> list) {
                            confirmationNumberList = list;
                        }

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the list of 'IssueDate' element items. "IssueDate" is used to return ticket issue date-related information. 	"IssueDate" follows this format: MM:DD
                         * 
                         * @return list
                         */
                        public List<String> getIssueDateList() {
                            return issueDateList;
                        }

                        /** 
                         * Set the list of 'IssueDate' element items. "IssueDate" is used to return ticket issue date-related information. 	"IssueDate" follows this format: MM:DD
                         * 
                         * @param list
                         */
                        public void setIssueDateList(List<String> list) {
                            issueDateList = list;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the 'ServiceInformation' element value.
                         * 
                         * @return value
                         */
                        public ServiceInformation getServiceInformation() {
                            return serviceInformation;
                        }

                        /** 
                         * Set the 'ServiceInformation' element value.
                         * 
                         * @param serviceInformation
                         */
                        public void setServiceInformation(
                                ServiceInformation serviceInformation) {
                            this.serviceInformation = serviceInformation;
                        }

                        /** 
                         * Get the 'SNCF_Information' element value.
                         * 
                         * @return value
                         */
                        public SNCFInformation getSNCFInformation1() {
                            return SNCFInformation1;
                        }

                        /** 
                         * Set the 'SNCF_Information' element value.
                         * 
                         * @param SNCFInformation1
                         */
                        public void setSNCFInformation1(
                                SNCFInformation SNCFInformation1) {
                            this.SNCFInformation1 = SNCFInformation1;
                        }

                        /** 
                         * Get the list of 'SpaceReserved' element items. "SpaceReserved" is used to return space reserved-related information.
                         * 
                         * @return list
                         */
                        public List<String> getSpaceReservedList() {
                            return spaceReservedList;
                        }

                        /** 
                         * Set the list of 'SpaceReserved' element items. "SpaceReserved" is used to return space reserved-related information.
                         * 
                         * @param list
                         */
                        public void setSpaceReservedList(List<String> list) {
                            spaceReservedList = list;
                        }

                        /** 
                         * Get the list of 'Text' element items. "Text" is used to return miscellaneous rail-related information.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items. "Text" is used to return miscellaneous rail-related information.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }

                        /** 
                         * Get the list of 'TicketControlNumber' element items. "TicketControlNumber" is used to return ticket control number-related information.
                         * 
                         * @return list
                         */
                        public List<String> getTicketControlNumberList() {
                            return ticketControlNumberList;
                        }

                        /** 
                         * Set the list of 'TicketControlNumber' element items. "TicketControlNumber" is used to return ticket control number-related information.
                         * 
                         * @param list
                         */
                        public void setTicketControlNumberList(List<String> list) {
                            ticketControlNumberList = list;
                        }

                        /** 
                         * Get the list of 'Train' element items.
                         * 
                         * @return list
                         */
                        public List<Train> getTrainList() {
                            return trainList;
                        }

                        /** 
                         * Set the list of 'Train' element items.
                         * 
                         * @param list
                         */
                        public void setTrainList(List<Train> list) {
                            trainList = list;
                        }

                        /** 
                         * Get the 'Vendor' element value.
                         * 
                         * @return value
                         */
                        public Vendor getVendor() {
                            return vendor;
                        }

                        /** 
                         * Set the 'Vendor' element value.
                         * 
                         * @param vendor
                         */
                        public void setVendor(Vendor vendor) {
                            this.vendor = vendor;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular rail segment if applicable.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular rail segment if applicable.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular rail segment.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of passengers associated with the particular rail segment.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular rail segment.
                         * 
                         * @return value
                         */
                        public String getResBookDesigCode() {
                            return resBookDesigCode;
                        }

                        /** 
                         * Set the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to return the booking class associated with the particular rail segment.
                         * 
                         * @param resBookDesigCode
                         */
                        public void setResBookDesigCode(String resBookDesigCode) {
                            this.resBookDesigCode = resBookDesigCode;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value. "Type" is used to return the type of segment.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. "Type" is used to return the type of segment.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Rail - OriginLocation - DepartureDate, Rail - OriginLocation - DepartureTime, Rail - OriginLocation - @LocationCode. There is end date included in schema, but it is never populated, this is why origin departure time and origin location will consider.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Rail - OriginLocation - DepartureDate, Rail - OriginLocation - DepartureTime, Rail - OriginLocation - @LocationCode. There is end date included in schema, but it is never populated, this is why origin departure time and origin location will consider.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Rail (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Rail (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ArrivalDate" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="ArrivalTime" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="LocationName" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Point" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private List<String> arrivalDateList = new ArrayList<String>();
                            private List<String> arrivalTimeList = new ArrayList<String>();
                            private String locationName;
                            private List<String> pointList = new ArrayList<String>();
                            private String locationCode;

                            /** 
                             * Get the list of 'ArrivalDate' element items. "ArrivalDate" is used to return arrival date information associated with the particular rail segment.	"ArrivalDate" follows this format: MM:DD
                             * 
                             * @return list
                             */
                            public List<String> getArrivalDateList() {
                                return arrivalDateList;
                            }

                            /** 
                             * Set the list of 'ArrivalDate' element items. "ArrivalDate" is used to return arrival date information associated with the particular rail segment.	"ArrivalDate" follows this format: MM:DD
                             * 
                             * @param list
                             */
                            public void setArrivalDateList(List<String> list) {
                                arrivalDateList = list;
                            }

                            /** 
                             * Get the list of 'ArrivalTime' element items. "ArrivalTime" is used to return arrival time information associated with the particular rail segment. 	"ArrivalTime" follows this format: HH:MM
                             * 
                             * @return list
                             */
                            public List<String> getArrivalTimeList() {
                                return arrivalTimeList;
                            }

                            /** 
                             * Set the list of 'ArrivalTime' element items. "ArrivalTime" is used to return arrival time information associated with the particular rail segment. 	"ArrivalTime" follows this format: HH:MM
                             * 
                             * @param list
                             */
                            public void setArrivalTimeList(List<String> list) {
                                arrivalTimeList = list;
                            }

                            /** 
                             * Get the 'LocationName' element value. "LocationName" is used to return the arrival location name associated with the particular rail segment.
                             * 
                             * @return value
                             */
                            public String getLocationName() {
                                return locationName;
                            }

                            /** 
                             * Set the 'LocationName' element value. "LocationName" is used to return the arrival location name associated with the particular rail segment.
                             * 
                             * @param locationName
                             */
                            public void setLocationName(String locationName) {
                                this.locationName = locationName;
                            }

                            /** 
                             * Get the list of 'Point' element items. "Point" is used to return the arrival location point associated with the particular rail segment.
                             * 
                             * @return list
                             */
                            public List<String> getPointList() {
                                return pointList;
                            }

                            /** 
                             * Set the list of 'Point' element items. "Point" is used to return the arrival location point associated with the particular rail segment.
                             * 
                             * @param list
                             */
                            public void setPointList(List<String> list) {
                                pointList = list;
                            }

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular rail segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular rail segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="DepartureDate" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="DepartureTime" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="LocationName" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="Point" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String departureDate;
                            private List<String> departureTimeList = new ArrayList<String>();
                            private List<String> locationNameList = new ArrayList<String>();
                            private List<String> pointList = new ArrayList<String>();
                            private String locationCode;

                            /** 
                             * Get the 'DepartureDate' element value. "DepartureDate" is used to return departure date information associated with the particular rail segment.	"DepartureDate" follows this format: MM-DD
                             * 
                             * @return value
                             */
                            public String getDepartureDate() {
                                return departureDate;
                            }

                            /** 
                             * Set the 'DepartureDate' element value. "DepartureDate" is used to return departure date information associated with the particular rail segment.	"DepartureDate" follows this format: MM-DD
                             * 
                             * @param departureDate
                             */
                            public void setDepartureDate(String departureDate) {
                                this.departureDate = departureDate;
                            }

                            /** 
                             * Get the list of 'DepartureTime' element items. "DepartureTime" is used to return departure time information associated with the particular rail segment.	"DepartureTime" follows this format: HH:MM
                             * 
                             * @return list
                             */
                            public List<String> getDepartureTimeList() {
                                return departureTimeList;
                            }

                            /** 
                             * Set the list of 'DepartureTime' element items. "DepartureTime" is used to return departure time information associated with the particular rail segment.	"DepartureTime" follows this format: HH:MM
                             * 
                             * @param list
                             */
                            public void setDepartureTimeList(List<String> list) {
                                departureTimeList = list;
                            }

                            /** 
                             * Get the list of 'LocationName' element items. "LocationName" is used to return the departure location name associated with the particular rail segment.
                             * 
                             * @return list
                             */
                            public List<String> getLocationNameList() {
                                return locationNameList;
                            }

                            /** 
                             * Set the list of 'LocationName' element items. "LocationName" is used to return the departure location name associated with the particular rail segment.
                             * 
                             * @param list
                             */
                            public void setLocationNameList(List<String> list) {
                                locationNameList = list;
                            }

                            /** 
                             * Get the list of 'Point' element items. "Point" is used to return the departure location point associated with the particular rail segment.
                             * 
                             * @return list
                             */
                            public List<String> getPointList() {
                                return pointList;
                            }

                            /** 
                             * Set the list of 'Point' element items. "Point" is used to return the departure location point associated with the particular rail segment.
                             * 
                             * @param list
                             */
                            public void setPointList(List<String> list) {
                                pointList = list;
                            }

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular rail segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the departure location code associated with the particular rail segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInformation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ServiceInformation implements
                            Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items. "Text" is used to return miscellaneous service-related information.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items. "Text" is used to return miscellaneous service-related information.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SNCF_Information" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SNCFInformation implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value. "Text" is used to return miscellaneous SNCF-related information.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value. "Text" is used to return miscellaneous SNCF-related information.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Train" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Train implements Serializable
                        {
                            private String number;

                            /** 
                             * Get the 'Number' attribute value. "Number" is used to return the number of the train, cruise, or bus associated with the particular rail segment.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value. "Number" is used to return the number of the train, cruise, or bus associated with the particular rail segment.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Vendor implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular rail segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular rail segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seats" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Seat" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Seat -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Seats implements Serializable
                    {
                        private List<Seat> seatList = new ArrayList<Seat>();

                        /** 
                         * Get the list of 'Seat' element items.
                         * 
                         * @return list
                         */
                        public List<Seat> getSeatList() {
                            return seatList;
                        }

                        /** 
                         * Set the list of 'Seat' element items.
                         * 
                         * @param list
                         */
                        public void setSeatList(List<Seat> list) {
                            seatList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="FlightSegment" minOccurs="0">
                         *         &lt;!-- Reference to inner class FlightSegment -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Changed"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentStatus"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="SmokingPreference"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TypeTwo"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Seat implements Serializable
                        {
                            private FlightSegment flightSegment;
                            private String changed;
                            private String nameNumber;
                            private String number;
                            private String segmentNumber;
                            private String segmentStatus;
                            private String smokingPreference;
                            private String status;
                            private String type;
                            private String typeTwo;
                            private String id;

                            /** 
                             * Get the 'FlightSegment' element value.
                             * 
                             * @return value
                             */
                            public FlightSegment getFlightSegment() {
                                return flightSegment;
                            }

                            /** 
                             * Set the 'FlightSegment' element value.
                             * 
                             * @param flightSegment
                             */
                            public void setFlightSegment(
                                    FlightSegment flightSegment) {
                                this.flightSegment = flightSegment;
                            }

                            /** 
                             * Get the 'Changed' attribute value. "Changed" is used to indicate if the passenger's seat as been changed.
                             * 
                             * @return value
                             */
                            public String getChanged() {
                                return changed;
                            }

                            /** 
                             * Set the 'Changed' attribute value. "Changed" is used to indicate if the passenger's seat as been changed.
                             * 
                             * @param changed
                             */
                            public void setChanged(String changed) {
                                this.changed = changed;
                            }

                            /** 
                             * Get the 'NameNumber' attribute value. "NameNumber" is used return the passenger name number associated with the particular seat reservation.
                             * 
                             * @return value
                             */
                            public String getNameNumber() {
                                return nameNumber;
                            }

                            /** 
                             * Set the 'NameNumber' attribute value. "NameNumber" is used return the passenger name number associated with the particular seat reservation.
                             * 
                             * @param nameNumber
                             */
                            public void setNameNumber(String nameNumber) {
                                this.nameNumber = nameNumber;
                            }

                            /** 
                             * Get the 'Number' attribute value. "Number" is used to return the seat assignment associated with the particular seat reservation.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value. "Number" is used to return the seat assignment associated with the particular seat reservation.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }

                            /** 
                             * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number that the seat is related to.
                             * 
                             * @return value
                             */
                            public String getSegmentNumber() {
                                return segmentNumber;
                            }

                            /** 
                             * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number that the seat is related to.
                             * 
                             * @param segmentNumber
                             */
                            public void setSegmentNumber(String segmentNumber) {
                                this.segmentNumber = segmentNumber;
                            }

                            /** 
                             * Get the 'SegmentStatus' attribute value. "SegmentStatus" is used to return the segment status associated with the particular seat reservation.
                             * 
                             * @return value
                             */
                            public String getSegmentStatus() {
                                return segmentStatus;
                            }

                            /** 
                             * Set the 'SegmentStatus' attribute value. "SegmentStatus" is used to return the segment status associated with the particular seat reservation.
                             * 
                             * @param segmentStatus
                             */
                            public void setSegmentStatus(String segmentStatus) {
                                this.segmentStatus = segmentStatus;
                            }

                            /** 
                             * Get the 'SmokingPreference' attribute value. "SmokingPreference" is used to indicate the smoking preference associated with the particular seat reservation.
                             * 
                             * @return value
                             */
                            public String getSmokingPreference() {
                                return smokingPreference;
                            }

                            /** 
                             * Set the 'SmokingPreference' attribute value. "SmokingPreference" is used to indicate the smoking preference associated with the particular seat reservation.
                             * 
                             * @param smokingPreference
                             */
                            public void setSmokingPreference(
                                    String smokingPreference) {
                                this.smokingPreference = smokingPreference;
                            }

                            /** 
                             * Get the 'Status' attribute value. "Status" is used to return the seat status code.
                             * 
                             * @return value
                             */
                            public String getStatus() {
                                return status;
                            }

                            /** 
                             * Set the 'Status' attribute value. "Status" is used to return the seat status code.
                             * 
                             * @param status
                             */
                            public void setStatus(String status) {
                                this.status = status;
                            }

                            /** 
                             * Get the 'Type' attribute value. "Type" is used to return the seat type associated with the particular seat reservation.
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value. "Type" is used to return the seat type associated with the particular seat reservation.
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'TypeTwo' attribute value. "TypeTwo" is used to return the seat type associated with the particular seat reservation.
                             * 
                             * @return value
                             */
                            public String getTypeTwo() {
                                return typeTwo;
                            }

                            /** 
                             * Set the 'TypeTwo' attribute value. "TypeTwo" is used to return the seat type associated with the particular seat reservation.
                             * 
                             * @param typeTwo
                             */
                            public void setTypeTwo(String typeTwo) {
                                this.typeTwo = typeTwo;
                            }

                            /** 
                             * Get the 'Id' attribute value.
                             * 
                             * @return value
                             */
                            public String getId() {
                                return id;
                            }

                            /** 
                             * Set the 'Id' attribute value.
                             * 
                             * @param id
                             */
                            public void setId(String id) {
                                this.id = id;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                             *         &lt;!-- Reference to inner class DestinationLocation -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="OriginLocation" minOccurs="0">
                             *         &lt;!-- Reference to inner class OriginLocation -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class FlightSegment implements
                                Serializable
                            {
                                private DestinationLocation destinationLocation;
                                private OriginLocation originLocation;

                                /** 
                                 * Get the 'DestinationLocation' element value.
                                 * 
                                 * @return value
                                 */
                                public DestinationLocation getDestinationLocation() {
                                    return destinationLocation;
                                }

                                /** 
                                 * Set the 'DestinationLocation' element value.
                                 * 
                                 * @param destinationLocation
                                 */
                                public void setDestinationLocation(
                                        DestinationLocation destinationLocation) {
                                    this.destinationLocation = destinationLocation;
                                }

                                /** 
                                 * Get the 'OriginLocation' element value.
                                 * 
                                 * @return value
                                 */
                                public OriginLocation getOriginLocation() {
                                    return originLocation;
                                }

                                /** 
                                 * Set the 'OriginLocation' element value.
                                 * 
                                 * @param originLocation
                                 */
                                public void setOriginLocation(
                                        OriginLocation originLocation) {
                                    this.originLocation = originLocation;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class DestinationLocation
                                    implements Serializable
                                {
                                    private String locationCode;

                                    /** 
                                     * Get the 'LocationCode' attribute value. "LocationCode" is used to return the arrival airport code.
                                     * 
                                     * @return value
                                     */
                                    public String getLocationCode() {
                                        return locationCode;
                                    }

                                    /** 
                                     * Set the 'LocationCode' attribute value. "LocationCode" is used to return the arrival airport code.
                                     * 
                                     * @param locationCode
                                     */
                                    public void setLocationCode(
                                            String locationCode) {
                                        this.locationCode = locationCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class OriginLocation implements
                                    Serializable
                                {
                                    private String locationCode;

                                    /** 
                                     * Get the 'LocationCode' attribute value. "LocationCode" is used to return the departure airport code.
                                     * 
                                     * @return value
                                     */
                                    public String getLocationCode() {
                                        return locationCode;
                                    }

                                    /** 
                                     * Set the 'LocationCode' attribute value. "LocationCode" is used to return the departure airport code.
                                     * 
                                     * @param locationCode
                                     */
                                    public void setLocationCode(
                                            String locationCode) {
                                        this.locationCode = locationCode;
                                    }
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surface" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ArrivalDepartureIdentifier" minOccurs="0"/>
                     *       &lt;xs:element name="FlightSegment" minOccurs="0">
                     *         &lt;!-- Reference to inner class FlightSegment -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="POS" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *       &lt;xs:element name="Vendor" minOccurs="0">
                     *         &lt;!-- Reference to inner class Vendor -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Surface implements Serializable
                    {
                        private String arrivalDepartureIdentifier;
                        private FlightSegment flightSegment;
                        private OriginLocation originLocation;
                        private String POS;
                        private String text;
                        private Vendor vendor;
                        private String id;
                        private String departureDateTime;
                        private String numberInParty;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;

                        /** 
                         * Get the 'ArrivalDepartureIdentifier' element value. "ArrivalDepartureIdentifier" is used to return the arrival/departure indicator associated with the particular segment.
                         * 
                         * @return value
                         */
                        public String getArrivalDepartureIdentifier() {
                            return arrivalDepartureIdentifier;
                        }

                        /** 
                         * Set the 'ArrivalDepartureIdentifier' element value. "ArrivalDepartureIdentifier" is used to return the arrival/departure indicator associated with the particular segment.
                         * 
                         * @param arrivalDepartureIdentifier
                         */
                        public void setArrivalDepartureIdentifier(
                                String arrivalDepartureIdentifier) {
                            this.arrivalDepartureIdentifier = arrivalDepartureIdentifier;
                        }

                        /** 
                         * Get the 'FlightSegment' element value.
                         * 
                         * @return value
                         */
                        public FlightSegment getFlightSegment() {
                            return flightSegment;
                        }

                        /** 
                         * Set the 'FlightSegment' element value.
                         * 
                         * @param flightSegment
                         */
                        public void setFlightSegment(FlightSegment flightSegment) {
                            this.flightSegment = flightSegment;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the 'POS' element value. "POS" is used to return the point of sale location associated with the particular segment.
                         * 
                         * @return value
                         */
                        public String getPOS() {
                            return POS;
                        }

                        /** 
                         * Set the 'POS' element value. "POS" is used to return the point of sale location associated with the particular segment.
                         * 
                         * @param POS
                         */
                        public void setPOS(String POS) {
                            this.POS = POS;
                        }

                        /** 
                         * Get the 'Text' element value. "Text" is used to return miscellaneous free text associated with the particular segment.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value. "Text" is used to return miscellaneous free text associated with the particular segment.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'Vendor' element value.
                         * 
                         * @return value
                         */
                        public Vendor getVendor() {
                            return vendor;
                        }

                        /** 
                         * Set the 'Vendor' element value.
                         * 
                         * @param vendor
                         */
                        public void setVendor(Vendor vendor) {
                            this.vendor = vendor;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Surface (BasData)
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Surface (BasData)
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the date and time associated with the particular tour reservation.
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the date and time associated with the particular tour reservation.
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of  passengers associated with the particular tour reservation.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of  passengers associated with the particular tour reservation.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value. "Type" is used to return the segment type.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value. "Type" is used to return the segment type.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Surface - @DepartureDateTime, Surface - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Surface - @DepartureDateTime, Surface - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                         *         &lt;!-- Reference to inner class DestinationLocation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                         *         &lt;!-- Reference to inner class MarketingAirline -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="OriginLocation" minOccurs="0">
                         *         &lt;!-- Reference to inner class OriginLocation -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FlightSegment implements
                            Serializable
                        {
                            private DestinationLocation destinationLocation;
                            private MarketingAirline marketingAirline;
                            private OriginLocation originLocation;
                            private String departureDateTime;
                            private String flightNumber;

                            /** 
                             * Get the 'DestinationLocation' element value.
                             * 
                             * @return value
                             */
                            public DestinationLocation getDestinationLocation() {
                                return destinationLocation;
                            }

                            /** 
                             * Set the 'DestinationLocation' element value.
                             * 
                             * @param destinationLocation
                             */
                            public void setDestinationLocation(
                                    DestinationLocation destinationLocation) {
                                this.destinationLocation = destinationLocation;
                            }

                            /** 
                             * Get the 'MarketingAirline' element value.
                             * 
                             * @return value
                             */
                            public MarketingAirline getMarketingAirline() {
                                return marketingAirline;
                            }

                            /** 
                             * Set the 'MarketingAirline' element value.
                             * 
                             * @param marketingAirline
                             */
                            public void setMarketingAirline(
                                    MarketingAirline marketingAirline) {
                                this.marketingAirline = marketingAirline;
                            }

                            /** 
                             * Get the 'OriginLocation' element value.
                             * 
                             * @return value
                             */
                            public OriginLocation getOriginLocation() {
                                return originLocation;
                            }

                            /** 
                             * Set the 'OriginLocation' element value.
                             * 
                             * @param originLocation
                             */
                            public void setOriginLocation(
                                    OriginLocation originLocation) {
                                this.originLocation = originLocation;
                            }

                            /** 
                             * Get the 'DepartureDateTime' attribute value. DepartureDateTime" is used to return the departure date/time associated with the particular segment. 	"DepartureDateTime" follows this format: MM:DD
                             * 
                             * @return value
                             */
                            public String getDepartureDateTime() {
                                return departureDateTime;
                            }

                            /** 
                             * Set the 'DepartureDateTime' attribute value. DepartureDateTime" is used to return the departure date/time associated with the particular segment. 	"DepartureDateTime" follows this format: MM:DD
                             * 
                             * @param departureDateTime
                             */
                            public void setDepartureDateTime(
                                    String departureDateTime) {
                                this.departureDateTime = departureDateTime;
                            }

                            /** 
                             * Get the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getFlightNumber() {
                                return flightNumber;
                            }

                            /** 
                             * Set the 'FlightNumber' attribute value. "FlightNumber" is used to return the flight number associated with the particular segment.
                             * 
                             * @param flightNumber
                             */
                            public void setFlightNumber(String flightNumber) {
                                this.flightNumber = flightNumber;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class DestinationLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class MarketingAirline implements
                                Serializable
                            {
                                private String code;
                                private String flightNumber;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'FlightNumber' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getFlightNumber() {
                                    return flightNumber;
                                }

                                /** 
                                 * Set the 'FlightNumber' attribute value.
                                 * 
                                 * @param flightNumber
                                 */
                                public void setFlightNumber(String flightNumber) {
                                    this.flightNumber = flightNumber;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class OriginLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value. "LocationCode" is used to return the service city location code associated with the particular segment.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value. "LocationCode" is used to return the service city location code associated with the particular segment.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value. "LocationCode" is used to return the service city location code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value. "LocationCode" is used to return the service city location code associated with the particular segment.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Vendor implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular segment.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value. "Code" is used to return the vendor code associated with the particular segment.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tour" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="TourDetails" minOccurs="0">
                     *         &lt;!-- Reference to inner class TourDetails -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IsPast"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tour implements Serializable
                    {
                        private TourDetails tourDetails;
                        private String id;
                        private String dayOfWeekInd;
                        private String departureDateTime;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String numberInParty;
                        private String segmentNumber;
                        private String status;
                        private String type;
                        private Boolean isPast;

                        /** 
                         * Get the 'TourDetails' element value.
                         * 
                         * @return value
                         */
                        public TourDetails getTourDetails() {
                            return tourDetails;
                        }

                        /** 
                         * Set the 'TourDetails' element value.
                         * 
                         * @param tourDetails
                         */
                        public void setTourDetails(TourDetails tourDetails) {
                            this.tourDetails = tourDetails;
                        }

                        /** 
                         * Get the 'Id' attribute value. "Id" is used to return the id of Tour
                         * 
                         * @return value
                         */
                        public String getId() {
                            return id;
                        }

                        /** 
                         * Set the 'Id' attribute value. "Id" is used to return the id of Tour
                         * 
                         * @param id
                         */
                        public void setId(String id) {
                            this.id = id;
                        }

                        /** 
                         * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @return value
                         */
                        public String getDayOfWeekInd() {
                            return dayOfWeekInd;
                        }

                        /** 
                         * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
                         * 
                         * @param dayOfWeekInd
                         */
                        public void setDayOfWeekInd(String dayOfWeekInd) {
                            this.dayOfWeekInd = dayOfWeekInd;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the date and time associated with the particular tour reservation.
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value. "DepartureDateTime" is used to return the date and time associated with the particular tour reservation.
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value. "LinkCode" is used to return the link code
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value. "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of  passengers associated with the particular tour reservation.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value. "NumberInParty" is used to return the number of  passengers associated with the particular tour reservation.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value. "SegmentNumber" is used to return the itinerary segment number.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value. "Status" is used to return the status code associated with the particular itinerary segment.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Tour - @DepartureDateTime, Tour - TourDetails - @LocationCode, Tour - TourDetails - Duration - NumDays. There is no end date, but here is duration time, thus end date will be calculated based on start date and duration time. If duration time will not be populated then IsPast attribute will be calculated like for air segment.
                         * 
                         * @return value
                         */
                        public Boolean getIsPast() {
                            return isPast;
                        }

                        /** 
                         * Set the 'IsPast' attribute value. It returns information if current segment is past or not. Attribute is populated based on Tour - @DepartureDateTime, Tour - TourDetails - @LocationCode, Tour - TourDetails - Duration - NumDays. There is no end date, but here is duration time, thus end date will be calculated based on start date and duration time. If duration time will not be populated then IsPast attribute will be calculated like for air segment.
                         * 
                         * @param isPast
                         */
                        public void setIsPast(Boolean isPast) {
                            this.isPast = isPast;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/tir/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourDetails" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element name="Duration" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Duration -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="Extensions" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="Features" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element name="HotelInformation" minOccurs="0">
                         *         &lt;!-- Reference to inner class HotelInformation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="Location" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="Meals" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element type="xs:string" name="Options" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element name="Price" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Price -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="ServiceInformation" minOccurs="0">
                         *         &lt;!-- Reference to inner class ServiceInformation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *       &lt;xs:element name="VehicleInformation" minOccurs="0">
                         *         &lt;!-- Reference to inner class VehicleInformation -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceCityName"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Vendor"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TourDetails implements Serializable
                        {
                            private List<String> confirmationNumberList = new ArrayList<String>();
                            private List<Duration> durationList = new ArrayList<Duration>();
                            private List<String> extensionList = new ArrayList<String>();
                            private List<String> featureList = new ArrayList<String>();
                            private HotelInformation hotelInformation;
                            private List<String> locationList = new ArrayList<String>();
                            private List<String> mealList = new ArrayList<String>();
                            private List<String> optionList = new ArrayList<String>();
                            private List<Price> priceList = new ArrayList<Price>();
                            private ServiceInformation serviceInformation;
                            private List<String> textList = new ArrayList<String>();
                            private VehicleInformation vehicleInformation;
                            private String locationCode;
                            private String name;
                            private String number;
                            private String serviceCityName;
                            private String vendor;

                            /** 
                             * Get the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the confirmation number associated with the particular tour reservation.
                             * 
                             * @return list
                             */
                            public List<String> getConfirmationNumberList() {
                                return confirmationNumberList;
                            }

                            /** 
                             * Set the list of 'ConfirmationNumber' element items. "ConfirmationNumber" is used to return the confirmation number associated with the particular tour reservation.
                             * 
                             * @param list
                             */
                            public void setConfirmationNumberList(
                                    List<String> list) {
                                confirmationNumberList = list;
                            }

                            /** 
                             * Get the list of 'Duration' element items.
                             * 
                             * @return list
                             */
                            public List<Duration> getDurationList() {
                                return durationList;
                            }

                            /** 
                             * Set the list of 'Duration' element items.
                             * 
                             * @param list
                             */
                            public void setDurationList(List<Duration> list) {
                                durationList = list;
                            }

                            /** 
                             * Get the list of 'Extensions' element items. "Extensions" is used to return extension-related information associated with the particular tour reservation.
                             * 
                             * @return list
                             */
                            public List<String> getExtensionList() {
                                return extensionList;
                            }

                            /** 
                             * Set the list of 'Extensions' element items. "Extensions" is used to return extension-related information associated with the particular tour reservation.
                             * 
                             * @param list
                             */
                            public void setExtensionList(List<String> list) {
                                extensionList = list;
                            }

                            /** 
                             * Get the list of 'Features' element items. "Features" is used to return feature-related information associated with the particular tour reservation.
                             * 
                             * @return list
                             */
                            public List<String> getFeatureList() {
                                return featureList;
                            }

                            /** 
                             * Set the list of 'Features' element items. "Features" is used to return feature-related information associated with the particular tour reservation.
                             * 
                             * @param list
                             */
                            public void setFeatureList(List<String> list) {
                                featureList = list;
                            }

                            /** 
                             * Get the 'HotelInformation' element value.
                             * 
                             * @return value
                             */
                            public HotelInformation getHotelInformation() {
                                return hotelInformation;
                            }

                            /** 
                             * Set the 'HotelInformation' element value.
                             * 
                             * @param hotelInformation
                             */
                            public void setHotelInformation(
                                    HotelInformation hotelInformation) {
                                this.hotelInformation = hotelInformation;
                            }

                            /** 
                             * Get the list of 'Location' element items. "Location" is used to return location-related information associated with the particular tour reservation.
                             * 
                             * @return list
                             */
                            public List<String> getLocationList() {
                                return locationList;
                            }

                            /** 
                             * Set the list of 'Location' element items. "Location" is used to return location-related information associated with the particular tour reservation.
                             * 
                             * @param list
                             */
                            public void setLocationList(List<String> list) {
                                locationList = list;
                            }

                            /** 
                             * Get the list of 'Meals' element items. "Meals" is used to return meal-related information associated with the particular tour reservation.
                             * 
                             * @return list
                             */
                            public List<String> getMealList() {
                                return mealList;
                            }

                            /** 
                             * Set the list of 'Meals' element items. "Meals" is used to return meal-related information associated with the particular tour reservation.
                             * 
                             * @param list
                             */
                            public void setMealList(List<String> list) {
                                mealList = list;
                            }

                            /** 
                             * Get the list of 'Options' element items. "Options" is used to return option-related information associated with the particular tour reservation.
                             * 
                             * @return list
                             */
                            public List<String> getOptionList() {
                                return optionList;
                            }

                            /** 
                             * Set the list of 'Options' element items. "Options" is used to return option-related information associated with the particular tour reservation.
                             * 
                             * @param list
                             */
                            public void setOptionList(List<String> list) {
                                optionList = list;
                            }

                            /** 
                             * Get the list of 'Price' element items.
                             * 
                             * @return list
                             */
                            public List<Price> getPriceList() {
                                return priceList;
                            }

                            /** 
                             * Set the list of 'Price' element items.
                             * 
                             * @param list
                             */
                            public void setPriceList(List<Price> list) {
                                priceList = list;
                            }

                            /** 
                             * Get the 'ServiceInformation' element value.
                             * 
                             * @return value
                             */
                            public ServiceInformation getServiceInformation() {
                          