
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Identifies the trip type - one way, return, circle trip, open jaw.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTripType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OneWay"/>
 *     &lt;xs:enumeration value="Return"/>
 *     &lt;xs:enumeration value="Circle"/>
 *     &lt;xs:enumeration value="OpenJaw"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AirTripType implements Serializable {
    ONE_WAY("OneWay"), RETURN("Return"), CIRCLE("Circle"), OPEN_JAW("OpenJaw"), OTHER(
            "Other");
    private final String value;

    private AirTripType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AirTripType convert(String value) {
        for (AirTripType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
