
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Used to specify a code and its associated attributes; meaning is derived from actual use.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodeListGroup">
 *   &lt;xs:attribute type="xs:string" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="codeContext"/>
 *   &lt;xs:attribute type="xs:string" name="URI"/>
 *   &lt;xs:attribute type="xs:int" name="quantity"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CodeListGroup implements Serializable
{
    private String code;
    private String codeContext;
    private String URI;
    private Integer quantity;

    /** 
     * Get the 'code' attribute value. Any code used to specify an item, for example, type of traveler, service code, room amenity, etc.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Any code used to specify an item, for example, type of traveler, service code, room amenity, etc.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'codeContext' attribute value. Identifies the source authority for the code.
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'codeContext' attribute value. Identifies the source authority for the code.
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'URI' attribute value. Identifies the location of the code table
     * 
     * @return value
     */
    public String getURI() {
        return URI;
    }

    /** 
     * Set the 'URI' attribute value. Identifies the location of the code table
     * 
     * @param URI
     */
    public void setURI(String URI) {
        this.URI = URI;
    }

    /** 
     * Get the 'quantity' attribute value. Specifies the number of items that are identified by the Code (e.g., 2 adults, 5 first class seats).
     * 
     * @return value
     */
    public Integer getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'quantity' attribute value. Specifies the number of items that are identified by the Code (e.g., 2 adults, 5 first class seats).
     * 
     * @param quantity
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
}
