
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Provides a monetary amount and the currency code to reflect the currency in which this amount is expressed.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DecimalPrice">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:decimal">
 *       &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DecimalPrice implements Serializable
{
    private BigDecimal decimal;
    private String currencyCode;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public BigDecimal getDecimal() {
        return decimal;
    }

    /** 
     * Set the extension value.
     * 
     * @param decimal
     */
    public void setDecimal(BigDecimal decimal) {
        this.decimal = decimal;
    }

    /** 
     * Get the 'currencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
}
