
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Reservation" minOccurs="0">
 *       &lt;!-- Reference to inner class Reservation -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AdditionalInformation" minOccurs="0">
 *       &lt;!-- Reference to inner class AdditionalInformation -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="SegmentText" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:short" name="sequence"/>
 *   &lt;xs:attribute type="xs:boolean" name="isPast"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HotelType implements Serializable
{
    private Reservation reservation;
    private AdditionalInformation additionalInformation;
    private String segmentText;
    private BigInteger index;
    private String id;
    private Short sequence;
    private Boolean isPast;

    /** 
     * Get the 'Reservation' element value.
     * 
     * @return value
     */
    public Reservation getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value.
     * 
     * @param reservation
     */
    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    /** 
     * Get the 'AdditionalInformation' element value.
     * 
     * @return value
     */
    public AdditionalInformation getAdditionalInformation() {
        return additionalInformation;
    }

    /** 
     * Set the 'AdditionalInformation' element value.
     * 
     * @param additionalInformation
     */
    public void setAdditionalInformation(
            AdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    /** 
     * Get the 'SegmentText' element value.
     * 
     * @return value
     */
    public String getSegmentText() {
        return segmentText;
    }

    /** 
     * Set the 'SegmentText' element value.
     * 
     * @param segmentText
     */
    public void setSegmentText(String segmentText) {
        this.segmentText = segmentText;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'sequence' attribute value. Identifies sequence number of Itinerary
     * 
     * @return value
     */
    public Short getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value. Identifies sequence number of Itinerary
     * 
     * @param sequence
     */
    public void setSequence(Short sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'isPast' attribute value. It returns information if current element is past or not.
     * 
     * @return value
     */
    public Boolean getIsPast() {
        return isPast;
    }

    /** 
     * Set the 'isPast' attribute value. It returns information if current element is past or not.
     * 
     * @param isPast
     */
    public void setIsPast(Boolean isPast) {
        this.isPast = isPast;
    }
    /** 
     * Hotel reservation  information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reservation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:integer" name="LineNumber" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LineType" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LineStatus" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="POSRequestorID" minOccurs="0"/>
     *       &lt;xs:element name="SpecialPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class SpecialPrefs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RoomType" minOccurs="0">
     *         &lt;!-- Reference to inner class RoomType -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Services" minOccurs="0">
     *         &lt;!-- Reference to inner class Services -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RoomRates" minOccurs="0">
     *         &lt;!-- Reference to inner class RoomRates -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RateAccessCodeBooked" minOccurs="0">
     *         &lt;!-- Reference to inner class RateAccessCodeBooked -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="GuestCounts" minOccurs="0">
     *         &lt;!-- Reference to inner class GuestCounts -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:dateTime" name="TimeSpanStart" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TimeSpanDuration" minOccurs="0"/>
     *       &lt;xs:element type="xs:dateTime" name="TimeSpanEnd" minOccurs="0"/>
     *       &lt;xs:element name="Guarantee" minOccurs="0">
     *         &lt;!-- Reference to inner class Guarantee -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="ChainCode" minOccurs="0"/>
     *       &lt;xs:element name="HotelCode" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HotelCode -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="HotelCityCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="HotelName" minOccurs="0"/>
     *       &lt;xs:element name="HotelTotalPricing" minOccurs="0">
     *         &lt;!-- Reference to inner class HotelTotalPricing -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="HotelReplyText" minOccurs="0"/>
     *       &lt;xs:element type="ns:HotelUniqueIDType" name="HotelUniqueID" minOccurs="0" maxOccurs="5"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Reservation implements Serializable
    {
        private BigInteger lineNumber;
        private String lineType;
        private String lineStatus;
        private String POSRequestorID;
        private SpecialPrefs specialPrefs;
        private RoomType roomType;
        private Services services;
        private RoomRates roomRates;
        private RateAccessCodeBooked rateAccessCodeBooked;
        private GuestCounts guestCounts;
        private Date timeSpanStart;
        private String timeSpanDuration;
        private Date timeSpanEnd;
        private Guarantee guarantee;
        private String chainCode;
        private List<HotelCode> hotelCodeList = new ArrayList<HotelCode>();
        private String hotelCityCode;
        private String hotelName;
        private HotelTotalPricing hotelTotalPricing;
        private String hotelReplyText;
        private List<HotelUniqueIDType> hotelUniqueIDList = new ArrayList<HotelUniqueIDType>();

        /** 
         * Get the 'LineNumber' element value.
         * 
         * @return value
         */
        public BigInteger getLineNumber() {
            return lineNumber;
        }

        /** 
         * Set the 'LineNumber' element value.
         * 
         * @param lineNumber
         */
        public void setLineNumber(BigInteger lineNumber) {
            this.lineNumber = lineNumber;
        }

        /** 
         * Get the 'LineType' element value.
         * 
         * @return value
         */
        public String getLineType() {
            return lineType;
        }

        /** 
         * Set the 'LineType' element value.
         * 
         * @param lineType
         */
        public void setLineType(String lineType) {
            this.lineType = lineType;
        }

        /** 
         * Get the 'LineStatus' element value.
         * 
         * @return value
         */
        public String getLineStatus() {
            return lineStatus;
        }

        /** 
         * Set the 'LineStatus' element value.
         * 
         * @param lineStatus
         */
        public void setLineStatus(String lineStatus) {
            this.lineStatus = lineStatus;
        }

        /** 
         * Get the 'POSRequestorID' element value.
         * 
         * @return value
         */
        public String getPOSRequestorID() {
            return POSRequestorID;
        }

        /** 
         * Set the 'POSRequestorID' element value.
         * 
         * @param POSRequestorID
         */
        public void setPOSRequestorID(String POSRequestorID) {
            this.POSRequestorID = POSRequestorID;
        }

        /** 
         * Get the 'SpecialPrefs' element value.
         * 
         * @return value
         */
        public SpecialPrefs getSpecialPrefs() {
            return specialPrefs;
        }

        /** 
         * Set the 'SpecialPrefs' element value.
         * 
         * @param specialPrefs
         */
        public void setSpecialPrefs(SpecialPrefs specialPrefs) {
            this.specialPrefs = specialPrefs;
        }

        /** 
         * Get the 'RoomType' element value.
         * 
         * @return value
         */
        public RoomType getRoomType() {
            return roomType;
        }

        /** 
         * Set the 'RoomType' element value.
         * 
         * @param roomType
         */
        public void setRoomType(RoomType roomType) {
            this.roomType = roomType;
        }

        /** 
         * Get the 'Services' element value.
         * 
         * @return value
         */
        public Services getServices() {
            return services;
        }

        /** 
         * Set the 'Services' element value.
         * 
         * @param services
         */
        public void setServices(Services services) {
            this.services = services;
        }

        /** 
         * Get the 'RoomRates' element value.
         * 
         * @return value
         */
        public RoomRates getRoomRates() {
            return roomRates;
        }

        /** 
         * Set the 'RoomRates' element value.
         * 
         * @param roomRates
         */
        public void setRoomRates(RoomRates roomRates) {
            this.roomRates = roomRates;
        }

        /** 
         * Get the 'RateAccessCodeBooked' element value.
         * 
         * @return value
         */
        public RateAccessCodeBooked getRateAccessCodeBooked() {
            return rateAccessCodeBooked;
        }

        /** 
         * Set the 'RateAccessCodeBooked' element value.
         * 
         * @param rateAccessCodeBooked
         */
        public void setRateAccessCodeBooked(
                RateAccessCodeBooked rateAccessCodeBooked) {
            this.rateAccessCodeBooked = rateAccessCodeBooked;
        }

        /** 
         * Get the 'GuestCounts' element value.
         * 
         * @return value
         */
        public GuestCounts getGuestCounts() {
            return guestCounts;
        }

        /** 
         * Set the 'GuestCounts' element value.
         * 
         * @param guestCounts
         */
        public void setGuestCounts(GuestCounts guestCounts) {
            this.guestCounts = guestCounts;
        }

        /** 
         * Get the 'TimeSpanStart' element value. The starting value of the time span.
         * 
         * @return value
         */
        public Date getTimeSpanStart() {
            return timeSpanStart;
        }

        /** 
         * Set the 'TimeSpanStart' element value. The starting value of the time span.
         * 
         * @param timeSpanStart
         */
        public void setTimeSpanStart(Date timeSpanStart) {
            this.timeSpanStart = timeSpanStart;
        }

        /** 
         * Get the 'TimeSpanDuration' element value. The lexical representation for timeDuration is the [ISO 8601] extended format PnYn MnDTnH nMnS,
                                        where nY represents the number of years, nM the number of months, nD the number of days,
                                        'T' is the date/time separator, nH the number of hours, nM the number of minutes and nS the number of seconds.
                                        The number of seconds can include decimal digits to arbitrary precision.
                                        As an example, 7 months, 2 days, 2hours and 30 minutes would be expressed as P0Y7M2DT2H30M0S.
                                        Truncated representations are allowed provided they conform to ISO 8601 format.
         * 
         * @return value
         */
        public String getTimeSpanDuration() {
            return timeSpanDuration;
        }

        /** 
         * Set the 'TimeSpanDuration' element value. The lexical representation for timeDuration is the [ISO 8601] extended format PnYn MnDTnH nMnS,
                                        where nY represents the number of years, nM the number of months, nD the number of days,
                                        'T' is the date/time separator, nH the number of hours, nM the number of minutes and nS the number of seconds.
                                        The number of seconds can include decimal digits to arbitrary precision.
                                        As an example, 7 months, 2 days, 2hours and 30 minutes would be expressed as P0Y7M2DT2H30M0S.
                                        Truncated representations are allowed provided they conform to ISO 8601 format.
         * 
         * @param timeSpanDuration
         */
        public void setTimeSpanDuration(String timeSpanDuration) {
            this.timeSpanDuration = timeSpanDuration;
        }

        /** 
         * Get the 'TimeSpanEnd' element value. The ending value of the time span.
         * 
         * @return value
         */
        public Date getTimeSpanEnd() {
            return timeSpanEnd;
        }

        /** 
         * Set the 'TimeSpanEnd' element value. The ending value of the time span.
         * 
         * @param timeSpanEnd
         */
        public void setTimeSpanEnd(Date timeSpanEnd) {
            this.timeSpanEnd = timeSpanEnd;
        }

        /** 
         * Get the 'Guarantee' element value.
         * 
         * @return value
         */
        public Guarantee getGuarantee() {
            return guarantee;
        }

        /** 
         * Set the 'Guarantee' element value.
         * 
         * @param guarantee
         */
        public void setGuarantee(Guarantee guarantee) {
            this.guarantee = guarantee;
        }

        /** 
         * Get the 'ChainCode' element value. The code that identifies a hotel chain or management group.
                                        The hotel chain code is decided between vendors.
                                        This attribute is optional if the hotel is an independent property that can be identified by the HotelCode attribute.
         * 
         * @return value
         */
        public String getChainCode() {
            return chainCode;
        }

        /** 
         * Set the 'ChainCode' element value. The code that identifies a hotel chain or management group.
                                        The hotel chain code is decided between vendors.
                                        This attribute is optional if the hotel is an independent property that can be identified by the HotelCode attribute.
         * 
         * @param chainCode
         */
        public void setChainCode(String chainCode) {
            this.chainCode = chainCode;
        }

        /** 
         * Get the list of 'HotelCode' element items.
         * 
         * @return list
         */
        public List<HotelCode> getHotelCodeList() {
            return hotelCodeList;
        }

        /** 
         * Set the list of 'HotelCode' element items.
         * 
         * @param list
         */
        public void setHotelCodeList(List<HotelCode> list) {
            hotelCodeList = list;
        }

        /** 
         * Get the 'HotelCityCode' element value. The IATA city code; for example DCA, ORD.
         * 
         * @return value
         */
        public String getHotelCityCode() {
            return hotelCityCode;
        }

        /** 
         * Set the 'HotelCityCode' element value. The IATA city code; for example DCA, ORD.
         * 
         * @param hotelCityCode
         */
        public void setHotelCityCode(String hotelCityCode) {
            this.hotelCityCode = hotelCityCode;
        }

        /** 
         * Get the 'HotelName' element value.  A text field used to communicate the proper name of the hotel.
         * 
         * @return value
         */
        public String getHotelName() {
            return hotelName;
        }

        /** 
         * Set the 'HotelName' element value.  A text field used to communicate the proper name of the hotel.
         * 
         * @param hotelName
         */
        public void setHotelName(String hotelName) {
            this.hotelName = hotelName;
        }

        /** 
         * Get the 'HotelTotalPricing' element value.
         * 
         * @return value
         */
        public HotelTotalPricing getHotelTotalPricing() {
            return hotelTotalPricing;
        }

        /** 
         * Set the 'HotelTotalPricing' element value.
         * 
         * @param hotelTotalPricing
         */
        public void setHotelTotalPricing(HotelTotalPricing hotelTotalPricing) {
            this.hotelTotalPricing = hotelTotalPricing;
        }

        /** 
         * Get the 'HotelReplyText' element value. A text field with info received from the hotel at the time of booking.
         * 
         * @return value
         */
        public String getHotelReplyText() {
            return hotelReplyText;
        }

        /** 
         * Set the 'HotelReplyText' element value. A text field with info received from the hotel at the time of booking.
         * 
         * @param hotelReplyText
         */
        public void setHotelReplyText(String hotelReplyText) {
            this.hotelReplyText = hotelReplyText;
        }

        /** 
         * Get the list of 'HotelUniqueID' element items.
         * 
         * @return list
         */
        public List<HotelUniqueIDType> getHotelUniqueIDList() {
            return hotelUniqueIDList;
        }

        /** 
         * Set the list of 'HotelUniqueID' element items.
         * 
         * @param list
         */
        public void setHotelUniqueIDList(List<HotelUniqueIDType> list) {
            hotelUniqueIDList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:boolean" name="LateDepartureRequired" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SpecialPrefs implements Serializable
        {
            private List<String> textList = new ArrayList<String>();
            private Boolean lateDepartureRequired;

            /** 
             * Get the list of 'Text' element items.
             * 
             * @return list
             */
            public List<String> getTextList() {
                return textList;
            }

            /** 
             * Set the list of 'Text' element items.
             * 
             * @param list
             */
            public void setTextList(List<String> list) {
                textList = list;
            }

            /** 
             * Get the 'LateDepartureRequired' element value.
             * 
             * @return value
             */
            public Boolean getLateDepartureRequired() {
                return lateDepartureRequired;
            }

            /** 
             * Set the 'LateDepartureRequired' element value.
             * 
             * @param lateDepartureRequired
             */
            public void setLateDepartureRequired(Boolean lateDepartureRequired) {
                this.lateDepartureRequired = lateDepartureRequired;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="RoomTypeCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:integer" name="NumberOfUnits" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
         *       &lt;xs:element type="xs:unsignedShort" name="RateOccupancyPerRoom" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="BedTypeDesc" minOccurs="0"/>
         *       &lt;xs:element type="xs:unsignedShort" name="NumOfBeds" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RoomType implements Serializable
        {
            private String roomTypeCode;
            private BigInteger numberOfUnits;
            private String shortText;
            private String rateOccupancyPerRoom;
            private String bedTypeDesc;
            private String numOfBeds;

            /** 
             * Get the 'RoomTypeCode' element value. Specific system room type code, ex: A1K, A1Q etc.
             * 
             * @return value
             */
            public String getRoomTypeCode() {
                return roomTypeCode;
            }

            /** 
             * Set the 'RoomTypeCode' element value. Specific system room type code, ex: A1K, A1Q etc.
             * 
             * @param roomTypeCode
             */
            public void setRoomTypeCode(String roomTypeCode) {
                this.roomTypeCode = roomTypeCode;
            }

            /** 
             * Get the 'NumberOfUnits' element value.
             * 
             * @return value
             */
            public BigInteger getNumberOfUnits() {
                return numberOfUnits;
            }

            /** 
             * Set the 'NumberOfUnits' element value.
             * 
             * @param numberOfUnits
             */
            public void setNumberOfUnits(BigInteger numberOfUnits) {
                this.numberOfUnits = numberOfUnits;
            }

            /** 
             * Get the 'ShortText' element value.
             * 
             * @return value
             */
            public String getShortText() {
                return shortText;
            }

            /** 
             * Set the 'ShortText' element value.
             * 
             * @param shortText
             */
            public void setShortText(String shortText) {
                this.shortText = shortText;
            }

            /** 
             * Get the 'RateOccupancyPerRoom' element value. Indicates how many guests the room can accommodate for the provided rate.
             * 
             * @return value
             */
            public String getRateOccupancyPerRoom() {
                return rateOccupancyPerRoom;
            }

            /** 
             * Set the 'RateOccupancyPerRoom' element value. Indicates how many guests the room can accommodate for the provided rate.
             * 
             * @param rateOccupancyPerRoom
             */
            public void setRateOccupancyPerRoom(String rateOccupancyPerRoom) {
                this.rateOccupancyPerRoom = rateOccupancyPerRoom;
            }

            /** 
             * Get the 'BedTypeDesc' element value. Specifies the type of bed.
             * 
             * @return value
             */
            public String getBedTypeDesc() {
                return bedTypeDesc;
            }

            /** 
             * Set the 'BedTypeDesc' element value. Specifies the type of bed.
             * 
             * @param bedTypeDesc
             */
            public void setBedTypeDesc(String bedTypeDesc) {
                this.bedTypeDesc = bedTypeDesc;
            }

            /** 
             * Get the 'NumOfBeds' element value. Specifies the number of beds requested.
             * 
             * @return value
             */
            public String getNumOfBeds() {
                return numOfBeds;
            }

            /** 
             * Set the 'NumOfBeds' element value. Specifies the number of beds requested.
             * 
             * @param numOfBeds
             */
            public void setNumOfBeds(String numOfBeds) {
                this.numOfBeds = numOfBeds;
            }
        }
        /** 
         * Specifies additional services to be provided by hotel.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="MealType" minOccurs="0">
         *         &lt;!-- Reference to inner class MealType -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Services implements Serializable
        {
            private MealType mealType;

            /** 
             * Get the 'MealType' element value.
             * 
             * @return value
             */
            public MealType getMealType() {
                return mealType;
            }

            /** 
             * Set the 'MealType' element value.
             * 
             * @param mealType
             */
            public void setMealType(MealType mealType) {
                this.mealType = mealType;
            }
            /** 
             * Type of meal (e.g. breakfast, dinner etc.)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="mealTypeCode"/>
             *     &lt;xs:attribute type="xs:string" name="mealTypeDescription"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MealType implements Serializable
            {
                private String mealTypeCode;
                private String mealTypeDescription;

                /** 
                 * Get the 'mealTypeCode' attribute value. Meal type code  (e.g. BB, HB, AI)
                 * 
                 * @return value
                 */
                public String getMealTypeCode() {
                    return mealTypeCode;
                }

                /** 
                 * Set the 'mealTypeCode' attribute value. Meal type code  (e.g. BB, HB, AI)
                 * 
                 * @param mealTypeCode
                 */
                public void setMealTypeCode(String mealTypeCode) {
                    this.mealTypeCode = mealTypeCode;
                }

                /** 
                 * Get the 'mealTypeDescription' attribute value. Meal type description
                 * 
                 * @return value
                 */
                public String getMealTypeDescription() {
                    return mealTypeDescription;
                }

                /** 
                 * Set the 'mealTypeDescription' attribute value. Meal type description
                 * 
                 * @param mealTypeDescription
                 */
                public void setMealTypeDescription(String mealTypeDescription) {
                    this.mealTypeDescription = mealTypeDescription;
                }
            }
        }
        /** 
         * Reservation rate(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomRates" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="AmountBeforeTax" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:boolean" name="Override" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RoomRates implements Serializable
        {
            private String amountBeforeTax;
            private String currencyCode;
            private Boolean override;

            /** 
             * Get the 'AmountBeforeTax' element value.
             * 
             * @return value
             */
            public String getAmountBeforeTax() {
                return amountBeforeTax;
            }

            /** 
             * Set the 'AmountBeforeTax' element value.
             * 
             * @param amountBeforeTax
             */
            public void setAmountBeforeTax(String amountBeforeTax) {
                this.amountBeforeTax = amountBeforeTax;
            }

            /** 
             * Get the 'CurrencyCode' element value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' element value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'Override' element value.
             * 
             * @return value
             */
            public Boolean getOverride() {
                return override;
            }

            /** 
             * Set the 'Override' element value.
             * 
             * @param override
             */
            public void setOverride(Boolean override) {
                this.override = override;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateAccessCodeBooked" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ClientIdentificationCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="RateAccessCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CategoryTypeCode" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RateAccessCodeBooked implements Serializable
        {
            private String clientIdentificationCode;
            private String rateAccessCode;
            private String categoryTypeCode;

            /** 
             * Get the 'ClientIdentificationCode' element value.
             * 
             * @return value
             */
            public String getClientIdentificationCode() {
                return clientIdentificationCode;
            }

            /** 
             * Set the 'ClientIdentificationCode' element value.
             * 
             * @param clientIdentificationCode
             */
            public void setClientIdentificationCode(
                    String clientIdentificationCode) {
                this.clientIdentificationCode = clientIdentificationCode;
            }

            /** 
             * Get the 'RateAccessCode' element value.
             * 
             * @return value
             */
            public String getRateAccessCode() {
                return rateAccessCode;
            }

            /** 
             * Set the 'RateAccessCode' element value.
             * 
             * @param rateAccessCode
             */
            public void setRateAccessCode(String rateAccessCode) {
                this.rateAccessCode = rateAccessCode;
            }

            /** 
             * Get the 'CategoryTypeCode' element value.
             * 
             * @return value
             */
            public String getCategoryTypeCode() {
                return categoryTypeCode;
            }

            /** 
             * Set the 'CategoryTypeCode' element value.
             * 
             * @param categoryTypeCode
             */
            public void setCategoryTypeCode(String categoryTypeCode) {
                this.categoryTypeCode = categoryTypeCode;
            }
        }
        /** 
         * Number of guests associated with this reservation.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuestCounts" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:integer" name="GuestCount" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ExtraGuestCount" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="RollAwayCount" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:integer" name="CribCount" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:unsignedShort" name="ChildGuestCount" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ChildAges" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GuestCounts implements Serializable
        {
            private BigInteger guestCount;
            private List<String> extraGuestCountList = new ArrayList<String>();
            private List<String> rollAwayCountList = new ArrayList<String>();
            private List<BigInteger> cribCountList = new ArrayList<BigInteger>();
            private List<String> reserveUnderNameList = new ArrayList<String>();
            private List<String> nameList = new ArrayList<String>();
            private String childGuestCount;
            private String childAges;

            /** 
             * Get the 'GuestCount' element value.
             * 
             * @return value
             */
            public BigInteger getGuestCount() {
                return guestCount;
            }

            /** 
             * Set the 'GuestCount' element value.
             * 
             * @param guestCount
             */
            public void setGuestCount(BigInteger guestCount) {
                this.guestCount = guestCount;
            }

            /** 
             * Get the list of 'ExtraGuestCount' element items.
             * 
             * @return list
             */
            public List<String> getExtraGuestCountList() {
                return extraGuestCountList;
            }

            /** 
             * Set the list of 'ExtraGuestCount' element items.
             * 
             * @param list
             */
            public void setExtraGuestCountList(List<String> list) {
                extraGuestCountList = list;
            }

            /** 
             * Get the list of 'RollAwayCount' element items.
             * 
             * @return list
             */
            public List<String> getRollAwayCountList() {
                return rollAwayCountList;
            }

            /** 
             * Set the list of 'RollAwayCount' element items.
             * 
             * @param list
             */
            public void setRollAwayCountList(List<String> list) {
                rollAwayCountList = list;
            }

            /** 
             * Get the list of 'CribCount' element items.
             * 
             * @return list
             */
            public List<BigInteger> getCribCountList() {
                return cribCountList;
            }

            /** 
             * Set the list of 'CribCount' element items.
             * 
             * @param list
             */
            public void setCribCountList(List<BigInteger> list) {
                cribCountList = list;
            }

            /** 
             * Get the list of 'ReserveUnderName' element items.
             * 
             * @return list
             */
            public List<String> getReserveUnderNameList() {
                return reserveUnderNameList;
            }

            /** 
             * Set the list of 'ReserveUnderName' element items.
             * 
             * @param list
             */
            public void setReserveUnderNameList(List<String> list) {
                reserveUnderNameList = list;
            }

            /** 
             * Get the list of 'Name' element items.
             * 
             * @return list
             */
            public List<String> getNameList() {
                return nameList;
            }

            /** 
             * Set the list of 'Name' element items.
             * 
             * @param list
             */
            public void setNameList(List<String> list) {
                nameList = list;
            }

            /** 
             * Get the 'ChildGuestCount' element value. Child guest count for the room. Required for all properties.
                                                      Used in combination with ChildAges to determine availability and rates.
             * 
             * @return value
             */
            public String getChildGuestCount() {
                return childGuestCount;
            }

            /** 
             * Set the 'ChildGuestCount' element value. Child guest count for the room. Required for all properties.
                                                      Used in combination with ChildAges to determine availability and rates.
             * 
             * @param childGuestCount
             */
            public void setChildGuestCount(String childGuestCount) {
                this.childGuestCount = childGuestCount;
            }

            /** 
             * Get the 'ChildAges' element value. The individual ages of the children in the room as a comma-separated list.
             * 
             * @return value
             */
            public String getChildAges() {
                return childAges;
            }

            /** 
             * Set the 'ChildAges' element value. The individual ages of the children in the room as a comma-separated list.
             * 
             * @param childAges
             */
            public void setChildAges(String childAges) {
                this.childAges = childAges;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Guarantee" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PaymentCardNumber" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Guarantee implements Serializable
        {
            private String paymentCardNumber;
            private String text;

            /** 
             * Get the 'PaymentCardNumber' element value.
             * 
             * @return value
             */
            public String getPaymentCardNumber() {
                return paymentCardNumber;
            }

            /** 
             * Set the 'PaymentCardNumber' element value.
             * 
             * @param paymentCardNumber
             */
            public void setPaymentCardNumber(String paymentCardNumber) {
                this.paymentCardNumber = paymentCardNumber;
            }

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }
        }
        /** 
         * The code that uniquely identifies a single hotel property. The hotel code is decided between vendors.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelCode" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="Source"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HotelCode implements Serializable
        {
            private String string;
            private String source;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Source' attribute value. Hold the source of this Hotel Code which could be external application or system
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'Source' attribute value. Hold the source of this Hotel Code which could be external application or system
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelTotalPricing" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TotalTax" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalTax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TotalSurcharge" minOccurs="0">
         *         &lt;!-- Reference to inner class TotalSurcharge -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ApproximateTotal" minOccurs="0">
         *         &lt;!-- Reference to inner class ApproximateTotal -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RateChange" minOccurs="0" maxOccurs="8">
         *         &lt;!-- Reference to inner class RateChange -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Disclaimer" minOccurs="0" maxOccurs="2">
         *         &lt;!-- Reference to inner class Disclaimer -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HotelFees" minOccurs="0">
         *         &lt;!-- Reference to inner class HotelFees -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:float" name="NightlyRateTotal" minOccurs="0"/>
         *       &lt;xs:element type="xs:float" name="MaxNightlyRate" minOccurs="0"/>
         *       &lt;xs:element type="xs:float" name="CommissionableUsdTotal" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HotelTotalPricing implements Serializable
        {
            private TotalTax totalTax;
            private TotalSurcharge totalSurcharge;
            private ApproximateTotal approximateTotal;
            private List<RateChange> rateChangeList = new ArrayList<RateChange>();
            private List<Disclaimer> disclaimerList = new ArrayList<Disclaimer>();
            private HotelFees hotelFees;
            private Float nightlyRateTotal;
            private Float maxNightlyRate;
            private Float commissionableUsdTotal;
            private String currencyCode;

            /** 
             * Get the 'TotalTax' element value.
             * 
             * @return value
             */
            public TotalTax getTotalTax() {
                return totalTax;
            }

            /** 
             * Set the 'TotalTax' element value.
             * 
             * @param totalTax
             */
            public void setTotalTax(TotalTax totalTax) {
                this.totalTax = totalTax;
            }

            /** 
             * Get the 'TotalSurcharge' element value.
             * 
             * @return value
             */
            public TotalSurcharge getTotalSurcharge() {
                return totalSurcharge;
            }

            /** 
             * Set the 'TotalSurcharge' element value.
             * 
             * @param totalSurcharge
             */
            public void setTotalSurcharge(TotalSurcharge totalSurcharge) {
                this.totalSurcharge = totalSurcharge;
            }

            /** 
             * Get the 'ApproximateTotal' element value.
             * 
             * @return value
             */
            public ApproximateTotal getApproximateTotal() {
                return approximateTotal;
            }

            /** 
             * Set the 'ApproximateTotal' element value.
             * 
             * @param approximateTotal
             */
            public void setApproximateTotal(ApproximateTotal approximateTotal) {
                this.approximateTotal = approximateTotal;
            }

            /** 
             * Get the list of 'RateChange' element items.
             * 
             * @return list
             */
            public List<RateChange> getRateChangeList() {
                return rateChangeList;
            }

            /** 
             * Set the list of 'RateChange' element items.
             * 
             * @param list
             */
            public void setRateChangeList(List<RateChange> list) {
                rateChangeList = list;
            }

            /** 
             * Get the list of 'Disclaimer' element items.
             * 
             * @return list
             */
            public List<Disclaimer> getDisclaimerList() {
                return disclaimerList;
            }

            /** 
             * Set the list of 'Disclaimer' element items.
             * 
             * @param list
             */
            public void setDisclaimerList(List<Disclaimer> list) {
                disclaimerList = list;
            }

            /** 
             * Get the 'HotelFees' element value.
             * 
             * @return value
             */
            public HotelFees getHotelFees() {
                return hotelFees;
            }

            /** 
             * Set the 'HotelFees' element value.
             * 
             * @param hotelFees
             */
            public void setHotelFees(HotelFees hotelFees) {
                this.hotelFees = hotelFees;
            }

            /** 
             * Get the 'NightlyRateTotal' element value. Total of all nightly rate values.
             * 
             * @return value
             */
            public Float getNightlyRateTotal() {
                return nightlyRateTotal;
            }

            /** 
             * Set the 'NightlyRateTotal' element value. Total of all nightly rate values.
             * 
             * @param nightlyRateTotal
             */
            public void setNightlyRateTotal(Float nightlyRateTotal) {
                this.nightlyRateTotal = nightlyRateTotal;
            }

            /** 
             * Get the 'MaxNightlyRate' element value. The highest nightly rate of all rates.
             * 
             * @return value
             */
            public Float getMaxNightlyRate() {
                return maxNightlyRate;
            }

            /** 
             * Set the 'MaxNightlyRate' element value. The highest nightly rate of all rates.
             * 
             * @param maxNightlyRate
             */
            public void setMaxNightlyRate(Float maxNightlyRate) {
                this.maxNightlyRate = maxNightlyRate;
            }

            /** 
             * Get the 'CommissionableUsdTotal' element value. Amount used to calculate partner commissions, in USD. Total of nightly rates less surcharges.
             * 
             * @return value
             */
            public Float getCommissionableUsdTotal() {
                return commissionableUsdTotal;
            }

            /** 
             * Set the 'CommissionableUsdTotal' element value. Amount used to calculate partner commissions, in USD. Total of nightly rates less surcharges.
             * 
             * @param commissionableUsdTotal
             */
            public void setCommissionableUsdTotal(Float commissionableUsdTotal) {
                this.commissionableUsdTotal = commissionableUsdTotal;
            }

            /** 
             * Get the 'CurrencyCode' attribute value. The code specifying a monetary unit. Use ISO 4217, three alpha code
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value. The code specifying a monetary unit. Use ISO 4217, three alpha code
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalTax implements Serializable
            {
                private List<Tax> taxList = new ArrayList<Tax>();
                private String amount;

                /** 
                 * Get the list of 'Tax' element items.
                 * 
                 * @return list
                 */
                public List<Tax> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items.
                 * 
                 * @param list
                 */
                public void setTaxList(List<Tax> list) {
                    taxList = list;
                }

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="Id"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private String string;
                    private String id;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalSurcharge" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Surcharge" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class Surcharge -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TotalSurcharge implements Serializable
            {
                private List<Surcharge> surchargeList = new ArrayList<Surcharge>();
                private String amount;

                /** 
                 * Get the list of 'Surcharge' element items.
                 * 
                 * @return list
                 */
                public List<Surcharge> getSurchargeList() {
                    return surchargeList;
                }

                /** 
                 * Set the list of 'Surcharge' element items.
                 * 
                 * @param list
                 */
                public void setSurchargeList(List<Surcharge> list) {
                    surchargeList = list;
                }

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharge" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="Id"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Surcharge implements Serializable
                {
                    private String string;
                    private String id;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Id' attribute value.
                     * 
                     * @return value
                     */
                    public String getId() {
                        return id;
                    }

                    /** 
                     * Set the 'Id' attribute value.
                     * 
                     * @param id
                     */
                    public void setId(String id) {
                        this.id = id;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApproximateTotal" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="AmountAndCurrency"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ApproximateTotal implements Serializable
            {
                private String amountAndCurrency;

                /** 
                 * Get the 'AmountAndCurrency' attribute value.
                 * 
                 * @return value
                 */
                public String getAmountAndCurrency() {
                    return amountAndCurrency;
                }

                /** 
                 * Set the 'AmountAndCurrency' attribute value.
                 * 
                 * @param amountAndCurrency
                 */
                public void setAmountAndCurrency(String amountAndCurrency) {
                    this.amountAndCurrency = amountAndCurrency;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateChange" minOccurs="0" maxOccurs="8">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="Id"/>
             *     &lt;xs:attribute type="xs:string" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" name="Effective"/>
             *     &lt;xs:attribute type="xs:string" name="Surcharge"/>
             *     &lt;xs:attribute type="xs:string" name="Tax"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RateChange implements Serializable
            {
                private String id;
                private String amount;
                private String effective;
                private String surcharge;
                private String tax;

                /** 
                 * Get the 'Id' attribute value.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Effective' attribute value.
                 * 
                 * @return value
                 */
                public String getEffective() {
                    return effective;
                }

                /** 
                 * Set the 'Effective' attribute value.
                 * 
                 * @param effective
                 */
                public void setEffective(String effective) {
                    this.effective = effective;
                }

                /** 
                 * Get the 'Surcharge' attribute value.
                 * 
                 * @return value
                 */
                public String getSurcharge() {
                    return surcharge;
                }

                /** 
                 * Set the 'Surcharge' attribute value.
                 * 
                 * @param surcharge
                 */
                public void setSurcharge(String surcharge) {
                    this.surcharge = surcharge;
                }

                /** 
                 * Get the 'Tax' attribute value.
                 * 
                 * @return value
                 */
                public String getTax() {
                    return tax;
                }

                /** 
                 * Set the 'Tax' attribute value.
                 * 
                 * @param tax
                 */
                public void setTax(String tax) {
                    this.tax = tax;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Disclaimer" minOccurs="0" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" name="Id"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Disclaimer implements Serializable
            {
                private String string;
                private String id;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Id' attribute value.
                 * 
                 * @return value
                 */
                public String getId() {
                    return id;
                }

                /** 
                 * Set the 'Id' attribute value.
                 * 
                 * @param id
                 */
                public void setId(String id) {
                    this.id = id;
                }
            }
            /** 
             * This element breaks out certain taxes and fees collected by the hotel that are otherwise not specifically detailed in the Surcharges array.
                                                      Contains size attribute to indicate the number of charges contained.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelFees" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="HotelFee" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HotelFee -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HotelFees implements Serializable
            {
                private List<HotelFee> hotelFeeList = new ArrayList<HotelFee>();

                /** 
                 * Get the list of 'HotelFee' element items.
                 * 
                 * @return list
                 */
                public List<HotelFee> getHotelFeeList() {
                    return hotelFeeList;
                }

                /** 
                 * Set the list of 'HotelFee' element items.
                 * 
                 * @param list
                 */
                public void setHotelFeeList(List<HotelFee> list) {
                    hotelFeeList = list;
                }
                /** 
                 * Contains attributes for the description, amount, and currency of a single fee.
                                                                    Details any VAT, state/city tax, resort fees, or any other fees collected that cannot be reasonably avoided.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelFee" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="Description"/>
                 *     &lt;xs:attribute type="xs:float" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HotelFee implements Serializable
                {
                    private String description;
                    private Float amount;

                    /** 
                     * Get the 'Description' attribute value. The type of charge.
                     * 
                     * @return value
                     */
                    public String getDescription() {
                        return description;
                    }

                    /** 
                     * Set the 'Description' attribute value. The type of charge.
                     * 
                     * @param description
                     */
                    public void setDescription(String description) {
                        this.description = description;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Value for the charge.
                     * 
                     * @return value
                     */
                    public Float getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Value for the charge.
                     * 
                     * @param amount
                     */
                    public void setAmount(Float amount) {
                        this.amount = amount;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ConfirmationNumber -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Address" minOccurs="0">
     *         &lt;!-- Reference to inner class Address -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactNumbers" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactNumbers -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="CancelPenaltyPolicyCode" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="CustLoyaltyMembershipID" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="IDNumber" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="CorporateIDNumber" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="Commission" minOccurs="0">
     *         &lt;!-- Reference to inner class Commission -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:boolean" name="WrittenConfirmation" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdditionalInformation implements Serializable
    {
        private List<ConfirmationNumber> confirmationNumberList = new ArrayList<ConfirmationNumber>();
        private Address address;
        private ContactNumbers contactNumbers;
        private List<String> cancelPenaltyPolicyCodeList = new ArrayList<String>();
        private List<String> custLoyaltyMembershipIDList = new ArrayList<String>();
        private List<String> IDNumberList = new ArrayList<String>();
        private List<String> corporateIDNumberList = new ArrayList<String>();
        private List<String> textList = new ArrayList<String>();
        private Commission commission;
        private Boolean writtenConfirmation;

        /** 
         * Get the list of 'ConfirmationNumber' element items.
         * 
         * @return list
         */
        public List<ConfirmationNumber> getConfirmationNumberList() {
            return confirmationNumberList;
        }

        /** 
         * Set the list of 'ConfirmationNumber' element items.
         * 
         * @param list
         */
        public void setConfirmationNumberList(List<ConfirmationNumber> list) {
            confirmationNumberList = list;
        }

        /** 
         * Get the 'Address' element value.
         * 
         * @return value
         */
        public Address getAddress() {
            return address;
        }

        /** 
         * Set the 'Address' element value.
         * 
         * @param address
         */
        public void setAddress(Address address) {
            this.address = address;
        }

        /** 
         * Get the 'ContactNumbers' element value.
         * 
         * @return value
         */
        public ContactNumbers getContactNumbers() {
            return contactNumbers;
        }

        /** 
         * Set the 'ContactNumbers' element value.
         * 
         * @param contactNumbers
         */
        public void setContactNumbers(ContactNumbers contactNumbers) {
            this.contactNumbers = contactNumbers;
        }

        /** 
         * Get the list of 'CancelPenaltyPolicyCode' element items.
         * 
         * @return list
         */
        public List<String> getCancelPenaltyPolicyCodeList() {
            return cancelPenaltyPolicyCodeList;
        }

        /** 
         * Set the list of 'CancelPenaltyPolicyCode' element items.
         * 
         * @param list
         */
        public void setCancelPenaltyPolicyCodeList(List<String> list) {
            cancelPenaltyPolicyCodeList = list;
        }

        /** 
         * Get the list of 'CustLoyaltyMembershipID' element items.
         * 
         * @return list
         */
        public List<String> getCustLoyaltyMembershipIDList() {
            return custLoyaltyMembershipIDList;
        }

        /** 
         * Set the list of 'CustLoyaltyMembershipID' element items.
         * 
         * @param list
         */
        public void setCustLoyaltyMembershipIDList(List<String> list) {
            custLoyaltyMembershipIDList = list;
        }

        /** 
         * Get the list of 'IDNumber' element items.
         * 
         * @return list
         */
        public List<String> getIDNumberList() {
            return IDNumberList;
        }

        /** 
         * Set the list of 'IDNumber' element items.
         * 
         * @param list
         */
        public void setIDNumberList(List<String> list) {
            IDNumberList = list;
        }

        /** 
         * Get the list of 'CorporateIDNumber' element items.
         * 
         * @return list
         */
        public List<String> getCorporateIDNumberList() {
            return corporateIDNumberList;
        }

        /** 
         * Set the list of 'CorporateIDNumber' element items.
         * 
         * @param list
         */
        public void setCorporateIDNumberList(List<String> list) {
            corporateIDNumberList = list;
        }

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }

        /** 
         * Get the 'Commission' element value.
         * 
         * @return value
         */
        public Commission getCommission() {
            return commission;
        }

        /** 
         * Set the 'Commission' element value.
         * 
         * @param commission
         */
        public void setCommission(Commission commission) {
            this.commission = commission;
        }

        /** 
         * Get the 'WrittenConfirmation' element value.
         * 
         * @return value
         */
        public Boolean getWrittenConfirmation() {
            return writtenConfirmation;
        }

        /** 
         * Set the 'WrittenConfirmation' element value.
         * 
         * @param writtenConfirmation
         */
        public void setWrittenConfirmation(Boolean writtenConfirmation) {
            this.writtenConfirmation = writtenConfirmation;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConfirmationNumber" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="Source"/>
         *         &lt;xs:attribute type="xs:boolean" default="false" name="DirectConnect"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ConfirmationNumber implements Serializable
        {
            private String string;
            private String source;
            private Boolean directConnect;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Source' attribute value. Source of this confirmation Number
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'Source' attribute value. Source of this confirmation Number
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }

            /** 
             * Get the 'DirectConnect' attribute value. Set if hotel was sold via DirectConnect
             * 
             * @return value
             */
            public Boolean getDirectConnect() {
                return directConnect;
            }

            /** 
             * Set the 'DirectConnect' attribute value. Set if hotel was sold via DirectConnect
             * 
             * @param directConnect
             */
            public void setDirectConnect(Boolean directConnect) {
                this.directConnect = directConnect;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ZipCode" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Address implements Serializable
        {
            private List<String> addressLineList = new ArrayList<String>();
            private String countryCode;
            private String city;
            private String state;
            private String zipCode;

            /** 
             * Get the list of 'AddressLine' element items.
             * 
             * @return list
             */
            public List<String> getAddressLineList() {
                return addressLineList;
            }

            /** 
             * Set the list of 'AddressLine' element items.
             * 
             * @param list
             */
            public void setAddressLineList(List<String> list) {
                addressLineList = list;
            }

            /** 
             * Get the 'CountryCode' element value.
             * 
             * @return value
             */
            public String getCountryCode() {
                return countryCode;
            }

            /** 
             * Set the 'CountryCode' element value.
             * 
             * @param countryCode
             */
            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }

            /** 
             * Get the 'City' element value.
             * 
             * @return value
             */
            public String getCity() {
                return city;
            }

            /** 
             * Set the 'City' element value.
             * 
             * @param city
             */
            public void setCity(String city) {
                this.city = city;
            }

            /** 
             * Get the 'State' element value.
             * 
             * @return value
             */
            public String getState() {
                return state;
            }

            /** 
             * Set the 'State' element value.
             * 
             * @param state
             */
            public void setState(String state) {
                this.state = state;
            }

            /** 
             * Get the 'ZipCode' element value.
             * 
             * @return value
             */
            public String getZipCode() {
                return zipCode;
            }

            /** 
             * Set the 'ZipCode' element value.
             * 
             * @param zipCode
             */
            public void setZipCode(String zipCode) {
                this.zipCode = zipCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PhoneNumber" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="FaxNumber" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactNumbers implements Serializable
        {
            private List<String> phoneNumberList = new ArrayList<String>();
            private String faxNumber;

            /** 
             * Get the list of 'PhoneNumber' element items.
             * 
             * @return list
             */
            public List<String> getPhoneNumberList() {
                return phoneNumberList;
            }

            /** 
             * Set the list of 'PhoneNumber' element items.
             * 
             * @param list
             */
            public void setPhoneNumberList(List<String> list) {
                phoneNumberList = list;
            }

            /** 
             * Get the 'FaxNumber' element value.
             * 
             * @return value
             */
            public String getFaxNumber() {
                return faxNumber;
            }

            /** 
             * Set the 'FaxNumber' element value.
             * 
             * @param faxNumber
             */
            public void setFaxNumber(String faxNumber) {
                this.faxNumber = faxNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Indicator" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="PerNight" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Commission implements Serializable
        {
            private String indicator;
            private String perNight;
            private String text;

            /** 
             * Get the 'Indicator' element value.
             * 
             * @return value
             */
            public String getIndicator() {
                return indicator;
            }

            /** 
             * Set the 'Indicator' element value.
             * 
             * @param indicator
             */
            public void setIndicator(String indicator) {
                this.indicator = indicator;
            }

            /** 
             * Get the 'PerNight' element value.
             * 
             * @return value
             */
            public String getPerNight() {
                return perNight;
            }

            /** 
             * Set the 'PerNight' element value.
             * 
             * @param perNight
             */
            public void setPerNight(String perNight) {
                this.perNight = perNight;
            }

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }
        }
    }
}
