
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProductNameType" name="ProductName"/>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:HotelProductType" name="Hotel" minOccurs="0"/>
 *       &lt;xs:element type="ns:GroundTransportationType" name="GroundTransportation" minOccurs="0"/>
 *       &lt;xs:element type="ns:RailType" name="Rail" minOccurs="0"/>
 *       &lt;xs:element type="ns:TourType" name="Tour" minOccurs="0"/>
 *       &lt;xs:element type="ns:AirType" name="Air" minOccurs="0"/>
 *       &lt;xs:element type="ns:VisaType" name="Visa" minOccurs="0"/>
 *       &lt;xs:element type="ns:VehicleType" name="Vehicle" minOccurs="0"/>
 *       &lt;xs:element type="ns:SkiType" name="Ski" minOccurs="0"/>
 *       &lt;xs:element type="ns:OtherType" name="Other" minOccurs="0"/>
 *       &lt;xs:element type="ns:InsuranceType" name="Insurance" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="ns:ExternalSystemReferenceType" name="ExternalSystemReference" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element name="TransactionInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class TransactionInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BillingInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class BillingInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CO2ValueType" name="CO2Value" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:SegmentCommonAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProductDetailsType implements Serializable
{
    private ProductNameType productName;
    private HotelProductType hotel;
    private GroundTransportationType groundTransportation;
    private RailType rail;
    private TourType tour;
    private AirType air;
    private VisaType visa;
    private VehicleType vehicle;
    private SkiType ski;
    private OtherType other;
    private InsuranceType insurance;
    private List<ExternalSystemReferenceType> externalSystemReferenceList = new ArrayList<ExternalSystemReferenceType>();
    private TransactionInfo transactionInfo;
    private BillingInfo billingInfo;
    private CO2ValueType CO2Value;
    private String comment;
    private SegmentCommonAttributes segmentCommonAttributes;

    /** 
     * Get the 'ProductName' element value.
     * 
     * @return value
     */
    public ProductNameType getProductName() {
        return productName;
    }

    /** 
     * Set the 'ProductName' element value.
     * 
     * @param productName
     */
    public void setProductName(ProductNameType productName) {
        this.productName = productName;
    }

    /** 
     * Get the 'Hotel' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public HotelProductType getHotel() {
        return hotel;
    }

    /** 
     * Set the 'Hotel' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param hotel
     */
    public void setHotel(HotelProductType hotel) {
        this.hotel = hotel;
    }

    /** 
     * Get the 'GroundTransportation' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public GroundTransportationType getGroundTransportation() {
        return groundTransportation;
    }

    /** 
     * Set the 'GroundTransportation' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param groundTransportation
     */
    public void setGroundTransportation(
            GroundTransportationType groundTransportation) {
        this.groundTransportation = groundTransportation;
    }

    /** 
     * Get the 'Rail' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public RailType getRail() {
        return rail;
    }

    /** 
     * Set the 'Rail' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param rail
     */
    public void setRail(RailType rail) {
        this.rail = rail;
    }

    /** 
     * Get the 'Tour' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public TourType getTour() {
        return tour;
    }

    /** 
     * Set the 'Tour' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param tour
     */
    public void setTour(TourType tour) {
        this.tour = tour;
    }

    /** 
     * Get the 'Air' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public AirType getAir() {
        return air;
    }

    /** 
     * Set the 'Air' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param air
     */
    public void setAir(AirType air) {
        this.air = air;
    }

    /** 
     * Get the 'Visa' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public VisaType getVisa() {
        return visa;
    }

    /** 
     * Set the 'Visa' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param visa
     */
    public void setVisa(VisaType visa) {
        this.visa = visa;
    }

    /** 
     * Get the 'Vehicle' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public VehicleType getVehicle() {
        return vehicle;
    }

    /** 
     * Set the 'Vehicle' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param vehicle
     */
    public void setVehicle(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    /** 
     * Get the 'Ski' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public SkiType getSki() {
        return ski;
    }

    /** 
     * Set the 'Ski' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param ski
     */
    public void setSki(SkiType ski) {
        this.ski = ski;
    }

    /** 
     * Get the 'Other' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public OtherType getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param other
     */
    public void setOther(OtherType other) {
        this.other = other;
    }

    /** 
     * Get the 'Insurance' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @return value
     */
    public InsuranceType getInsurance() {
        return insurance;
    }

    /** 
     * Set the 'Insurance' element value. Hotel, GroundTransportation, Rail, Tour, Air, Visa, Vehicle, Ski, Other and Insurance are mutually exclusive in original TIR schema,
                              this was simplified for easier xsd -&gt; JSON conversion.
                              For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * @param insurance
     */
    public void setInsurance(InsuranceType insurance) {
        this.insurance = insurance;
    }

    /** 
     * Get the list of 'ExternalSystemReference' element items. Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
     * 
     * @return list
     */
    public List<ExternalSystemReferenceType> getExternalSystemReferenceList() {
        return externalSystemReferenceList;
    }

    /** 
     * Set the list of 'ExternalSystemReference' element items. Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
     * 
     * @param list
     */
    public void setExternalSystemReferenceList(
            List<ExternalSystemReferenceType> list) {
        externalSystemReferenceList = list;
    }

    /** 
     * Get the 'TransactionInfo' element value.
     * 
     * @return value
     */
    public TransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value.
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'BillingInfo' element value.
     * 
     * @return value
     */
    public BillingInfo getBillingInfo() {
        return billingInfo;
    }

    /** 
     * Set the 'BillingInfo' element value.
     * 
     * @param billingInfo
     */
    public void setBillingInfo(BillingInfo billingInfo) {
        this.billingInfo = billingInfo;
    }

    /** 
     * Get the 'CO2Value' element value.
     * 
     * @return value
     */
    public CO2ValueType getCO2Value() {
        return CO2Value;
    }

    /** 
     * Set the 'CO2Value' element value.
     * 
     * @param CO2Value
     */
    public void setCO2Value(CO2ValueType CO2Value) {
        this.CO2Value = CO2Value;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @return value
     */
    public SegmentCommonAttributes getSegmentCommonAttributes() {
        return segmentCommonAttributes;
    }

    /** 
     * Set the 'SegmentCommonAttributes' attributeGroup value.
     * 
     * @param segmentCommonAttributes
     */
    public void setSegmentCommonAttributes(
            SegmentCommonAttributes segmentCommonAttributes) {
        this.segmentCommonAttributes = segmentCommonAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:RequestorSourceType" name="RequestorInfo"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:dateTime" name="LastUpdateTimeStamp"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TransactionInfo implements Serializable
    {
        private RequestorSourceType requestorInfo;
        private Date lastUpdateTimeStamp;

        /** 
         * Get the 'RequestorInfo' element value.
         * 
         * @return value
         */
        public RequestorSourceType getRequestorInfo() {
            return requestorInfo;
        }

        /** 
         * Set the 'RequestorInfo' element value.
         * 
         * @param requestorInfo
         */
        public void setRequestorInfo(RequestorSourceType requestorInfo) {
            this.requestorInfo = requestorInfo;
        }

        /** 
         * Get the 'LastUpdateTimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
         * 
         * @return value
         */
        public Date getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        /** 
         * Set the 'LastUpdateTimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
         * 
         * @param lastUpdateTimeStamp
         */
        public void setLastUpdateTimeStamp(Date lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BillingInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="BillingCode"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BillingInfo implements Serializable
    {
        private String billingCode;

        /** 
         * Get the 'BillingCode' element value. Holds information about billing code for product
         * 
         * @return value
         */
        public String getBillingCode() {
            return billingCode;
        }

        /** 
         * Set the 'BillingCode' element value. Holds information about billing code for product
         * 
         * @param billingCode
         */
        public void setBillingCode(String billingCode) {
            this.billingCode = billingCode;
        }
    }
}
