
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Indicates if program is affiliated with a group of related offers accumulating credits.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SingleVendorIndType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="SingleVndr"/>
 *     &lt;xs:enumeration value="Alliance"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SingleVendorIndType implements Serializable {
    SINGLE_VNDR("SingleVndr"), ALLIANCE("Alliance");
    private final String value;

    private SingleVendorIndType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SingleVendorIndType convert(String value) {
        for (SingleVendorIndType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
