
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;

/** 
 * Ski product is used to ski tour sale and processing purposes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SkiType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Booking" minOccurs="0">
 *       &lt;!-- Reference to inner class Booking -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ChangePolicy" minOccurs="0">
 *       &lt;!-- Reference to inner class ChangePolicy -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="City" minOccurs="0">
 *       &lt;!-- Reference to inner class City -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ClothingHire" minOccurs="0">
 *       &lt;!-- Reference to inner class ClothingHire -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:SkiCommonElementsType" name="EquipmentHire" minOccurs="0"/>
 *     &lt;xs:element type="ns:SkiCommonElementsType" name="Extras" minOccurs="0"/>
 *     &lt;xs:element type="ns:SkiCommonElementsType" name="Lessons" minOccurs="0"/>
 *     &lt;xs:element type="ns:SkiCommonElementsType" name="LiftPass" minOccurs="0"/>
 *     &lt;xs:element name="Location" minOccurs="0">
 *       &lt;!-- Reference to inner class Location -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Vendor" minOccurs="0">
 *       &lt;!-- Reference to inner class Vendor -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Transfers" minOccurs="0">
 *       &lt;!-- Reference to inner class Transfers -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PricingElementsType" name="PricingElements" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SkiType implements Serializable
{
    private Booking booking;
    private ChangePolicy changePolicy;
    private City city;
    private ClothingHire clothingHire;
    private SkiCommonElementsType equipmentHire;
    private SkiCommonElementsType extras;
    private SkiCommonElementsType lessons;
    private SkiCommonElementsType liftPass;
    private Location location;
    private Vendor vendor;
    private Transfers transfers;
    private PricingElementsType pricingElements;

    /** 
     * Get the 'Booking' element value.
     * 
     * @return value
     */
    public Booking getBooking() {
        return booking;
    }

    /** 
     * Set the 'Booking' element value.
     * 
     * @param booking
     */
    public void setBooking(Booking booking) {
        this.booking = booking;
    }

    /** 
     * Get the 'ChangePolicy' element value.
     * 
     * @return value
     */
    public ChangePolicy getChangePolicy() {
        return changePolicy;
    }

    /** 
     * Set the 'ChangePolicy' element value.
     * 
     * @param changePolicy
     */
    public void setChangePolicy(ChangePolicy changePolicy) {
        this.changePolicy = changePolicy;
    }

    /** 
     * Get the 'City' element value.
     * 
     * @return value
     */
    public City getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value.
     * 
     * @param city
     */
    public void setCity(City city) {
        this.city = city;
    }

    /** 
     * Get the 'ClothingHire' element value.
     * 
     * @return value
     */
    public ClothingHire getClothingHire() {
        return clothingHire;
    }

    /** 
     * Set the 'ClothingHire' element value.
     * 
     * @param clothingHire
     */
    public void setClothingHire(ClothingHire clothingHire) {
        this.clothingHire = clothingHire;
    }

    /** 
     * Get the 'EquipmentHire' element value. "EquipmentHire" is used to order ski equipment
     * 
     * @return value
     */
    public SkiCommonElementsType getEquipmentHire() {
        return equipmentHire;
    }

    /** 
     * Set the 'EquipmentHire' element value. "EquipmentHire" is used to order ski equipment
     * 
     * @param equipmentHire
     */
    public void setEquipmentHire(SkiCommonElementsType equipmentHire) {
        this.equipmentHire = equipmentHire;
    }

    /** 
     * Get the 'Extras' element value. "Extras" is used to order extra services
     * 
     * @return value
     */
    public SkiCommonElementsType getExtras() {
        return extras;
    }

    /** 
     * Set the 'Extras' element value. "Extras" is used to order extra services
     * 
     * @param extras
     */
    public void setExtras(SkiCommonElementsType extras) {
        this.extras = extras;
    }

    /** 
     * Get the 'Lessons' element value. "Lessons" is used to order ski lessons
     * 
     * @return value
     */
    public SkiCommonElementsType getLessons() {
        return lessons;
    }

    /** 
     * Set the 'Lessons' element value. "Lessons" is used to order ski lessons
     * 
     * @param lessons
     */
    public void setLessons(SkiCommonElementsType lessons) {
        this.lessons = lessons;
    }

    /** 
     * Get the 'LiftPass' element value. "LiftPass" is used to order ski lift pass
     * 
     * @return value
     */
    public SkiCommonElementsType getLiftPass() {
        return liftPass;
    }

    /** 
     * Set the 'LiftPass' element value. "LiftPass" is used to order ski lift pass
     * 
     * @param liftPass
     */
    public void setLiftPass(SkiCommonElementsType liftPass) {
        this.liftPass = liftPass;
    }

    /** 
     * Get the 'Location' element value.
     * 
     * @return value
     */
    public Location getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value.
     * 
     * @param location
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public Vendor getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'Transfers' element value.
     * 
     * @return value
     */
    public Transfers getTransfers() {
        return transfers;
    }

    /** 
     * Set the 'Transfers' element value.
     * 
     * @param transfers
     */
    public void setTransfers(Transfers transfers) {
        this.transfers = transfers;
    }

    /** 
     * Get the 'PricingElements' element value.
     * 
     * @return value
     */
    public PricingElementsType getPricingElements() {
        return pricingElements;
    }

    /** 
     * Set the 'PricingElements' element value.
     * 
     * @param pricingElements
     */
    public void setPricingElements(PricingElementsType pricingElements) {
        this.pricingElements = pricingElements;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Booking" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="ID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Booking implements Serializable
    {
        private String ID;

        /** 
         * Get the 'ID' attribute value. ID of the Ski booking
         * 
         * @return value
         */
        public String getID() {
            return ID;
        }

        /** 
         * Set the 'ID' attribute value. ID of the Ski booking
         * 
         * @param ID
         */
        public void setID(String ID) {
            this.ID = ID;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangePolicy" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Conditions" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="ConditionsDefault" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ChangePolicy implements Serializable
    {
        private String conditions;
        private String conditionsDefault;

        /** 
         * Get the 'Conditions' element value. Conditions of the change policy
         * 
         * @return value
         */
        public String getConditions() {
            return conditions;
        }

        /** 
         * Set the 'Conditions' element value. Conditions of the change policy
         * 
         * @param conditions
         */
        public void setConditions(String conditions) {
            this.conditions = conditions;
        }

        /** 
         * Get the 'ConditionsDefault' element value. Default conditions of the change policy
         * 
         * @return value
         */
        public String getConditionsDefault() {
            return conditionsDefault;
        }

        /** 
         * Set the 'ConditionsDefault' element value. Default conditions of the change policy
         * 
         * @param conditionsDefault
         */
        public void setConditionsDefault(String conditionsDefault) {
            this.conditionsDefault = conditionsDefault;
        }
    }
    /** 
     * Ski city
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="City" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="code"/>
     *     &lt;xs:attribute type="xs:string" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class City implements Serializable
    {
        private String code;
        private String name;

        /** 
         * Get the 'code' attribute value. City code e.g. DFW
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. City code e.g. DFW
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'name' attribute value. City name
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value. City name
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * "ClothingHire" is used to order ski clothing
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClothingHire" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:SkiCommonElementsType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="Item" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ClothingHire extends SkiCommonElementsType implements
        Serializable
    {
        private String item;

        /** 
         * Get the 'Item' element value. Clothing item
         * 
         * @return value
         */
        public String getItem() {
            return item;
        }

        /** 
         * Set the 'Item' element value. Clothing item
         * 
         * @param item
         */
        public void setItem(String item) {
            this.item = item;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Regions" minOccurs="0">
     *         &lt;!-- Reference to inner class Regions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Resort" minOccurs="0">
     *         &lt;!-- Reference to inner class Resort -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Location implements Serializable
    {
        private Regions regions;
        private Resort resort;

        /** 
         * Get the 'Regions' element value.
         * 
         * @return value
         */
        public Regions getRegions() {
            return regions;
        }

        /** 
         * Set the 'Regions' element value.
         * 
         * @param regions
         */
        public void setRegions(Regions regions) {
            this.regions = regions;
        }

        /** 
         * Get the 'Resort' element value.
         * 
         * @return value
         */
        public Resort getResort() {
            return resort;
        }

        /** 
         * Set the 'Resort' element value.
         * 
         * @param resort
         */
        public void setResort(Resort resort) {
            this.resort = resort;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Regions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="name"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Regions implements Serializable
        {
            private String name;

            /** 
             * Get the 'name' attribute value. Ski region name
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'name' attribute value. Ski region name
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Resort" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="name"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Resort implements Serializable
        {
            private String name;

            /** 
             * Get the 'name' attribute value. Ski location resort name
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'name' attribute value. Ski location resort name
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="code"/>
     *     &lt;xs:attribute type="xs:string" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Vendor implements Serializable
    {
        private String code;
        private String name;

        /** 
         * Get the 'code' attribute value. Ski vendor code
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Ski vendor code
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'name' attribute value. Ski vendor name
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value. Ski vendor name
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transfers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Transfers implements Serializable
    {
        private String description;

        /** 
         * Get the 'Description' element value. Transfers description
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Transfers description
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }
    }
}
