
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Provides information on the source of a request.
 This is from the OTA xsd.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RequestorIDType" name="RequestorID" minOccurs="0"/>
 *     &lt;xs:element type="ns:BookingChannelType" name="BookingChannel" minOccurs="0"/>
 *     &lt;xs:element type="ns:TTYRecordLocatorType" name="TTYRecordLocator" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OACType" name="OAC" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="BookingSource"/>
 *   &lt;xs:attribute type="xs:string" name="AgentSine"/>
 *   &lt;xs:attribute type="xs:string" name="PseudoCityCode"/>
 *   &lt;xs:attribute type="xs:string" name="ISOCountry"/>
 *   &lt;xs:attribute type="xs:string" name="ISOCurrency"/>
 *   &lt;xs:attribute type="xs:string" name="AgentDutyCode"/>
 *   &lt;xs:attribute type="xs:string" name="AirlineVendorID"/>
 *   &lt;xs:attribute type="xs:string" name="AirportCode"/>
 *   &lt;xs:attribute type="xs:string" name="FirstDepartPoint"/>
 *   &lt;xs:attribute type="xs:string" name="SourceSystem"/>
 *   &lt;xs:attribute type="xs:string" name="TerminalID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SourceType implements Serializable
{
    private RequestorIDType requestorID;
    private BookingChannelType bookingChannel;
    private List<TTYRecordLocatorType> TTYRecordLocatorList = new ArrayList<TTYRecordLocatorType>();
    private OACType OAC;
    private String bookingSource;
    private String agentSine;
    private String pseudoCityCode;
    private String ISOCountry;
    private String ISOCurrency;
    private String agentDutyCode;
    private String airlineVendorID;
    private String airportCode;
    private String firstDepartPoint;
    private String sourceSystem;
    private String terminalID;

    /** 
     * Get the 'RequestorID' element value. An identifier of the entity making the request (e.g. ATA/IATA/ID number,
                          Electronic Reservation Service Provider (ERSP), Association of British Travel Agents (ABTA)).
     * 
     * @return value
     */
    public RequestorIDType getRequestorID() {
        return requestorID;
    }

    /** 
     * Set the 'RequestorID' element value. An identifier of the entity making the request (e.g. ATA/IATA/ID number,
                          Electronic Reservation Service Provider (ERSP), Association of British Travel Agents (ABTA)).
     * 
     * @param requestorID
     */
    public void setRequestorID(RequestorIDType requestorID) {
        this.requestorID = requestorID;
    }

    /** 
     * Get the 'BookingChannel' element value. Specifies the booking channel type and whether it is the primary means of connectivity of the source.
     * 
     * @return value
     */
    public BookingChannelType getBookingChannel() {
        return bookingChannel;
    }

    /** 
     * Set the 'BookingChannel' element value. Specifies the booking channel type and whether it is the primary means of connectivity of the source.
     * 
     * @param bookingChannel
     */
    public void setBookingChannel(BookingChannelType bookingChannel) {
        this.bookingChannel = bookingChannel;
    }

    /** 
     * Get the list of 'TTYRecordLocator' element items.
     * 
     * @return list
     */
    public List<TTYRecordLocatorType> getTTYRecordLocatorList() {
        return TTYRecordLocatorList;
    }

    /** 
     * Set the list of 'TTYRecordLocator' element items.
     * 
     * @param list
     */
    public void setTTYRecordLocatorList(List<TTYRecordLocatorType> list) {
        TTYRecordLocatorList = list;
    }

    /** 
     * Get the 'OAC' element value. Office Account Code. Defines agency PCC extension
     * 
     * @return value
     */
    public OACType getOAC() {
        return OAC;
    }

    /** 
     * Set the 'OAC' element value. Office Account Code. Defines agency PCC extension
     * 
     * @param OAC
     */
    public void setOAC(OACType OAC) {
        this.OAC = OAC;
    }

    /** 
     * Get the 'BookingSource' attribute value. Identifies the booking source within the requesting entity.
     * 
     * @return value
     */
    public String getBookingSource() {
        return bookingSource;
    }

    /** 
     * Set the 'BookingSource' attribute value. Identifies the booking source within the requesting entity.
     * 
     * @param bookingSource
     */
    public void setBookingSource(String bookingSource) {
        this.bookingSource = bookingSource;
    }

    /** 
     * Get the 'AgentSine' attribute value. Identifies the party within the requesting entity.
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' attribute value. Identifies the party within the requesting entity.
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'ISOCountry' attribute value. The country code of the requesting party.
     * 
     * @return value
     */
    public String getISOCountry() {
        return ISOCountry;
    }

    /** 
     * Set the 'ISOCountry' attribute value. The country code of the requesting party.
     * 
     * @param ISOCountry
     */
    public void setISOCountry(String ISOCountry) {
        this.ISOCountry = ISOCountry;
    }

    /** 
     * Get the 'ISOCurrency' attribute value.
     * 
     * @return value
     */
    public String getISOCurrency() {
        return ISOCurrency;
    }

    /** 
     * Set the 'ISOCurrency' attribute value.
     * 
     * @param ISOCurrency
     */
    public void setISOCurrency(String ISOCurrency) {
        this.ISOCurrency = ISOCurrency;
    }

    /** 
     * Get the 'AgentDutyCode' attribute value. An authority code assigned to a requestor.
     * 
     * @return value
     */
    public String getAgentDutyCode() {
        return agentDutyCode;
    }

    /** 
     * Set the 'AgentDutyCode' attribute value. An authority code assigned to a requestor.
     * 
     * @param agentDutyCode
     */
    public void setAgentDutyCode(String agentDutyCode) {
        this.agentDutyCode = agentDutyCode;
    }

    /** 
     * Get the 'AirlineVendorID' attribute value. The IATA assigned airline code.
     * 
     * @return value
     */
    public String getAirlineVendorID() {
        return airlineVendorID;
    }

    /** 
     * Set the 'AirlineVendorID' attribute value. The IATA assigned airline code.
     * 
     * @param airlineVendorID
     */
    public void setAirlineVendorID(String airlineVendorID) {
        this.airlineVendorID = airlineVendorID;
    }

    /** 
     * Get the 'AirportCode' attribute value. The IATA assigned airport code.
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'AirportCode' attribute value. The IATA assigned airport code.
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'FirstDepartPoint' attribute value. The point of first departure in a trip.
     * 
     * @return value
     */
    public String getFirstDepartPoint() {
        return firstDepartPoint;
    }

    /** 
     * Set the 'FirstDepartPoint' attribute value. The point of first departure in a trip.
     * 
     * @param firstDepartPoint
     */
    public void setFirstDepartPoint(String firstDepartPoint) {
        this.firstDepartPoint = firstDepartPoint;
    }

    /** 
     * Get the 'SourceSystem' attribute value. e.g., CSS, CSI
     * 
     * @return value
     */
    public String getSourceSystem() {
        return sourceSystem;
    }

    /** 
     * Set the 'SourceSystem' attribute value. e.g., CSS, CSI
     * 
     * @param sourceSystem
     */
    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    /** 
     * Get the 'TerminalID' attribute value. This is the electronic address of the device from which information is entered.
     * 
     * @return value
     */
    public String getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'TerminalID' attribute value. This is the electronic address of the device from which information is entered.
     * 
     * @param terminalID
     */
    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }
}
