
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Combines exemption rules connected with taxes.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxRulesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="ExemptAllTaxes" minOccurs="0"/>
 *     &lt;xs:element type="ns:TaxCodeType" name="ExemptTax" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxRulesType implements Serializable
{
    private Boolean exemptAllTaxes;
    private List<TaxCodeType> exemptTaxList = new ArrayList<TaxCodeType>();

    /** 
     * Get the 'ExemptAllTaxes' element value. Exempt all taxes (/TE)
     * 
     * @return value
     */
    public Boolean getExemptAllTaxes() {
        return exemptAllTaxes;
    }

    /** 
     * Set the 'ExemptAllTaxes' element value. Exempt all taxes (/TE)
     * 
     * @param exemptAllTaxes
     */
    public void setExemptAllTaxes(Boolean exemptAllTaxes) {
        this.exemptAllTaxes = exemptAllTaxes;
    }

    /** 
     * Get the list of 'ExemptTax' element items. Exempt Tax (/TE)
     * 
     * @return list
     */
    public List<TaxCodeType> getExemptTaxList() {
        return exemptTaxList;
    }

    /** 
     * Set the list of 'ExemptTax' element items. Exempt Tax (/TE)
     * 
     * @param list
     */
    public void setExemptTaxList(List<TaxCodeType> list) {
        exemptTaxList = list;
    }
}
