
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TripProposalReference">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ProposalId">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:string" name="snapshotId"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="OptionIds" minOccurs="0">
 *       &lt;!-- Reference to inner class OptionIds -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TripProposalReference implements Serializable
{
    private String proposalIdString;
    private String proposalIdSnapshotId;
    private OptionIds optionIds;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getProposalIdString() {
        return proposalIdString;
    }

    /** 
     * Set the extension value.
     * 
     * @param proposalIdString
     */
    public void setProposalIdString(String proposalIdString) {
        this.proposalIdString = proposalIdString;
    }

    /** 
     * Get the 'snapshotId' attribute value. SnapshotID defining version of TripProposal
     * 
     * @return value
     */
    public String getProposalIdSnapshotId() {
        return proposalIdSnapshotId;
    }

    /** 
     * Set the 'snapshotId' attribute value. SnapshotID defining version of TripProposal
     * 
     * @param proposalIdSnapshotId
     */
    public void setProposalIdSnapshotId(String proposalIdSnapshotId) {
        this.proposalIdSnapshotId = proposalIdSnapshotId;
    }

    /** 
     * Get the 'OptionIds' element value.
     * 
     * @return value
     */
    public OptionIds getOptionIds() {
        return optionIds;
    }

    /** 
     * Set the 'OptionIds' element value.
     * 
     * @param optionIds
     */
    public void setOptionIds(OptionIds optionIds) {
        this.optionIds = optionIds;
    }
    /** 
     * Element containing list of TripProposal option IDs related to PNR
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionIds" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="OptionId" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OptionIds implements Serializable
    {
        private List<String> optionIdList = new ArrayList<String>();

        /** 
         * Get the list of 'OptionId' element items.
         * 
         * @return list
         */
        public List<String> getOptionIdList() {
            return optionIdList;
        }

        /** 
         * Set the list of 'OptionId' element items.
         * 
         * @param list
         */
        public void setOptionIdList(List<String> list) {
            optionIdList = list;
        }
    }
}
