
package com.sabre.services.sp.eab.v310;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VirtualCard">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CustomerAccountCode"/>
 *     &lt;xs:element type="xs:string" name="BNumber" minOccurs="0"/>
 *     &lt;xs:element name="Transactions" minOccurs="0">
 *       &lt;!-- Reference to inner class Transactions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VirtualCard implements Serializable
{
    private String customerAccountCode;
    private String BNumber;
    private Transactions transactions;

    /** 
     * Get the 'CustomerAccountCode' element value.
     * 
     * @return value
     */
    public String getCustomerAccountCode() {
        return customerAccountCode;
    }

    /** 
     * Set the 'CustomerAccountCode' element value.
     * 
     * @param customerAccountCode
     */
    public void setCustomerAccountCode(String customerAccountCode) {
        this.customerAccountCode = customerAccountCode;
    }

    /** 
     * Get the 'BNumber' element value.
     * 
     * @return value
     */
    public String getBNumber() {
        return BNumber;
    }

    /** 
     * Set the 'BNumber' element value.
     * 
     * @param BNumber
     */
    public void setBNumber(String BNumber) {
        this.BNumber = BNumber;
    }

    /** 
     * Get the 'Transactions' element value.
     * 
     * @return value
     */
    public Transactions getTransactions() {
        return transactions;
    }

    /** 
     * Set the 'Transactions' element value.
     * 
     * @param transactions
     */
    public void setTransactions(Transactions transactions) {
        this.transactions = transactions;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transactions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Transaction" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Transaction -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Transactions implements Serializable
    {
        private List<Transaction> transactionList = new ArrayList<Transaction>();

        /** 
         * Get the list of 'Transaction' element items.
         * 
         * @return list
         */
        public List<Transaction> getTransactionList() {
            return transactionList;
        }

        /** 
         * Set the list of 'Transaction' element items.
         * 
         * @param list
         */
        public void setTransactionList(List<Transaction> list) {
            transactionList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/eab/v3_10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transaction" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:dateTime" name="LastUpdateTime" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="DeploymentId" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:int" name="index"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Transaction implements Serializable
        {
            private Date lastUpdateTime;
            private String deploymentId;
            private String documentNumber;
            private String confirmationNumber;
            private Integer index;

            /** 
             * Get the 'LastUpdateTime' element value.
             * 
             * @return value
             */
            public Date getLastUpdateTime() {
                return lastUpdateTime;
            }

            /** 
             * Set the 'LastUpdateTime' element value.
             * 
             * @param lastUpdateTime
             */
            public void setLastUpdateTime(Date lastUpdateTime) {
                this.lastUpdateTime = lastUpdateTime;
            }

            /** 
             * Get the 'DeploymentId' element value.
             * 
             * @return value
             */
            public String getDeploymentId() {
                return deploymentId;
            }

            /** 
             * Set the 'DeploymentId' element value.
             * 
             * @param deploymentId
             */
            public void setDeploymentId(String deploymentId) {
                this.deploymentId = deploymentId;
            }

            /** 
             * Get the 'DocumentNumber' element value. DocumentNumber and ConfirmationNumber are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * @return value
             */
            public String getDocumentNumber() {
                return documentNumber;
            }

            /** 
             * Set the 'DocumentNumber' element value. DocumentNumber and ConfirmationNumber are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * @param documentNumber
             */
            public void setDocumentNumber(String documentNumber) {
                this.documentNumber = documentNumber;
            }

            /** 
             * Get the 'ConfirmationNumber' element value. DocumentNumber and ConfirmationNumber are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * @return value
             */
            public String getConfirmationNumber() {
                return confirmationNumber;
            }

            /** 
             * Set the 'ConfirmationNumber' element value. DocumentNumber and ConfirmationNumber are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                                                      For original schemas please refer to https://beta.developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
             * 
             * @param confirmationNumber
             */
            public void setConfirmationNumber(String confirmationNumber) {
                this.confirmationNumber = confirmationNumber;
            }

            /** 
             * Get the 'index' attribute value.
             * 
             * @return value
             */
            public Integer getIndex() {
                return index;
            }

            /** 
             * Set the 'index' attribute value.
             * 
             * @param index
             */
            public void setIndex(Integer index) {
                this.index = index;
            }
        }
    }
}
