
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;

/** 
 * Open Reservation Element Type used to store accounting field data
 Transaction is a choice in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
 For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingField">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AccountingTransaction" name="Transaction" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountingField implements Serializable
{
    private AccountingTransaction transaction;

    /** 
     * Get the 'Transaction' element value.
     * 
     * @return value
     */
    public AccountingTransaction getTransaction() {
        return transaction;
    }

    /** 
     * Set the 'Transaction' element value.
     * 
     * @param transaction
     */
    public void setTransaction(AccountingTransaction transaction) {
        this.transaction = transaction;
    }
}
