
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingTransactionSource">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="SegmentData" minOccurs="0">
 *       &lt;!-- Reference to inner class SegmentData -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AncillaryServiceData" minOccurs="0">
 *       &lt;!-- Reference to inner class AncillaryServiceData -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountingTransactionSource implements Serializable
{
    private SegmentData segmentData;
    private AncillaryServiceData ancillaryServiceData;

    /** 
     * Get the 'SegmentData' element value.
     * 
     * @return value
     */
    public SegmentData getSegmentData() {
        return segmentData;
    }

    /** 
     * Set the 'SegmentData' element value.
     * 
     * @param segmentData
     */
    public void setSegmentData(SegmentData segmentData) {
        this.segmentData = segmentData;
    }

    /** 
     * Get the 'AncillaryServiceData' element value.
     * 
     * @return value
     */
    public AncillaryServiceData getAncillaryServiceData() {
        return ancillaryServiceData;
    }

    /** 
     * Set the 'AncillaryServiceData' element value.
     * 
     * @param ancillaryServiceData
     */
    public void setAncillaryServiceData(
            AncillaryServiceData ancillaryServiceData) {
        this.ancillaryServiceData = ancillaryServiceData;
    }
    /** 
     * SegmentData and AncillaryServiceData are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentData" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FareComponent" name="FareComponent" minOccurs="0"/>
     *       &lt;xs:element type="ns:SegmentOrTravelPortion" name="Segments" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SegmentData implements Serializable
    {
        private FareComponent fareComponent;
        private List<SegmentOrTravelPortion> segmentList = new ArrayList<SegmentOrTravelPortion>();

        /** 
         * Get the 'FareComponent' element value.
         * 
         * @return value
         */
        public FareComponent getFareComponent() {
            return fareComponent;
        }

        /** 
         * Set the 'FareComponent' element value.
         * 
         * @param fareComponent
         */
        public void setFareComponent(FareComponent fareComponent) {
            this.fareComponent = fareComponent;
        }

        /** 
         * Get the list of 'Segments' element items.
         * 
         * @return list
         */
        public List<SegmentOrTravelPortion> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segments' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<SegmentOrTravelPortion> list) {
            segmentList = list;
        }
    }
    /** 
     * SegmentData and AncillaryServiceData are mutually exclusive in original TIR schema, this was simplified for easier xsd -&gt; JSON conversion.
                          For original schemas please refer to https://developer.sabre.com/docs/soap_apis/management/itinerary/Get_Itinerary
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServiceData" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:group ref="ns:BasicAncillaryServicesDataGroup"/>
     *       &lt;xs:element type="ns:SegmentOrTravelPortion" name="Segments" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AncillaryServiceData implements Serializable
    {
        private BasicAncillaryServicesDataGroup basicAncillaryServicesDataGroup;
        private List<SegmentOrTravelPortion> segmentList = new ArrayList<SegmentOrTravelPortion>();

        /** 
         * Get the 'BasicAncillaryServicesDataGroup' group value.
         * 
         * @return value
         */
        public BasicAncillaryServicesDataGroup getBasicAncillaryServicesDataGroup() {
            return basicAncillaryServicesDataGroup;
        }

        /** 
         * Set the 'BasicAncillaryServicesDataGroup' group value.
         * 
         * @param basicAncillaryServicesDataGroup
         */
        public void setBasicAncillaryServicesDataGroup(
                BasicAncillaryServicesDataGroup basicAncillaryServicesDataGroup) {
            this.basicAncillaryServicesDataGroup = basicAncillaryServicesDataGroup;
        }

        /** 
         * Get the list of 'Segments' element items.
         * 
         * @return list
         */
        public List<SegmentOrTravelPortion> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segments' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<SegmentOrTravelPortion> list) {
            segmentList = list;
        }
    }
}
