
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Provides a currency code to reflect the currency in which an amount may be expressed.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyCodeGroup">
 *   &lt;xs:attribute type="xs:string" name="currencyCode"/>
 *   &lt;xs:attribute type="xs:integer" name="decimalPlaces"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CurrencyCodeGroup implements Serializable
{
    private String currencyCode;
    private BigInteger decimalPlaces;

    /** 
     * Get the 'currencyCode' attribute value. A currency code (e.g. USD, EUR, PLN)
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value. A currency code (e.g. USD, EUR, PLN)
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'decimalPlaces' attribute value. Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit".
     * 
     * @return value
     */
    public BigInteger getDecimalPlaces() {
        return decimalPlaces;
    }

    /** 
     * Set the 'decimalPlaces' attribute value. Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit".
     * 
     * @param decimalPlaces
     */
    public void setDecimalPlaces(BigInteger decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }
}
