
package com.sabre.services.sp.pd.v35;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.TaxInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="CombinedTax" minOccurs="0" maxOccurs="3">
 *       &lt;!-- Reference to inner class CombinedTax -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Tax" minOccurs="0" maxOccurs="198">
 *       &lt;!-- Reference to inner class Tax -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Airport" minOccurs="0" maxOccurs="30">
 *       &lt;!-- Reference to inner class Airport -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Domestic" minOccurs="0" maxOccurs="30">
 *       &lt;!-- Reference to inner class Domestic -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareTaxInfo implements Serializable
{
    private List<CombinedTax> combinedTaxList = new ArrayList<CombinedTax>();
    private List<Tax> taxList = new ArrayList<Tax>();
    private List<Airport> airportList = new ArrayList<Airport>();
    private List<Domestic> domesticList = new ArrayList<Domestic>();

    /** 
     * Get the list of 'CombinedTax' element items.
     * 
     * @return list
     */
    public List<CombinedTax> getCombinedTaxList() {
        return combinedTaxList;
    }

    /** 
     * Set the list of 'CombinedTax' element items.
     * 
     * @param list
     */
    public void setCombinedTaxList(List<CombinedTax> list) {
        combinedTaxList = list;
    }

    /** 
     * Get the list of 'Tax' element items.
     * 
     * @return list
     */
    public List<Tax> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items.
     * 
     * @param list
     */
    public void setTaxList(List<Tax> list) {
        taxList = list;
    }

    /** 
     * Get the list of 'Airport' element items.
     * 
     * @return list
     */
    public List<Airport> getAirportList() {
        return airportList;
    }

    /** 
     * Set the list of 'Airport' element items.
     * 
     * @param list
     */
    public void setAirportList(List<Airport> list) {
        airportList = list;
    }

    /** 
     * Get the list of 'Domestic' element items.
     * 
     * @return list
     */
    public List<Domestic> getDomesticList() {
        return domesticList;
    }

    /** 
     * Set the list of 'Domestic' element items.
     * 
     * @param list
     */
    public void setDomesticList(List<Domestic> list) {
        domesticList = list;
    }
    /** 
     * Taxes combined and represented in tax boxes 1, 2, 3
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CombinedTax" minOccurs="0" maxOccurs="3">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Amount">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:decimal">
     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
     *     &lt;xs:attribute type="xs:boolean" name="refundable"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CombinedTax implements Serializable
    {
        private BigDecimal amountDecimal;
        private String amountCurrencyCode;
        private BigInteger amountDecimalPlace;
        private String code;
        private Boolean paid;
        private Boolean exempt;
        private Boolean refundable;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getAmountDecimal() {
            return amountDecimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param amountDecimal
         */
        public void setAmountDecimal(BigDecimal amountDecimal) {
            this.amountDecimal = amountDecimal;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getAmountCurrencyCode() {
            return amountCurrencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param amountCurrencyCode
         */
        public void setAmountCurrencyCode(String amountCurrencyCode) {
            this.amountCurrencyCode = amountCurrencyCode;
        }

        /** 
         * Get the 'decimalPlace' attribute value.
         * 
         * @return value
         */
        public BigInteger getAmountDecimalPlace() {
            return amountDecimalPlace;
        }

        /** 
         * Set the 'decimalPlace' attribute value.
         * 
         * @param amountDecimalPlace
         */
        public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
            this.amountDecimalPlace = amountDecimalPlace;
        }

        /** 
         * Get the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_CA_TID1
                                    DM0Z_CA_TID2
                                    DM0Z_CA_TID3

                                    DM0Z_85_TID1
                                    DM0Z_85_TID2
                                    DM0Z_85_TID3
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_CA_TID1
                                    DM0Z_CA_TID2
                                    DM0Z_CA_TID3

                                    DM0Z_85_TID1
                                    DM0Z_85_TID2
                                    DM0Z_85_TID3
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'paid' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_PDT

                                    DM0Z_85_TXN1
                                    #DM0Z_85_PDT
         * 
         * @return value
         */
        public Boolean getPaid() {
            return paid;
        }

        /** 
         * Set the 'paid' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_PDT

                                    DM0Z_85_TXN1
                                    #DM0Z_85_PDT
         * 
         * @param paid
         */
        public void setPaid(Boolean paid) {
            this.paid = paid;
        }

        /** 
         * Get the 'exempt' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_ADC

                                    DM0Z_85_TXN1
                                    #DM0Z_85_ADC
         * 
         * @return value
         */
        public Boolean getExempt() {
            return exempt;
        }

        /** 
         * Set the 'exempt' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_ADC

                                    DM0Z_85_TXN1
                                    #DM0Z_85_ADC
         * 
         * @param exempt
         */
        public void setExempt(Boolean exempt) {
            this.exempt = exempt;
        }

        /** 
         * Get the 'refundable' attribute value. Ref: #DM0Z_90_NRF
         * 
         * @return value
         */
        public Boolean getRefundable() {
            return refundable;
        }

        /** 
         * Set the 'refundable' attribute value. Ref: #DM0Z_90_NRF
         * 
         * @param refundable
         */
        public void setRefundable(Boolean refundable) {
            this.refundable = refundable;
        }
    }
    /** 
     * Includes tax breakdown
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="198">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Amount">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:decimal">
     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
     *     &lt;xs:attribute type="xs:boolean" name="paid"/>
     *     &lt;xs:attribute type="xs:boolean" name="exempt"/>
     *     &lt;xs:attribute type="xs:boolean" name="refundable"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Tax implements Serializable
    {
        private BigDecimal amountDecimal;
        private String amountCurrencyCode;
        private BigInteger amountDecimalPlace;
        private String code;
        private Boolean paid;
        private Boolean exempt;
        private Boolean refundable;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getAmountDecimal() {
            return amountDecimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param amountDecimal
         */
        public void setAmountDecimal(BigDecimal amountDecimal) {
            this.amountDecimal = amountDecimal;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getAmountCurrencyCode() {
            return amountCurrencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param amountCurrencyCode
         */
        public void setAmountCurrencyCode(String amountCurrencyCode) {
            this.amountCurrencyCode = amountCurrencyCode;
        }

        /** 
         * Get the 'decimalPlace' attribute value.
         * 
         * @return value
         */
        public BigInteger getAmountDecimalPlace() {
            return amountDecimalPlace;
        }

        /** 
         * Set the 'decimalPlace' attribute value.
         * 
         * @param amountDecimalPlace
         */
        public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
            this.amountDecimalPlace = amountDecimalPlace;
        }

        /** 
         * Get the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_CA_TID1
                                    DM0Z_CA_TID2
                                    DM0Z_CA_TID3

                                    DM0Z_85_TID1
                                    DM0Z_85_TID2
                                    DM0Z_85_TID3
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_CA_TID1
                                    DM0Z_CA_TID2
                                    DM0Z_CA_TID3

                                    DM0Z_85_TID1
                                    DM0Z_85_TID2
                                    DM0Z_85_TID3
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'paid' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_PDT

                                    DM0Z_85_TXN1
                                    #DM0Z_85_PDT
         * 
         * @return value
         */
        public Boolean getPaid() {
            return paid;
        }

        /** 
         * Set the 'paid' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_PDT

                                    DM0Z_85_TXN1
                                    #DM0Z_85_PDT
         * 
         * @param paid
         */
        public void setPaid(Boolean paid) {
            this.paid = paid;
        }

        /** 
         * Get the 'exempt' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_ADC

                                    DM0Z_85_TXN1
                                    #DM0Z_85_ADC
         * 
         * @return value
         */
        public Boolean getExempt() {
            return exempt;
        }

        /** 
         * Set the 'exempt' attribute value. Ref:
                                    DM0Z_CA_TXN1
                                    #DM0Z_CA_ADC

                                    DM0Z_85_TXN1
                                    #DM0Z_85_ADC
         * 
         * @param exempt
         */
        public void setExempt(Boolean exempt) {
            this.exempt = exempt;
        }

        /** 
         * Get the 'refundable' attribute value. Ref: #DM0Z_90_NRF
         * 
         * @return value
         */
        public Boolean getRefundable() {
            return refundable;
        }

        /** 
         * Set the 'refundable' attribute value. Ref: #DM0Z_90_NRF
         * 
         * @param refundable
         */
        public void setRefundable(Boolean refundable) {
            this.refundable = refundable;
        }
    }
    /** 
     * Tax breakdown of XF tax code
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airport" minOccurs="0" maxOccurs="30">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Amount">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:decimal">
     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="AirportCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:int" name="pfcBreakDownType"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Airport implements Serializable
    {
        private BigDecimal amountDecimal;
        private String amountCurrencyCode;
        private BigInteger amountDecimalPlace;
        private String airportCode;
        private Integer pfcBreakDownType;
        private String code;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getAmountDecimal() {
            return amountDecimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param amountDecimal
         */
        public void setAmountDecimal(BigDecimal amountDecimal) {
            this.amountDecimal = amountDecimal;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getAmountCurrencyCode() {
            return amountCurrencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param amountCurrencyCode
         */
        public void setAmountCurrencyCode(String amountCurrencyCode) {
            this.amountCurrencyCode = amountCurrencyCode;
        }

        /** 
         * Get the 'decimalPlace' attribute value.
         * 
         * @return value
         */
        public BigInteger getAmountDecimalPlace() {
            return amountDecimalPlace;
        }

        /** 
         * Set the 'decimalPlace' attribute value.
         * 
         * @param amountDecimalPlace
         */
        public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
            this.amountDecimalPlace = amountDecimalPlace;
        }

        /** 
         * Get the 'AirportCode' element value. Airport/Station City Code

                                        Ref: DM0Z_95_ARPT
         * 
         * @return value
         */
        public String getAirportCode() {
            return airportCode;
        }

        /** 
         * Set the 'AirportCode' element value. Airport/Station City Code

                                        Ref: DM0Z_95_ARPT
         * 
         * @param airportCode
         */
        public void setAirportCode(String airportCode) {
            this.airportCode = airportCode;
        }

        /** 
         * Get the 'pfcBreakDownType' attribute value. Ref: DM0Z_95_TYPE Tax item type
                                    #DM0Z_95_LIN     EQU X'01'   Linear format
                                    #DM0Z_95_CPN     EQU X'02'   Coupon format
                                    #DM0Z_95_ATB     EQU X'03'   Auditor coupon format
         * 
         * @return value
         */
        public Integer getPfcBreakDownType() {
            return pfcBreakDownType;
        }

        /** 
         * Set the 'pfcBreakDownType' attribute value. Ref: DM0Z_95_TYPE Tax item type
                                    #DM0Z_95_LIN     EQU X'01'   Linear format
                                    #DM0Z_95_CPN     EQU X'02'   Coupon format
                                    #DM0Z_95_ATB     EQU X'03'   Auditor coupon format
         * 
         * @param pfcBreakDownType
         */
        public void setPfcBreakDownType(Integer pfcBreakDownType) {
            this.pfcBreakDownType = pfcBreakDownType;
        }

        /** 
         * Get the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_95_ITYP Tax item type
                                    #DM0Z_95_PFC     EQU X'80'   ePFC tax
                                    #DM0Z_95_ZPT     EQU X'40'   eZP tax

                                
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_95_ITYP Tax item type
                                    #DM0Z_95_PFC     EQU X'80'   ePFC tax
                                    #DM0Z_95_ZPT     EQU X'40'   eZP tax

                                
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Tax breakdown of ZP tax code
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/sp/pd/v3_5" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Domestic" minOccurs="0" maxOccurs="30">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Amount">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:decimal">
     *               &lt;xs:attribute type="xs:string" name="currencyCode"/>
     *               &lt;xs:attribute type="xs:integer" name="decimalPlace"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="AirportCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Domestic implements Serializable
    {
        private BigDecimal amountDecimal;
        private String amountCurrencyCode;
        private BigInteger amountDecimalPlace;
        private String airportCode;
        private String code;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getAmountDecimal() {
            return amountDecimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param amountDecimal
         */
        public void setAmountDecimal(BigDecimal amountDecimal) {
            this.amountDecimal = amountDecimal;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getAmountCurrencyCode() {
            return amountCurrencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param amountCurrencyCode
         */
        public void setAmountCurrencyCode(String amountCurrencyCode) {
            this.amountCurrencyCode = amountCurrencyCode;
        }

        /** 
         * Get the 'decimalPlace' attribute value.
         * 
         * @return value
         */
        public BigInteger getAmountDecimalPlace() {
            return amountDecimalPlace;
        }

        /** 
         * Set the 'decimalPlace' attribute value.
         * 
         * @param amountDecimalPlace
         */
        public void setAmountDecimalPlace(BigInteger amountDecimalPlace) {
            this.amountDecimalPlace = amountDecimalPlace;
        }

        /** 
         * Get the 'AirportCode' element value. Airport/Station City Code

                                        Ref: DM0Z_95_ARPT
         * 
         * @return value
         */
        public String getAirportCode() {
            return airportCode;
        }

        /** 
         * Set the 'AirportCode' element value. Airport/Station City Code

                                        Ref: DM0Z_95_ARPT
         * 
         * @param airportCode
         */
        public void setAirportCode(String airportCode) {
            this.airportCode = airportCode;
        }

        /** 
         * Get the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_95_ITYP Tax item type
                                    #DM0Z_95_PFC     EQU X'80'   ePFC tax
                                    #DM0Z_95_ZPT     EQU X'40'   eZP tax

                                
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Tax box identifier

                                    Ref: DM0Z_95_ITYP Tax item type
                                    #DM0Z_95_PFC     EQU X'80'   ePFC tax
                                    #DM0Z_95_ZPT     EQU X'40'   eZP tax

                                
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
}
